/'* 
 @file  protocol.h
 @brief ENet protocol
'/
#ifndef __ENET_PROTOCOL_BI__
#define __ENET_PROTOCOL_BI__

#include "enet/types.bi"

enum 
	ENET_PROTOCOL_MINIMUM_MTU = 576
	ENET_PROTOCOL_MAXIMUM_MTU = 4096
	ENET_PROTOCOL_MAXIMUM_PACKET_COMMANDS = 32
	ENET_PROTOCOL_MINIMUM_WINDOW_SIZE = 4096
	ENET_PROTOCOL_MAXIMUM_WINDOW_SIZE = 32768
	ENET_PROTOCOL_MINIMUM_CHANNEL_COUNT = 1
	ENET_PROTOCOL_MAXIMUM_CHANNEL_COUNT = 255
	ENET_PROTOCOL_MAXIMUM_PEER_ID = &h7FFF
end enum

enum ENetProtocolCommand
	ENET_PROTOCOL_COMMAND_NONE = 0
	ENET_PROTOCOL_COMMAND_ACKNOWLEDGE = 1
	ENET_PROTOCOL_COMMAND_CONNECT = 2
	ENET_PROTOCOL_COMMAND_VERIFY_CONNECT = 3
	ENET_PROTOCOL_COMMAND_DISCONNECT = 4
	ENET_PROTOCOL_COMMAND_PING = 5
	ENET_PROTOCOL_COMMAND_SEND_RELIABLE = 6
	ENET_PROTOCOL_COMMAND_SEND_UNRELIABLE = 7
	ENET_PROTOCOL_COMMAND_SEND_FRAGMENT = 8
	ENET_PROTOCOL_COMMAND_SEND_UNSEQUENCED = 9
	ENET_PROTOCOL_COMMAND_BANDWIDTH_LIMIT = 10
	ENET_PROTOCOL_COMMAND_THROTTLE_CONFIGURE = 11
	ENET_PROTOCOL_COMMAND_COUNT = 12
	ENET_PROTOCOL_COMMAND_MASK = &h0F
end enum


enum ENetProtocolFlag
	ENET_PROTOCOL_COMMAND_FLAG_ACKNOWLEDGE = (1 shl 7)
	ENET_PROTOCOL_COMMAND_FLAG_UNSEQUENCED = (1 shl 6)
	ENET_PROTOCOL_HEADER_FLAG_SENT_TIME = (1 shl 15)
	ENET_PROTOCOL_HEADER_FLAG_MASK = &h8000
end enum


type ENetProtocolHeader
	checksum as enet_uint32
	peerID as enet_uint16
	sentTime as enet_uint16
end type

type ENetProtocolCommandHeader
	command as enet_uint8
	channelID as enet_uint8
	reliableSequenceNumber as enet_uint16
end type

type ENetProtocolAcknowledge
	header as ENetProtocolCommandHeader
	receivedReliableSequenceNumber as enet_uint16
	receivedSentTime as enet_uint16
end type

type ENetProtocolConnect
	header as ENetProtocolCommandHeader
	outgoingPeerID as enet_uint16
	mtu as enet_uint16
	windowSize as enet_uint32
	channelCount as enet_uint32
	incomingBandwidth as enet_uint32
	outgoingBandwidth as enet_uint32
	packetThrottleInterval as enet_uint32
	packetThrottleAcceleration as enet_uint32
	packetThrottleDeceleration as enet_uint32
	sessionID as enet_uint32
end type

type ENetProtocolVerifyConnect
	header as ENetProtocolCommandHeader
	outgoingPeerID as enet_uint16
	mtu as enet_uint16
	windowSize as enet_uint32
	channelCount as enet_uint32
	incomingBandwidth as enet_uint32
	outgoingBandwidth as enet_uint32
	packetThrottleInterval as enet_uint32
	packetThrottleAcceleration as enet_uint32
	packetThrottleDeceleration as enet_uint32
end type

type ENetProtocolBandwidthLimit
	header as ENetProtocolCommandHeader
	incomingBandwidth as enet_uint32
	outgoingBandwidth as enet_uint32
end type

type ENetProtocolThrottleConfigure
	header as ENetProtocolCommandHeader
	packetThrottleInterval as enet_uint32
	packetThrottleAcceleration as enet_uint32
	packetThrottleDeceleration as enet_uint32
end type

type ENetProtocolDisconnect
	header as ENetProtocolCommandHeader
	data as enet_uint32
end type

type ENetProtocolPing
	header as ENetProtocolCommandHeader
end type

type ENetProtocolSendReliable
	header as ENetProtocolCommandHeader
	dataLength as enet_uint16
end type

type ENetProtocolSendUnreliable
	header as ENetProtocolCommandHeader
	unreliableSequenceNumber as enet_uint16
	dataLength as enet_uint16
end type

type ENetProtocolSendUnsequenced
	header as ENetProtocolCommandHeader
	unsequencedGroup as enet_uint16
	dataLength as enet_uint16
end type

type ENetProtocolSendFragment
	header as ENetProtocolCommandHeader
	startSequenceNumber as enet_uint16
	dataLength as enet_uint16
	fragmentCount as enet_uint32
	fragmentNumber as enet_uint32
	totalLength as enet_uint32
	fragmentOffset as enet_uint32
end type

union ENetProtocol
	header as ENetProtocolCommandHeader
	acknowledge as ENetProtocolAcknowledge
	connect as ENetProtocolConnect
	verifyConnect as ENetProtocolVerifyConnect
	disconnect as ENetProtocolDisconnect
	ping as ENetProtocolPing
	sendReliable as ENetProtocolSendReliable
	sendUnreliable as ENetProtocolSendUnreliable
	sendUnsequenced as ENetProtocolSendUnsequenced
	sendFragment as ENetProtocolSendFragment
	bandwidthLimit as ENetProtocolBandwidthLimit
	throttleConfigure as ENetProtocolThrottleConfigure
end union
#EndIf	/'__ENET_PROTOCOL_BI__'/
