#Include "ui_text.bi"
#Include "ui_button.bi"
#Include "cmnTTO_gstate.bi"
#Include "clTTO_client.bi"
#Include "svTTO_server.bi"
#Include "fbgfx.bi"
#Include "crt.bi"

Dim Shared lblAddr As t_uiText ptr
Dim Shared lblPort As t_uiText ptr

Dim Shared btnConnect As t_uiButton ptr
Dim Shared btnHost As t_uiButton Ptr

Dim Shared txtAddr As t_uiText ptr
Dim Shared txtPort As t_uiText ptr
Dim Shared btnQuit As t_uiButton ptr

'Dim Shared txtName As t_uiText Ptr

/'
Dim Shared txtChat As t_uiText Ptr
Dim Shared txtInput As t_uiText Ptr
Dim Shared btnSubmit As t_uiButton ptr
'/
Dim Shared uiTitle As Any ptr

Declare Sub PLoad(file As String, ByRef destBuffer As Any Ptr)

Sub flushBuffer()

	Do Until InKey() = ""
	Loop		

End Sub

Sub Connect_Click(ByRef self As t_uiButton, uData As t_gameState Ptr)
	Dim port As Integer
	
	uData->ip = "127.0.0.1"
	
	If txtAddr->text <> "" Then
		uData->ip = txtAddr->text
	EndIf
	
	port = valInt(txtPort->text)
	
	If port > 0 then
		uData->port = port
	Else
		uData->port = 9920
	End If

	client_connect(*uData)
		
	uData->p1state.timeout = Timer
	svTTO_initState(*uData)
	
	uData->gState = egsWaiting
	uData->isServer = 0
End Sub

Sub Host_Click(ByRef self As t_uiButton, uData As t_gameState Ptr)
	Dim port As Integer
	
	port = valInt(txtPort->text)
	
	If port > 0 then
		uData->port = port
	Else
		uData->port = 9920
	End If
	
	server_host(*uData)
	
	svTTO_initState(*uData)
	
	uData->gState = egsWaiting
	uData->isServer = 1
End Sub

Sub Quit_Click(ByRef self As t_uiButton, uData As t_gameState Ptr)
	uData->gState = egsEndGame
	uData->isRunning = 0
End Sub

Sub clTTO_createUI(ByRef gameState As t_gameState)

	uiTitle = ImageCreate(200, 100)
	PLoad("./img/title.png", uiTitle)
	
	lblAddr = New t_uiText
	lblPort = New t_uiText

	btnConnect = New t_uiButton
	btnHost = New t_uiButton

	txtAddr = New t_uiText
	txtPort = New t_uiText
	btnQuit = New t_uiButton
/'
	txtName = New t_uiText
	txtChat = New t_uiText
	txtInput = New t_uiText

	btnSubmit = New t_uiButton
'/

	lblAddr->height = 1

	lblAddr->xPos = 110
	lblAddr->yPos = 130
	lblAddr->text = "Address:"
	lblAddr->wdth = Len("Address:")
	
	lblPort->xPos = 134
	lblPort->yPos = 144
	lblPort->text = "Port:"
	lblPort->wdth = Len("Port:")
	
	txtAddr->xPos = 183
	txtAddr->yPos = 130
	txtAddr->Length = 128
	txtAddr->hasFocus = 1	
	txtAddr->text = "127.0.0.1"
	txtAddr->wdth = 16

	txtPort->xPos = 183
	txtPort->yPos = 144
	txtPort->hasFocus = 0
	txtPort->text = "9920"
	txtPort->wdth = 10
		
	btnConnect->xPos = 180
	btnConnect->yPos = 180
	btnConnect->wdth = 8
	btnConnect->height = 3
	btnConnect->text = "Connect"
	btnConnect->callback = Cast(t_click_CB, @Connect_Click)
	btnConnect->callbackData = @gameState
		
	btnHost->xPos = 252
	btnHost->yPos = 180
	btnHost->wdth = 8
	btnHost->height = 3
	btnHost->text = "Host"
	btnHost->callback = Cast(t_click_CB, @Host_Click)
	btnHost->callbackData = @gameState
	
	btnQuit->xPos = 330
	btnQuit->yPos = 270
	btnQuit->wdth = 8
	btnQuit->height = 3	
	btnQuit->text = "Quit"
	btnQuit->callback = Cast(t_click_CB, @Quit_Click)
	btnQuit->callbackData = @gameState
/'
	txtChat->xPos = 10
	txtChat->yPos = 208
	txtChat->Length = -1
	txtChat->hasFocus = 0
	txtChat->text = ""
	txtChat->wdth = 32
	txtChat->height = 9
	
	txtInput->xPos = 77
	txtInput->yPos = 286
	txtInput->Length = 128
	txtInput->hasFocus = 0
	txtInput->text = ""
	txtInput->wdth = 24
	txtInput->height = 1

	txtName->xPos = 10
	txtName->yPos = 286
	txtName->Length = 32
	txtName->hasFocus = 0
	txtName->text = "Bob"
	txtName->wdth = 8
	txtName->height = 1
'/	
End Sub

Sub clTTO_destroyUI()
	Delete lblAddr
	Delete lblPort

	Delete btnConnect
	Delete btnHost

	Delete txtAddr
	Delete txtPort
	Delete btnQuit
	/'
	Delete txtChat
	Delete txtInput

	Delete btnSubmit
'/
'	Delete txtName
	
	ImageDestroy(uiTitle)
End Sub

Sub clTTO_UpdateGameui()
/'
	txtChat->poll()
	txtInput->poll()
'/
	btnQuit->poll()
'	txtName->poll()
	/'
	If txtInput->hasFocus And MultiKey(FB.SC_ENTER) Then
		If Len(txtInput->text) > 0 then
			
			txtChat->text = txtChat->text & txtName->text & ": " & txtInput->text & !"\n"
			txtInput->text = ""
			If Len(txtChat->text) > 1024 Then
				txtChat->text = Right(txtChat->text, 1024)
			EndIf
		End if
	EndIf

	txtChat->render()
	txtInput->render()	
'/
	btnQuit->render()
'	txtName->render()
	flushBuffer()
End Sub

Sub clTTO_Updateui()
		lblAddr->poll()
		lblPort->poll()
		txtAddr->poll()
		txtPort->poll()
		btnConnect->poll()
		btnHost->poll()
		btnQuit->poll()
				
		Put (10, 0), uiTitle,alpha

		lblAddr->render()
		lblPort->render()
		txtAddr->render()
		txtPort->render()
		btnConnect->render()
		btnHost->render()
		btnQuit->render()
		
		flushBuffer()
End Sub
