/'
  <Slightly modified copy of the zlib license>
 
  clTTO_draw.bas -- client rendering functions.

  Copyright (C) 2008 Daniel Cousley

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Daniel Cousley
'/

#Include "cmnTTO_gstate.bi"
#Include "clTTO_draw.bi"
#Include "png.bi"
#Include "crt.bi"
#Include "fbgfx.bi"

Dim Shared xIMG As Any Ptr
Dim Shared oIMG As Any Ptr
'All of these should be fairly straightforward, each one draws what it says it does.

Sub PLoad(file As String, ByRef destBuffer As Any Ptr)

	Dim As Integer imgW, imgH, bpp, iPitch, iY, oW, oH, oBPP
	Dim As png_infop  info_ptr, end_info

	Dim row_pointers As png_bytepp
	Dim png_ptr As png_structp 

	Dim oImage As FB.IMAGE Ptr = destBuffer
	Dim fileHandle As FILE ptr
	Dim linePTR As UByte Ptr
	Dim sig As ZString * 8
	Dim oPitch As UInteger
  
	fileHandle = fopen(@file[0], "rb")
	
	If fileHandle = 0 Then
		printf(!"File not found:%s\n", file)
		GoTo errorCleanup
	EndIf

	fread(@sig, 1, 8, fileHandle)
  
  If png_sig_cmp(@sig, 0, 8) <> 0 Then
		printf(!"Not a PNG File\n")
		GoTo errorCleanup
  EndIf
  
  png_ptr = png_create_read_struct( _
  PNG_LIBPNG_VER_STRING, _
  0, _
  0, _
  0)
  
  info_ptr = png_create_info_struct(png_ptr)
  end_info = png_create_info_struct(png_ptr)
  
  png_init_io(png_ptr, fileHandle)
  png_set_sig_bytes(png_ptr, 8)
	
	png_read_png(png_ptr, info_ptr, PNG_TRANSFORM_BGR, NULL)
	row_pointers = png_get_rows(png_ptr, info_ptr)
	
	imgW = png_get_image_width(png_ptr, info_ptr)
	imgH = png_get_image_height(png_ptr, info_ptr)
  bpp = png_get_bit_depth(png_ptr, info_ptr)
  iPitch = png_get_rowbytes(png_ptr, info_ptr)

  oW = oImage->Width
  oH = oImage->Height
  oPitch = oImage->pitch
  oBPP = oImage->bpp

  If oBPP <> 4 or png_get_channels(png_ptr, info_ptr) <> 4 Then
		printf(!"input or output in an unsupported format\n")
		png_destroy_read_struct(@png_ptr, @info_ptr, @end_info)
		GoTo errorCleanup  	
  EndIf
  
  If oW <> imgW Or oH <> imgH Then
  	printf (!"%d=%d %d=%d\n", oW, imgW, oh, imgH)
		printf(!"input does not match output image format\n")
		png_destroy_read_struct(@png_ptr, @info_ptr, @end_info)
		GoTo errorCleanup
  EndIf

  linePTR = Cast(Byte Ptr, oImage) + SizeOf(FB.IMAGE)
	
  For iY = 0 To imgH - 1

 		memcpy(linePTR, row_pointers[iY], oPitch)
  	linePTR += oPitch
  	
  Next
  
errorCleanup:
 	If fileHandle then
		fclose(fileHandle)
	End if
End Sub

Sub loadIMG()
	xIMG = ImageCreate(64,64)
	oIMG = ImageCreate(64,64)
	PLoad("./img/X.png", xIMG)
	PLoad("./img/O.png", oIMG)
End Sub

Sub freeIMG()
	ImageDestroy(xImg)
	ImageDestroy(oImg)
End Sub

Sub drawBox(x As Integer, y As Integer, w As Integer, h As Integer, bColor As Integer, fColor As Integer)
	
	Line (x, y)-(x + w, y + h),fColor,BF
	Line (x, y)-(x + w, y + h),bColor,B
	
End Sub

Sub drawX(cellNum As Integer, xOffset As Integer, yOffset As Integer)
	Dim x As Integer
	Dim y As Integer
	
	x = cellNum Mod 3
	y = (cellNum - x) / 3
	
	x = (x * 64)' + 1
	y = (y * 64)' + 1
	
	Put (xOffset + x, yOffset + y), xIMG, alpha
End Sub

Sub drawO(cellNum As Integer, xOffset As Integer, yOffset As Integer)
	Dim x As Integer
	Dim y As Integer
	
	x = cellNum Mod 3
	y = (cellNum - x) / 3
	
	x = (x * 64)
	y = (y * 64)
	
	Put (xOffset + x, yOffset + y), oIMG, alpha

End Sub

Sub redrawCell(cellNum As Integer, xOffset As Integer, yOffset As Integer, col1 As UInteger, col2 As UInteger )
	Dim x As Integer
	Dim y As Integer

	If cellNum < 0 Then
		Exit sub
	EndIf
	
	x = cellNum Mod 3
	y = (cellNum - x) / 3
		
	x = x * 64
	y = y * 64
	x += xOffset
	y += yOffset
	
	drawBox(x + 1, y + 1, 62, 62, col1, col2)

End Sub

Sub redrawBoard( xOffset As Integer, yOffset As Integer)
	drawBox(xOffset, yOffset, 192, 192,  RGB(255,64,64), RGB(128,128,128))

	Line (xOffset + 64, yOffset + 1)-(xOffset + 64, yOffset + 191), RGB(255,64,64)
	Line (xOffset + 128, yOffset + 1)-(xOffset + 128, yOffset + 191), RGB(255,64,64)
	
	Line (xOffset + 1, yOffset + 64)-(xOffset + 191, yOffset + 64), RGB(255,64,64)
	Line (xOffset + 1, yOffset + 128)-(xOffset + 191, yOffset + 128), RGB(255,64,64)

End Sub

Sub redrawPieces(xOffset As Integer, yOffset As Integer, gameState As t_gameState)

	Dim i As integer
	With gameState
		For i = 0 To 9
			If Bit(.p1State.cellState, i) Then
				drawX(i, xOffset, yOffset)
			elseIf Bit(.p2State.cellState, i) Then
				drawO(i, xOffset, yOffset)
			EndIf
		Next
	End With
End Sub
