/'
  <Slightly modified copy of the zlib license>
 
  clTTO_main.bas -- client main program.

  Copyright (C) 2008 Daniel Cousley

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Daniel Cousley
'/

#Include "fbgfx.bi"
#Include "cmnTTO_gstate.bi"
#Include "clTTO_draw.bi"
#Include "clTTO_client.bi"
#Include "svTTO_server.bi"
#Include "clTTO_Interface.bi"

#Include "enet/enet.bi"
#Include "crt.bi"

Using FB

Dim Shared isRunning As integer

Sub clioPump(ByRef gameState As t_gameState, interval As integer)
	'A simple wrapper to clean up the main game loop

	getCellNumber(10, 10, gameState.p1State)
	getKeyBoard(gameState.p1State)
	
	client_pump(gameState, interval)

End Sub

Sub svioPump(ByRef gameState As t_gameState, interval As integer)
	'A simple wrapper to clean up the main game loop

	getCellNumber(10, 10, gameState.p1State)
	getKeyBoard(gameState.p1State)

	server_pseudoRecv(gameState)
	server_pump(gameState, interval)
End Sub

Sub GameRender(ByRef gameState As t_gameState)
	'Renders main game state
	redrawBoard (10, 10)
	redrawCell(gameState.p1State.iostate.cellOffset, 10, 10, RGB(128, 64, 64), RGB(192, 128, 128))
	redrawCell(gameState.p2State.iostate.cellOffset, 10, 10, RGB(64, 128, 64), RGB(128, 192, 128))
	
	redrawPieces(10, 10, gameState)
	Locate 1,1
		If gameState.turn = 0 Then
				Print "Your turn."
		Else
				Print "Not your turn."
		EndIf
	clTTO_UpdateGameui()
	
	Flip
	cls
	Sleep 10, 1
End Sub

Sub EndRender(ByRef gameState As t_gameState)
	'Renders end game state
	Dim winString As String
	Dim cShade As Integer

	If gameState.wWinner = ewsP1Wins Then
		winString = "!!You Win!!"
	ElseIf gameState.wWinner = ewsP2Wins then
		winString = "!!You lose!!"
	ElseIf gameState.wWinner = ewsDraw then
		winString = "!!Draw game!!"
	EndIf
		
	cShade = Rnd * 255
	Draw String ((Rnd * 420) - 20, (Rnd * 310) - 10), winString, RGB(cShade, cShade, cShade)
	drawBox(124, 128, 148, 24, RGB(128,128,128), RGB(64,64,64))
	Draw String (132, 136), "Play again? (Y/N)", RGB(255,64,64)

	drawBox(124, 152, 76, 16, RGB(128,128,128), RGB(64,64,64))
	drawBox(200, 152, 16, 16, RGB(128,128,128), RGB(64,64,64))
	Draw String (132, 157), "P1 Ready", RGB(128,64,64)
	
	If gamestate.p1state.iostate.keyState = eksYes then
		drawBox(200, 152, 16, 16, RGB(128,192,128), RGB(64,192,64))
		Draw String (132, 157), "P1 Ready", RGB(255,64,64)
	End If
	
	drawBox(124, 168, 76, 16, RGB(128,128,128), RGB(64,64,64))
	drawBox(200, 168, 16, 16, RGB(128,128,128), RGB(64,64,64))
	Draw String (132, 174), "P2 Ready", RGB(128,64,64)	
		
	If gamestate.p2state.iostate.keyState = eksYes then
		drawBox(200, 168, 16, 16, RGB(128,192,128), RGB(64,192,64))
		Draw String (132, 174), "P2 Ready", RGB(255,64,64)	
	End If
	
	clTTO_UpdateGameui()
	
	Flip
	Sleep 100, 1
End Sub

Sub renderWait(ByRef gameState As t_gameState)
	'Renders wait state
	Locate 1,1
	Print "waiting..."

	clTTO_UpdateGameui()

	flip
	cls
	Sleep 100, 1
End Sub

Sub main()
	Dim GameState As t_gameState

	Randomize timer

	ScreenRes 400, 300, 32, 2
	ScreenSet 1,0
	Color RGB(0, 255, 154), RGB(64, 64, 64)

	enet_initialize()
	
	clTTO_createUI(GameState)

	GameState.gState = egsEndGame
	GameState.isRunning = 1

	loadIMG()
	
	Do While GameState.isRunning
		
		Do While GameState.gState = egsEndGame And GameState.isRunning
			clTTO_Updateui()
			Flip
			Cls
			Sleep 10, 1
		Loop
				
		Do While GameState.gState <> egsEndGame
			
			Do While GameState.gState = egsWaiting
				If GameState.isServer Then
					svioPump(GameState, 10)
				Else
					clioPump(GameState, 10)				
				EndIf
				renderWait(GameState)
			Loop
		
			Do While GameState.gState = egsMainGame
				If GameState.isServer Then
					svioPump(GameState, 10)
				Else
					clioPump(GameState, 10)				
				EndIf
				GameRender(GameState)
			Loop

				
			Do While GameState.gState = egsResetGame
				If GameState.isServer Then
					svioPump(GameState, 10)
				Else
					clioPump(GameState, 10)				
				EndIf
				EndRender(GameState)
			Loop
			Cls

			svTTO_initState(gameState)

		Loop
				
	Loop
	
	freeIMG()
	GameState.ip = ""
	clTTO_destroyUI()
	
	If GameState.host then
		enet_peer_disconnect_now(@GameState.host->peers[0], 0)
		enet_host_flush(gameState.host)
		enet_host_destroy(GameState.host)
	End if
	
	enet_deinitialize()

End Sub

main()