/'
  <Slightly modified copy of the zlib license>
 
  cmnTTO_helpers.bas -- packet manipulation helper functions.

  Copyright (C) 2008 Daniel Cousley

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Daniel Cousley
'/

#Include "enet/enet.bi"
#Include "crt.bi"

/'
These functions will push data into a block of memory.
They should always be passed a valid copy of another pointer
Never pass them the original pointer.

The various ENET_*_T_*_16/32 functions convert the byte ordering of
a 16 or 32 bit integer to either host ordering, or network ordering.

By always converting to network byte order on outgoing data, and back
to host byte ordering on incoming data, you can always be sure that its the
correct endianness.
'/

Sub pushBytes(ByRef dataPtr As Byte Ptr, value As UByte Ptr, byteCount As Integer)
End Sub

Sub pushInteger(ByRef dataPtr As Byte Ptr, value As Integer)
	*Cast(Integer Ptr, dataPtr) = ENET_HOST_TO_NET_32(value)
	dataPtr += SizeOf(Integer)
End Sub

Sub pushShort(ByRef dataPtr As Byte Ptr, value As Short)
	*Cast(Short Ptr, dataPtr) = ENET_HOST_TO_NET_16(value)
	dataPtr += SizeOf(Short)
End Sub

Sub pushByte(ByRef dataPtr As Byte Ptr, value As byte)
	*dataPtr = value
	dataPtr += SizeOf(Byte)
End Sub

Sub pushUInteger(ByRef dataPtr As UByte Ptr, value As UInteger)
	*Cast(UInteger Ptr, dataPtr) = ENET_HOST_TO_NET_32(value)
	dataPtr += SizeOf(UInteger)
End Sub

Sub pushUShort(ByRef dataPtr As UByte Ptr, value As UShort)
	*Cast(UShort Ptr, dataPtr) = ENET_HOST_TO_NET_16(value)
	dataPtr += SizeOf(UShort)
End Sub

Sub pushUByte(ByRef dataPtr As UByte Ptr, value As Ubyte)
	*dataPtr = value
	dataPtr += SizeOf(UByte)
End Sub


/'
These functions will get data out of a block of memory.
They should always be passed a valid copy of another pointer
Never pass them the original pointer.

The various ENET_*_T_*_16/32 functions convert the byte ordering of
a 16 or 32 bit integer to either host ordering, or network ordering.

By always converting to network byte order on outgoing data, and back
to host byte ordering on incoming data, you can always be sure that its the
correct endianness.

They are named get* as opposed to pop* because they operate from the beginning
of the data block, IE: FIFO as opposed to LIFO.
'/
Function getInteger(ByRef dataPtr As Byte Ptr) As Integer
	Function = ENET_NET_TO_HOST_32(*Cast(Integer Ptr, dataPtr))
	dataPtr += SizeOf(Integer)
End Function

Function getShort(ByRef dataPtr As Byte Ptr) As Short
	Function = ENET_NET_TO_HOST_16(*Cast(Short Ptr, dataPtr))	
	dataPtr += SizeOf(Short)
End Function

Function getByte(ByRef dataPtr As Byte Ptr) As Byte
	Function = *dataPtr	
	dataPtr += SizeOf(Byte)
End Function

Function getUInteger(ByRef dataPtr As UByte Ptr) As UInteger
	Function = ENET_NET_TO_HOST_32(*Cast(UInteger Ptr, dataPtr))	
	dataPtr += SizeOf(UInteger)
End Function

Function getUShort(ByRef dataPtr As UByte Ptr) As UShort	
	Function = ENET_NET_TO_HOST_16(*Cast(UShort Ptr, dataPtr))	
	dataPtr += SizeOf(UShort)
End Function

Function getUByte(ByRef dataPtr As UByte Ptr) As UByte
	Function = *dataPtr		
	dataPtr += SizeOf(UByte)
End Function