/'
  <Slightly modified copy of the zlib license>
 
  svTTO_server.bas -- server functions:
		Game State management
		Connection management

  Copyright (C) 2008 Daniel Cousley

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Daniel Cousley
'/

#Include "cmnTTO_gstate.bi"
#Include "crt.bi"
#Include "enet/enet.bi"
#Include "cmnTTO_helpers.bi"
#Include "svTTO_server.bi"
#Include "fbgfx.bi"
Using FB
Sub svTTO_initState(ByRef gameState As t_gameState)
	With gameState	
		.turn = Int(Rnd * 2)
		.cellState = 0
		.p1state.cellState = 0
		.p2state.cellState = 0
		.p1state.ioState.keyState = eksNone
		.p1state.ioState.keyState = eksNone
	End With
End Sub

Sub updateCell(ByRef gameState As t_gameState)
	'Takes the cellNum, and checks to see if it can legally alter
	'the state of the game board.
	Dim oldPState As UShort
	Dim tCellNum As Ubyte
	With gameState

		tCellNum = 255

		If .turn = 0 then
			If .p1state.ioState.mouseButton = 1 then
				tCellNum = .p1State.ioState.cellOffset
			End If
		ElseIf .turn = 1 Then
			If .p2state.ioState.mouseButton = 1 then
				tCellNum = .p2State.ioState.cellOffset
			End If
		End If
		
		If tCellNum = 255 Then
			Exit sub
		EndIf
		
		If Bit(.cellState, tCellNum) = 0 Then
			.cellState = BitSet(.cellState, tCellNum)
			
			If .turn = 0 Then
				oldPState = .p1State.cellState
				.p1State.cellState = BitSet(.p1State.cellState, tCellNum)
				If oldPState <> .p1State.cellState Then
					.turn = 1
				EndIf
			Else
				oldPState = .p2State.cellState
				.p2State.cellState = BitSet(.p2State.cellState, tCellNum)
				If oldPState <> .p2State.cellState Then
					.turn = 0
				EndIf
			EndIf
			
		EndIf	
	End with
End Sub


sub globalStateUpdate(ByRef gameState As t_gameState)
	'Updates the game state.
	'The board is stored in 3 1 byte states
	'cellState is a mask which describes available, and unavailable cells
	'p1CellState is a mask which describes which cells p1 owns
	'p2CellState is the equivalent for p2
	Dim tempState As UShort
	Dim win As Integer
	
	updateCell(gameState)
	
	With gameState
		'Player 1's winning move will still change the turn to P2,
		'and vice versa.
		If .turn = 1 Then
			tempState = .p1State.cellState			
		Else
			tempState = .p2State.cellState
		EndIf
		win = 0
		'The check the players state against a few masks that descibre winning moves
		If ((tempState and &h07) = &h07) Then
			win = 1
		ElseIf ((tempState and &h38) = &h38) Then 
			win = 1
		ElseIf ((tempState and &h1C0) = &h1C0) Then 
			win = 1
		ElseIf ((tempState and &h49) = &h49) Then 
			win = 1
		ElseIf ((tempState and &h92) = &h92) Then 
			win = 1
		ElseIf ((tempState and &h124) = &h124) Then 
			win = 1
		ElseIf ((tempState and &h111) = &h111) Then 
			win = 1
		ElseIf ((tempState and &h54) = &h54) Then 
			win = 1
		EndIf
		
		'If the board is full, and no one won, then its a draw
		If win = 0 then
			If ((.cellState and &h1FF) = &h1FF)Then 
				win = 2
			End If
		End if

		'If someone won, or the game was a draw, reset the game state
		If win = 1 then
			gameState.gState = egsResetGame
			If .turn = 1 then
				gameState.wWinner = ewsP1Wins
			Else
				gameState.wWinner = ewsP2Wins
			End If
		ElseIf win = 2 then
				gameState.gState = egsResetGame
				gameState.wWinner = ewsDraw			
		End If
		
		'Check for the readyness of the two players
		If .gState = egsResetGame Then
			If .p1State.ioState.keyState = eksYes and .p2State.ioState.keyState = eksYes Then
				gameState.gState = egsMainGame
			EndIf
		EndIf
	End With
End sub

sub server_host(ByRef gameState As t_gameState)
	Dim As ENetAddress address

	address.host = ENET_HOST_ANY
	address.port = gameState.port
	
	If gameState.host Then
		enet_peer_disconnect_now(@gameState.host->peers[0], 0)
		enet_host_destroy(gameState.host)
	EndIf
	
	gameState.host = enet_host_create (@address, 1, 0, 0)
	
End sub

Sub server_SendGameState(ByRef gameState As t_gameState)
	'Update the client as to the game state
	
	Dim outPacket As ENetPacket Ptr
	Dim As Byte Ptr p_bData

	'Packet for client
	outPacket = enet_packet_create (0, 25, ENET_PACKET_FLAG_RELIABLE)

	p_bData = outPacket->data
	
	pushUByte(p_bData, &hFF)		'Command
	With gameState.p1State.ioState
		pushUByte(p_bData, .cellOffset)
		pushUByte(p_bData, .mouseButton)	
		pushUInteger(p_bData, .keyState)
	End With
	
	pushUShort(p_bData, gameState.p1State.cellState)	
	pushUShort(p_bData, gameState.p2State.cellState)
	
	pushUInteger(p_bData, gameState.gState)
	
	If gameState.wWinner = ewsP1Wins Then
		pushUInteger(p_bData, ewsP2Wins)
	ElseIf gameState.wWinner = ewsP2Wins then
		pushUInteger(p_bData, ewsP1Wins)
	Else
		pushUInteger(p_bData, ewsDraw)
	EndIf
	
					
	pushUByte(p_bData, gameState.turn Xor 1)

	enet_peer_send (@(gameState.host->peers[0]), 0, outPacket)
		
End Sub
Sub server_pseudoRecv(ByRef gameState As t_gameState)
	
	Dim tUserState As e_keyState 
		
	If gameState.p1State.ioStateChange Then
		gameState.p1State.ioStateChange = 0
		server_SendGameState(gameState)
	End If
	
End Sub

Sub server_Receive(ByRef gameState As t_gameState, inPacket As ENetPacket Ptr)
	'Receives client input
	'Same ideas as in client_receive
	Dim As UByte Ptr p_bData
	Dim potentialState As e_gameState
	Dim tUserState As e_keyState 
	Dim tCellNum As UByte
	Dim tMB As UByte
	
	p_bData = inPacket->Data
	
	If getUByte(p_bData) <> &hFE Then
		Exit sub
	EndIf
	With gameState.p2State.ioState
		.cellOffset = getUByte(p_bData)
		.mouseButton = getUByte(p_bData)
		.keyState = getUInteger(p_bData)
	End with
	
	globalStateUpdate(gameState)

End Sub


Sub server_pump(ByRef gameState As t_gameState, interval As integer)
	Dim As ENetEvent eve

	Do while (enet_host_service (gameState.host, @eve, interval) > 0)
		Select case (eve.type)
			case ENET_EVENT_TYPE_CONNECT:
				If gameState.host->peers[0].state = ENET_PEER_STATE_CONNECTED then
					gameState.gState = egsMainGame
				End if
				server_SendGameState(gameState)
			case ENET_EVENT_TYPE_DISCONNECT:
				gameState.gState = egsEndGame
			case ENET_EVENT_TYPE_RECEIVE:
				server_Receive(gameState, eve.packet)			
				server_SendGameState(gameState)
				enet_packet_destroy(eve.packet)
			Case else
		End select
	Loop

	globalStateUpdate(gameState)

End Sub

Sub server_disconnect_all(ByRef gameState As t_gameState)
	Dim i As Integer
	
	For i = 0 To gameState.host->peerCount - 1
		enet_peer_disconnect_now(@(gameState.host->peers[i]), 0)
	Next
	enet_host_flush(gameState.host)
End Sub