#Include "ui_text.bi"
#Include "fbgfx.bi"
#Include "crt.bi"

Using FB

Constructor t_uiText()
	Dim scrW As Integer
	Dim scrH As Integer
	Dim charSize As Integer
	
	ScreenControl(GET_SCREEN_SIZE, scrW, scrH)
	charSize = Width()
	With this
		._cw = scrW / Cast (Short Ptr, @charSize)[0]
		._ch = scrH / Cast (Short Ptr, @charSize)[1] 
		._x = 10
		._y = 10

		._w = 10
		._h = 1
		._txt = ""
		._needsResize = 1
		._maxLen = -1

		._colors(efgColor) = 0
		._colors(ebgColor) = RGB(255,255,255)
		._colors(ebr1Color) = RGB(128,128,128)
		._colors(ebr2Color) = RGB(64,64,64)
		._colors(efgColorIA) = 0 
		._colors(ebgColorIA) = RGB(128,128,128)
		._colors(ebr1ColorIA) = RGB(64,64,64)
		._colors(ebr2ColorIA) = RGB(32,32,32)
	End with
End Constructor

destructor t_uiText()
	ImageDestroy(this._surface)
	this._txt = ""
End destructor

Sub t_uiText._resize()
	Dim tW As Integer
	Dim tH As Integer	
	With this
		tW = (._w * ._cw) + 4
		
		tH = (._h * ._ch) + 4
		ImageDestroy(._surface)
		._surface = ImageCreate( tW, tH )
		._visChars = ._w * ._h
	End with
End Sub

Sub t_uiText._printText(device As Any Ptr, sztext As ZString Ptr, col As uinteger)
	ReDim cLines(0) As String
	Dim cString As ZString Ptr
	Dim cBreak As UInteger
	Dim i As Integer
	Dim upperBound As UInteger
	Dim lCount As Uinteger
	Dim lStart As Uinteger
	
	cString = szText
	cBreak = InStr(1, *cString, Chr(&h0A))
	
	Do While cBreak
		
		upperBound = UBound(cLines)
		
		cLines(upperBound) = Mid(*cString, 1 , cBreak - 1)
		
		If Len(cLines(upperBound)) > this._w Then
			ReDim Preserve cLines(upperBound + 1)
			cLines(upperBound + 1) = Mid(cLines(upperBound), this._w)
			cLines(upperBound) = Mid(cLines(upperBound),1, this._w - 1)
			upperBound = UBound(cLines)
		EndIf
		
		cString += cBreak
				
		cBreak = InStr(1, *cString, Chr(&h0A))	
		
		ReDim Preserve cLines(upperBound + 1)
	loop

	upperBound = UBound(cLines)
	cLines(upperBound) = *cString
	
	lCount = this._h - 1
	If lCount > upperBound Then
		lStart = 0
	Else
		lStart = upperBound - lCount
	EndIf
	
	For i = lStart To upperBound
		Draw String device, (3, ((i - lStart) * this._ch) + 3),cLines(i), col
	Next
	
	ReDim cLines(0)
	cLines(0) = ""
	
End Sub

Sub t_uiText._redraw()
	Dim tW As Integer
	Dim tH As Integer
	Dim As UInteger bgCol, fgCol, brCol1, brCol2
	Dim visText As ZString Ptr

	If this._maxLen > -1 then
		If Len(this._txt) > this._maxLen Then
			this.text = Mid(this.text, 1, this._maxLen)		
		End if
	End if

/'
	efgColor = 0
	ebgColor = 1,
	ebr1Color = 2,
	ebr2Color = 3,
	efgColorIA = 4,	'IA inactive
	ebgColorIA = 5,
	ebr1ColorIA = 6,
	ebr2ColorIA = 7
	'/
	With this
		If this._focused Or this._maxLen = -1 Then
			bgCol = ._colors(ebgColor)
			fgCol = ._colors(efgColor)
			brCol1 = ._colors(ebr1Color)
			If this._maxLen = -1 then
				brCol1 = ._colors(ebgColor)
			End if
			brCol2 = ._colors(ebr2Color)
		Else
			bgCol = ._colors(ebgColorIA)
			fgCol = ._colors(efgColorIA)
			brCol1 = ._colors(ebr1ColorIA)
			brCol2 = ._colors(ebr2ColorIA)
		EndIf
		tW = (._w * ._cw) + 4
		tH = (._h * ._ch) + 4
		If  ._visChars > Len(._txt) Then
			visText = @(._txt[0])
		Else
			visText = @(._txt[0]) + (Len(._txt) - ._visChars)
		EndIf
		Line ._surface, (0, 0)-( tW - 1, tH - 1),bgCol,BF
		._printText(._surface, visText, fgCol)
		Line ._surface, (1, 1)-( tW - 1, tH - 1),brCol1,B
		Line ._surface, (0, 0)-( tW - 1, tH - 1),brCol2,B
	print
	End with	
End Sub

Sub t_uiText._isClicked()
	Dim mX As Integer
	Dim mY As Integer
	Dim mB As Integer
	Dim oldFocus As integer
	GetMouse(mX,mY,,mB)
	mX -= this._x
	mY -= this._y

	If mB = 1 Then
		oldFocus = this._focused
		this._focused = 0
		If mX > 0 And mX < (this._w * this._cw) + 4 Then
			If mY > 0 And mY < (this._h * this._ch) + 4 Then
				this._focused = 1
			EndIf
		EndIf
		If oldFocus <> this._focused Then
			this._needsRedraw = 1
		EndIf
	EndIf
'	Line (0, 0)-STEP((this._w * this._cw) + 4, (this._h * this._ch) + 4),RGB(255,0,0),BF
End Sub

Sub t_uiText.poll()
	Dim iKey As String

	this._isClicked()
	
	If this._maxLen = -1 Then
		Exit sub
	EndIf

	Locate 1,1
	If this._focused Then
		
		iKey = InKey()
		
		Do Until iKey = ""
			Select Case iKey[0]
				Case 32 To 176
					this.text = this.text & iKey
					this._needsRedraw = 1
				Case 8	'backspace
					If Len(this.text) > 0 Then
						this.text = Mid(this.text,1,Len(this.text) - 1)
						this._needsRedraw = 1
					End If
				Case 13
					If this._h > 1 then
						this.text = this.text & Chr(&h0A)
					End if
			End Select
			iKey = InKey()	
		Loop
	EndIf
End Sub

Sub t_uiText.render()
	If this._needsResize = 1 Then
		this._resize()
		this._redraw()
		this._needsResize = 0		
		this._needsRedraw = 0
	elseIf this._needsRedraw = 1 then
		this._redraw()
		this._needsRedraw = 0
	End If
	
	Put (this._x, this._y), this._surface, pset
End Sub

Property t_uiText.hasFocus(newHF As Integer)
	this._focused = newHF
	this._needsRedraw = 1
End Property

Property t_uiText.hasFocus() As Integer
	Return this._focused
End Property


Property t_uiText.xPos(newX As Integer)
	this._x = newX
End Property
Property t_uiText.xPos() As Integer
	Return this._x
End Property

Property t_uiText.yPos(newY As Integer)
	this._y = newY
End Property
Property t_uiText.yPos() As Integer
	Return this._y
End Property

Property t_uiText.wdth(newW As Integer)
	With this
		._w = newW
		If ._w < 1 Then
			._w = 1
		EndIf 
		._needsResize = 1
	End with
End Property

Property t_uiText.wdth() As Integer
	Return this._w
End Property

Property t_uiText.height(newH As Integer)
	With this
		._h = newH
		If ._h < 1 Then
			._h = 1
		EndIf
		._needsResize = 1
	End with
End Property
Property t_uiText.height() As Integer
	Return this._h
End Property

Property t_uiText.text(newText As string)
	this._txt = newText
	this._needsRedraw = 1	
End Property

Property t_uiText.text() As String
	Return this._txt
End Property

Property t_uiText.length(newLen As integer)
	this._maxLen = newLen
	this._needsRedraw = 1
End Property

Property t_uiText.length() As Integer
	Return Len(this._txt)
End Property

Sub t_uiText.setColor(cElement As UInteger, newCol As UInteger)
	
	If cElement > UBound(this._colors) Then
		cElement = UBound(this._colors)
	EndIf
	
	this._colors(cElement) = newCol
	this._needsRedraw = 1
	
End Sub
