' Rotation Puzzle
' ---------------
' A simple square replacement puzzle.
' Concept is not mine... found a similar game in an old cellphone.
' written by the Math Wizard
' April 2008

Declare Sub About()
Declare Sub KeyHelp()
Declare Sub Rect(ByVal x1 As Integer, ByVal y1 As Integer, _ 
                 ByVal x2 As Integer, ByVal y2 As Integer)
Declare Sub CopyBoard(dest() As Integer, src() As Integer)
Declare Sub DrawBoard(ByVal y As Integer, ByVal x As Integer)
Declare Sub Twist()
Declare Sub Scramble()
Declare Sub Setup()
Declare Sub Titlebar(ByVal msg As String = "") 
Declare Function Solved() As Integer

Const PROGNAME = "Rotation v 0.1"
Const CW = 0
Const CCW = 1

Dim Shared As Integer sz                ' Size of square board
Dim Shared As Integer diff              ' Difficulty
Dim Shared As Integer bx, by            ' Cursor top left: (1,1) Top Left
Dim Shared As Integer direc             ' Spin direction at cursor
Dim As Integer twists                   ' # of twists done this game
Dim As String status                    ' "status bar" message

Dim As Integer i, j, k                  ' counter variables
Dim As Integer oldcolors                ' To save console color values

' Initialize some variables
sz = 4                                  ' 4 x 4 Board
diff = 1                                ' Easy (2=Medium, 3=Hard)
bx = 1: by = 1                          ' Cursor at top left
direc = CW

' System Setup
Randomize Timer
Screen 0
oldcolors = Color
Width 80, 25
Setup

' Now setup the board using the parameters: coord. order is R,C
Dim Shared As Integer board(1 To sz, 1 To sz)
k = 1
For i = 1 To sz
    For j = 1 To sz
        board(i, j) = k
        k += 1
Next j, i
Scramble

' Save the starting position of the board
Dim Shared As Integer board2(1 To sz, 1 To sz)
CopyBoard board2(), board()

' Start the game!
Do
    Cls
    status = sz & "-square board / "
    Select Case diff
        Case 1: status &= "Easy"
        Case 2: status &= "Medium"
        Case 3: status &= "Difficult"
    End Select
    Titlebar status
    DrawBoard 5, 2
    Color 8, 0: Locate 5, 24: Print "Twists:"
    Color 15, 0: Locate 6, 24: Print twists

' Draw key legend
    Color 7, 0
    Locate 8, 24: Print "[R]eset Board"
    Locate 9, 24: Print "[H]elp (keys)"
    Locate 11, 24: Print "[A]bout"
    Locate 12, 24: Print "[Esc] Quit" 

    Locate 1, 80

' Accept keyboard input
    k = GetKey
    Select Case k
        Case &h4DFF                     ' Right 
            If bx < sz - 1 Then bx += 1
        Case &h50FF                     ' Down
            If by < sz - 1 Then by += 1
        Case &h4BFF                     ' Left
            If bx > 1 Then bx -= 1
        Case &h48FF                     ' Up
            If by > 1 Then by -= 1
        Case &h0020                     ' Space (Twist)
            Twist
            twists += 1
        Case &h002C, &h003C             ' Comma/< (Counterclockwise)
            direc = CCW
        Case &h002E, &h003E             ' Period/> (Clockwise)
            direc = CW
        Case &h0041, &h0061             ' A/a (About)
            About
        Case &h0048, &h0068             ' H/h (Key help)
            KeyHelp
        Case &h0052, &h0072             ' R/r (Reset board)
            CopyBoard board(), board2()
            twists = 0                  ' also reset counter
    End Select
Loop Until (k = 27) Or Solved()

If Solved() Then
    Cls
    Titlebar "You solved the board!"
    DrawBoard 5, 2
    Color 15, 0
    Rect 5, 2, (2 * sz + 7), (3 * sz + 4)
    Locate 15, 24: Print "Twists:"
    Locate 16, 24: Print twists
    Locate 17, 24: Print "SOLVED!"
    Locate 18, 24: Print "Any key to quit"
    Sleep
End If

Cls
Color 15, 0
Print "Play again soon!"
Color LoWord(oldcolors), HiWord(oldcolors)  ' return color setup to normal
End

Sub About()
' Displays program information.

Cls
Titlebar "About"

Color 8, 0
Rect 3, 2, 13, 36
Color 15, 0: Locate 4, 3: Print PROGNAME
Color 7, 0
Locate 5, 3: Print "by the Math Wizard"
Locate 6, 3: Print "Concept is not mine..."
Locate 8, 3: Print "This code hereby released"
Locate 9, 3: Print "under the" 
Color 15, 0: Locate 9, 13: Print "GPL"
Locate 10, 3: Print "(General Public License)"
Color 7, 0
Locate 11, 3: Print "Direct comments/questions to"
Color 9, 0
Locate 12, 3: Print "math_wizard44 at hotmail dot com"

Color 7, 0
Locate 14, 3: Print "No infringement of copyright"
Locate 15, 3: Print "or of other intellectual right"
Locate 16, 3: Print "is intended on the concept of"
Locate 17, 3: Print "this game. If you know the"
Locate 18, 3: Print "proper attribution for this"
Locate 19, 3: Print "idea, please notify the coder."
Locate 20, 3: Print "Thank you."
Color 1, 0
Locate 22, 3: Print "Version 0.1, April 2008"
Do: Loop Until Inkey <> ""

End Sub


Sub CopyBoard(dest() As Integer, src() As Integer)
' Copies the content of one Board onto the other,
' rewriting what was there previously.

Dim As Integer i, j                     ' counter variables

For i = 1 To sz
    For j = 1 To sz
        dest(i, j) = src(i, j)
Next j, i

End Sub


Sub KeyHelp()
' Displays the key legend
Cls
Titlebar "Help Screen"
DrawBoard 5, 2
Color 15, 0
Rect 5, 24, 16, 39
Color 7, 0
Locate 6, 25: Print "Objective"
Color 8, 0
Locate 7, 25: Print "Arrange tiles"
Locate 8, 25: Print "in increasing"
Locate 9, 25: Print "order."
Color 15, 0
Locate 10, 25: Print String(14, 32)
Locate 11, 25: Print "Key Legend"
Color 7, 0
Locate 12, 25: Print "[" & Chr(24, 25, 26, 27) & "] Move"
Locate 13, 25: Print "[.][>] Clock."
Locate 14, 25: Print "[,][<] C.clock"
Locate 15, 25: Print "[Space] Twist"
Do: Loop Until Inkey <> ""

End Sub


Sub Scramble()
' Scrambles the numbers in the board using
' a considerable number of twists

Dim As Integer i, k                     ' counter variables

k = (diff + 1) * sz


For i = 1 To k
    bx = Int(Rnd * (sz - 1)) + 1        ' Cursor cannot be at right
    by = Int(Rnd * (sz - 1)) + 1        ' or bottom edge
    direc = Iif(Rnd > 0.5, CW, CCW)
    Twist
Next i

' Then set the cursor to the top left and clockwise
by = 1: bx = 1: direc = CW

End Sub


Sub Twist()
' shifts the numbers in the board

Dim As Integer i                        ' counter variable
Dim As Integer k                        ' Placeholder for swap

If direc = CW Then
    k = board(by, bx)
    board(by, bx) = board(by + 1, bx)
    board(by + 1, bx) = board(by + 1, bx + 1)
    board(by + 1, bx + 1) = board(by, bx + 1)
    board(by, bx + 1) = k
Else
    k = board(by, bx)
    board(by, bx) = board(by, bx + 1)
    board(by, bx + 1) = board(by + 1, bx + 1)
    board(by + 1, bx + 1) = board(by + 1, bx)
    board(by + 1, bx) = k
End If

DrawBoard 5, 2
Sleep 100

End Sub


Function Solved() As Integer
' Checks whether the board has been solved
' (i.e., the numbers are in increasing order)

Dim As Integer i, j                     ' counter variable
Dim As Integer k                        ' counter: # of squares correct

k = 0
For i = 1 To sz
    For j = 1 To sz
        If board(i, j) = (i - 1) * sz + j Then k += 1    
    Next j
Next i

Solved = (k = (sz * sz))

End Function


Sub Setup()
' Displays a dialog for choosing the puzzle difficulty

Dim As Integer k = 0                    ' keeps track of keypress
Dim As Integer olds, oldd               ' Previous setup values

' Save the old values just in case User aborts
olds = sz
oldd = diff

Do
    Cls
    Titlebar "Setup Board"

' Instructions
    Color 7, 0
    Locate 12, 24: Print "Enter the size  "
    Locate 13, 24: Print "and difficulty"
    Locate 14, 24: Print "values you want."
    Locate 16, 24: Print "[3 4 5 6 E M D]"
    Locate 17, 24: Print "[Enter] OK"
    Locate 18, 24: Print "[ Esc ] Cancel"

    Locate 4, 2
    Color 15, 0
    Print "Board Size"
    Locate 4, 24
    Print "Puzzle Difficulty"

' Board Size
    Color 8, 0
    Rect 5, 2, (5 + 2 * sz + 1 + 1), (2 + 3 * sz + 1 + 1)
    Locate 6, 3
    Color 15, 0
    Print sz; " by"; sz
    Locate 7, 4
    Print "board"

' Difficulty
    Color 7, 0
    Locate 6, 24: Print "Easy"
    Locate 8, 24: Print "Medium"
    Locate 10, 24: Print "Difficult"
    Color 15, 0
    Rect (2 * diff - 1 + 6 - 2), 23, (2 * diff - 1 + 8 - 2), 33

    Locate 1, 80

' Accept the keystroke
    k = Getkey
    If k < 32 Then
        If k = 27 Then                  ' User aborted
            sz = olds
            diff = oldd
        End If
    ElseIf (k >= 51 And k <= 54) Then   ' Board Size
        sz = k - 48
    Else
        Select Case k
            Case Asc("E"), Asc("e")     ' Easy
                diff = 1
            Case Asc("M"), Asc("m")     ' Medium
                diff = 2
            Case Asc("D"), Asc("d")     ' Difficult
                diff = 3
        End Select
    End If
    
Loop Until (k = 27 Or k = 13)

End Sub


Sub DrawBoard(ByVal y As Integer, ByVal x As Integer)
' Draws the Rotation board and the cursor

Dim As Integer i, j                     ' counter variables

' Draw the Square
Color 8, 0
Rect y, x, (y + 2 * sz + 1 + 1), (x + 3 * sz + 1 + 1)

' Draw the Numbers
Color 7, 0
For i = 1 To sz
    For j = 1 To sz
        Locate (y + 2 + 2 * (i - 1)), (x + 2 + 3 * (j - 1))
        Print Trim(Str(board(i, j)))
    Next j
Next i

' Draw the cursor
Rect (y + 2 * by - 1), (x + 3 * bx - 2), (y + 2 * by + 3), (x + 3 * bx + 4)
Locate (y + 2 * by - 1), (x + 3 * bx - 2)
Color 0, 7
If direc = CW Then
    Print ">"
Else
    Print "<"
End If

Color 7, 0
Locate 1, 80

End Sub


Sub Titlebar(ByVal msg As String)
' Draws a titlebar on the top of the screen

Locate 1, 1
Color 0, 15
Print String(80, 32)

Locate 1, 1
Print PROGNAME

If Len(msg) > 0 Then
    Locate 2, 1
    Color 8, 0
    Print msg
End If

End Sub


Sub Rect(ByVal y1 As Integer, ByVal x1 As Integer, _ 
         ByVal y2 As Integer, ByVal x2 As Integer)
' Draws a text-mode rectangle specified by the two diagonal points.
' Characters inside the rectangle are cleared.
' Color should have been set before entering the Sub.
' Coordinate order is just like the one used in Locate.

Dim As Integer i                        ' counter variable

' Make sure Point 1 is upper left and Point 2 is lower right
If x1 > x2 Then Swap x1, x2 
If y1 > y2 Then Swap y1, y2 

If x1 = x2 Then
    If y1 = y2 Then
        Locate y1, x1
        Print Chr(219)
    Else
        For i = y1 To y2                ' Vertical Line
            Locate i, x1
            Print Chr(179)
        Next i
    End If
Else
    If y1 = y2 Then
        For i = x1 To x2                ' Horizontal Line
            Locate y1, i
            Print Chr(196)
        Next i
    Else
        For i = y1 To y2
            Locate i, x1
            If i = y1 Then 
                Print Chr(218); String(x2 - x1 - 1, 196); Chr(191)
            ElseIf i = y2 Then
                Print Chr(192); String(x2 - x1 - 1, 196); Chr(217)
            Else
                Print Chr(179)
                Locate i, x2
                Print Chr(179)
            End If
        Next i
    End If
End If

End Sub
