'this will not be a complete library, but a code sniplets that shows a possible management
'regarding Win32 GUI window procedure.  
#Include "wndproc.bi"

'our window procedure
Declare Function WindowProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
'child windows procedure
Declare Function ChildProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
'the messages handlers
Declare Function MngCommand(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
Declare Function MngActivate(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
Declare Function MngInitDlg(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer

'the main array to handle messages
Dim Shared As Any ptr MsgList(WM_USER)
'the array to handle child messages - to do
'Dim Shared As Any ptr ChildMsgList(WM_USER)
'the array to process the "events"
Dim Shared As GlbMsgMgm Events(N_WxM)
'how many "events" are we using? 
Dim Shared As Integer ccount=0
'
Dim Shared As HINSTANCE hInstance
Dim Shared As HANDLE hWnd
Dim Shared As HANDLE hDlg

Dim Shared As HACCEL HAccel 

'here we put all messages we want to handle
'I discovered by chance this Constructor use 
'if we put here all messages handler we don't need the assign() proc 
Private Sub LibInit Constructor
	Msglist(WM_ACTIVATE)=@MngActivate
	Msglist(WM_INITDIALOG)=@MngInitDlg
	Msglist(WM_COMMAND)=@MngCommand
'	MsgList(WM_SIZE)=@MngSize
End Sub

'
Private Function WindowProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
'	here we save the main Window handle
	hWnd=hWin
	Dim GuiFunc As Function(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer

	If uMsg=WM_CLOSE Then
		DestroyWindow(hWin)
	End If
	If uMsg= WM_DESTROY Then 
		PostQuitMessage(0)
	EndIf 

'	we obtain the proc address based on the message
	GuiFunc=MsgList(uMsg)
'	if there is a proc run it
	If Guifunc>0 Then
		Return GuiFunc(hWin,wParam,lParam)
	Else
		Return DefWindowProc(hWin,uMsg,wParam,lParam)
	End If
	
	Return FALSE

End Function

'same as WindowProc, but this handle modal dialog
Private Function ChildProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer

	Dim GuiFunc As Function(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
'	here we save the dialog Handle
	hDlg=hWin
	If uMsg=WM_CLOSE Then
		EndDialog(hWin,0)	
	End If

'	If we use the same array, we have the same handlers
'	maybe use another array would be a better idea. To try 
	GuiFunc=MsgList(uMsg)

	If Guifunc>0 Then
		Return GuiFunc(hWin,wParam,lParam)
	End If

	Return FALSE

End Function

'here we verify if we can add the new handler
Private Sub Verify_N_WxM
	If ccount < N_WxM Then 
		ccount+=1
	Else
		MessageBox(NULL,"Too many item in the array","FB - Fatal error",MB_OK)
		End 1
	EndIf
End Sub

'Messages handlers
Private Function MngCommand(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
	Dim As Integer code,id,k
	Dim ChSub As Sub()
	
	code=HiWord(wParam)
	id=LoWord(wParam)
	
	'for child form
	If code= BN_CLICKED Then
		If id=IDCANCEL Then EndDialog(hDlg,0)
	EndIf
	
	For k=0 To ccount
		If Events(k).msg=WM_COMMAND Then
			If Events(k).code = code Or code=1 Then 
				If Events(k).id = id Then
					ChSub=Events(k).addr
					ChSub()
					Exit For
				EndIf
			EndIf 
		EndIf
	Next
	
	Return TRUE
End Function

Private Function MngActivate(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
	Dim ChSub As Sub()
	
	For k As Integer=0 To ccount
		If Events(k).msg=WM_ACTIVATE Then
			ChSub=Events(k).addr
			ChSub()
			Exit For
		EndIf
	Next
	Return TRUE
End Function

Private Function MngInitDlg(ByVal hWin As HWND,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer

	Dim ChSub As Sub()
	For k As Integer=0 To ccount
		If Events(k).msg=WM_INITDIALOG Then
			If Events(k).id=lParam Then
				ChSub=Events(k).addr
				ChSub()
				Exit For
			EndIf
		EndIf
	Next
	Return TRUE
End Function

'here we assign a windows message to a proc
Sub Assign(mess As Long,proc As Any Ptr)
	MsgList(mess)=proc
End Sub

'Events
Sub OnChange(id As Integer,proc As Any Ptr)
	Events(ccount).id=id
	Events(ccount).addr=proc
	Events(ccount).msg=WM_COMMAND		 
	Events(ccount).code=LBN_SELCHANGE
	verify_N_WxM
End Sub

Sub OnClick(id As Integer,proc As Any Ptr)
	Events(ccount).id=id
	Events(ccount).addr=proc
	Events(ccount).msg=WM_COMMAND
	Events(ccount).code=BN_CLICKED
	verify_N_WxM	
End Sub

Sub OnActivate(ID As Integer,proc As Any Ptr)
	Events(ccount).id=ID
	Events(ccount).addr=proc
	Events(ccount).msg=WM_ACTIVATE
	verify_N_WxM	
End Sub

'here we use the Dialog ID for lInitParam parameter in WM_INITDIALOG message
'in this way in the MngInitDlg we could choose the right init proc to call
Sub OnInit(ID As Integer,proc As Any Ptr)
	Events(ccount).id=ID
	Events(ccount).addr=proc
	Events(ccount).msg=WM_INITDIALOG
	Verify_N_WxM
End Sub

'Properties - to do
Sub Align(id As Integer,cAlign As Integer,WType As Integer)'0=Edit, 1 = button, 2 = combo etc.
	Events(ccount).id=id
	Events(ccount).addr=Cast(Any Ptr,cAlign)
	Events(ccount).msg=WM_SIZE
	Events(ccount).code=WType	'we will use this to choose the right alignment for the specified control
	verify_N_WxM
End Sub

'GUI section (very simple and minimal). Just to show a way to build a GUI library
'I'm sure there are many ways probably best.
'it work with resources, so we could use a resource editor to graphically build the GUI
Function CreateForm(ByVal menu As Integer,ClassName As String,icon As Integer,DlgID As Integer) As HANDLE
	Dim wc As WNDCLASSEX

	InitCommonControls
	hInstance=GetModuleHandle(NULL)
	' Setup and register class for dialog
	wc.cbSize=SizeOf(WNDCLASSEX)
	wc.style=CS_HREDRAW or CS_VREDRAW
	wc.lpfnWndProc=@WindowProc
	wc.cbClsExtra=0
	wc.cbWndExtra=DLGWINDOWEXTRA
	wc.hInstance=hInstance
	wc.hbrBackground=Cast(HBRUSH,COLOR_BTNFACE+1)
'	wc.lpszMenuName=Cast(ZString Ptr,menu)
	wc.lpszClassName=StrPtr(ClassName)
	wc.hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(icon))
	wc.hIconSm=wc.hIcon
	wc.hCursor=LoadCursor(NULL,IDC_ARROW)
	RegisterClassEx(@wc)
	
	' Create and show the dialog
	hWnd=CreateDialogParam(hInstance,MAKEINTRESOURCE(DlgID),NULL,@windowProc,DlgID)
	
	SendMessage(hWnd,WM_SIZE,NULL,NULL)
	ShowWindow(hWnd,SW_SHOWNORMAL)
	UpdateWindow(hWnd)

	Return hWnd

End Function

Sub RunForm(idAccel As Integer)
	Dim msg As MSG
	
	'load accelerators from resources
	If idAccel <>0 Then
		hAccel=LoadAccelerators(hInstance,Cast(ZString Ptr,idAccel))
	EndIf

	' Message loop
	Do While GetMessage(@msg,NULL,0,0)
		If TranslateAccelerator(hWnd,HAccel,@msg)=0 then
'			If IsDialogMessage(hWnd,@msg) =FALSE Then
				TranslateMessage(@msg)
				DispatchMessage(@msg)
'			End If
		EndIf
	Loop
End Sub

'we call a child dialog
Sub ChildForm(ChildID As Integer)
	hDlg=NULL
	DialogBoxParam(hInstance,MAKEINTRESOURCE(ChildID),hWnd,@ChildProc,ChildID)	
End Sub

'a quirk to get the main window handle. I use it in the "init dialog proc" 
'when the hWnd returned from CreateForm isn't yet available. 
Function GetMainHandle () As HANDLE
	Return hWnd
End Function

'return the child dialog handle to the caller. The same as above
Function GetDlgHandle () As HANDLE
	Return hDlg
End Function