'LightMap tester
'Relsoft 2003
'SetvideoSeg by Plasma357

DEFINT A-Z

CONST PI = 3.141593


DIM SHARED Light%(64, 64)           'Our LightMap
CLS
SCREEN 13
RANDOMIZE TIMER


'////==============Grey Scaled Pal
 FOR i = 0 TO 255
  OUT &H3C8, i
  OUT &H3C9, i \ 4
  OUT &H3C9, i \ 4
  OUT &H3C9, i \ 4
 NEXT i



'////==============Generate our LightMap
'Illumination formula:
'"Distance is inversly propotional to illumination
'i = 1 / (d ^ 2)

'/////=======Standard formula
MAXCOLOR = 255
FOR x% = -32 TO 31
FOR y% = -32 TO 31
        Dist! = SQR(x ^ 2 + y ^ 2)
        IF x% = 0 AND y% = 0 THEN   'check for center
            c% = 255
        ELSE
            c% = Dist! ^ 2
            c% = MAXCOLOR - c%
        END IF
    IF c% < 0 THEN c% = 0           'Check if it's out of bounds
    IF c% > 255 THEN c% = 255
    Light%(x% + 32, y% + 32) = c%       'save it
NEXT y%
NEXT x%


'////==============Test to see out lightmap in action
FOR y = 0 TO 64
FOR x = 0 TO 64
    PSET (70 + x, 70 + y), Light%(x, y)
NEXT x
NEXT y


'/////=======Better looking formula

'Our own way...
'i = (Strength / Distance * MAXCOLOR) - MAXCOLOR

Strength% = 32
MAXCOLOR = 255
FOR x% = -32 TO 31
FOR y% = -32 TO 31
        Dist! = SQR(x ^ 2 + y ^ 2)
        IF x% = 0 AND y% = 0 THEN   'check for center
            c% = 255
        ELSE
            c% = Strength% / Dist! * MAXCOLOR
            c% = c% - MAXCOLOR
        END IF
    IF c% < 0 THEN c% = 0           'Check if it's out of bounds
    IF c% > 255 THEN c% = 255
    Light%(x% + 32, y% + 32) = c%       'save it
NEXT y%
NEXT x%


'////==============Test to see out lightmap in action
FOR y = 0 TO 64
FOR x = 0 TO 64
    PSET (180 + x, 70 + y), Light%(x, y)
NEXT x
NEXT y


END

SUB SetVideoSeg (Segment) STATIC

DEF SEG

IF VideoAddrOff& = 0 THEN ' First time the sub is called

' We need to find the location of b$AddrC, which holds the graphics
' offset (b$OffC) and segment (b$SegC). Since b$AddrC is in the default
' segment, we can find it by setting it to a certain value, and then
' searching for that value.

SCREEN 13 ' Set b$SegC to A000 (00A0 in memory)
PSET (160, 100), 0 ' Set b$OffC to 7DA0 (not needed in the IDE)

FOR offset& = 0 TO 32764 ' Search for b$AddrC, which is
IF PEEK(offset&) = &HA0 THEN ' in the default segment and
IF PEEK(offset& + 1) = &H7D THEN ' should have a value of
IF PEEK(offset& + 2) = &H0 THEN ' A0 7D 00 A0.
IF PEEK(offset& + 3) = &HA0 THEN
VideoAddrOff& = offset& + 2 ' If we found it, record the
EXIT FOR ' offset of b$SegC and quit
END IF ' looking. (Oddly, changing
END IF ' the b$OffC doesn't seem to
END IF ' do anything, so this is why
END IF ' this sub only changes b$SegC)
NEXT

END IF

' Change b$SegC to the specified Segment

POKE VideoAddrOff&, Segment AND &HFF
POKE VideoAddrOff& + 1, (Segment AND &HFF00&) \ &H100



END SUB

