' ===================================================================================
'          NAME: Ergon O.S. (Ergonomic Operating System)
'     FILE NAME: ErgonOSHelper.bas
'     FILE TYPE: Ergon O.S. Specific Helper subs and function Definitions Module
'       VERSION: 1.00.000a Build 0001
'  DATE CREATED: Wednesday, October 26th, 2005
' -----------------------------------------------------------------------------------
'   DESCRIPTION: This module contains the different subs and functions that are 
'                needed by the main program module.  Such functions as the 
'                ValidateParameters(), LoadConfiguration() and the 
'                SetupDefaultConfiguration() subs and functions are implemented.
' ===================================================================================
'  PROJECT NAME: Ergon O.S.
'  PROJECT TYPE: Graphical User Interface
'       VERSION: 1.00.000a Build 0001
'   PROJECT URL: Coming Soon
'      LANGUAGE: FreeBasic Version 0.15b and higher
'        TARGET: DOS 32 Bits
' -----------------------------------------------------------------------------------
'   DESCRIPTION: Ergon O.S. is a Graphical User Interface Project designed to be a
'                document based User Interface.  To best describe this project, you
'                simply need to think of the GUI as a document based interface
'                rather than an application based interface as commonly seen these
'                days.
' ===================================================================================
'   AUTHOR NAME: Stephane Richard
'      NICKNAME: MystikShadows
'         EMAIL: srichard@adaworld.com
'       WEBSITE: Coming Soon
' -----------------------------------------------------------------------------------
'     COPYRIGHT: Copyright (c) January 2005 - Stephane Richard
'       LICENSE: Licenced under the G.P.L. Version 2 licence scheme
'  DISTRIBUTION: Allowed in accordance with the G.P.L. Version 2 licence
'   ALTERATIONS: Allowed as under the termes of the G.P.L. Version 2 licence
' ===================================================================================

' -----------------------------------------------
'  Preprocessor to include this module only once
' -----------------------------------------------
#IFNDEF ErgonOSHelper
#DEFINE ErgonOSHelper

' ===============================================================
'          NAME: ValidateParameters()
'    PARAMETERS: None
'       RETURNS: 0 of parameters are valid, Invalid Param number
'       ASSUMES: Nothing
'   CALLED FROM: ErgonOS.bas Main Program Section
' ---------------------------------------------------------------
'   DESCRIPTION: This Sub makes sure that any parameters that
'                passed to the application are valid ones. An
'                Error will be reported if a parameter is not
'                valid but the application will not exit instead
'                the IDE will start in default mode or process
'                the rest of the valid parameters.
' ===============================================================
FUNCTION ValidateParameters() AS INTEGER

    DIM argc       AS INTEGER
    DIM argv       AS INTEGER
    DIM WorkResult AS INTEGER

    argc = 1
    WorkResult = 0
    DO
       argv = COMMAND$(argc)
       IF LEN(argv) = 0 THEN
          EXIT DO
       END IF
       IF argv <> AlternateSetup AND argv <> CommandFileExecution THEN
          WorkResult = argc
       END IF
       argc = argc + 1
    LOOP
    ValidateParameters = WorkResult

END FUNCTION

' ===============================================================
'          NAME: LoadConfiguration()
'    PARAMETERS: ConfigFile AS STRING
'       RETURNS: 0 if no errors, Err number if anything happened
'       ASSUMES: ConfigFile is valid path and file name.
'   CALLED FROM: ErgonOS.bas Main Program Section
' ---------------------------------------------------------------
'   DESCRIPTION: This Sub takes the passed configuration file
'                name, opens it and loads up the values into the
'                appropriate User Defined Types so that they are
'                available to the rest of the application.
' ===============================================================
FUNCTION LoadConfiguration(ConfigFile AS STRING) AS INTEGER

    DIM ErrorMessage AS STRING
    DIM WorkLine     AS STRING
    DIM WorkResult   AS INTEGER
    DIM FileHandle   AS INTEGER

    ' --------------------------------
    '  Turn On Local Error Management
    ' --------------------------------
    ON LOCAL ERROR GOTO ErrorManager
    ' ----------------------------------------------------
    '  Get next available File handle and open ConfigFile
    ' ----------------------------------------------------
    WorkResult = 0
    FileHandle = FREEFILE
    OPEN ConfigFile FOR INPUT AS #FileHandle
    ' -----------------------------------------------
    '  Skip Everything until we get to the a section
    ' -----------------------------------------------
    DO WHILE WorkLine <> "[APPLICATION]"
       LINE INPUT #FileHandle, WorkLine
    LOOP
    ' ----------------------------------------------------
    '  Next we load field values into the data structures
    '  Note that this is not implemented yet but this
    '  will be a series of Field assignement for all the
    '  fields of he Application and Environment Types
    '  based on values read from the file Here's a few
    '  examples so you know how I'll do it.
    ' ----------------------------------------------------
    LINE INPUT #FileHandle, WorkLine
    Application.ScreenHeight = VAL(RIGHT$(WorkLine, LEN(WorkLine) - 30))
    LINE INPUT #FileHandle, WorkLine
    Application.ScreenWidth  = VAL(RIGHT$(WorkLine, LEN(WorkLine) - 30))
    LINE INPUT #FileHandle, WorkLine
    Application.ColorDepth   = VAL(RIGHT$(WorkLine, LEN(WorkLine) - 30))
    ' --------------------------------------
    '  Close the file and exit the function
    ' --------------------------------------
    CLOSE #FileHandle
    OpenConfigurationFile = WorkResult
    EXIT FUNCTION

' --------------------------
'  Error Management Section
' --------------------------
ErrorManager:
    ' ---------------------------------------
    '  Create the full ErrorMessage Contents
    ' ---------------------------------------
    ErrorMessage = "Engine:     ErgonOS" + CHR$(13) + _
                   "Module:     ErgonOS.bas" + CHR$(13) + _
                   "Function:   LoadConfiguration()" + CHR$(13) + _
                   "Parameters: (" + ConfigFile + ")" + CHR$(13) + _
                   "Error:      " + STR$(Err) + ":" + Err$
    ' --------------------------------------------------------
    '  Depending on settings, either log or display the error
    ' --------------------------------------------------------
    IF ErrorLogging = True THEN
       LogError(ErrorMessage)
    ELSE
       DisplayError(ErrorMessage)
    END IF

END FUNCTION

' ===============================================================
'          NAME: SetupDefaultConfiguration()
'    PARAMETERS: None
'       RETURNS: No valies
'       ASSUMES: Nothing
'   CALLED FROM: ErgonOS.bas Main Program Section
' ---------------------------------------------------------------
'   DESCRIPTION: This Sub is called when the normal loading of a
'                configuration file failed. It basically assigns
'                default values into the necessary data
'                structures to allow ErgonOS to boot in a normal
'                mode if it can.
' ===============================================================
SUB SetupDefaultConfiguration()

    ' ---------------------------------------------
    '  Setup the Application's default information
    ' ---------------------------------------------
    WITH Application
         .ScreenWidth          = 800
         .ScreenHeight         = 600
         .ColorDepth           = 8
         .ProjectVisible       = 1
         .ProjectWidth         = 200
         .ProjectHeight        = 200
         .RelatedVisible       = 1
         .RelatedWidth         = 200
         .RelatedHeight        = 200
         .SearchVisible        = 1
         .SearchWidth          = 200
         .SearchHeight         = 200
         .DocumentVisible      = 1
         .DocumentWidth        = 600
         .DocumentHeight       = 400
         .CommandVisible       = 1
         .CommandWidth         = 600
         .CommandHeight        = 130
         .ShortcutsVisible     = 1
         .ShortcutWidth        = 600
         .ShortcutHeight       = 70
    END WITH
    ' ---------------------------------------------
    '  Setup the Environment's default information
    ' ---------------------------------------------
    WITH Environment
         .DateSeperator        = "/"
         .DateFormat           = "MM/DD/CCYY"
         .TimeSeperator        = ":"
         .TimeFormat           = "HH:MM:SS"
         .DecimalSeperator     = "."
         .ThousandSeperator    = ","
         .CurrencySymbol       = "$"
         .SystemPath           = "C:\ErgonOS\"
         .DefaultProjectPath   = "C:\ErgonOS\Projects\"
         .DefaultSearchPath    = "C:\ErgonOS\Search\"
         .DefaultResourcePath  = "C:\ErgonOS\Resources\"
         .DefaultDocumentPath  = "C:\ErgonOS\Documents\"
         .DefaultToolsPath     = "C:\ErgonOS\Tools\"
    END WITH

END SUB

' ---------------------------------
'  Close the #IFNDEF defined above
' ---------------------------------
#ENDIF