' ===================================================================================
'          NAME: Ergon O.S. (Ergonomic Operating System)
'     FILE NAME: SharedUserTypes.bi
'     FILE TYPE: Ergon O.S. Shared User Defined Types Definition Module
'       VERSION: 1.00.000a Build 0001
'  DATE CREATED: Saturday, November 12th, 2005
' -----------------------------------------------------------------------------------
'   DESCRIPTION: This module defined all the User Defined Type that are needed by
'                the shared set of Ergon O.S. Modules (Shared____.bi and
'                Shared____.bas) files only.
' ===================================================================================
'  PROJECT NAME: Ergon O.S.
'  PROJECT TYPE: Graphical User Interface
'       VERSION: 1.00.000a Build 0001
'   PROJECT URL: Coming Soon
'      LANGUAGE: FreeBasic Version 0.15b and higher
'        TARGET: DOS 32 Bits
' -----------------------------------------------------------------------------------
'   DESCRIPTION: Ergon O.S. is a Graphical User Interface Project designed to be a
'                document based User Interface.  To best describe this project, you
'                simply need to think of the GUI as a document based interface
'                rather than an application based interface as commonly seen these
'                days.
' ===================================================================================
'   AUTHOR NAME: Stephane Richard
'      NICKNAME: MystikShadows
'         EMAIL: srichard@adaworld.com
'       WEBSITE: Coming Soon
' -----------------------------------------------------------------------------------
'     COPYRIGHT: Copyright (c) January 2005 - Stephane Richard
'       LICENSE: Licenced under the G.P.L. Version 2 licence scheme
'  DISTRIBUTION: Allowed in accordance with the G.P.L. Version 2 licence
'   ALTERATIONS: Allowed as under the terms of the G.P.L. Version 2 licence
' ===================================================================================

' -----------------------------------------------
'  Preprocessor to include this module only once
' -----------------------------------------------
#IFNDEF SharedUserTypes
#DEFINE SharedUserTypes

' ----------------------------------------------------------------------
'         NAME: ApplicationType
'  DESCRIPTION: This Type holds general Application related information
'               such as the screen resolution, the color depth which
'               zones are visible and the zone sizes.
' ----------------------------------------------------------------------
TYPE ApplicationType
     ScreenHeight              AS INTEGER
     ScreenWidth               AS INTEGER
     ColorDepth                AS INTEGER
     ProjectVisible            AS BYTE
     ProjectWidth              AS INTEGER
     ProjectHeight             AS INTEGER
     RelatedVisible            AS BYTE
     RelatedWidth              AS INTEGER
     RelatedHeight             AS INTEGER
     SearchVisible             AS BYTE
     SearchWidth               AS INTEGER
     SearchHeight              AS INTEGER
     DocumentVisible           AS BYTE
     DocumentWidth             AS INTEGER
     DocumentHeight            AS INTEGER
     CommandVisible            AS BYTE
     CommandWidth              AS INTEGER
     CommandHeight             AS INTEGER
     ShortcutsVisible          AS BYTE
     ShortcutWidth             AS INTEGER
     ShortcutHeight            AS INTEGER
END TYPE

' ------------------------------------------------------------
'    TYPE NAME: WindowType
'  DESCRIPTION: This holds all the needed information to
'               create a window on the screen including if
'               all controls on the window should be shown
'               or hiding, the windows title, it's size,
'               it's color combinations and its coordinates.
' ------------------------------------------------------------
TYPE WindowType
     WindowNumber              AS INTEGER
     WindowType                AS INTEGER
     WindowTitle               AS STRING
     WindowTop                 AS USHORT
     WindowLeft                AS USHORT
     WindowHeight              AS USHORT
     WindowWidth               AS USHORT
     TitleForeground           AS USHORT
     TitleBackground           AS USHORT
     ControlForeground         AS USHORT
     ControlBackground         AS USHORT
     ActiveForeground          AS USHORT
     ActiveBackground          AS USHORT
     InactiveForeground        AS USHORT
     InactiveBackground        AS USHORT
     BorderForeground          AS USHORT
     BorderBackground          AS USHORT
     HighlightForeground       AS USHORT
     HighlightBackground       AS USHORT
     ShadowForeground          AS USHORT
     ShadowBackground          AS USHORT
     IsActive                  AS BYTE
     ShowMinimize              AS BYTE
     ShowMaximize              AS BYTE
     ShowClose                 AS BYTE
     ShowControl               AS BYTE
     ShowResizeHandle          AS BYTE
     ShowVerticalScrollbar     AS BYTE
     ShowHorizontalScrollbar   AS BYTE
END TYPE

' ------------------------------------------------------------
'    TYPE NAME: EnvironmentInformation
'  DESCRIPTION: This holds the environment settings and
'               other configuration data that is active when
'               in an ErgonOS session.
' ------------------------------------------------------------
TYPE EnvironmentType
     DateSeperator             AS STRING    ' Default '/'
     DateFormat                AS STRING    ' Default 'MM/DD/CCYY'
     TimeSeparator             AS STRING    ' Default ':'
     TimeFormat                AS STRING    ' Default 'HH:MM:SS'
     DecimalSeperator          AS STRING    ' Default '.'
     ThousandSeperator         AS STRING    ' Default ','
     CurrencySymbol            AS STRING    ' Default '$'
     SystemPath                AS STRING    ' Where the system is
     DefaultProjectPath        AS STRING    ' Where the projects are
     DefaultSearchPath         AS STRING    ' Where to search first
     DefaultResourcePath       AS STRING    ' Where bitmaps are stored
     DefaultDocumentPath       AS STRING    ' Where Documents are stored
     DefaultToolsPath          AS STRING    ' where Tools are saved in
END TYPE

' ---------------------------------------------------------
'  This #ENDIF closes to module inclusion check at the top
' ---------------------------------------------------------
#ENDIF