' ===================================================================================
'          NAME: Ergon O.S. (Ergonomic Operating System)
'     FILE NAME: ErgonOS.bas
'     FILE TYPE: Main Program Module
'       VERSION: 1.00.000a Build 0001
'  DATE CREATED: Wednesday, October 26th, 2005
' -----------------------------------------------------------------------------------
'   DESCRIPTION: This module calls upon the functionality of other modules in order
'                to validate the command line parameters and act upon them.  Then it
'                will load the configuration file, initialize all sub systems and
'                present the Ergon O.S. GUI to the user.
' ===================================================================================
'  PROJECT NAME: Ergon O.S.
'  PROJECT TYPE: Graphical User Interface
'       VERSION: 1.00.000a Build 0001
'   PROJECT URL: Coming Soon
'      LANGUAGE: FreeBasic Version 0.15b and higher
'        TARGET: DOS 32 Bits
' -----------------------------------------------------------------------------------
'   DESCRIPTION: Ergon O.S. is a Graphical User Interface Project designed to be a
'                document based User Interface.  To best describe this project, you
'                simply need to think of the GUI as a document based interface
'                rather than an application based interface as commonly seen these
'                days.
' ===================================================================================
'   AUTHOR NAME: Stephane Richard
'      NICKNAME: MystikShadows
'         EMAIL: srichard@adaworld.com
'       WEBSITE: Coming Soon
' -----------------------------------------------------------------------------------
'     COPYRIGHT: Copyright (c) January 2005 - Stephane Richard
'       LICENSE: Licenced under G.P.L. Version 2 for OpenSourceProjects
'                Licenced under B.S.D. for freeware/shareware projects
'  DISTRIBUTION: Allowed in accordance with the G.P.L. Version 2 licence
'   ALTERATIONS: Allowed as under the termes of the G.P.L. Version 2 licence
' ===================================================================================

' --------------------------------------
'  Module and Library Inclusion Section
' --------------------------------------
'$INCLUDE: 'SharedConstants.bi'
'$INCLUDE: 'SharedUsertypes.bi'
'$INCLUDE: 'ErgonOSConstants.bi'
'$INCLUDE: 'ErgonOSHelper.bas'

' -------------------------------------------
'  Globally available Variables declarations
' -------------------------------------------
DIM SHARED Application AS ApplicationType
DIM SHARED Environment AS EnvironmentType
DIM SHARED ConfigFile  AS STRING
DIM SHARED FileResult  AS INTEGER

' ------------------------------------------------------
'  If there's any parameters, we'll validate them here.
' ------------------------------------------------------
IF COMMAND$ <> "" THEN
   ValidArguments = ValidateParameters()
   IF ValidArguments = 0 THEN
      ' ---------------------------------------------
      '  Test to see if a /C: parameter was supplied
      ' ---------------------------------------------
      IF UCASE$(LEFT$(COMMAND$(1), 3)) = "/C:" THEN
         ' --------------------------------------
         '  Going to open the passed config file
         ' --------------------------------------
         ConfigFile = RIGHT$(TRIM$(COMMAND$(1)), LEN(TRIM$(COMMAND$(1))) - 3)
      ELSE
         ' ---------------------------------------
         '  Going to open the default config file
         ' ---------------------------------------
         ConfigFile = "ErgonOS.cfg"
      END IF
      ' ---------------------------------------------
      '  Test to see if a /E: parameter was supplied
      ' ---------------------------------------------
      IF UCASE$(LEFT$(COMMAND$(1), 3)) = "/E:" THEN
         CanExecuteCommandFile = 1
      END IF
   END IF
END IF
' --------------------------------------------------------
'  We start printing some general information to the user
' --------------------------------------------------------
WIDTH 80, 50
CLS
COLOR White,     Black: PRINT ApplicationName;
COLOR White,     Black: PRINT " Version " + VersionStamp
COLOR Yellow,    Black: PRINT ProjectDescription
COLOR Yellow,    Black: PRINT "Brought to you by " + AuthorName
COLOR LightCyan, Black: PRINT ProjectLicensing
COLOR LightCyan, Black: PRINT ProjectCopyright

' ------------------------------------------
'  We can now load the configuration file
' ------------------------------------------
COLOR Yellow, Black: PRINT "Loading Configuration File.           ";
FileResult = LoadConfiguration(ConfigFile)
IF FileResult = 0 THEN
   ' ------------------------------------------
   '  If there's no errors, we print "Success"
   ' ------------------------------------------
   COLOR LightGreen, Black: PRINT "Success"
ELSE
   ' --------------------------------------------
   '  If there was error we setup default values
   ' --------------------------------------------
   COLOR LightRed,   Black: PRINT "Failed"
   COLOR Yellow,     Black: PRINT "Creating Default Configuration"
   CALL SetupDefaultConfiguration()
END IF

' -----------------------------------------------------------
'  1. Acquire low level System Information (from LAHP)
'  2. Acquire list of storage media (from LAHP)
'  3. Acquire all available Screen Resolutions (from VADM)
'  4. Setup all default visible components (from EVRIL)
'  5. Set the screen into desired mode (from VADM)
'  6. Draw all components on screen (from EVRIL)
'  7. Go into Main ErgonOS Event Management Loop (from TEMS)
' -----------------------------------------------------------

' -------------------------------------------------------
'  If a Command file to run was specified, we execute it
' -------------------------------------------------------
IF CanExecuteCommandFile = 1 THEN
   ' Later we'll call the code to execute a command file.
END IF
