DECLARE SUB StartGame(level AS INTEGER)
DECLARE SUB UpdatePlayer()
DECLARE SUB Display()
DECLARE SUB SpawnChaser(num AS INTEGER)
DECLARE SUB UpdateChaser()
DECLARE SUB SpawnResource(num AS INTEGER)
DECLARE SUB BlastEmToHell()
DECLARE SUB LoseGame()
DECLARE SUB WaitForKeyRelease()
DECLARE FUNCTION Collision (x1 AS INTEGER,y1 AS INTEGER,r1 AS INTEGER,x2 AS INTEGER,y2 AS INTEGER,r2 AS INTEGER) AS BYTE
DECLARE FUNCTION Distance (x1 AS INTEGER, y1  AS INTEGER, x2  AS INTEGER, y2  AS INTEGER)  AS INTEGER
DECLARE FUNCTION Angle(x1 AS INTEGER,y1 AS INTEGER,x2 AS INTEGER,y2 AS INTEGER) AS INTEGER

TYPE ChaserType
    x               AS INTEGER
    y               AS INTEGER
    lastUpdate      AS DOUBLE
    lastDamage      AS DOUBLE
END TYPE

TYPE ResourceType
    x               AS INTEGER
    y               AS INTEGER
END TYPE

TYPE GameType
    health          AS INTEGER
    button          AS BYTE
    lastButton      AS DOUBLE
    lastX           AS INTEGER
    lastY           AS INTEGER
    currentPage     AS BYTE
    level           AS UINTEGER
    chaserSpeed     AS INTEGER
    chaserAmount    AS INTEGER
    resourceAmount  AS INTEGER
    resourceNeeded  AS INTEGER
    resourceHave    AS INTEGER
    resourceRate    AS INTEGER
    lastResource    AS DOUBLE
    difficulty      AS INTEGER
END TYPE

CONST False = 0
CONST True = NOT(False)
CONST Used = 4
CONST r2d = .01745329252

DIM SHARED    AS GameType      game
DIM SHARED    AS ResourceType  resource(9)
DIM SHARED    AS ChaserType    chaser(499)

DIM           AS INTEGER       tempfps, _
                               fps, _
                               tempX, _
                               tempY, _
                               tempButtons, _
                               tempAngle, _
                               tempDistance
                        
DIM           AS DOUBLE        fpsTimer
DIM           AS STRING        tempDifficulty

SCREENRES 640,480,32,2
RANDOMIZE TIMER
INPUT "Difficulty? (1=easy, higher = harder)"; tempDifficulty
game.difficulty = INT(VAL(tempDifficulty) * 10)
WaitForKeyRelease()
game.resourceRate = 100 / game.difficulty
StartGame(1)
SCREENSET currentPage, -(currentPage-1)
SETMOUSE  ,,0 'hide the cursor
fpsTimer = TIMER

DO
    UpdatePlayer()
    UpdateChaser()
    CLS
    Display()
    
    'LOCATE 3,1: PRINT "FPS: "+str$(fps)      
       
    currentPage = -(currentPage-1)
    SCREENSET currentPage, -(currentPage-1)
    'tempfps += 1
    'IF TIMER - fpsTimer >= 1 THEN
    '    fps = tempfps
    '    tempfps=0
    '    fpsTimer = TIMER        
    'END IF
    
LOOP UNTIL MULTIKEY(1)
END

SUB StartGame(level AS INTEGER)
    DIM AS STRING CKEY
    DIM AS INTEGER tempButtons, tempX, tempY
    SCREENSET 0,0
    CLS
    IF level <> 1 THEN 
        PRINT "Level"; level - 1; " Finished!"
        PRINT "Press Any Key To Continue to Level (or any mouse button ;) )"; level        
    ELSE
        PRINT "Press Any Key To Start Game! (or any mouse button ;) )"
        game.resourceHave = INT(500/game.difficulty)
    END IF
    DO 'wait for keypress
        FOR tempCount = 0 TO 127
            IF MULTIKEY(tempCount) = -1 THEN EXIT DO
        NEXT
        GETMOUSE tempX,tempY,,tempButtons
        IF tempButtons > 0 THEN EXIT DO
        CKEY = INKEY$
    LOOP UNTIL CKEY = CHR$(255) + "X"
    WaitForKeyRelease()
    game.level = level
    game.chaserAmount = game.level * game.difficulty
    IF game.chaserAmount > 500 THEN game.chaserAmount = 500
    game.chaserspeed = 5 * game.difficulty + game.level * 10
    game.resourceAmount = 10 - game.level \ 5
    IF game.resourceAmount < 1 THEN game.resourceAmount = 1
    game.resourceNeeded += (5 * game.difficulty + game.level * 2.5 * game.difficulty)
    SpawnChaser(game.chaserAmount)
    SpawnResource(game.resourceAmount)
END SUB

SUB UpdatePlayer()
    DIM AS INTEGER tempCount, tempX, tempY, tempButtons
    
    GETMOUSE tempX, tempY, ,tempButtons    
    
    game.button = False
    IF (tempButtons AND 1) AND NOT(tempX = -1) THEN 
        game.button = True 
    ELSE
        game.button = False
    END IF
    
    FOR tempCount = 0 TO game.resourceAmount - 1
        IF Collision(tempX, tempY, 10, resource(tempCount).x, resource(tempCount).y, 5) = True THEN
            IF (TIMER - game.lastResource) >= 1 THEN
                game.resourceHave += game.resourceRate
                game.lastResource = TIMER
            ELSEIF (TIMER - game.lastResource) * game.resourceRate >= .5 THEN
                game.resourceHave += (TIMER - game.lastResource) * game.resourceRate
                game.lastResource = TIMER
            END IF
        END IF
    NEXT
    IF game.resourceHave >= game.resourceNeeded THEN StartGame(game.level + 1)
    IF game.button = True THEN 'if left mouse
        IF (TIMER - game.lastButton) >= game.difficulty\2-1 THEN
            BlastEmToHell() 'launch weapon
        END IF
    END IF
    FOR tempCount = 0 TO game.chaserAmount - 1
        IF Collision(tempX, tempY, 10, chaser(tempCount).x, chaser(tempCount).y, 6) = True THEN
            circle(0,0),144,rgb(255,0,255)
            IF (TIMER - chaser(tempCount).lastDamage) > 1 THEN
                game.resourceHave -= game.resourceRate * 2
                chaser(tempCount).lastDamage = TIMER
            ELSEIF (TIMER - chaser(tempCount).lastDamage) * game.resourceRate * 2 > .5 THEN
                game.resourceHave -= game.resourceRate * 2 * (TIMER - chaser(tempCount).lastDamage)
                chaser(tempCount).lastDamage = TIMER
            END IF
        END IF    
    NEXT
    IF game.resourceHave <= 0 THEN LoseGame()    
END SUB

SUB Display()
    DIM AS INTEGER tempCount, tempX, tempY, tempButtons, tempColor
    
    FOR tempCount = 0 TO game.resourceAmount - 1
        CIRCLE(resource(tempCount).x,resource(tempCount).y), 5, RGB(0,0,192)
    NEXT
    
    FOR tempCount = 0 TO game.chaserAmount - 1
        IF chaser(tempCount).lastUpdate < TIMER THEN 
            CIRCLE(chaser(tempCount).x,chaser(tempCount).y), 6, RGB(255,32,1)
        ELSE
            IF (INT(TIMER*10)) AND 1 _
            THEN CIRCLE(chaser(tempCount).x,chaser(tempCount).y), 6, RGB(128,16,1)
        END IF        
    NEXT
    
    IF (TIMER - game.lastButton) < (2.2 / game.difficulty) THEN
        FOR tempX = 120 TO (((TIMER - game.lastButton) / (22 / game.difficulty))*1200) STEP -10
            tempColor = ((TIMER - game.lastButton) / (22 / game.difficulty)) * 255
            tempColor = RGB(255,240-tempX*2, 0)'RGB(tempX*2,240-tempX*2, 0)
            CIRCLE(game.lastX, game.lastY), tempX, tempColor
        NEXT
    END IF
    
    GETMOUSE TempX, TempY, , TempButtons
    CIRCLE(tempX, tempY), 10, RGB(0,255,0)
    
    LOCATE 1,52:PRINT "Peta-blast"
    tempColor = (TIMER - game.lastButton)/(game.difficulty\2-1) * 255
    IF tempColor >= 255 THEN 
        tempColor = RGB(255,255,0)
        COLOR RGB(255,0,0)
        IF INT(TIMER) AND 1 THEN LOCATE 2,54: PRINT "READY!"
        COLOR RGB(224,224,224)
    ELSE 
        tempColor = RGB(255,tempColor,0)
        LOCATE 2,52: 
        COLOR RGB(0,0,255)
        IF (((INT(TIMER*5)SHL 29)SHR 29)+4)\2 = 0 THEN 
            PRINT "CHARGING."
        ELSEIF (((INT(TIMER*5)SHL 29)SHR 29)+4)\2 = 1 THEN
            PRINT "CHARGING.. "
        ELSEIF (((INT(TIMER*5)SHL 29)SHR 29)+4)\2 = 2 THEN
            PRINT "CHARGING..."
        ELSE
            PRINT "CHARGING   "
        END IF
        COLOR RGB(224,224,224)
    END IF
    LINE(500, 0)-(500+140*(TIMER - game.lastButton)/(game.difficulty\2-1),7),tempColor,BF
    LOCATE 1,1
    IF (game.resourceHave/game.resourceNeeded)< .1 THEN
        tempColor = RGB(255,0,0)
        COLOR tempColor
        IF INT(TIMER * 2) AND 1 THEN PRINT "MegaChow:";game.resourceHave; " out of:";game.resourceNeeded
    ELSE
        PRINT "MegaChow:";game.resourceHave; " out of:";game.resourceNeeded
    END IF
    
END SUB

SUB BlastEmToHell()
    DIM AS INTEGER tempCount, tempX, tempY, tempButtons, tempAngle
    IF game.resourceHave <= game.resourceRate * 5 THEN EXIT SUB
    game.resourceHave -= game.resourceRate * 5 'it costs a ton for this
    GETMOUSE tempX, tempY,,tempButtons
    game.lastX = tempX
    game.lastY = tempY
    FOR tempCount = 0 TO game.chaserAmount - 1
        IF Collision(chaser(tempCount).x, chaser(tempCount).y, 6, tempX, tempY, 120 ) THEN
            tempAngle = Angle(tempX,tempY,chaser(tempCount).x, chaser(tempCount).y)
            chaser(tempCount).x = COS(tempAngle * r2d) * 110 + chaser(tempCount).x
            IF chaser(tempCount).x < 0 THEN 
                chaser(tempCount).x += 640
            ELSEIF chaser(tempCount).x > 639 THEN 
                chaser(tempCount).x -= 640
            END IF
            chaser(tempCount).y = SIN(tempAngle * r2d) * 110 + chaser(tempCount).y
            IF chaser(tempCount).y < 0 THEN 
                chaser(tempCount).y += 480
            ELSEIF chaser(tempCount).x > 479 THEN 
                chaser(tempCount).x -= 480
            END IF
            chaser(tempCount).lastUpdate = 23/game.difficulty
            IF chaser(tempCount).lastUpdate < .5 THEN chaser(tempCount).lastUpdate = .5
            chaser(tempCount).lastUpdate += TIMER
        END IF
    NEXT
    game.lastButton = TIMER
END SUB

SUB SpawnChaser(num AS INTEGER)
    DIM AS INTEGER tempCount, tempX, tempY, tempButtons
    FOR tempCount = 0 TO num - 1
        SETCOORD:
        chaser(tempCount).x = INT(RND * 640)
        chaser(tempCount).y = INT(RND * 480)
        chaser(tempCount).lastUpdate = TIMER
        GETMOUSE tempX, tempY,,tempButtons
        IF Distance(tempX, tempY, chaser(tempCount).x, chaser(tempCount).y) < 80 THEN GOTO SETCOORD
    NEXT
END SUB 

SUB UpdateChaser()
    DIM AS INTEGER tempAngle, tempCount,tempNum
    DIM AS INTEGER tempX, tempY, tempButtons
    DIM AS INTEGER tempLowestIndex, tempLowestValue
    GETMOUSE tempX, tempY,,tempButtons
    tempLowestValue = 2000
    tempLowestIndex = -1
    FOR tempCount = 0 TO game.resourceAmount - 1
        tempDistance = Distance(tempX, tempY, resource(tempCount).x, resource(tempCount).y)
        IF tempDistance < tempLowestValue THEN
            tempLowestIndex = tempCount
            tempLowestValue = tempDistance
        END IF
    NEXT
    FOR tempCount = 0 TO game.chaserAmount - 1
        IF ((TIMER - chaser(tempCount).lastUpdate) * game.chaserSpeed) >= 1 THEN
            GETMOUSE tempX, tempY,,tempButtons
            tempDistance = Distance(chaser(tempCount).x,chaser(tempCount).y, tempX, tempY)
            tempNum = 10 + tempDistance\25
            IF tempDistance < 150 OR INT(RND * tempNum)=0 THEN
                tempDistance = Distance(resource(tempLowestIndex).x, resource(tempLowestIndex).y, chaser(tempCount).x, chaser(tempCount).y)
                IF tempDistance > tempLowestValue THEN
                    tempX = resource(tempLowestIndex).x
                    tempY = resource(tempLowestIndex).y
                END IF
                tempAngle = Angle(chaser(tempCount).x,chaser(tempCount).y,tempX,tempY)
            ELSE
                tempAngle = INT(RND * 360)
            END IF
            chaser(tempCount).lastUpdate = (TIMER - chaser(tempCount).lastUpdate)
            IF chaser(tempCount).lastUpdate > 1 THEN chaser(tempCount).lastUpdate = 1
            chaser(tempCount).x += COS(tempAngle * r2d) * (game.chaserSpeed * chaser(tempCount).lastUpdate) * (INT(RND * 50)+75)/100
            chaser(tempCount).y += SIN(tempAngle * r2d) * (game.chaserSpeed * chaser(tempCount).lastUpdate) * (INT(RND * 50)+75)/100
            IF chaser(tempCount).x < 0 THEN chaser(tempCount).x = 0
            IF chaser(tempCount).y < 0 THEN chaser(tempCount).y = 0
            IF chaser(tempCount).x > 639 THEN chaser(tempCount).x = 639
            IF chaser(tempCount).y > 479 THEN chaser(tempCount).y = 479
            chaser(tempCount).lastUpdate = TIMER
        END IF    
    NEXT
    
END SUB

SUB SpawnResource(num AS INTEGER)
    FOR tempCount = 0 TO num - 1
        resource(tempCount).x = INT(RND * 640)
        resource(tempCount).y = INT(RND * 480)
    NEXT
END SUB

SUB LoseGame()
    SCREENSET 0,0
    CLS
    DIM AS INTEGER tempCount, tempKey 
    PRINT "YOU HAVE FAILED TO SURVIVE. YOUR CARCASS IS NOW DINNER FOR THE KILOTWERPS."
    DO
        FOR tempCount = 0 TO 127
            IF MULTIKEY(tempCount) THEN 
                EXIT DO
            END IF            
        NEXT
    LOOP    
    END
END SUB

SUB WaitForKeyRelease()
    DIM AS INTEGER tempCount, tempKey 
    DIM AS INTEGER tempButtons, tempX, tempY
    DO
        tempKey = 0
        FOR tempCount = 0 TO 127
            IF MULTIKEY(tempCount) THEN 
                tempKey +=1
                EXIT FOR
            END IF            
        NEXT
        GETMOUSE tempX,tempY,,tempButtons
        IF tempButtons > 0 THEN tempKey += 1
        IF tempKey = 0 THEN EXIT SUB
    LOOP
END SUB 

FUNCTION Collision (x1 AS INTEGER,y1 AS INTEGER,r1 AS INTEGER,x2 AS INTEGER,y2 AS INTEGER,r2 AS INTEGER) AS BYTE
    DIM AS INTEGER tempDistance
    tempDistance = Distance(x1,y1,x2,y2)
    IF tempDistance <= (r1+r2) THEN RETURN True
    RETURN False
END FUNCTION

FUNCTION Distance (x1 AS INTEGER, y1  AS INTEGER, x2  AS INTEGER, y2  AS INTEGER)  AS INTEGER
    RETURN INT(SQR( ( x1 - x2 ) ^ 2 + ( y1 - y2 ) ^ 2 ))
END FUNCTION 
'x1 and y1 are your starting coords, x2 and y2 your dest coords
FUNCTION Angle(x1 AS INTEGER,y1 AS INTEGER,x2 AS INTEGER,y2 AS INTEGER) AS INTEGER
    DIM AS Integer tempAngle, tempY, tempX
    tempX = x1 - x2
    tempY = y1 - y2
    tempAngle = ( ATN ( tempY / tempX ) ) / r2d
    IF tempX < 0 XOR tempY < 0 THEN tempAngle = tempAngle + 180
    IF tempY >= 0 THEN tempAngle = tempAngle + 180
    RETURN tempAngle
END FUNCTION 