DECLARE SUB getXY (x0!, y0!, z0!, sx%, sy%)
DECLARE SUB mRotate (an!, plane%)
DECLARE SUB mMult ()
DECLARE SUB mIdentity ()
declare sub mScale (factor!)

DEFINT A-Z
randomize timer

const xplane = 0, yplane = 1, zplane = 2

DIM SHARED apage, bpage, zback, rad as single
DIM SHARED matrix(8) AS SINGLE, tempmatrix(2, 8) AS SINGLE

screen 13,,2

apage = 0
bpage = 1
rad = 3.141592 / 180
zback = 30
matrixScale! = .8
xan! = -20
rotSpd! = .05
scaleSpd! = .001

DO

    swap apage, bpage
    screenset apage, bpage
    cls

    mIdentity
    mRotate yan!, yplane
    mRotate xan!, xplane
    mScale matrixScale!
    
    FOR x! = -10 TO 10 STEP 2
        FOR z! = -10 TO 10 STEP 2
        
            getXY x!, 0, z!, sx, sy
            PSET (sx, sy), 7
          
        NEXT
    NEXT

    if multikey(&h1) then exit do
    
    if multikey(&h48) then xan! = xan! + rotSpd!
    if multikey(&h50) then xan! = xan! - rotSpd!
    if multikey(&h4b) then yan! = yan! - rotSpd!
    if multikey(&h4d) then yan! = yan! + rotSpd!
    
    if multikey(&h4e) then matrixScale! = matrixScale! + scaleSpd!
    if multikey(&h4a) then matrixScale! = matrixScale! - scaleSpd!
    
    while inkey$ <> "": wend

LOOP





SUB getXY (x0!, y0!, z0!, sx, sy)

  nx! = x0! * matrix(0) + y0! * matrix(3) + z0! * matrix(6)
  ny! = x0! * matrix(1) + y0! * matrix(4) + z0! * matrix(7)
  nz! = x0! * matrix(2) + y0! * matrix(5) + z0! * matrix(8) - zback

  IF nz! = 0 THEN nz! = -.1
  sx = 160 + nx! / nz! * 256
  sy = 150 + ny! / nz! * 256

END SUB

SUB mIdentity

  for i = 0 to 8
    matrix(i) = 0
  NEXT

  matrix(0) = 1
  matrix(4) = 1
  matrix(8) = 1


END SUB

SUB mMult
 
  FOR i = 0 TO 8
    tempmatrix(0, i) = matrix(i)
  NEXT

  FOR y = 0 TO 2
    FOR x = 0 TO 2
      v! = 0
      FOR a = 0 TO 2
        i1 = y * 3 + a
        i2 = a * 3 + x
        v! = v! + tempmatrix(0, i1) * tempmatrix(1, i2)
      NEXT
      i3 = y * 3 + x
      matrix(i3) = v!
    NEXT
  NEXT

END SUB

SUB mRotate (an!, plane)

  SELECT CASE plane
    CASE xplane
      tempmatrix(1, 0) = 1
      tempmatrix(1, 1) = 0
      tempmatrix(1, 2) = 0
      tempmatrix(1, 3) = 0
      tempmatrix(1, 4) = COS(rad * an!)
      tempmatrix(1, 5) = -SIN(rad * an!)
      tempmatrix(1, 6) = 0
      tempmatrix(1, 7) = SIN(rad * an!)
      tempmatrix(1, 8) = COS(rad * an!)
      mMult
    CASE yplane
      tempmatrix(1, 0) = COS(rad * an!)
      tempmatrix(1, 1) = 0
      tempmatrix(1, 2) = SIN(rad * an!)
      tempmatrix(1, 3) = 0
      tempmatrix(1, 4) = 1
      tempmatrix(1, 5) = 0
      tempmatrix(1, 6) = -SIN(rad * an!)
      tempmatrix(1, 7) = 0
      tempmatrix(1, 8) = COS(rad * an!)
      mMult
    CASE zplane
      tempmatrix(1, 0) = COS(rad * an!)
      tempmatrix(1, 1) = SIN(rad * an!)
      tempmatrix(1, 2) = 0
      tempmatrix(1, 3) = -SIN(rad * an!)
      tempmatrix(1, 4) = COS(rad * an!)
      tempmatrix(1, 5) = 0
      tempmatrix(1, 6) = 0
      tempmatrix(1, 7) = 0
      tempmatrix(1, 8) = 1
      mMult
  END SELECT


END SUB


sub mScale (factor!)
    for i = 0 to 8
        matrix(i) = matrix(i) * factor!
    next
end sub
