'OpenGL Picking Example
'MGD - Matt's GameDev
'http://mysite.verizon.net/vzepe2fj
'OpenGL Rendering code by:
'Relsoft 2004
'Rel.Betterwebber.com
DefInt A - Z

Const PI = 3.141593                    'PI for rotation
Const SCR_WIDTH = 800                  'Width of the screen
Const SCR_HEIGHT = 600                 'height of the screen
Const BITSPP = 32                      '32 bits per pixel format

Option Explicit                         'Force declaration

'$include: "\sdl\sdl.bi"                'sdl function and constants declaration
'$include: "\gl\gl.bi"                  'OpenGL funks and consts
'$include: "\gl\glu.bi"                 'GL standard utility lib

'Declarations
Declare Sub Init_GL_SDL(SDLscreen As SDL_Surface ptr)       'Initialization of SDL and openGL
Declare Sub SDL_GetEvents(EscapeVal As Integer)             'Process events detected by SDL
Declare Sub Draw_Scene()                                    'Load our 3D scene into the buffer
Declare Sub Draw_Cube(SLen As Single, glColorArray() As UByte) 'My sub for drawing a simple cube
Declare Sub Pick (Cursor_X As Integer, Cursor_Y As Integer)    'Our Picking Sub


'*******************************************************************************************
'Main code
'*******************************************************************************************
Dim Shared thetaX As Integer, thetaY As Integer, thetaZ As Integer 'Rotation Variables
Dim Shared Cube_Flags(0 To 5) As Integer     'Highlight Flags of Cube (value 1 = highlight, 0 = normal; index 0 = front, 1 = left, 2 = back, 3 = right, 4 = top, 5 = bottom faces)
Dim vpage As SDL_Surface Ptr            'The screen we want to draw to
Dim Finished As Integer                 'Quit or not?
Dim Timei As Double                     'Our Time variable for pausing
Init_GL_SDL vpage                       'Initizaliaze all GL SDL stuff
Finished = 0                            'Set finished to false
Do
   Timei = Timer                       'Set out Time var to the Timer
   SDL_GetEvents(Finished)             'Handle events (Process Input from the user)
   Draw_Scene                          'Draw something to the buffer
   SDL_GL_SwapBuffers                  'Swap the buffer you just drawed to to the screen so we can see it
   SDL_PumpEvents                      'Force an event queue update(input, etc)
   Do: Loop While Timer - Timei <= .015  'Pause
Loop Until Finished                      'Loop until SDL_GetEvents returns finished as true
SDL_Quit                                'Quit SDL
End                                     'End Program

'*******************************************************************************************
'SUBS/FUNKS
'*******************************************************************************************

'*******************************************************************************************
'Initializes GL+SDL
'Params: SDLscreen pointer to GL/SDL context to draw to
Sub Init_GL_SDL(SDLscreen as SDL_Surface ptr)

   Dim Result as unsigned integer      'Checker value for SDL initialization
   Dim SDL_flags as integer            'Flags for SDL screen

   'OpenGL params for gluerspective
	Dim FOVy As Double            
	Dim Aspect As Double         
	Dim znear As Double          
	Dim zfar As Double            

    SDL_flags = SDL_HWSURFACE 
    SDL_flags = SDL_flags or SDL_DOUBLEBUF     
    SDL_flags = SDL_flags or SDL_OPENGL         
    'SDL_flags = SDL_flags or SDL_FULLSCREEN     'FullScreen(REM for windowed)

	result = SDL_Init(SDL_INIT_EVERYTHING)
	If result <> 0 Then End 1                               'Then quit
    
	SDLscreen = SDL_SetVideoMode(SCR_WIDTH, SCR_HEIGHT, BITSPP, SDL_flags)
	If SDLscreen = 0 Then SDL_Quit: End 1

	SDL_WM_SetCaption "OpenGL Picking Tutorial", ""       'Make caption if Windowed
	glViewport 0, 0, SCR_WIDTH, SCR_HEIGHT

	glMatrixMode GL_PROJECTION
	glLoadIdentity

    FOVy = 80/2                                     '45 Degree Feild of Veiw
    Aspect = SCR_WIDTH / SCR_HEIGHT                 'Aspect of the screen = x/y
    znear = 1                                       'Near clip
    zfar = 200                                      'Far clip

    'use glu Perspective to set our 3d frustum dimension up
	gluPerspective FOVy, aspect, znear, zfar

	glMatrixMode GL_MODELVIEW
	glLoadIdentity

	glShadeModel GL_SMOOTH                
	glClearColor 0.2, 0.2, 0.2, 0.0             'The color it uses to clear the screen
	glClearDepth 1.0                       
	glEnable GL_DEPTH_TEST                

	glDepthFunc GL_LEQUAL
	glEnable GL_COLOR_MATERIAL

	'Tell openGL that we want the best possible perspective transform
	glHint GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST

End Sub


'*******************************************************************************************
'Check for events from SDL
'Params: Escapeval is a byref integer that allows us to
'       quit out mainloop and quit the proggie

Sub SDL_GetEvents(EscapeVal As Integer)
  'SDL event is type in the SDL inc directory
  Dim event as SDL_Event
     Dim MX As Integer, MY As Integer    'Initialize Mouse Vars
        'poll events
		While(SDL_PollEvent(@event))
			Select Case event.type
                Case SDL_KEYDOWN:               
				    EscapeVal = -1        'If user pressed a key down then Exit program
				Case SDL_MOUSEBUTTONDOWN:     'If user clicked the mouse button down
                  SDL_GetMouseState @Mx, @My    'Get the Position of the mouse
                  Pick Mx, My                   'Pick with those coordinates
			End Select
		Wend
End Sub
Sub Draw_Scene()
    glClear  GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT 'Clear Screen
        
    glPushMatrix    'Matrix Stuff
    glLoadIdentity

    glTranslatef 0.0, 0.0, -10.0 'Translate(x, y, z)
 
    glScalef 0.7, 0.7, 0.7  'Scale(x, y, z)
    
    glRotatef thetaX, 1, 0, 0      'Rotate(Ang, x, y, z)
    glRotatef thetaY, 0, 1, 0        
    glRotatef thetaZ, 0, 0, 1        
    
    glColor3f 1.0, 1.0, 1.0      'Change Color
    'Draw the cube (Cyan Color)
    ReDim glColorArray (0 To 5, 0 To 2) As UByte, i As Integer 'Initailize ColorArray 4 the cube and the index i
    'Again first index 0 = front, 1 = left ... 5 = bottom, second index 0 = Red value, 1 = Green value, 2 = Blue value (0-255)
    For i = 0 To 5
      If Cube_Flags(i) = 0 Then    'If Face of Cube isnt highlighted then
         'Draw a Cyan Face
         glColorArray(i, 0) = 0            'Red
         glColorArray(i, 1) = 210          'Green
         glColorArray(i, 2) = 255          'Blue
        Else                      'If Face of Cube highlighted = true then
         'Draw a Yellowish Face
         glColorArray(i, 0) = 255           'Red
         glColorArray(i, 1) = 240           'Green
         glColorArray(i, 2) = 0             'Blue
      End If
    Next i
    Draw_Cube 2.0, glColorArray()           'Draw the cube with 4.0 side lengths
    
    'Rotate the cube
    thetaX = thetaX + 1
    thetaY = thetaY + 1
    thetaZ = thetaZ + 1

    glPopMatrix       'pop it
    glFlush 'Down the glToliet
End Sub
Sub Draw_Cube(SLen As Single, glCA() As UByte)
 'My sub for making a cube with its center at the current Trans point
 'Basically it Draws our cube
 glBegin GL_QUADS
      glColor3ub glCA(0,0), glCA(0,1), glCA(0,2)
      glVertex3f -SLen, SLen, SLen
      glVertex3f SLen, SLen, SLen 
      glVertex3f SLen, -SLen, SLen
      glVertex3f -SLen, -SLen, SLen
      
      glColor3ub glCA(1,0), glCA(1,1), glCA(1,2)
      glVertex3f -SLen, SLen, SLen
      glVertex3f -SLen, -SLen, SLen
      glVertex3f -SLen, -SLen, -SLen
      glVertex3f -SLen, SLen, -SLen
      
      glColor3ub glCA(2,0), glCA(2,1), glCA(2,2) 
      glVertex3f -SLen, -SLen, -SLen
      glVertex3f -SLen, SLen, -SLen 
      glVertex3f SLen, SLen, -SLen
      glVertex3f SLen, -SLen, -SLen
      
      glColor3ub glCA(3,0), glCA(3,1), glCA(3,2)
      glVertex3f SLen, SLen, -SLen
      glVertex3f SLen, -SLen, -SLen
      glVertex3f SLen, -SLen, SLen
      glVertex3f SLen, SLen, SLen
      
      glColor3ub glCA(4,0), glCA(4,1), glCA(4,2)
      glVertex3f -SLen, SLen, SLen
      glVertex3f SLen, SLen, SLen
      glVertex3f SLen, SLen, -SLen
      glVertex3f -SLen, SLen, -SLen
      
      glColor3ub glCA(5,0), glCA(5,1), glCA(5,2)
      glVertex3f -SLen, -SLen, SLen
      glVertex3f SLen, -SLen, SLen
      glVertex3f SLen, -SLen, -SLen
      glVertex3f -SLen, -SLen, -SLen
    glEnd
End Sub
Sub Pick(Cursor_X As Integer, Cursor_Y As Integer)
    'Our Picking Sub
    glClearColor 0.0, 0.0, 0.0, 0.0        'Set Clear color to black
    glClear  GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT 'Clear Screen
        
    glPushMatrix    'Start with a fresh matrix
    glLoadIdentity  'Load it with an Identity (all 0s with 1s going diagonal from 1 corner to the other)

    glTranslatef 0.0, 0.0, -10.0 'Translate(x, y, z)
 
    glScalef 0.7, 0.7, 0.7  'Scale(x, y, z)

    glRotatef thetaX, 1, 0, 0      'Rotate(Ang, x, y, z)
    glRotatef thetaY, 0, 1, 0        
    glRotatef thetaZ, 0, 0, 1        
    
    glColor3f 1.0, 1.0, 1.0      'Change Color
    glDisable GL_DITHER
    
     'Draw the cube with the different colors
    ReDim glColorArray (0 To 5, 0 To 2) As UByte
    glColorArray (0, 0) = 0
    glColorArray (0, 1) = 0
    glColorArray (0, 2) = 255
    
    glColorArray (1, 0) = 0
    glColorArray (1, 1) = 255
    glColorArray (1, 2) = 0
    
    glColorArray (2, 0) = 0
    glColorArray (2, 1) = 255
    glColorArray (2, 2) = 255
    
    glColorArray (3, 0) = 255
    glColorArray (3, 1) = 0
    glColorArray (3, 2) = 0
    
    glColorArray (4, 0) = 255
    glColorArray (4, 1) = 0
    glColorArray (4, 2) = 255
    
    glColorArray (5, 0) = 255
    glColorArray (5, 1) = 255
    glColorArray (5, 2) = 0
    Draw_Cube 2.0, glColorArray()

    glPopMatrix       'pop it
    glClearColor 0.2, 0.2, 0.2, 0.0        'set Clear color to BLACK
    
    glEnable GL_DITHER
    
    Dim viewport(4) As GLint
	Dim pixel(3) As GLubyte

	glGetIntegerv GL_VIEWPORT, @viewport(0)

	glReadPixels Cursor_X, viewport(3)-Cursor_Y, 1, 1, GL_RGB, GL_UNSIGNED_BYTE, @pixel(0)
    
    If pixel(0) = 0 And pixel(1) = 0 And pixel(2) = 255 Then If Cube_Flags(0) = 1 Then Cube_Flags(0) = 0 Else Cube_Flags(0) = 1
    If pixel(0) = 0 And pixel(1) = 255 And pixel(2) = 0 Then If Cube_Flags(1) = 1 Then Cube_Flags(1) = 0 Else Cube_Flags(1) = 1
    If pixel(0) = 0 And pixel(1) = 255 And pixel(2) = 255 Then If Cube_Flags(2) = 1 Then Cube_Flags(2) = 0 Else Cube_Flags(2) = 1
    If pixel(0) = 255 And pixel(1) = 0 And pixel(2) = 0 Then If Cube_Flags(3) = 1 Then Cube_Flags(3) = 0 Else Cube_Flags(3) = 1
    If pixel(0) = 255 And pixel(1) = 0 And pixel(2) = 255 Then If Cube_Flags(4) = 1 Then Cube_Flags(4) = 0 Else Cube_Flags(4) = 1
    If pixel(0) = 255 And pixel(1) = 255 And pixel(2) = 0 Then If Cube_Flags(5) = 1 Then Cube_Flags(5) = 0 Else Cube_Flags(5) = 1
    
End Sub
