' Y A G L   B M P   P i c t u r e   T e s t
'=================================================================
' Presented by Adigun Azikiwe Polack for marzec's YAGL (Yet
' Another Game Library) for FreeBASIC.
'
'
' In this simple yet effective little program, this one is a test
' on how to successfully load in a .BMP file on the screen, using
' YAGL.  Very good for beginners, because it should help you get
' started on the right path in creating games using this original
' game library in FreeBASIC!
'
' Enjoy it richly, and thanks so much!!  ^-^=b
'
'                                         - Adigun Azikiwe Polack
'                                                January 26, 2006



'Let us get YAGL in here!!  ;)
'--------------------------------------------------------------
#include "yaglwrapper.bi"


'Now setting the screenmode to 640x480, 32-bit color, windowed!
'--------------------------------------------------------------
YaglGfxDevice_setScreenMode (640, 480, 32, 0)


YaglGfxDevice_setWindowTitle "YAGL BMP Picture Test - Presented by Adigun Azikiwe Polack."


'Next, setting the array "TestBMP" as YaglGfxSurface, and then
'we create our own custom surface and load it from a file!
'--------------------------------------------------------------
Dim TestBMP as YaglGfxSurface
TestBMP = YaglGfxDevice_createSurface


'Now loading our test file "testBMP.bmp" into play!!  :D
'--------------------------------------------------------------
resultingBMP = YaglGfxSurface_loadFile ( TestBMP, "testBMP.bmp" )


'Blitting our BMP file right here, and then with the 
'"YaglGfxDevice_swapBuffers" command, we display it on the
'screen for us all to see!  Nice!!  ^-^=b !
'--------------------------------------------------------------
YaglGfxDevice_blit 0, 0, TestBMP, 0, 1
YaglGfxDevice_swapBuffers


'Leaving it on the screen for 10 seconds before we head out
'the door!
'--------------------------------------------------------------
sleep 10000