DECLARE SUB Font (FontX%, FontY%, FontText$, TheCharArray() AS SINGLE, TheMaskArray() AS SINGLE, FontMask%)
DECLARE SUB MouseStatus (lb%, rb%, xMouse%, yMouse%, div%)
DECLARE FUNCTION ButtonState% (BtnArray() AS ANY, BtnNum%)
TYPE ButtonType
 BtX1 AS INTEGER
 BtY1 AS INTEGER
 BtX2 AS INTEGER
 BtY2 AS INTEGER
 BtFlag AS INTEGER
END TYPE

COMMON SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
COMMON SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
COMMON SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
COMMON SHARED MIXER.CHIP AS INTEGER, SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
COMMON SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
COMMON SHARED BIT.STORAGE() AS INTEGER, SENSITIVE AS INTEGER
COMMON SHARED REVERSE.STEREO AS INTEGER, SOUND.DISABLED AS INTEGER
  COMMON SHARED PlaySndFlag%, WavFlag%
  COMMON SHARED BasePort%, LenPort%, Channel%, IRQ%, HaveBlast%, WavRep%, TheWavLen&
  COMMON SHARED TFWav() AS STRING * 15000
  COMMON SHARED SoundEvent%
 COMMON SHARED Mouse$
 COMMON SHARED LineCount%, Score&, Level%, Goal%, CurGoal%
 COMMON SHARED SeeNextFlag%, LineBuf%
 COMMON SHARED MusFile$, MusLen%, Song%, MIDIFlag%, SongFlag%
COMMON SHARED TetMask() AS SINGLE, TetFont() AS SINGLE, TfStg() AS STRING

'$DYNAMIC
DIM SHARED TfBtn(48) AS ButtonType
DIM SHARED TfStg(48) AS STRING

REM $STATIC
SUB ButtonCreate (BtnArray() AS ButtonType, BtnNum%, BX1%, BY1%, BW%, BH%)
 BtnArray(BtnNum%).BtX1 = BX1%
 BtnArray(BtnNum%).BtY1 = BY1%
 BtnArray(BtnNum%).BtX2 = BX1% + BW%
 BtnArray(BtnNum%).BtY2 = BY1% + BH%
END SUB

SUB ButtonDisable (BtnArray() AS ButtonType, BtnNum%)
  BtnArray(BtnNum%).BtFlag = -1
END SUB

SUB ButtonDraw (BtnArray() AS ButtonType, BtnNum%)

X1% = BtnArray(BtnNum%).BtX1
X2% = BtnArray(BtnNum%).BtX2
Y1% = BtnArray(BtnNum%).BtY1
Y2% = BtnArray(BtnNum%).BtY2

 SELECT CASE BtnArray(BtnNum%).BtFlag

  CASE -1   'Disabled
   LINE (X1%, Y1%)-(X2%, Y2%), 3, BF
   Font X1% + 2, Y1% + 2, TfStg(BtnNum%), TetFont(), TetMask(), 1
  CASE 0, 1, 3  'Cursor not within button
   LINE (X1%, Y1%)-(X2%, Y2%), 1, B
   LINE (X1% + 1, Y1% + 1)-(X2%, Y2%), 3, B
   LINE (X1% + 1, Y1% + 1)-(X2% - 1, Y2% - 1), 2, BF
    Font X1% + 2, Y1% + 2, TfStg(BtnNum%), TetFont(), TetMask(), 1
  CASE 2    'Cursor within button, pressed
   LINE (X1%, Y1%)-(X2%, Y2%), 3, B
   LINE (X1% + 1, Y1% + 1)-(X2%, Y2%), 1, B
   LINE (X1% + 1, Y1% + 1)-(X2% - 1, Y2% - 1), 2, BF
    Font X1% + 3, Y1% + 3, TfStg(BtnNum%), TetFont(), TetMask(), 1
 END SELECT

END SUB

SUB ButtonEnable (BtnArray() AS ButtonType, BtnNum%)
  BtnArray(BtnNum%).BtFlag = 0
END SUB

SUB ButtonLoad (FileName$, BtnArray() AS ButtonType, BtV1%, BtV2%)
  OPEN FileName$ FOR INPUT AS #1
    FOR B% = BtV1% TO BtV2%
     INPUT #1, BtnArray(B%).BtX1, BtnArray(B%).BtY1, BtnArray(B%).BtX2, BtnArray(B%).BtY2
    NEXT
  CLOSE #1
END SUB

SUB ButtonSave (FileName$, BtnArray() AS ButtonType, BtV1%, BtV2%)
  OPEN FileName$ FOR OUTPUT AS #1
    FOR B% = BtV1% TO BtV2%
     PRINT #1, BtnArray(B%).BtX1, BtnArray(B%).BtY1, BtnArray(B%).BtX2, BtnArray(B%).BtY2
    NEXT
  CLOSE #1
END SUB

FUNCTION ButtonState% (BtnArray() AS ButtonType, BtnNum%)

IF BtnArray(BtnNum%).BtFlag = -1 THEN ButtonState% = BtnArray(BtnNum%).BtFlag: EXIT FUNCTION
MouseStatus lb%, rb%, x%, y%, 2
  IF x% >= BtnArray(BtnNum%).BtX1 AND x% <= BtnArray(BtnNum%).BtX2 AND y% >= BtnArray(BtnNum%).BtY1 AND y% <= BtnArray(BtnNum%).BtY2 THEN
    IF lb% <> 0 THEN
      BtnArray(BtnNum%).BtFlag = 2
    ELSE
      IF BtnArray(BtnNum%).BtFlag = 2 THEN
        BtnArray(BtnNum%).BtFlag = 3
      ELSE
        BtnArray(BtnNum%).BtFlag = 1
      END IF
    END IF
  ELSE
    BtnArray(BtnNum%).BtFlag = 0
  END IF

'-1 - Disabled
' 0 - Not within button
' 1 - Within button, not pressed
' 2 - Within button, pressed
' 3 - Within button, just released
ButtonState% = BtnArray(BtnNum%).BtFlag
END FUNCTION

SUB LoadNames (FileName$, BtnArray() AS STRING, BtV1%, BtV2%)
  OPEN FileName$ FOR INPUT AS #1
    FOR B% = BtV1% TO BtV2%
     INPUT #1, BtnArray(B%)
    NEXT
  CLOSE #1
END SUB

