'    
'    
'                                                             
'             QTetris:  A QBasic Tetris Implementation        
'             QTDual:  A Two-Player Version of QTetris        
'             HighDual:  A Scoreboard Keeper for QTDual       
'                                                             
'    
'                                                             
'            Copyright (C) 1998 by Belly Laugh Software.      
'                                                             
'    
'                                                             
'                        Version 1.00 Beta                    
'                                                             
'    
'    


encoder% = 251: False% = 0: True% = NOT (False%)
While (Inkey$ <> ""): WEND
DIM Info%(25, 12)    ' 22 entries; 10 items per,  (item 11 has to do with
'                                                  whether this is the new
'                                                  entry or not.)
DIM Name1$(25)       ' plus the name,
DIM Name2$(25)        ' plus the adjective.

'  Item 23 is the new item, which is then sorted in,
'    leaving the rejected record at #23.

'  Record 24 is used for swapping purposes.


GOSUB LoadGameScore
GOSUB LoadScoreBoard
GOSUB InsertGameScore
GOSUB SaveScoreBoard
GOSUB ViewScoreBoard

Open "qtdscore.dat" for output as #1
     Print #1, PSetSpec$
         For count% = 1 to 11
            PRINT #1, 0
           next count%
       CLOSE #1

While (Inkey$<>""): WEND
While (Inkey$ = ""): WEND

RUN "QTetMenu.Q"

SYSTEM

ViewScoreBoard:
     CLS
     Go$ = "Y"
     IF (NOT (Info%(23, 11))) THEN
          Go$ = ""
          COLOR 7, 0: PRINT "Do you want to view the high score board? (y/n)";
          WHILE ((Go$ <> "Y") AND (Go$ <> "N"))
               Go$ = UCASE$(INKEY$)
            WEND
        END IF
     IF (Go$ = "N") THEN RETURN
     CLS
     COLOR 15, 0
     LOCATE 1, 1
     PRINT "Vertical & Horizontal Players      Score  Level  Lines  Drops/Length  Pieces"
     FOR idx% = 1 TO 22
          IF (Info%(idx%, 11)) THEN COLOR 0, 7 ELSE COLOR 7, 0
          LOCATE idx% + 1, 1
               PRINT LEFT$(Name1$(idx%), 15);
               PRINT " & ";
               PRINT LEFT$(Name2$(idx%), 15);
          LOCATE idx% + 1, 36
               PRINT Info%(idx%, 1)' Score
          LOCATE idx% + 1, 43
               PRINT Info%(idx%, 2)' Level
          LOCATE idx% + 1, 50
               PRINT Info%(idx%, 4)' Lines
          LOCATE idx% + 1, 57
               PRINT Info%(idx%, 6)' Drops
          LOCATE idx% + 1, 64
               PRINT Info%(idx%, 7)' Drop Length
          LOCATE idx% + 1, 71
               PRINT Info%(idx%, 9)' Pieces Placed
       NEXT idx%
  RETURN

InsertGameScore:
     If (Info%(23,1)<>0) Then
          COLOR 7, 0: CLS
          PRINT "Vertical player: enter thy name:  ";
          LINE INPUT Name1$(23)
          PRINT "Horizontal player: enter thy name  ";
          LINE INPUT Name2$(23)
       end if
       INFO%(23,1) = score%: INFO%(23,2) = level%: INFO%(23,3) = LevP%
       INFO%(23,4) = lines%: INFO%(23,5) = LP%: INFO%(23,6) = drops%
       INFO%(23,7) = dropl%: INFO%(23,8) = dropP%: INFO%(23,9) = placed%
       INFO%(23,11) = True%
     Print INFO%(23,1)
     GOSUB BubbleSort    '  Yes, I have coded an optimized quiksort
          '    in QBasic, but under the circumstances (first, this
          '    sort will only have to ever handle 23 records and, second,
          '    I need to avoid a fencepost error) the extra programmer
          '    time even to code an insertion sort is simply not worth it
          '    in light of the two seconds it will take to sort this baby,
          '    even on an 8088.
  RETURN

BubbleSort:
'Print "Sorting...";
          FOR idx% = 22 TO 1 STEP -1    ' counting backwords is
                                        ' in itself optimization
                                        ' under the circumstances.
'               Print ".";
'               Print Info%(idx%,1);: Print ",";: Print Info%(idx%+1,1);: print ";";
               IF (Info%(idx%, 1) < Info%(idx% + 1, 1)) THEN
                    Src% = idx%: Dst% = 24: GOSUB CopyRec
                    Src% = idx% + 1: Dst% = idx%: GOSUB CopyRec
                    Src% = 24: Dst% = idx% + 1: GOSUB CopyRec
                 END IF
            NEXT idx%
  Print
  RETURN

CopyRec:
     Name$(Dst%) = Name$(Src%)
     Adj$(Dst%) = Adj$(Src%)
     FOR CRC% = 1 TO 11
          Info%(Dst%, CRC%) = Info%(Src%, CRC%)
       NEXT CRC%
   RETURN

FixLoadError:
     CLOSE
'     GOSUB MakeBlankScore     '    Combine robustness with tamper-resistance.
  RESUME FixedLoadError

LoadScoreBoard:
     ON ERROR GOTO FixLoadError
          GOSUB DecryptScoreBoard
     Gosub ContinueLoad
     Return
FixedLoadError:
     Gosub MakeBlankScore
ContinueLoad:
     Close
     ON ERROR GOTO 0
     OPEN (PSetSpec$ + ".SCD") FOR INPUT AS #1
          FOR idx% = 1 TO 22
               INPUT #1, Name1$(idx%)
               INPUT #1, Name2$(idx%)
               FOR count% = 1 TO  9     ' Item 11 only used internally to mark
                                        '  newest record.
                                        ' Item 10 not used in Dual game.
                    INPUT #1, Info%(idx%, count%)
                 NEXT count%
               IF (Info%(idx%, 1) <> Info%(idx%, 2) * Info%(idx%, 3) + Info%(idx%, 4) * Info%(idx%, 5) + Info%(idx%, 8)) THEN
                  Print "Tamper Resistance Invoked": FOR count% = 1 TO 10: Info%(idx%, count%) = 0: NEXT count%
                  While (Inkey$=""): WEND
                 end if
            NEXT idx%
       CLOSE #1
       ON ERROR GOTO 0
  RETURN

SaveScoreBoard:
     OPEN (PSetSpec$ + ".SCD") FOR OUTPUT AS #1
          FOR idx% = 1 TO 22
               PRINT #1, Name1$(idx%)
               PRINT #1, Name2$(idx%)
               FOR count% = 1 TO 09     ' Item 11 only used internally,
                                        '    to mark newest record.
                    PRINT #1, Info%(idx%, count%)
                 NEXT count%
            NEXT idx%
          PRINT #1, "<EOF>"
          PRINT #1, "<EOF>"
       CLOSE #1
     GOSUB EncryptScoreBoard
  RETURN

MakeBlankScore:
     OPEN (PSetSpec$ + ".SCO") FOR OUTPUT AS #1
          FOR idx% = 1 TO 22
               PRINT #1, "Jonadab"
               PRINT #1, "Company"
               FOR count% = 1 TO 9
                    PRINT #1, 0
                 NEXT count%
            NEXT idx%
          PRINT #1, "<EOF>"
          PRINT #1, "<EOF>"
        CLOSE #1
   RETURN

DecryptScoreBoard:
     OPEN (PSetSpec$ + ".DAD") FOR INPUT AS #1
     OPEN (PSetSpec$ + ".SCD") FOR OUTPUT AS #2
     GOSUB Crypt
  RETURN

EncryptScoreBoard:
     OPEN (PSetSpec$ + ".SCD") FOR INPUT AS #1
     OPEN (PSetSpec$ + ".DAD") FOR OUTPUT AS #2
     GOSUB Crypt
  RETURN

Crypt:
          LINE INPUT #1, Go$
          WHILE (Go$ <> "<EOF>")
               Temp$ = ""
               FOR Psn% = 1 TO LEN(Go$)
                    T$ = MID$(Go$, Psn%, 1)
                    T% = ASC(T$)
                    T% = T% XOR encoder%
                    T$ = CHR$(T%)
                    Temp$ = Temp$ + T$
                 NEXT Psn%
               PRINT #2, Temp$
               LINE INPUT #1, Go$
            WEND
          PRINT #2, Go$
          PRINT #2, Go$
          Close
RETURN

LoadGameScore:
'[][][][][][][][][][][][][][][][][][][][][][][][]
     OPEN "qtdscore.dat" FOR INPUT AS #1     '
          INPUT #1, PSetSpec$                '
          INPUT #1, score%                   '
          INPUT #1, level%                   '
          INPUT #1, LevP%                    '
          INPUT #1, lines%                   '
          INPUT #1, LP%                      '
          INPUT #1, drops%                   '
          INPUT #1, dropl%                   '
          INPUT #1, dropP%                   '
          INPUT #1, placed%                  '
          IF (score% <> LevP% * level% + LP% * lines% + dropP% ) THEN Print "Tamper Resistance Invoked": score% = 0      ' somewhat tamper resistant.
       CLOSE #1     '
  RETURN            '
