'    
'    
'                                                             
'             QTetris:  A QBasic Tetris Implementation        
'               PSEd:  A Piece Set EDitor for QTetris         
'                                                             
'    
'                                                             
'            Copyright (C) 1997 by Belly Laugh Software.      
'                                                             
'    
'                                                             
'                        Version 1.00 Alpha                   
'                                                             
'    
'    

Option Base 1

False% = 0:  True% = NOT(False%)

MaxNumOfPieces% = 20

FlashInterval! = 1
FIDID! = .15

screen 0: cls

'  First, get the colors:

     Open "PSED.CFG" for input as #1
          input #1, ClrSpec$
       close #1

     Open (ClrSpec$+".CLR") for input as #1
          input #1, NumOfColors%
       close #1

     Dim C%(NumOfColors%)
     Dim CN$(NumOfColors%)
     if (CM% < 10) then DIM C$(NumOfColors%)

     Open (ClrSpec$+".CLR") for input as #1 ' Color Scheme File
          input #1, NumOfColors%   ' Alread read, but read past.
          For Count% = 1 to NumOfColors%
               Line Input #1, CN$(Count%)
               Input #1, C%(Count%)
               If (CM% < 10) then Line Input #1, C$(Count%)
            next Count%
       close #1


'  Next, find out whether we want to create a new set.

cls
Print "     Select One:"
Print "     -----------------------------------"
Print "     A:      Create New Piece Set"
Print "     B:      Edit Last-Edited Set"
Print "     C:      Edit Another Set"
Print
Print "     Press A, B, or C."
While ((Go$<>"A") and (Go$<>"B") and (Go$<>"C"))
     Go$ = UCase$(Inkey$)
  WEND


Select Case Go$
     Case "A"
                    Gosub MakeNew
     Case "B"
                    Gosub LoadPrevious
     Case "C"
                    Gosub LoadOther
  End Select

CP% = 1   ' Start with first piece, by default.

Gosub InitDisplay
Gosub InitKeys
Gosub AllowKeys
Continue% = True%
Gosub UpdateDisplay

'************************************************************************

'         ********************************************************
'         **                                                    **
'         **        M A I N    L O O P                          **
'         **                                                    **
'         ********************************************************

     While (Continue%)
               Gosub WaitForInput
               Gosub FlashCursor
          WEND

Run "QTetMenu.Q"

SYSTEM

'

WaitForInput:
     WFI! = TIMER
     While (WFI! + FlashInterval! > TIMER): WEND
  Return

ReadList:
     Open "PSED.LST" for input as #1
          Input #1, NumOfSets%
          if not(NSetsDetermined%) then
               NSetsDetermined% = True%
               Dim SetName$(NumOfSets% + 20)
            end if
          For count% = 1 to NumOfSets%
               Input #1, SetName$(count%)
            next count%
       close #1
  Return

UpDateList:
     Gosub ReadList
     Found% = False%
     For count% = 1 to NumOfSets%
          if (Ucase$(SetName$(count%)) = UCase$(PSetSpec$)) then Found% = True%
       next count%
     If Not(Found%) then
          NumOfSets% = NumOfSets% + 1
          SetName$(NumOfSets%) = PSetSpec$
          Gosub WriteList
       end if
  Return

WriteList:
          Open "PSED.LST" for output as #1
               Print #1, NumOfSets%
               For count% = 1 to NumOfSets%
                    Print #1, SetName$(count%)
                 next count%
            close #1
  Return


LoadOther:
     Gosub ReadList
     color 7,0: cls
     Print "Choose a piece set:"
     If (NumOfSets% > 80) then NumOfSets% = 80
     For count% = 1 to NumOfSets%
          locate 2+(count% mod 20),18*(count%\20)+2
          Temp$ = Str$(count%)
          Temp$ = Right$(Temp$,Len(Temp$)-1)
          Temp$ = Temp$ + ":  "
          Print Temp$;
          print SetName$(count%)
       next count%
     locate 24,1: color 0,7
     Print "Enter the number of the set you want:";
     Input count%
     PSetSpec$ = SetName$(count%)
     Gosub StartByLoading
  Return

LoadPrevious:
     Open "PSED.CFG" for input as #1
          input #1, ClrSpec$
          Input #1, PSetSpec$
       close #1
StartByLoading:
  Open (PSetSpec$ + ".SET") for input as #1
     Input #1, NumOfPieces%
     input #1, NumOfRotations%
     input #1, PMX%
     input #1, PMY%
     input #1, FMX%
     input #1, FMY%
     input #1, NumOfLevels%
     input #1, InitDV!
     input #1, Accel!
     input #1, RAccel!
     '------------------------
     DIM P%(MaxNumOfPieces%,NumOfRotations%,PMX%,PMY%)
     Dim PP%(MaxNumOfPieces%,NumOfRotations%)
     Dim DP%(FMY%,NumOfLevels%)
     Dim Prob%(MaxNumOfPieces%,NumOfLevels%)
     '------------------------
     For SCP% = 1 to NumOfPieces%
          input #1, PN$(SCP%)
          for SCR% = 1 to NumOfRotations%
               for SCX% = 1 to PMX%
                    for SCY% = 1 to PMY%
                         input #1, P%(SCP%,SCR%,SCX%,SCY%)
                      next SCY%
                 next SCX%
               input #1, PP%(SCP%,SCR%)
            next SCR%
          for level% = 1 to NumOfLevels%
               input #1, Prob%(SCP%,level%)
            next level%
       next SCP%
     For level% = 1 to NumOfLevels%
          for lines% = 1 to FMY%
               input #1, DP%(lines%,level%)
            next lines%
       next level%
     input #1, LevC%
     input #1, LevP%
     input #1, LP%
   close #1
     CP% = 1
 Return

MakeNew:
     ChangeMade% = True%
     Print " Utilize Defaults?  (y/n)";
     Go$ = "": While Go$ = "": Go$ = UCASE$(Inkey$): WEND
     if Left$(Go$,1)="Y" then gosub NewDefaults: Return
'MNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMN
     Print "Enter a name for your set."                                '  M
     Print "   (up to 8 letters/numbers -- NO SPACES)."                '  N
     Input " Name:  -->> ", PSetSpec$                                  '  M
                                                                       '  N
     Print "Enter the number of squares on the side of a piece:"       '  M
     print "(A natural number no greater than 5.)"                     '  N
     Print "(3 or 4 would be a good choice.)"                          '  M
     Input "  Number -->> ", PMX%                                      '  N
                                                                       '  M
     Print "Enter the number of squares across for each piece:"        '  N
     print "(A natural number no greater than 5.)"                     '  M
     Print "(Only";                                                    '  N
     Print PMX%;                                                       '  M
     Print "would be a natural choice.)"                               '  N
     Input "  Number -->> ", PMY%                                      '  M
                                                                       '  N
     Print "Enter the number of rotations:"                            '  M
     print "(A natural number no greater than 6.)"                     '  N
     print "(Only 1, 2, or 4 makes any sense.)"                        '  M
     Input "  Number -->> ", NumOfRotations%                           '  N
                                                                       '  M
     Print "Enter the WIDTH of the playing field."                     '  N
     print "(A natural number between";                                '  M
     print PMX%;: print "and 40.)";                                    '  N
     print "(A multiple of";: print PMX%;                              '  M
     print "would be a good choice.";                                  '  N
     Input "  Number -->> ", FMX%                                      '  M
                                                                       '  N
     Print "Enter the HEIGHT of the playing field."                    '  M
     print "(A natural number between";                                '  N
     print PMY%;: print "and 20.)";                                    '  M
     print "(A multiple of";: print PMY%;                              '  N
     print "would be a good choice.";                                  '  M
     Input "  Number -->> ", FMY%                                      '  N
                                                                       '  M
     Print "Enter the number of levels which will be "                 '  N
     print "distinct in terms of piece selection:"                     '  M
     print "(That is, the first n levels will introduce "              '  N
     print "new pieces or increased likelihood of the "                '  M
     print "occurrance of certain pieces.  Enter n.)"                  '  N
     print "(A natural number between 1 and 10.)"                      '  M
     Input "  Number -->> ", NumOfLevels%                              '  N
                                                                       '  M
     Print "Enter the Initial Falling Delay Value."                    '  N
     Print "(In other words, a piece will fall down "                  '  M
     print "one line every w seconds.  Enter the "                     '  N
     print "starting value for w.)"                                    '  M
     Print "(A positive real number.)"                                 '  N
     print "(Something between 0.25 and 1.25 makes good sense.)"       '  M
     Input "  Decimal Number -->> ", InitDV!                           '  N
                                                                       '  M
     Print "Enter the Accelleration Factor."                           '  N
     Print "(The number you have just entered will be "                '  M
     print "multiplied by it every level.)"                            '  N
     Print "(A positive real number NOT greater than 1.)"              '  M
     print "(Just less than one is recommended.  0.95 for example.)"   '  N
     Input "  Decimal Number -->> ", Accel!                            '  M
                                                                       '  N
     Print "Enter the Random Accelleration Factor."                    '  M
     Print "(This works approximately the same as the above, "         '  N
     print "except it has randomness.)"                                '  M
     print "(A value of 1 cancels the random acceleration.)"           '  N
     Print "(A value between 0.95 and 1 is recommended.)"              '  M
     Print "Enter a positive real number NOT greater than 1."          '  N
     Input "  Decimal Number -->> ", RAccel!                           '  M
                                                                       '  N
     DIM P%(MaxNumOfPieces%,NumOfRotations%,PMX%,PMY%)                 '  M
     Dim PP%(MaxNumOfPieces%,NumOfRotations%)                          '  N
     Dim DP%(FMY%,NumOfLevels%)                                        '  M
     Dim Prob%(MaxNumOfPieces%,NumOfLevels%)                           '  N

     Print "Enter the number of lines per level."
     Print "(A natural number.  At least 10 is recommended.)"
     Input "  Number -->> ", LevC%

     Print "Enter the number of points obtained for passing a level."
     Print "(A whole number.)"
     Input "  Number -->> ", LevP%

     Print "Enter the number of points for completing a single line."
     Print "(A whole number.)"
     Input "  Number -->> ", LP%

     NumOfPieces% = 1: CP% = 1

     Print "Do you want to calculate the drop points automatically?";
     Print " (y/n)";
     Go$ = "": While Go$ = "": Go$ = UCASE$(Inkey$): WEND
     if Left$(Go$,1)="Y" then gosub CalcDropPoints: Return

     For level% = 1 to NumOfLevels%
          for lines% = 1 to FMY%
               Print "How many points should be awarded for dropping"
               Print "  a piece ";
                         print lines%;
               Print                 " on level ";
                                          print level%;: ? "?"
               Input "  Number -->> ",  DP%(lines%,level%)
            next lines%
       next level%

     Gosub KeyIns
                                                                       '  M
  Return       '                                                       '  N
'MNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMNMN

NewDefaults:
     PSetSpec$ = "Untitled"
     PMX% = 3
     PMY% = 3
     NumOfRotations% = 4
     FMX% = 18
     FMY% = 18
     NumOfLevels% = 3
     InitDV! = 1
     Accel! = .94
     RAccel! = .97
     NumOfPieces% = 1: CP% = 1
     LevC% = 25
     LevP% = 15
     LP% = 5
     DIM P%(MaxNumOfPieces%,NumOfRotations%,PMX%,PMY%)
     Dim PP%(MaxNumOfPieces%,NumOfRotations%)
     Dim DP%(FMY%,NumOfLevels%)
     Dim Prob%(MaxNumOfPieces%,NumOfLevels%)
       CDPBase% = 1
       LineGeom! = 1
       LineArith! = .6
       LevGeom! = 1.2
       LevArith! = .2
     Gosub CalcDropDefaults
     PN$(CP%) = "First Piece"
     For Temp% = 1 to NumOfLevels%
        Prob%(CP%, Temp%) = 1
      next Temp%
  Return


CalcDropPoints:
  '------------------------------------------------------------------
     Print "What is the base value for dropping a piece one"     ' --
     print "line on level one?  (A whole number.)"               ' --
     Input "  Number -->> ",  CDPBase%                           ' --
                                                                 ' --
     Print "What is the geometric increase per line?"            ' --
     Print "(A value of 1 means no geometric increase.)"         ' --
     Print "(A value less than 1 means decrease.)"               ' --
     Print "(Do not use too large a value.  Up to 1.4 is ok.)"   ' --
     Input "  Decimal Number -->> ",  LineGeom!                  ' --
                                                                 ' --
     Print "What is the arithmetic increase per line?"           ' --
     print "(A value of zero means no arithmetic increase.)"     ' --
     Input "  Decimal Number -->> ", LineArith!                  ' --
                                                                 ' --
     Print "What is the geometric increase per level?"           ' --
     Print "(A value of 1 means no geometric increase.)"         ' --
     Print "(A value less than 1 means decrease.)"               ' --
     Print "(Do not use too large a value.  Up to 1.4 is ok.)"   ' --
     Input "  Decimal Number -->> ",  LevGeom!                   ' --
                                                                 ' --
     Print "What is the arithmetic increase per level?"          ' --
     print "(A value of zero means no arithmetic increase.)"     ' --
     Input "  Decimal Number -->> ", LevArith!                   ' --
                                                                 ' --
CalcDropDefaults:                                                ' --
     For level% = 1 to NumOfLevels%                              ' --
          for lines% = 1 to FMY%                                 ' --
               DP%(lines%,level%) = Int(CDPBase% * LineGeom!^lines% * LevGeom!^level% + LineArith! * lines% * LevGeom!^level% + LevArith! * level% * LineGeom!^lines%)
            next lines%                                          ' --
       next level%                                               ' --
                                                                 ' --
   Return                                                        ' --
  '------------------------------------------------------------------

LoadPieceSet:
 NotNew% = True%
 ChangeMade% = False%
'
 Go$ = PSetSpec$ + ".SET":  ChangeMade% = False%            '  
 Open Go$ for input  as #1                                  '  
      input #1, NumOfPieces%                                '  
      input #1, NumOfRotations%                             '  
      input #1, PMX%                                        '  
      input #1, PMY%                                        '  
      input #1, FMX%                                        '  
      input #1, FMY%                                        '  
      input #1, NumOfLevels%                                '  
      input #1, InitDV!                                     '  
      input #1, Accel!                                      '  
      input #1, RAccel!                                     '  
      '------------------------                             '  
     For SCP% = 1 to NumOfPieces%                           '  
          input #1, PN$(SCP%)                               '  
          for SCR% = 1 to NumOfRotations%                   '  
               for SCX% = 1 to PMX%                         '  
                    for SCY% = 1 to PMY%                    '  
                         input #1, P%(SCP%,SCR%,SCX%,SCY%)  '  
                      next SCY%                             '  
                 next SCX%                                  '  
               input #1, PP%(SCP%,SCR%)                     '  
            next SCR%                                       '  
          for level% = 1 to NumOfLevels%                    '  
               input #1, Prob%(SCP%,level%)                 '  
            next level%                                     '  
       next SCP%                                            '  
                                                            '  
     For level% = 1 to NumOfLevels%                         '  
          for lines% = 1 to FMY%                            '  
               input #1, DP%(lines%,level%)                 '  
            next lines%                                     '  
       next level%                                          '  
                                                            '  
     input #1, LevC%                                        '  
     input #1, LevP%                                        '  
     input #1, LP%                                          '  
                                                            '  
   close #1    '                                            '  
 Return        '                                            '  
'


SavePieceSet:
'
 Go$ = PSetSpec$ + ".SET":  ChangeMade% = False%            '  
 Open Go$ for output as #1                                  '  
      print #1, NumOfPieces%                                '  
      print #1, NumOfRotations%                             '  
      print #1, PMX%                                        '  
      print #1, PMY%                                        '  
      print #1, FMX%                                        '  
      print #1, FMY%                                        '  
      print #1, NumOfLevels%                                '  
      print #1, InitDV!                                     '  
      print #1, Accel!                                      '  
      print #1, RAccel!                                     '  
      '------------------------                             '  
     For SCP% = 1 to NumOfPieces%                           '  
          Print #1, PN$(SCP%)                               '  
          for SCR% = 1 to NumOfRotations%                   '  
               for SCX% = 1 to PMX%                         '  
                    for SCY% = 1 to PMY%                    '  
                         Print #1, P%(SCP%,SCR%,SCX%,SCY%)  '  
                      next SCY%                             '             
                 next SCX%                                  '  
               Print #1, PP%(SCP%,SCR%)                     '  
            next SCR%                                       '  
          for level% = 1 to NumOfLevels%                    '  
               Print #1, Prob%(SCP%,level%)                 '  
            next level%                                     '  
       next SCP%                                            '  
                                                            '  
     For level% = 1 to NumOfLevels%                         '  
          for lines% = 1 to FMY%                            '  
               Print #1, DP%(lines%,level%)                 '  
            next lines%                                     '  
       next level%                                          '  
                                                            '  
     Print #1, LevC%                                        '  
     Print #1, LevP%                                        '  
     Print #1, LP%                                          '  
                                                            '  
   close #1    '                                            '  
                                                            '  
Open "PSED.CFG" for output as #1                            '  
     Print #1, ClrSpec$                                     '  
     Print #1, PSetSpec$                                    '  
  Close #1                                                  '  
                                                            '  
Gosub UpDateList                                            '  
                                                            '  
 Return        '                                            '  
'

FlashCursor:
     Gosub HoldKeys
     Gosub BrightCursor
     Gosub FlashInternalDelay
     Gosub DarkCursor
     Gosub FlashInternalDelay
     Gosub RestoreCursor
     Gosub AllowKeys
  Return

FlashInternalDelay:
     FID! = TIMER
     While (TIMER < FID! + FIDID!): WEND
  Return

BrightCursor:
    locate (5 + Y%),(10*(Rotation%)+X%*UDXW%)
    color 15
    ? Chr$(219)
  Return

DarkCursor:
    locate (5 + Y%),(10*(Rotation%)+X%*UDXW%)
    color 0
    ? Chr$(219)
  Return

RestoreCursor:
    locate (5 + Y%),(10*(Rotation%)+X%*UDXW%)
    color C%(P%(CP%, Rotation%, X%, Y%)+1)
    ? C$(P%(CP%, Rotation%, X%, Y%)+1);
  Return

UpdateDisplay:
'
 UDXW% = 1     ' How wide is one pixel?                              
     For UDR% = 1 to NumOfRotations%    '                            
          For UDY% = 1 to PMY%          '                            
               For UDX% = 1 to PMX%     '                            
                    locate (5 + UDY%),(10*(UDR%)+UDX%*UDXW%)     '   
                    color C%(P%(CP%, UDR%, UDX%, UDY%)+1)        '   
                    ? C$(P%(CP%, UDR%, UDX%, UDY%)+1);           '   
                 next UDX%              '                            
            next UDY%                   '                            
          color 7,0                     '                            
          locate 4, 10*UDR%             '                            
          ? PP%(CP%,UDR%)               '                            
       next UDR%                        '                            
       color 7,0                        '                            
       locate 3,7: print CP%;           '                            
       locate 3,13: print NumOfPieces%; '                            
       print ":  ";                     '                            
       print PN$(CP%) + Space$(20);     '                            
       Temp$ = Date$ + " -- " + Time$   '                            
       locate 1, 79 - Len(Temp$)        '                            
       Print Temp$;                     '                            
 Return        '                                                     
'

InitDisplay:
'
 screen 0: color 7,0: cls                    '                       
 locate 16,1: print String$(80,176);         '                       
 locate 2,1: print PSetSpec$                 '                       
 locate 3,1: print "Piece";                  '                       
 locate 3,10: print "of";                    '                       
 locate 17,1: print "KEYS:"                  '                       
 locate 18,1   '                                                     
 print "  Arrows    move cursor         +/- (pad) Change Color"  '   
 print "  Tab       next rotation       INS       New Piece"     '   
 print "  PgUp/Dn   prev/next piece     F10       Exit"          '   
 print "  Home/End  first/last piece    F2        Save"          '   
 print "  Center(5) set placement pts   F3        Load"          '   
 Return        '                                                     
'

KeyUp:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 Y% = Y% - 1: If (Y% = 0) then Y% = PMY%          '          K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyDown:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 Y% = Y% + 1: If (Y% > PMY%) then Y% = 1          '          K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyLeft:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 X% = X% - 1: If (X% = 0) then X% = PMX%          '          K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyRite:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 X% = X% + 1: If (X% > PMX%) then X% = 1          '          K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

HoldKeys:
     For AK% = 1 to 24
          Key(AK%) Stop
       next AK%
  Return
AllowKeys:
     For AK% = 1 to 24
          Key(AK%) On
       next AK%
  Return

InitKeys:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
'     On Key(1)  gosub Help    '    (If I decide to code it.) K
     On Key(2)  gosub KeySave
     On Key(3)  gosub KeyLoad
     On Key(4)  gosub KeyFour
     On Key(5)  gosub KeyFive
     On Key(6)  gosub KeySix
     On Key(7)  gosub KeySeven
     On Key(8)  gosub KeyEight
     On Key(9)  gosub KeyNine
     On Key(10) gosub ExitSub '    (Exit ?)                  K
     On Key(11) gosub KeyUp   '    (square above)            K
     On Key(12) gosub KeyLeft '    (square to the left)      K
     On Key(13) gosub KeyRite '    (square to the right)     K
     On Key(14) gosub KeyDown '    (square below)            K
     Key 15, Chr$(0) + Chr$(76)    ' (pad center)            K
     Key 16, Chr$(0) + Chr$(73)    ' (pgup)                  K
     Key 17, Chr$(0) + Chr$(81)    ' (pgdn)                  K
     Key 18, Chr$(0) + Chr$(71)    ' (home)                  K
     Key 19, Chr$(0) + Chr$(79)    ' (end)                   K
     Key 20, Chr$(0) + Chr$(15)    ' (tab)                   K
     Key 21, Chr$(1) + Chr$(15)    ' (shift+tab)             K
     Key 22, Chr$(0) + Chr$(74)    ' (grey -)                K
     Key 23, Chr$(0) + Chr$(78)    ' (grey +)                K
     Key 24, Chr$(0) + Chr$(82)    ' INS                     K
     On Key(15) gosub KeyPad5 '    (Placement Pts.)          K
     On Key(16) gosub KeyPgUp '    (Prev. Piece)             K
     On Key(17) gosub KeyPgDn '    (Next Piece)              K
     On Key(18) gosub KeyHome '    (First Piece)             K
     On Key(19) gosub KeyEnd  '    (Last Piece)              K
     On Key(20) gosub KeyTab  '    (Next Rotation)           K
     On Key(21) gosub KeySTab '    (Prev. Rotation)          K
     On Key(22) gosub KeyNeg  '    (Prev. Color)             K
     On Key(23) gosub KeyPos  '    (Next Color)              K
     On Key(24) gosub KeyIns  '    (Insert Piece)            K
     X% = 1: Y% = 1: Rotation% = 1 '                             INITIALIZATION
  Return       '                                             K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyPos:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 P%(CP%,Rotation%,X%,Y%) = P%(CP%,Rotation%,X%,Y%) + 1 '     K
 if (P%(CP%,Rotation%,X%,Y%) >= NumOfColors%) then     '     K
     P%(CP%,Rotation%,X%,Y%) = 0                       '     K
   end if           '                                        K
 Gosub UpdateDisplay: ChangeMade% = True%              '     K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyNeg:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 P%(CP%,Rotation%,X%,Y%) = P%(CP%,Rotation%,X%,Y%) - 1 '     K
 if (P%(CP%,Rotation%,X%,Y%) < 0) then                 '     K
     P%(CP%,Rotation%,X%,Y%) = NumOfColors% - 1        '     K
   end if           '                                        K
 Gosub UpdateDisplay: ChangeMade% = True%              '     K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeySTab:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 Rotation% = Rotation% - 1    '                              K
 if (Rotation% = 0) then Rotation% = NumOfRotations%   '     K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyTab:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 Rotation% = Rotation% + 1    '                              K
 if (Rotation% > NumOfRotations%) then Rotation% = 1   '     K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyEnd:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 CP% = NumOfPieces% '                                        K
 Gosub UpdateDisplay     '                                   K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyHome:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 CP% = 1            '                                        K
 Gosub UpdateDisplay     '                                   K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyPgDn:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 CP% = CP% + 1      '                                        K
 if (CP% > NumOfPieces%) then CP% = 1        '               K
 Gosub UpdateDisplay                         '               K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyPgUp:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 CP% = CP% - 1      '                                        K
 if (CP% = 0) then CP% = NumOfPieces%        '               K
 Gosub UpdateDisplay                         '               K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyPad5:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
     Color 7,0                          '                    K
     locate 4, 10*Rotation%             '                    K
     Input PP%(CP%,Rotation%)           '                    K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyIns:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 NumOfPieces% = NumOfPieces% + 1             '               K
 CP% = NumOfPieces%                          '               K
 color 7,0                                   '               K
 locate 15,1: Input "Piece Name:  ", PN$(CP%)'               K
 locate 15,1: ? space$(79);                  '               K
 For Temp% = 1 to NumOfLevels%               '               K
    locate 15,1: Print "Frequency on level"; '               K
    ? Temp%;                                 '               K
    Input Prob%(CP%, Temp%)                  '               K
    locate 15,1: ? space$(79);               '               K
  next Temp%                                 '               K
 Gosub UpDateDisplay                         '               K
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

KeyLoad:
     Gosub HoldKeys
     screen ,,1,1
     If (ChangeMade%) then
          Print "You have made changes to the current set."
          print "Do you wish to save them before loading"
          print "  another set? (y/n) ";
          Go$ = ""      '
          While ((Go$ <> "Y") and (Go$ <> "N"))
              Go$ = UCASE$(Inkey$)     '
            WEND        '
          If (Go$ = "Y") then
              DisAllowKeys% = True%
              gosub KeySave
              DisAllowKeys% = False%
            End If
       end if
     cls
     Print "Enter the name of the set you wish to load."
     Print "   (up to 8 letters/numbers -- NO SPACES)."
     Input " Name:  -->> ", PSetSpec$
     screen ,,0,0
     Gosub LoadPieceSet
     Gosub UpDateDisplay
     locate 2,1: print PSetSpec$ + Space$(8)
     Gosub AllowKeys
  Return
KeyFour:
KeyFive:
KeySix:
KeySeven:
KeyEight:
KeyNine:
  Return

KeySave:
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK
 Gosub HoldKeys
 If (NotNew%) then                 '                         K
      Screen ,,1,1                 '                         K
      color 7,0: cls               '                         K
      Print "Existing File:  ";    '                         K
      Print PSetSpec$              '                         K
      Print "Do you want to overwrite the existing ";  '     K
      Print "file?  (y/n)";        '                         K
      Go$ = ""      '                                        K
      While ((Go$ <> "Y") and (Go$ <> "N"))            '     K
          Go$ = UCASE$(Inkey$)     '                         K
        WEND        '                                        K
      If (Go$ = "N") then          '                         K
          Print                    '                         K
          Print "Enter a new name for your set."            'K
          Print "   (up to 8 letters/numbers -- NO SPACES)."'K
          Input " Name:  -->> ", PSetSpec$                  'K
        end if                     '                         K
      Screen ,,0,0                 '                         K
   End If           '                                        K
   Gosub SavePieceSet              '                         K
   NotNew% = True%                 '                         K
   If Not (DisAllowKeys%) then Gosub AllowKeys
 Return             '                                        K
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK

ExitSub:
     If not(ChangeMade%) then Continue% = False%: Return
     Screen ,,1,1: cls: Go$ = ""
     Print
     Print "Are you sure you want to exit?"
      While ((Go$ <> "Y") and (Go$ <> "N"))
          Go$ = UCASE$(Inkey$)     '
        WEND        '
     if (Go$ = "Y") then Continue% = False%
   Return

'<EOF>
