'    
'    
'                                                             
'             QTetris:  A QBasic Tetris Implementation        
'                                                             
'    
'                                                             
'            Copyright (C) 1997 by Belly Laugh Software.      
'                                                             
'    
'                                                             
'                        Version 1.00 Alpha                   
'                                                             
'    
'    


'  The pieces are held in one array; the playing field is held in
'    another.  Individual variables determine the current piece
'    and its position (and "rotation").

'  A third array holds the color pallette.  Version 1 will only support
'    one color pallette (in one screen mode -- 80x24), but it will
'    be designed so that the addition of other modes will be SMOP.

'  Variable List:  (Constants will be considered variables for our purposes.)
'    ARRAYS:
'         S%(x,y)        Holds the color attribute of the screen at
'                          position x, y (within the playing field).
'                          0 indicates background; any other number
'                          indicates a piece of some kind.  Note that
'                          the current (i.e. unfrozen) piece is not
'                          reflected here.
'                        The maximum playing field dimensions are
'                          40 x 20.  I may change this at some point
'                                    in the future, or I may not.
'                          The maximum piece size is five by five, so
'                             the maximum that any non-empty piece can
'                             extend beyond the playing area is four,
'                             so five is the necessary buffer.  Apply it
'                             to both sides and the bottom, and we have
'                             50x25, the maximum dimensions of S%.
'         P%(i,r,x,y)    Holds the color attribute of piece i at
'                          relative position (x,y) and rotation r.
'                          0 indicates background -- i.e. this spot
'                          can overlap; any other color is solid.
'         PP%(i,r)       Holds the placement points scored by placing
'                          piece i at rotation r.
'         PN$(i)         Holds the Piece Name of piece i.
'         DP%(n,l)       Holds the number of points scored by dropping
'                          any piece n lines on level l.
'         Prob%(i,l)     Holds an integer directly related to the
'                          probability that piece i will be the piece
'                          selected at any given point on level l.
'         C%(i)          Holds the actual color (in the case of single-
'                          palette screen modes, e.g. MDA, CGA; in
'                          the case of VGA modes this would be the
'                          "attribute") used on the screen when the
'                          above arrays indicate color i.
'         CN$(i)         Holds the NAME of the color.  Only important
'                          for piece editor, so not even declared in QTET.Q.
'         C$(i)          In the case of text mode only, holds the
'                          character displayed (in the color C$(i))
'                          when P% or S% indicates color i.
'                          This will usually be set to one of the
'                          following:  , , , or .  Other
'                          characters are, however, allowed.
'    VALUES:
'         PSetSpec$      File Specification for piece set (8 chars).
'         BorderC%       The number of the color for the borders.
'         PW%            The width of the panel, used to offset
'                             playing field display.  Constant.
'         NumOfPieces%   Number of pieces in the current set.
'         CM%            Holds the current Color Mode.
'                        Single-digit modes are text-based and map
'                         to screen mode 0.  Higher modes are graphics.
'                        0    Text mode, 80x24.
'                        1    Text mode.  Really 80x24; Used as 40x24
'                                         via  versus  for a square look.
'         NumOfColors%   The number of colors in the current scheme.
'         NP%            Next Piece.
'         CP%            Holds the number of the current piece.
'         CR%            Holds the current rotation.
'         CX%            Holds the current horizontal location of the piece.
'         CY%            Holds the current vertical location of the piece.
'         PR%            Holds a proposed rotation.
'         PX%            Holds a proposed horizontal location.
'         PY%            Holds a proposed vertical location.
'         level%         Holds the current level.
'         lines%         Holds the number of lines thus far completed.
'         LevP%          Holds the number of points scored for advancing a
'                             level.
'         LevC%          Holds the Level Criterion:  How many pieces placed?
'         LevCM%         Holds the Level Criterion Met:  How many pieces
'                             have been placed since level change?
'         LP%            Holds the number of points scored for each completed
'                             line.
'         drops%         Holds the number of drops that have been executed.
'         dropl%         Holds the total length of all the drops that have
'                             been executed.
'         dropP%         Holds the total points scored in drops thus far.
'         placed%        Holds the number of pieces placed so far in the game.
'         pPoints%       Holds the number of points scored thus far by placing
'                             point-carrying pieces.
'         score%         Composite score, formed from the above.
'                        Formula:  score% = LevP%*level% + LP%*lines%
'                                           + dropP% + pPoints%
'         MaxX%          Holds the horizontal size of the playing field.
'         MaxY%          Holds the vertical size of the playing field.
'         PMX%           Holds the horizontal size of the pieces.
'         PMY%           Holds the vertical size of the pieces.
'         NumOfLevels%   Holds the number of levels of play for which there
'                             are new piece probablilities.
'         DV!            Stands for Delay Value.  A piece is moved down when
'                        the value of Timer changes by at least this much.
'         InitDV!        This comes with the piece set and is the starting
'                             value for DV!.
'         Accel!         This comes with the piece set and should be a
'                             little less than one.  DV! is multiplied by
'                             it (less a random adjustment) each time
'                             a level is attained.
'         RAccel!        This comes with the piece set and is related to
'                             the above random adjustment.
'
'    Other variables Used:  Count%, Go$, Temp$, Temp!, Temp%, Temp2%
'
'          These are used only at the local level.  Thus, it is safe
'              for any routine to use them for its own purposes
'              without restoring them, as long as it does not need
'              to keep info in them while calling another routine.
'
'    FLAGS:
'
'         Continue%      True% until CheckInsertHeight turns it
'                             off when the next piece will not fit
'                             on the board.  At this point the game
'                             is over.
'         Frozen%        False% until FreezePiece turns it on,
'                             at which point it is time to move on
'                             to the next piece.
'         Okay%          Boolean return value used by certain subs.
'                        TestProposal returns True% if the move is
'                             kosher, False% if the move is unnacceptable.
'                        KeyDrop checks it to see what KeyDown received
'                             as an answer.  This is one of the benefits
'                             of using global variables.
'                        CheckForLines uses Okay% internally.
'
'
'    DECLARATIONS:

Option Base 1

False% = 0: True% = NOT(False%)

PW% = 16 ' Actually the panel is 15 wide, but this also includes
         '  the border.

'  To determine the number of pieces (for dimensioning), we need
'    the name of the piece set.  While we're at it, let's pick up
'    some other info we need for dimensioning:
'
Open "QTet.CFG" for input as #1
     Line input #1, PSetSpec$
     input #1, CM%  '    ColorMode
     Line input #1, Temp$  '  Color Scheme File Spec
  close #1

Go$ = PSetSpec$ + ".SET"
Open Go$ for input as #1
     input #1, NumOfPieces%
     input #1, NumOfRotations%
     input #1, PMX% ' Piece Max X
     input #1, PMY% ' Piece Max Y
     input #1, FMX% ' Field Max X
     input #1, FMY% ' Field Max Y
     input #1, NumOfLevels%   '  The number of levels that MATTER for piece
                              '    selection.  There are, of course,
                              '    infinitely many levels  (in theory).
     input #1, InitDV!  ' \
     input #1, Accel!   '  >  These affect the speed of falling pieces.
     input #1, RAccel!  ' /
  close #1

Open Temp$ for input as #1
     input #1, NumOfColors%
  close #1

'    Now we can dimension our arrays:

DIM S%(FMX%+2*PMX%,FMY%+PMY%)
DIM P%(NumOfPieces%,NumOfRotations%,PMX%,PMY%)
Dim PP%(NumOfPieces%,NumOfRotations%)


Dim DP%(FMY%,NumOfLevels%)

Dim Prob%(NumOfPieces%,NumOfLevels%)

'  Now the color-related arrays:

Dim C%(NumOfColors%)
Dim CN$(NumOfColors%)
if (CM% < 10) then DIM C$(NumOfColors%)

'    READ IN ALL THE REMAINING STUFF FROM THE FILES

Go$ = PSetSpec$ + ".SET"
Open Go$ for input as #1
     input #1, NumOfPieces%    '\
     input #1, NumOfRotations% ' \
     input #1, PMX%            '  \
     input #1, PMY%            '   \
     input #1, FMX%            '    \  These have already been read once, but
     input #1, FMY%            '    /    we must read past them anyway.
     input #1, NumOfLevels%    '   /
     input #1, InitDV!         '  /
     DV! = InitDV!
     input #1, Accel!          ' /
     input #1, RAccel!         '/

     For CP% = 1 to NumOfPieces%
          Line Input #1, PN$(CP%)
          for CR% = 1 to NumOfRotations%
               for CX% = 1 to PMX%
                    for CY% = 1 to PMY%
                         Input #1, P%(CP%,CR%,CX%,CY%)
                      next CY%
                 next CX%
               Input #1, PP%(CP%,CR%)
            next CR%
          CR% = 1
          for level% = 1 to NumOfLevels%
               Input #1, Prob%(CP%,level%)
            next level%
       next CP%
     CP% = 1

     For level% = 1 to NumOfLevels%
          for lines% = 1 to FMY%
               Input #1, DP%(lines%,level%)
            next lines%
       next level%

     input #1, LevC%     ' How many pieces must be placed to advance a level?
     input #1, LevP%     ' How many points are scored for advancing a level?
     input #1, LP%       ' How many points are scored for completing a line?

  close #1

Open "QTet.CFG" for input as #1
     Line input #1, Go$  '  Alread read piece file spec, but read past.
     input #1, CM%  '  Already read, but we must read past anyhow.
     Line input #1, Go$  '  Color Scheme File Spec.  Read once, but need again.
  close #1

Open Go$ for input as #1 ' Color Scheme File
     input #1, NumOfColors%   ' Alread read, but read past.
     For Count% = 1 to NumOfColors%
          Line Input #1, CN$(Count%)
          Input #1, C%(Count%)
          if (CM% < 10) then Line Input #1, C$(Count%)
       next Count%
  close #1

Gosub InitMovementKeys
Gosub InitDisplay
Gosub InitScreenArray ' (fill undisplayed borders)
Gosub SelectNextPiece

'         ********************************************************
'         **                                                    **
'         **        M A I N    L O O P                          **
'         **                                                    **
'         ********************************************************

          Continue% = True%
          While (Continue%)
               Gosub NextPiece
               Gosub FallingDelay  '  Add one delay so the user will
                                   '  quit trying to act on the
                                   '  previous piece before the keys
                                   '  come back on for this piece.
               Frozen% = False%
               While NOT(Frozen%)
                    Gosub AllowMovementKeys
                    Gosub FallingDelay
                    Gosub HoldMovementKeys  '  They will be examined next
                                            '   time around the loop.
                                            '   (That is, IF we are still
                                            '    on the same piece.)
                    PR% = CR%: PX% = CX%: PY% = CY% + 1 ' top left is origin
                    Gosub TestProposal
                    if Not (Okay%) then
                        Gosub DisAllowMovementKeys ' Do NOT hold them to be
                                                   '  examined later.   Kill
                                                   '  them.  Only use keys
                                                   '  pressed after the
                                                   '  piece change is complete.
                        Gosub FreezePiece
                        Gosub CheckForLines
                      else
                         Gosub UnDisplayPiece
                         CY% = PY%      ' Carry out the proposal.
                                        ' (The piece falls.)
                         Gosub DisplayPiece
                      end if
                 WEND
               Gosub CheckInsertHeight
            WEND

'         ********************************************************

'         Now, the game is over; clean up.
'
          Gosub GameOverMessage

          Gosub CreateGameScore '  Saves the game's score info in
                                '    a temporary file, which is read
                                '    by the scoreboard program

          run "HIGHSCOR.Q"

'         ********************************************************

'

'   SUBROUTINES:

NextPiece:
'***********************************
      CP% = NP%                  ' *
'      color 15,0: locate 2,70: ? CR%: color 7,0
      CY% = 1                    ' *
      Gosub SelectNextPiece      ' *
      Gosub UpdateStatsPanel     ' *
      Gosub ReDrawPlayingField   ' *
      Gosub ReDrawBorders        ' *
  Return                         ' *
'***********************************

SelectNextPiece:
'*************************************************
     NP% = rnd(1)*1793 mod NumOfPieces% + 1  '   *
     '  This will, of course, have to change '   *
     '   to reflect the values in Prob%.     '   *
  Return       '                                 *
'*************************************************

FallingDelay:
'**************************************
     Temp! = Timer  '                 *
     dummy$ = Inkey$               '  *
     While (Timer < Temp! + DV!)   '  *
       WEND    '                      *
  Return  '                           *
'**************************************

AllowMovementKeys:
'**********************************
  For TK% = 1 to 18           '   *
     Key(TK%) On         '        *
    next TK%        '             *
'     Key(11) On     ' Up (RotBack)*
'     Key(12) On     ' Left        *
'     Key(13) On     ' Right       *
'     Key(14) On     ' Down        *
'     Key(15) On     ' Rotate      *
'     Key(16) On     ' Pause       *
'     Key(17) On     ' Mutate      *
'     Key(18) On     ' Drop        *
  Return  '                       *
'**********************************

HoldMovementKeys:
'************************************
  For TK% = 1 to 18 '               *
     Key(TK%) Stop       '          *
    next TK%                  '     *
'     Key(11) Stop     ' Up (RotBack)*
'     Key(12) Stop     ' Left        *
'     Key(13) Stop     ' Right       *
'     Key(14) Stop     ' Down        *
'     Key(15) Stop     ' Rotate      *
'     Key(16) Stop     ' Pause       *
'     Key(17) Stop     ' Mutate      *
'     Key(18) Stop     ' Drop        *
  Return  '                         *
'************************************

DisAllowMovementKeys:
'************************************
  For TK% = 1 to 18 '               *
     Key(TK%) Off        '          *
    next TK%                  '     *
'     Key(11) Off      ' Up (RotBack)*
'     Key(12) Off      ' Left        *
'     Key(13) Off      ' Right       *
'     Key(14) Off      ' Down        *
'     Key(15) Off      ' Rotate      *
'     Key(16) Off      ' Pause       *
'     Key(17) Off      ' Mutate      *
'     Key(18) Off      ' Drop        *
  Return  '                         *
'************************************

InitMovementKeys:
'***********************************
     On Key(1)  Gosub Help       ' *
     On Key(2)  Gosub SaveScreen ' *
     On Key(3)  Gosub ToggleSound' *
     On Key(4)  Gosub Key4       ' *
     On Key(5)  Gosub Key5       ' *
     On Key(6)  Gosub Key6       ' *
     On Key(7)  Gosub Key7       ' *
     On Key(8)  Gosub Key8       ' *
     On Key(9)  Gosub Key9       ' *
     On Key(10) Gosub ExitQues   ' ************************
     On Key(11) Gosub KeyUp        ' (rotate backwards)   *
     On Key(12) Gosub KeyLeft      '                      *
     On Key(13) Gosub KeyRight     '                      *
     On Key(14) Gosub KeyDown      ' (one line down)      *
     '                             ************************
     ' Keypad Center = Rotate:     *
     Key 15, Chr$(0)+Chr$(76) '    *
     ' "P" = Pause:                *
     Key 16, Chr$(0)+Chr$(25) '    *
     ' secret combo: Mutate:       *
     Key 17,Chr$(12)+Chr$(50) '    *
     ' space = drop:               *
     Key 18, Chr$(0)+Chr$(57) '    *
     '                             ************************
     On Key(15) Gosub KeyFive      ' (rotate)             *
     On Key(16) Gosub KeyPause     '                      *
     On Key(17) Gosub KeyMutate    ' (secret cheat key)   *
     On Key(18) Gosub KeyDrop      '                      *
   Return      '                                          *
'**********************************************************

Key4:
Key5:
Key6:
Key7:
Key8:
Key9:
     Return

KeyLeft:
'*************************************
     Gosub HoldMovementKeys   '      *
     PR% = CR%: PY% = CY%     '      *
     PX% = CX% - 1            '      *
     Gosub TestProposal       '      *
     If NOT(Okay%) then       '      *
       Gosub AllowMovementKeys     ' *
      Else     '                     *
        Gosub UnDisplayPiece     '   *
        CX% = CX% - 1            '   *
        Gosub DisplayPiece       '   *
        Gosub AllowMovementKeys  '   *
     End If                      '   *
  Return       '                     *
'*************************************

KeyRight:
'*************************************
     Gosub HoldMovementKeys   '      *
     PR% = CR%: PY% = CY%     '      *
     PX% = CX% + 1            '      *
     Gosub TestProposal       '      *
     If NOT(Okay%) then       '      *
'          ? "Move to Right Denied."
       Gosub AllowMovementKeys     ' *
       Return  '                     *
      End If   '                     *
'          ? "Move to Right Allowed."
     Gosub UnDisplayPiece     '      *
     CX% = PX%                '      *
     Gosub DisplayPiece       '      *
     Gosub AllowMovementKeys  '      *
  Return       '                     *
'*************************************

KeyUp:    ' (Rotate Backwards)
'*************************************
     Gosub HoldMovementKeys   '      *
     PX% = CX%: PY% = CY%     '      *
     PR% = CR% - 1            '      *
     if (PR% <=0) then PR% = NumOfRotations%
     Gosub TestProposal       '      *
     If NOT(Okay%) then       '      *
       Gosub AllowMovementKeys     ' *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayPiece     '      *
     CR% = PR%                '      *
     Gosub DisplayPiece       '      *
     Gosub AllowMovementKeys  '      *
  Return       '                     *
'*************************************

KeyDown:
'*************************************
     Gosub HoldMovementKeys   '      *
     PR% = CR%: PX% = CX%     '      *
     PY% = CY% + 1            '      *
     Gosub TestProposal       '      *
     If NOT(Okay%) then       '      *
       Gosub AllowMovementKeys     ' *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayPiece     '      *
     CY% = PY%                '      *
     Gosub DisplayPiece       '      *
     Gosub AllowMovementKeys  '      *
  Return       '                     *
'*************************************

KeyFive:  ' (Rotate Forwards)
'*************************************
     Gosub HoldMovementKeys   '      *
     PX% = CX%: PY% = CY%     '      *
     PR% = CR% + 1            '      *
     if (PR% > NumOfRotations%) then PR% = 1
     Gosub TestProposal       '      *
     If NOT(Okay%) then       '      *
       Gosub AllowMovementKeys     ' *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayPiece     '      *
     CR% = PR%                '      *
     Gosub DisplayPiece       '      *
     Gosub AllowMovementKeys  '      *
  Return       '                     *
'*************************************

KeyPause:
'*********************************
     Gosub HoldMovementKeys   '  *
     Gosub SaveScreen         '  *
     Gosub InitDisplay        '  *
     Gosub UpdateStatsPanel   '  *
     Gosub ReDrawPlayingField '  *
     Gosub ReDrawBorders      '  *
     Gosub DisplayPiece       '  *
     Gosub AllowMovementKeys  '  *
  Return       '                 *
'*********************************

KeyMutate:     ' (The secret cheat key...)
'**********************************************
     Gosub HoldMovementKeys                 ' *
     Gosub UnDisplayPiece                   ' *
     CP% = CP% + 1                          ' *
     if (CP% > NumOfPieces%) then CP% = 1   ' *
     Gosub DisplayPiece                     ' *
     Gosub AllowMovementKeys                ' *
  Return       '                              *
'**********************************************

KeyDrop:
'***************************
     Okay% = True%  '      *
     Temp% = 0      '      *
     While (Okay%)  '      *
          Gosub KeyDown  ' *
          Temp%=Temp%+1  ' *
       WEND         '      *********************
     Temp% = Temp% - 1   '                     *
     if (Temp%>0) then drops% = drops% + 1   ' *
     dropl% = dropl% + Temp%       '           *
     If (level% <= NumOfLevels%) Then        ' *
        dropP% = dropP% + DP%(Temp%,level%)  ' *
       else              '                     *
        dropP%=dropP%+DP%(Temp%,NumOflevels%)' *
       end if            '                     *
     score% = LevP%*level% + LP%*lines% + dropP% + pPoints%
     Gosub UpdateStatsPanel        '           *
  Return       '                               *
'***********************************************

TestProposal:
'############################################################
     Okay% = True%  ' (default)                             #
     For Count% = 1 to PMX%        '                        #
          For Temp% = 1 to PMY%    '                        #
               If (P%(CP%,PR%,Count%,Temp%)>0) then    '    #
                    if (S%(PMX%+PX%+Count%-1,PY%+Temp%-1)>0) then Okay% = False%
                 end if  '                                  #
            next Temp%   '                                  #
       next Count%       '                                  #
   If PY% > FMY% then    '                                  #
        If (UseSound%) then sound 200,1                '    #
        Okay% = False%   '                                  #
     end if              '                                  #
   If ((UseSound%) and (not(Okay%))) then sound 37,.5  '    #
  Return                 '                                  #
'############################################################

FreezePiece:
'######################################
     for Count% = 1 to PMX%   '       #
          for Temp% = 1 to PMY%    '  #
               S%(PMX%+CX%+Count%-1,CY%+Temp%-1) = S%(PMX%+CX%+Count%-1,CY%+Temp%-1) + P%(CP%,PR%,Count%,Temp%)
            next Temp%             '  #
       next Count%            '       #
     Frozen% = True%          '       #
     pPoints%=pPoints%+PP%(CP%,CR%) ' #
     placed% = placed% + 1    '       #
     LevCM% = LevCM% + 1      '       #
     if (LevCM%>=LevC%) then gosub AdvanceLevel
     score% = LevP%*level% + LP%*lines% + dropP% + pPoints%
     Gosub UpdateStatsPanel   '       #
     If (CX% + PMX% > FMX%) then   '  #
         CX% = FMX% - PMX%    '       #
       end if  '                      #
     if (CX% < 1) then CX% = 1     '  #
  Return  '                           #
'######################################

AdvanceLevel:
'###################################
     LevCM% = 0     '              #
     level% = level% + 1      '    #
     If (UseSound%) then '         ###############################
          Play "T255"         '                                  #
          For TheNote% = 1 to 30 step 2 '                        #
               TheNote$=Str$(TheNote%) '                         #
               TheNote$=Right$(TheNote$,Len(TheNote$)-1)    '    #
               TheNote$="N"+TheNote$   '                         #
               Play TheNote$       '                             #
            next TheNote%     '                                  #
        End If                                              '    #
     DV! = DV! * Accel!       '                                  #
     DV! = DV! * (1 - (rnd(1) * (1 - RAccel!)))   '              #
  Return  '                                                      #
'#################################################################


CheckForLines:
'#########################################################################
     For Temp% = 1 to PMY%         '                                     #
          Okay% = True% ' Line is, by default, complete.                 #
          if (CY%+Temp%-1>FMY%) then Okay% = False%    '                 #
          For Count% = 1 to FMX%   '                                     #
               if (S%(PMX%+Count%,CY%+Temp%-1)<=0) then Okay% = False% ' #
            next Count%            '                                     #
          If (Okay%) Then          '                                     #
               lines% = lines% + 1 '                                     #
               score% = LevP%*level% + LP%*lines% + dropP% + pPoints% '  #
               For Temp2% = CY% + Temp% - 1 to 2 step -1              '  #
                    For Count% = 1 to FMX%             '               ###
                         S%(PMX%+Count%, Temp2%) = S%(PMX%+Count%, Temp2%-1)
                      next Count%  '                             ###     #
                 next Temp2%       '                          ###        #
               Gosub UpdateStatsPanel                  '   ###           #
               Gosub ReDrawPlayingField                '###              #
            End If       '                           ###                 #
       next Temp%        '                        ###                    #
  Return                 '                     ###                       #
'#########################################################################


CheckInsertHeight:
'##############################################
     '  Basically, this checks to see that    #
     '    the top line of the playing field   #
     '    is clean.  Otherwise, the game      #
     '    is over, so we set a flag.          #
     For Count% = 1 to FMX%   '               #
          if (S%(PMX%+Count%,1) > 0)    Then Continue% = False%
       next Count%            '               #
  Return  '                                   #
'##############################################

InitScreenArray:
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
     BorderC% = 1
     For Count% = 1 to PMX%   '                                 &
          For Temp% = 1 to FMY%+PMY%         '                  &
               S%(Count%,Temp%) = BorderC%   '                  &
               S%(PMX% + FMX% + Count%, Temp%) = BorderC%   '   &
            next Temp%        '                                 &
       next Count%            '                                 &
     For Count% = 1 to PMY%   '                                 &
          For Temp% = 1 to FMX%+2*PMX%       '                  &
               S%(Temp%,FMY%+Count%) = BorderC%             '   &
            next Temp%        '                                 &
       next Count%            '                                 &
  Return            '                                           &
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

InitDisplay:
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&
     Select Case CM%          '                                  ::
          Case 0    '  (text:  80x24)                            &&
               Screen 0 : cls '                                  ::
               Gosub InitTextPanel           '                   &&
          Case 1    '  (text:  80x24==>40x24, "square pixels")   ::
               Screen 0 : cls '                                  &&
               Gosub InitTextPanel           '                   ::
       End Select   '                                            &&
     Gosub ReDrawBorders      '                                  ::
     Gosub ReDrawPlayingField ' (misnamed in this first case)    &&
  Return            '                                            ::
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&

InitTextPanel:
     Color 7
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&
     locate 1,1: print "Current Piece:";     '   ::
     locate 3,1: print "Next Piece:";        '   &&
     locate 12,1: print "Score:";            '   ::
     locate 13, 2: print "Level:";           '   &&
     locate 14, 4: print "Crit.:";           '   ::
     locate 15, 2: print "Lines:";           '   &&
     locate 16, 2: print "Drops:";           '   ::
     locate 17, 4: print "Length:";          '   &&
     locate 18, 4: print "Points:";          '   ::
     locate 19, 2: print "Pieces:";          '   &&
     locate 20, 4: print "Points:";          '   ::
     locate 22, 1: print "HELP: PRESS F1";   '   &&
     locate 5,2: print "";   '                  ::
     locate 11,2: print "";  '                  &&
     Select Case CM%          '                  ::
          Case 0              '                  &&
               Temp% = 8      '                  ::
          Case 1              '                  &&
               Temp% = 13     '                  ::
       end select             '                  &&
     for Count% = 3 to Temp%  '                  ::
          locate 5,Count%     '                  &&
          print "";          '                  ::
          locate 11,Count%    '                  &&
          print "";          '                  ::
       next Count%            '                  &&
     locate 5,Temp%           '                  ::
     print "";               '                  &&
     locate 11,Temp%          '                  ::
     print "";               '                  &&
     For Count% = 6 to 10     '                  ::
          locate Count%,2     '                  &&
          print "";          '                  ::
          locate Count%,Temp% '                  &&
          print "";          '                  ::
       next Count%            '                  &&
  Return       '                                 ::
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&

UpdateStatsPanel:
'::::::::::::::::::::::::::::
     color 7   '           ::
     locate 2,2          ' ::
     print PN$(CP%);     ' ::
     locate 4,2          ' ::
     print PN$(NP%);     ' ::
     locate 12,8         ' ::
     print score%;       ' ::
     locate 13,9         ' ::
     print level%;       ' ::
     locate 14,11        ' ::
     print (LevC%-LevCM%); ':
     locate 15,9         ' ::
     print lines%;       ' ::
     locate 16,9         ' ::
     print drops%;       ' ::
     locate 17,12        ' ::
     print dropL%;       ' ::
     locate 18,12        ' ::
     print dropP%;       ' ::
     locate 19,10        ' ::
     print placed%;      ' ::
     locate 20,12        ' ::
     print pPoints%;     ' ::
     Gosub ShowNextPiece ' ::
  Return       '           ::
'::::::::::::::::::::::::::::

ReDrawBorders:
'::::::::::::::::::::::::::::::::::
     For Count% = 1 to FMY%   '  ::
          locate Count%, PW%  '  ::
          color 7             '  ::
          print "";          '  ::
          Select Case CM%     '  ::
               Case 0         '  ::
                    locate Count%, PW% + FMX% + 1
               Case 1         '  ::
                    locate Count%, PW% + FMX% * 2 + 1
            End Select        '  ::
          print "";          '  ::
       next Count%            '  ::
  Return       '                 ::
'::::::::::::::::::::::::::::::::::

ShowNextPiece:
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate 5+Count%,2+Temp%                 '  ::
                         color C%(P%(NP%,CR%,Temp%,Count%)+1)    '  ::
                         print C$(P%(NP%,CR%,Temp%,Count%)+1);   '  ::
                    Case 1         '                                ::
                         locate 5+Count%,1+Temp%*2               '  ::
                         color C%(P%(NP%,CR%,Temp%,Count%)+1)    '  ::
                         print C$(P%(NP%,CR%,Temp%,Count%)+1);   '  ::
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%                 '                                ::
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

UnDisplayPiece:
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate CY%+Count%-1, PW%+Temp%+CX%  -1  '  ::
'                         color C%(1)                             ' ::
                         color 0                                 '  ::
                         if (P%(CP%,CR%,Temp%,Count%)>0) then print " ";
                    Case 1         '                                ::
                         locate CY%+Count%-1,PW%+Temp%*2-1 +CX%*2-2'::
                         color C%(1)                             '  ::
                         if (P%(CP%,CR%,Temp%,Count%)>0) then print "  ";
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%  '                                               ::
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DisplayPiece:
on error goto CheckForSubscriptError
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate CY%+Count%-1, PW%+Temp%+CX% -1   '  ::
                         color C%(P%(CP%,CR%,Temp%,Count%)+1)    '  ::
                         if (P%(CP%,CR%,Temp%,Count%)>0) then print C$(P%(CP%,CR%,Temp%,Count%)+1);
                    Case 1         '                                ::
                         locate CY%+Count%-1,PW%+Temp%*2-1+CX%*2-2 '::
                         color C%(P%(CP%,CR%,Temp%,Count%)+1)    '  ::
                         if (P%(CP%,CR%,Temp%,Count%)>0) then print C$(P%(CP%,CR%,Temp%,Count%)+1);
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%  '                                               ::
FixSubscriptError:
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CheckForSubscriptError:
     if (err=9) then resume FixSubscriptError
     On Error goto 0
resume next

ReDrawPlayingField:
':::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to FMY%        '                  ::
          For Temp% = 1 to FMX%    '                  ::
               Select Case CM%     '                  ::
                    Case 0         '                  ::
                     locate Count%, PW%+Temp%     '   ::::::::::
                     color C%(S%(PMX% + Temp%,Count%)+1)    ' ::
                     Print C$(S%(PMX% + Temp%,Count%)+1);   ' ::
                    Case 1         '                          ::
                     locate Count%, PW%-1+2*Temp% '           ::
                     color C%(S%(PMX% + Temp%,Count%)+1)  '   ::
                     Print C$(S%(PMX% + Temp%,Count%)+1); '   ::
                 End Select        '                  ::::::::::
            next Temp%             '                  ::
       next Count%  '                                 ::
  Return            '                                 ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::

Help:
  Gosub DisAllowMovementKeys
  HelpDoneFlag% = False%
     Screen ,,3,3
          color 15,0: cls
          Print "QTetris Help:"
          Open "QTET.HLP" for input as #1
               Go$ = ""
               While ((Go$ <> "<EOF>") and (HelpDoneFlag% = False%))
                    If (Go$ = "") then
                         Print: Print "Do you wish to continue viewing help? (y/n)"
                         While ((Go$ <> "Y") and (Go$<>"N"))
                              Go$ = UCase$(Inkey$)
                           WEND
                         If (Go$ = "N") then HelpDoneFlag% = True%
                      else
                         Print Go$
                         ssT! = TIMER
                         While (ssT! + .15 > TIMER): WEND
                      end if
                    Line Input #1, Go$
                 WEND
               Print "END OF HELP:  Press any key."
               While (Inkey$ <> ""): WEND
               While (Inkey$ = ""): WEND
            Close #1
     Screen ,,0,0
  Gosub AllowMovementKeys
  Return

ExitQues:
  Gosub DisAllowMovementKeys
     Screen ,,1,1
          cls
          print "Are you sure you want to abort this game? (y/n)";
          Go$ = ""
          While ((Go$<>"Y") and (Go$ <> "N"))
              Go$ = UCase$(Inkey$)
            WEND
          If (Go$ = "Y") then Continue% = False%
     Screen ,,0,0
  Gosub AllowMovementKeys
  Return

ToggleSound:
     UseSound% = NOT(UseSound%)
  Return

SaveScreen:
  Gosub DisAllowMovementKeys
     Screen ,,2,2
     While (Inkey$ <> ""): WEND
     While (Inkey$ = "")
          ssX% = rnd(1)*40+15
          ssY% = rnd(1)*15+4
          locate ssY%, ssX%: print "Press Any Key"
          color rnd(1)*16,0
          ssT! = TIMER
          While (ssT! + .5 > TIMER): WEND
          locate ssY%, ssX%: Print "             "
       WEND
     Screen ,,0,0
     Gosub AllowMovementKeys
  Return

OldSS:
     if not (ssSettingsSet%) then SSXC% = 2: SSYC% = 2: ssXCV! = rnd(1)*.2: ssYCV! = rnd(1)*.15
     ssSettingsSet% = True%
     Screen ,,2,2
     ssWrap% = False%
     if (rnd(1)*100 > 50) then ssWrap% = True%
  While (Inkey$ <> ""): WEND
  While (Inkey$ = "")
     ssX% = ssX% + int(ssXC!): ssY% = ssY% + int(ssYC!)
     if ((ssX% > 78) or (ssX% < 2)) then
          if (ssWrap%) then
               ssX% = ssX% - (77 * ssXC! / abs(ssXC!))
            else
               ssXC! = -1 * ssXC! + 2 * ssXCV! - rnd(1)*ssXCV!
               ssX% = ssX% + int(2*ssXC!)
            end if
        end if
     if ((ssY% > 22) or (ssY% < 2)) then
          if (ssWrap%) then
               ssY% = ssY% - (21 * ssYC! / abs(ssYC!))
            else
               ssYC! = -1 * ssYC! + 2 * ssYCV! - rnd(1)*ssYCV!
               ssY% = ssY% + int(2*ssYC!)
            end if
        end if
     WEND

GameOverMessage:
'[][][][][][][][][][][][][][][][][][][][][][][][]
     locate FMY%\2, PW% + 5                  ' []
     color 31  '                               []
     print " G A M E   O V E R ";            ' []
     locate FMY%\2+1, PW% + 5                ' []
     print "   PRESS ANY KEY   ";            ' []
     While (Inkey$="")                       ' []
          for Temp% = 2500 to 2480 step -5   ' []
                If (UseSound%) then sound Temp%, .5
            next Temp%                       ' []
       WEND    '                               []
  Return       '                               []
'[][][][][][][][][][][][][][][][][][][][][][][][]

CreateGameScore:
'[][][][][][][][][][][][][][][][][][][][][][][][]
     Open "qtgscore.dat" for output as #1    '
          Print #1, PSetSpec$                '
          score% = LevP%*level% + LP%*lines% + dropP% + pPoints% ' jic
          Print #1, score%       ' 1
          Print #1, level%       ' 2
          Print #1, LevP%        ' 3
          Print #1, lines%       ' 4
          Print #1, LP%          ' 5
          Print #1, drops%       ' 6
          Print #1, dropl%       ' 7
          Print #1, dropP%       ' 8
          Print #1, placed%      ' 9
          Print #1, pPoints%     '10
       Close #1     '
  Return            '
