
DEFINT A-Z
DECLARE FUNCTION Engine.TileCollide% (Character AS ANY) ' Sub used for collision with tiles.
DECLARE SUB Engine.DrawPlayer (Player AS ANY)        ' Sub used to draw our hero on the screen.
DECLARE SUB Engine.DrawScreen () ' Sub used to draw all our stuff on the screen and to control the page flipping.
DECLARE SUB AINPC (currentNPC%)  ' Sub used to move and control the movement of NPCs.
DECLARE SUB Engine.DrawNPC ()    ' Sub used to draw the NPCs.
DECLARE SUB InitVariables ()     ' This sub is used to initate various variables(player starting position, ect).
DECLARE SUB Engine.DrawMap ()    ' Sub used to draw our map on the screen(paste the tiles).
DECLARE SUB InitMap (mapcon$)    ' This sub loads our map in the Map array(used in Engine.DrawMap sub).
DECLARE SUB Engine.UpdatePlayer (Player AS ANY, Direction%)   ' Sub used to update position of the player.
DECLARE SUB Engine.UpdateCamera (Level AS ANY, Player AS ANY) ' Sub used to update position of the camera.
DECLARE SUB Main ()        ' Main loop where statements for player control are.
DECLARE SUB MainScreen ()  ' Extra sub for title screen.
'============================================================================
DECLARE SUB Engine.DoCollision (currentNPC%)   ' Sub used to detect the collison between
                                               ' the player and the NPCs.
'============================================================================

' pp256_image.bi module is used for PUT file loading(Pixel Plus 256
' standard file format) while rel_collide.bi module is used for
' pixel perfect collision.
#include "fbgfx.bi"
#include "pp256_image.bi"  
#include "rel_collide.bi"

' SpriteType is used to hold character related data(from the player
' to NPCs).
TYPE SpriteType
         Typ            AS INTEGER    ' Character ID(used with NPCs).
         X              AS SINGLE     ' World X position of the character.
         Y              AS SINGLE     ' World Y position of the character.
         XV             AS SINGLE     ' X Speed of the character.
         YV             AS SINGLE     ' Y speed of the character.
         Frame          AS INTEGER    ' Used to display the proper image of the character from the PUT file.
         Move           AS INTEGER    ' Is sprite moving?
         RANGE          AS INTEGER    ' Not used!
         Active         AS INTEGER    ' Not used!
         HIT            AS INTEGER    ' Not used!
         AI             AS INTEGER    ' Not used!
         MONEY          AS INTEGER    ' Not used!
         HP             AS INTEGER    ' Not used!
         ITEM           AS INTEGER    ' Not used!
         Direction      AS INTEGER    ' Used to flag the direction of the character.
         TileX          AS INTEGER    ' Tile on which the character is.
         TileY          AS INTEGER     
         Frame2         AS INTEGER    ' Not used!
         
         OldX           AS INTEGER    ' Used with character to
         OldY           AS INTEGER    ' to character collision to
                                      ' restore the old positions of
                                      ' colliding characters
                                      ' (ie, player to NPC collision).
         Exists AS INTEGER
END TYPE

' Used to hold data related to scrolling(camera position, ect).
TYPE LevelType
        Xmax    AS INTEGER     ' Maximum number of tiles a map has.
        Ymax    AS INTEGER 
        CamX    AS INTEGER     ' Pixel*Pixel Camera Position.
        CamY    AS INTEGER 
        TileX   AS INTEGER     ' Tile postion of the camera.
        TileY   AS INTEGER     ' Calculated by CamX\TileSize.
        Xpos    AS INTEGER     ' Pixel position inside the tile
        Ypos    AS INTEGER     ' 0 to 19 (used for scrolling).
END TYPE

TYPE MapLayerType
       BaseL    AS INTEGER          ' Base Layer Implemented
       FringeL  AS INTEGER          ' Fringe     Not Implemented
       ObjectL  AS INTEGER          ' Object     Not Implemented
END TYPE

'***********************************************
' Variables and the sub used to load PUT files into arrays.
TYPE tileType
s_image	    as ImageType		
init	  	    as sub ( byref tile as tileType )	 
load_image   as sub ( byref tile as tileType )	  
END TYPE
DECLARE SUB tile_load_image ( byref tile as tileType )
'***********************************************

' Subs used to print custom font text on the screen.
DECLARE SUB GraphicText (xx%, yy%, Textt$, byref tile as tileType)
DECLARE FUNCTION GetDepth% (ImNo%,byref tilem as tileType)
DECLARE FUNCTION GetWidth% (ImNo%,byref tilem as tileType)


' Declare your constants here!
CONST NULL = 0
CONST CENTRETEXT = -1

' Change these constants to suit your screen mode needs 
' and tile size.
' Screen constants(Full Screen 320*200)
CONST ScrnXmax = 300, ScrnYmax = 300
CONST ScrnXmid = ScrnXmax/2, ScrnYmid = ScrnYmax/2
CONST ScrnXmin = 0, ScrnYmin = 0

'Tile dimensions 20*20
CONST TileW = 20
CONST TileH = 20

' Number of tiles per screen 320\20=16, 200\20=10
' Used to calculate the Engine.DrawMap sub.
CONST ScrnTileXmax = ScrnXmax \ TileW
CONST ScrnTileYmax = ScrnYmax \ TileH

' Directional constants for easy sprite handling
' DN=Neutral(not Moving), DR=Right...........
CONST DN = 0, DR = 1, DU = 2, DL = 3, DD = 4

' More needed constants.
CONST FALSE = 0
CONST TRUE = 1

' Arrays that will hold our sprites, tiles and our font.
DIM SHARED Tiles as tileType
DIM SHARED Tiles2 as tileType
DIM SHARED Sprites as tileType
DIM SHARED Font as tileType

' Map array used to hold the map data(which tiles go where in the map).
' Change 150, 150 to the biggest horizontal and vertical size any 
' of your maps will feature.
REDIM SHARED Map(150, 150) AS MapLayerType         

DIM SHARED Level AS LevelType    ' Used to hold data related to
                                 ' scrolling(camer position, ect).
DIM SHARED Player AS SpriteType  ' Our Player.
DIM SHARED NPC(40) AS SpriteType ' Our non-player controled sprites.
                                 ' We have defined 40 elements(max of 
                                 ' 40 NPCs per map). Change this to
                                 ' any desired number of maximum NPCs 
                                 ' you want to be featured on a 
                                 ' loaded map.

DIM SHARED pathf$ ' This variable used to locate the dir of your files.

' Some variables we use in our program.                            
DIM SHARED mapy$, countNPC
DIM SHARED Frame, Frame2, Frame3 ' Variables used to time animations.
DIM SHARED FPS, FPS2, Starttime& ' Variables used to count FPS.
DIM SHARED MapXMax, MapYMax      ' Variables used to set the
                                 ' size of our map.
DIM SHARED placetile, location, lockers, doors

placetile = 31

' Initiate our screen mode. 2 work pages minimum.
' Change 0 to 1 for full screen mode.
SCREEN 18,8,2,0
SETMOUSE 0,0,0 ' Hides the mouse cursor.

' If your working files are in the directory where the compiled
' file is pathf$ should be "".
pathf$ = "d:\working\freebasic\mycoding\scroll\"
pathf$=""

' This is how sprites are loaded by using pp256_image.bi module 
' and couple of variables and one sub declared in this code.
' Don't break your head over it, just use it.
' Tiles is the array holding our map tiles.
' Sprites is the array holding our sprites.
' Font is the array holding out font(you can use more of them
' at the same time, just declare Font2 or any other array above
' and store a second font into it).
Sprites.s_image.m_filename = pathf$ + "Graphics\SROGUE1.PUT"
Tile_load_image ( Sprites )
Font.s_image.m_filename = pathf$ + "Fonts\SROGUE1.FNT"
Tile_load_image ( Font )

LOCATE 1,1
PRINT "PLEASE INPUT LEVEL TO EDIT(be sure level PUT and MAP file exists):"
INPUT$ location

Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(location)+".PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(location)+"1.PUT"
Tile_load_image ( Tiles2 )

InitMap "Data\level"+STR$(location)+".map"               ' Read our Map Array(from a file).

init_palette_data  pathf$ + "normal.pal" ' Load our palette.

MainScreen              ' Displays introducing screen. 

InitVariables           ' Initialize our variables.

Main                    ' Main Loop.

END ' End program.


SUB AINPC (currentNPC)
' This is the sub which moves our NPCs. In this example the movement
' in randomized unless the player is in NPCs area(TileX>19 and
' TileY>25) and more than 30 pixels(in both directions) away
' from them. The only code important to you is the one in
' select case. The way the NPCs will move is up to you. Create
' your own AI. This is just for the purpose of the example.

' Default: NPC is not moving.
NPC(currentNPC).Direction = 0
NPC(currentNPC).Move = FALSE

' We tell our NPC to follow the player if the player is in the NPCs
' area and not too close the NPC.
IF Player.TileX > 19 AND Player.TileY > 25 AND ABS(Player.X - NPC(currentNPC).X)>30 AND ABS(Player.Y - NPC(currentNPC).Y)>30 THEN
IF Player.X > NPC(currentNPC).X THEN NPC(currentNPC).Direction = 1
IF Player.X < NPC(currentNPC).X THEN NPC(currentNPC).Direction = 3
IF Player.Y < NPC(currentNPC).Y THEN NPC(currentNPC).Direction = 2
IF Player.Y > NPC(currentNPC).Y THEN NPC(currentNPC).Direction = 4
NPC(currentNPC).Move = TRUE
GOTO skiprnddirec: ' Skip regular movement if NPC is following the
                   ' player( ALERT! ALERT! I used a GOTO statement.
                   ' Don't shoot me!) :P
END IF

' We randomize in which direction the current NPC will go and if
' the NPC will move at all.
ChangeDirec = INT(RND * 8) + 1
IF ChangeDirec = 2 THEN 
NPC(currentNPC).Direction = INT(RND * 4) + 1
NPC(currentNPC).Move = TRUE
END IF

skiprnddirec:

' These two lines of code prevent NPCs to go outside the NPCs 
' area(bottom-right corner of the map). This is just for the 
' purpose of the example.
IF NPC(currentNPC).TileX<20 AND NPC(currentNPC).TileY>25 THEN NPC(currentNPC).Direction = 1
IF NPC(currentNPC).TileY<26 AND NPC(currentNPC).TileX>19 THEN NPC(currentNPC).Direction = 4

' According to NPC's direction the NPC moves and is checked for 
' collision with colliding tiles.
SELECT CASE NPC(currentNPC).Direction
        CASE 1
                NPC(currentNPC).OldX = NPC(currentNPC).X   ' We save the old position of the NPC for collision purposes.
                NPC(currentNPC).X = NPC(currentNPC).X + NPC(currentNPC).XV
                'IF Engine.TileCollide(NPC(currentNPC)) THEN NPC(currentNPC).X = NPC(currentNPC).X - NPC(currentNPC).XV
                IF NPC(currentNPC).X > (Level.Xmax * TileW) - TileW THEN NPC(currentNPC).X = (Level.Xmax * TileW) - TileW
        CASE 2
                NPC(currentNPC).OldY = NPC(currentNPC).Y 
                NPC(currentNPC).Y = NPC(currentNPC).Y - NPC(currentNPC).YV
                'IF Engine.TileCollide(NPC(currentNPC)) THEN NPC(currentNPC).Y = NPC(currentNPC).Y + NPC(currentNPC).YV
                IF NPC(currentNPC).Y < ScrnYmin THEN NPC(currentNPC).Y = ScrnYmin
        CASE 3
                NPC(currentNPC).OldX = NPC(currentNPC).X 
                NPC(currentNPC).X = NPC(currentNPC).X - NPC(currentNPC).XV
                'IF Engine.TileCollide(NPC(currentNPC)) THEN NPC(currentNPC).X = NPC(currentNPC).X + NPC(currentNPC).XV
                IF NPC(currentNPC).X < ScrnXmin THEN NPC(currentNPC).X = ScrnXmin
        CASE 4
                NPC(currentNPC).OldY = NPC(currentNPC).Y 
                NPC(currentNPC).Y = NPC(currentNPC).Y + NPC(currentNPC).YV
                'IF Engine.TileCollide(NPC(currentNPC)) THEN NPC(currentNPC).Y = NPC(currentNPC).Y - NPC(currentNPC).YV
                IF NPC(currentNPC).Y > (Level.Ymax * TileH) - TileH THEN NPC(currentNPC).Y = (Level.Ymax * TileH) - TileH
        CASE ELSE
END SELECT

END SUB


SUB Engine.DoCollision (currentNPC)
' Collision sub. The collision is pixel perfect(from R.E.Lope's
' Space Impakto demo) but maybe not the most suitable for this type
' of collision(walking character to walking character collision). 
' Nevertheless, I've implemented it in the engine since this engine 
' can be used to create a shooting game like Chaos Engine(bullet
' collision!) so you won't need to look for collision detection
' module somewhere else.

' This checks for collision between the player and the current NPC and
' if collision is TRUE the old positions of the player and the NPC
' are restored(positions before the last move).

END SUB

SUB Engine.DrawMap 
' This sub draws our map on the screen. Can and should be used
' to implement other possible layers which are pasted over it.

' We need to MOD our Cam variables with TileW and TileH to get 
' the correct offset inside the tile.
' Note how the constants are used.
'==========BaseLayer====================
' Calculate the first tile to draw
Level.TileX = Level.CamX \ TileW        
Level.TileY = Level.CamY \ TileH
                               
' Get the offset inside the tile
Level.Xpos = Level.CamX MOD TileW          
Level.Ypos = Level.CamY MOD TileH           

' Formula for X(the loop below).
' (X * TileW) = video screen coordinate(0 to 320 Step 20).
' (X * TileW) - Level.Xpos = tile offset that we have to show from 
' 0 to 20 - Level.Xpos
' Assuming Level.Xpos = 4
' So if X * TileW = 0 then (X * TileW)- Level.Xpos = -4
' We start Drawing from X = -4 to X = -4 + TileW
' ie(for tile size 20*20), we draw our first tile from X = -4 to 
' X = 16 then the next tile from X = 17 to X = 17 + 20

lockers=0
doors = 0
' Loop through our visible screen and draw tiles on it.
FOR XT = 0 TO ScrnTileXmax          '16 tiles(320/20)
FOR YT = 0 TO ScrnTileYmax          '11 tiles(200/20)

' We flag which tile to draw. Note how the Map array is used.
tilep = Map(XT + Level.TileX, YT + Level.TileY).BaseL

' Explained with the comments above and in Engine.DrawPlayer sub.
IF tilep> 0 and tilep<157 then PUT ((XT * TileW) - Level.Xpos, (YT * TileH) - Level.Ypos), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[tilep-1+1]], PSET
IF tilep>170 then PUT ((XT * TileW) - Level.Xpos, (YT * TileH) - Level.Ypos), @Tiles2.s_image.p_data[Tiles2.s_image.p_dataindex[tilep-1-170+1]], PSET

NEXT YT
NEXT XT

MapXPos = 480-((MapXmax/2)*2)
MapYPos = 110-((MapYmax/2)*2)
subtractcol = 0
if mapblink < 25 then subtractcol = 1
for X = 0 to MapXmax          
for Y = 0 to MapYmax   
IF Map( X, Y).BaseL=156 then lockers=lockers+1
IF Map(X,Y).BaseL= 296 OR Map(X,Y).BaseL= 311 THEN doors = doors + 1
if Map(X, Y).BaseL<56 then coll=77-subtractcol
if Map(X, Y).BaseL>55 then coll=74-subtractcol
if Map(X, Y).BaseL>170 then coll=72-subtractcol
if Map(X, Y).BaseL=67 then coll=125-subtractcol
if Map(X, Y).BaseL=306 OR Map(X, Y).BaseL=321 then coll=154-subtractcol
if Map(X, Y).BaseL=16 OR Map(X, Y).BaseL=11 OR Map(X, Y).BaseL=21 then coll=28-subtractcol

'IF Map( X, Y).BaseL>65 then coll=74-subtractcol
if X = Player.TileX and Y= Player.TileY then coll=46-subtractcol*3
'IF Map( X, Y).FogStat=1 THEN LINE (500+2*X,100+2*Y)-(502+2*X,102+2*Y),coll, BF
'IF Map( X, Y).FogStat=0 THEN LINE (500+2*X,100+2*Y)-(502+2*X,102+2*Y),0, BF

line (MapXPos+2*X,MapYPos+10+2*Y)-(MapXPos+2+2*X,MapYPos+12+2*Y),coll, BF
'line (MapXPos+2*X,MapYPos+10+2*Y)-(MapXPos+2+2*X,MapYPos+12+2*Y),0, BF

next Y
next X

line (MapXPos+2*MapXmax,MapYPos+15+2*MapYmax)-(MapxPos+2*(MapXmax+1),MapYPos+10),0, BF
line (MapXPos+2*0,MapYPos+15+2*MapYmax)-(MapXPos+2*(MapXmax+1),MapYPos+10+2*MapYmax),0, BF


'LINE (320,0)-(340,340),1,BF
'LINE (0,320)-(340,340),1,BF
'LINE (0,0)-(20,340),1,BF
'LINE (0,0)-(340,20),1,BF

' ==========FringeLayer====================
' Not implemented!
' ==========ObjectLayer====================
' Not implemented!

END SUB


SUB Engine.DrawNPC
'This is the main sub where we move our NPCs


FOR countNPC = 1 TO 4   ' Loop through 4 NPC. You can change this
                        ' to any number of NPCs you want on one
                        ' map but be sure to declare it above
                        ' first.
                         
NPC(countNPC).TileX = NPC(countNPC).X / TileW
NPC(countNPC).TileY = NPC(countNPC).Y / TileH

Framem = 1
IF NPC(countNPC).Move = TRUE THEN Framem = Frame
' If the NPC is moving then animate the movement with Frame
' variable(Frame variable loops from 1 to 2).

' According to NPC direction flag the proper sprite to be
' displayed.
SELECT CASE NPC(countNPC).Direction
CASE 1
NPC(countNPC).Frame = 14 + Framem  
CASE 2                               
NPC(countNPC).Frame = 10 + Framem     
CASE 3
NPC(countNPC).Frame = 12 + Framem
CASE 4
NPC(countNPC).Frame = 8 + Framem
END SELECT

AINPC countNPC  ' AI for NPCs. We use AI on the current NPC in the 
                ' loop. Note how the AINPC sub is declared and how 
                ' countNPC value is passed into the AINPC sub!
                ' This sub also moves the NPCs.

' The collision is REMed here because I initiate collision in 
' Engine.DrawScreen sub after the work page is 
' cleared(better method).
' Engine.DoCollision countNPC ' We check for collision(NPC to
                             ' other NPC collision or player
                             ' to NPC collison).

' If NPC exists(not dead or similar) draw it.
IF NPC(countNPC).Exists = TRUE THEN
'PUT ((NPC(countNPC).X - Level.CamX), (NPC(countNPC).Y - Level.CamY)), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[NPC(countNPC).Frame-1]], TRANS
END IF

NEXT countNPC

END SUB


SUB Engine.DrawPlayer (Player AS SpriteType)
' This sub uses direction constant defined at module level(DN,DR...)
' to flag the right sprite to be displayed.

IF Player.Move THEN                     'Flag if player has moved.

' According to player's direction this flags the proper sprite(Frame 
' variable is used to create animation and it loops from 1 to 2).
        SELECT CASE Player.Direction
                CASE DR
                        Player.Frame = Frame + 6      
                CASE DU
                        Player.Frame = Frame + 2
                CASE DL
                        Player.Frame = Frame + 4       
                CASE DD
                        Player.Frame = Frame           
                CASE ELSE
        END SELECT

        Player.Move = FALSE   ' Stops the player from waving
                              ' his arms while he is not moving.
END IF

' Formula:
' Player.X - Level.CamX :
' puts the player at the center of the screen.
' So if Player.X = 500 then Level.CamX = Player.X - ScrnYmid(ScrnYmid = 320/2 = 160)
' Level.CamX: 500 - 160 = 340
' Player.X = 500
' Xcenter:500 - 340 = 160(ScrnXmid)
' Same goes for Y.
' See Engine.UpdateCamera for more Details :)
' Sprite(SpriteIndex(Sprite.Frame) is the current frame of 
' the Sprite(calculated above).

IF Player.Frame <> 0 THEN    ' Just to be sure to prevent errors. 
                             ' Player.Frame can be 0 but since in
                             ' the PUT statement we paste 
                             ' Player.Frame - 1 sprite we have to
                             ' use this. R.E.Lope's sprite loading
                             ' routine counts the sprites from 0
                             ' while PP256 from 1. That's why in
                             ' all the PUT statements you'll see
                             ' "- 1" after the number of sprite.

' A classic PUT statement with a bit quirky way of pointing to the
' memory address where the sprite is saved(with a pointer). Explore 
' that method by looking into pp256_image.bi if really interested. 
' Otherwise, just use it like it's used in this engine.                             
Player.Frame = 1
PUT ((Player.X - Level.CamX), (Player.Y - Level.CamY)), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[Player.Frame-1]], TRANS

LINE (300,35)-(400,70),46,BF
IF placetile> 0 and placetile<157 then PUT ((340), (40)), @tiles.s_image.p_data[tiles.s_image.p_dataindex[placetile-1+1]], PSET
IF placetile>170 then PUT ((340), (40)), @tiles2.s_image.p_data[tiles2.s_image.p_dataindex[placetile-1-170+1]], PSET
           

END IF
            
END SUB


SUB Engine.DrawScreen
' This sub draws our stuff on the screen and controls the page
' flipping.

RANDOMIZE TIMER

FPS = FPS + 1                     ' Used to count FPS.
IF StartTime& + 1 < TIMER THEN
 FPS2 = FPS
 FPS = 0
 seconds = seconds - 1
 StartTime& = TIMER
END IF

' Frame variables are used to time all kind of animations in our
' game like walking. Play with these variables to change the
' speed of walk animation.
Frame3 = (Frame3 MOD 8) + 1 
IF Frame3 = 1 THEN Frame = (Frame MOD 2) + 1     
IF Frame = 0 THEN Frame = 1
Frame2 = (Frame2 MOD 2) + 1  


' Hide our work page and draw stuff on it.
SCREENSET 1, 0

' We clear our work page(LINE statement) and draw our player
' and NPCs sprites on it(sprites on the clear background - 
' better collision detection).
CLS


Engine.DrawMap            ' Draw our map tiles on the screen.
Engine.DrawPlayer Player  ' Draw our player on the scren.
'Engine.DrawNPC

' Print some variables on the screen with our custom font routine.
GraphicText 4,360, "FPS:" + STR$(FPS2), Font
GraphicText 4,370, "Player.TileX:" + STR$(Player.TileX), Font
GraphicText 4,380, "Player.TileY:" + STR$(Player.TileY), Font
GraphicText 4,390, "Current tile:" + STR$(placetile), Font
GraphicText 4,400, "Number of lockers:" + STR$(lockers), Font
GraphicText 4,410, "Number of doors:" + STR$(doors), Font
' Code needed only for this example to display some text when
' the player comes near the sign.
'IF Player.TileX>23 and Player.TileX<27 and Player.TileY>20 and Player.TileY<25 then
'GraphicText CENTRETEXT,150, "Welcome To Free Basicville", Font
'END IF

'SCREENSYNC  ' Wait for vertical sync.
SCREENCOPY      ' Copy our work page on the screen.
SCREENSYNC   ' Wait for vertical sync.
SLEEP 2

' If I use vertical blank syncing before SCREENCOPY I get
' a notable amount of trembling. Please test it yourself
' a let me know if you get any trembling.

END SUB

FUNCTION Engine.TileCollide (Character AS SpriteType) STATIC
' Crappy tile*tile collision detection ;)
' Returns TRUE if collision is detected, FALSE if not.
' Pixel perfect collision with map tiles is not an option since
' tiles don't feature TRANSPARENT color. You can use another layer
' for trees and similar static objects and then apply pixel by
' pixel collision on that layer.
EXIT SUB
' Init the function to be FALSE(no collision).
Engine.TileCollide = FALSE

' 4 checks are done to be sure ;)
' This checks all the corners of the character for tile collision.
' + 10 in Character.Y for up-left and up-right corner is used to
' create an illusion of "foot" collision.
' Up-Left corner of Character
X = Character.X + 1       
Y = Character.Y + 10
GOSUB CheckForTile      ' Checks for collision.

' Up-Right corner of the character.
X = Character.X + 19
Y = Character.Y + 10
GOSUB CheckForTile

' Down-Right corner of the character.
X = Character.X + 19
Y = Character.Y + 19
GOSUB CheckForTile

' Down-Left corner of the character.
X = Character.X + 1
Y = Character.Y + 19
GOSUB CheckForTile

EXIT FUNCTION

' Checks for collision:(Bounding BoxType)
CheckForTile:
TX = X \ TileW          ' Character.X\TileW=Character.TileX
TY = Y \ TileH          ' Character.Y\TileH=Character.TileY

' In this example, all tiles above 5 are colliding.
IF Map(TX, TY).BaseL > 5 THEN
   Engine.TileCollide = TRUE
   Character.Move = FALSE
END IF

RETURN          ' Check for the next coordinate.

END FUNCTION


SUB Engine.UpdateCamera (Level AS LevelType, Player AS SpriteType) 

' Updates CAMX, CAMY in relation to Player.X, Player.Y to achieve
' ZELDA style scrolling engine.
' Sample Code:
' CODE: CASE DR
        ' Right Direction of movement.
' CODE: Level.CamX = Player.X - ScrnXmid
        ' Centers our player and moves the camera to where
        ' the player is going.
        ' ie, Assume: Player.X=1200, ScrnMid=Constant 160(middle of the screen)
        ' Level.CamX: 1200-160=1040
        ' To get the TileX:
        ' TileX=Level.CamX\TileW=1040\20=52(This will be used with 
        ' Engine.DrawMap).
' CODE: IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
        ' Checks if Level.CamX<0, zero it if its negative to prevent 
        ' errors. ScrnYmin=0(constant).
' CODE: IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        ' Checks if Level.CamX > (Level.Xmax * TileW) - ScrnXmax
        ' ScrnXmax = Maximum number of PIXELS our map has.
        ' Level.Xmax = Maximum number of tiles our map has.
        ' TileW = Width of our tile(constant).
        ' ScrnXmax = 320(constant).
        ' To calculate: Level.Xmax = MapXmax
        ' Formula:(Level.Xmax * TileW) - ScrnXmax
        ' Level.Xmax = 36  ->> this is an example.
        ' (36*20)-320 = 400
        ' Level.CamX =4 00
        ' To calculate TileX:
        ' Level.CamX\TileW
        ' 400\20 = 20
        ' TileX = 20(Start Drawing from 20 to 36) in Engine.DrawMap sub.
        ' 16 is the first tile to draw in X direction.
        ' 36-20 = 16(See, we have to draw 20 tiles horizontally!!!)
        ' Same goes for Y.
        ' See Engine.DrawMap SUB for more details. ;)

SELECT CASE Player.Direction
        CASE DR
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DU
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE DL
                Level.CamX = Player.X - ScrnXmid
                IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
                IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        CASE DD
                Level.CamY = Player.Y - ScrnYmid
                IF Level.CamY < ScrnYmin THEN Level.CamY = ScrnYmin
                IF Level.CamY > (Level.Ymax * TileH) - ScrnYmax THEN Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        CASE ELSE
END SELECT

END SUB

SUB Engine.UpdatePlayer (Player AS SpriteType, Direction) 
' Updates the player's position according to player's direction.
' ZELDA style pixel by pixel free movement.
' Sample Code:
' CODE: CASE DR
      ' Direction of player's movement.
' CODE: Player.X = Player.X + Player.XV
      ' Adds Xspeed to Player's X position since we are moving right.
' CODE: IF Engine.TileCollide(Player) THEN Player.X = Player.X - Player.XV
        ' Check for collision. If collided with valid "collidable" tile
        ' subtract Xspeed to return the player to it's original place.
        ' Also prevents player sticking to tiles when changing direction.
' CODE: IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        ' Checks if player is outside the map boudaries.
        ' Subtracting TileW is necessary to prevent errors if your
        ' speed is greater than 1. Also used for padding.

SELECT CASE Direction
        CASE DR
                Player.X = Player.X + Player.XV
                
                ' Flag that player is moving. This flags animation of the player
                ' (REM this for no animation). We need to flag this before 
                ' checking for tile collision since in tile collision sub movement
                ' is flagged as FALSE upon collision with a tile.
                Player.Move = TRUE
                IF Engine.TileCollide(Player) THEN Player.X = Player.X - Player.XV
                IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        CASE DU
                Player.Y = Player.Y - Player.YV
                Player.Move = TRUE
                IF Engine.TileCollide(Player) THEN Player.Y = Player.Y + Player.YV
                IF Player.Y < ScrnYmin THEN Player.Y = ScrnYmin
        CASE DL
                Player.X = Player.X - Player.XV
                Player.Move = TRUE
                IF Engine.TileCollide(Player) THEN Player.X = Player.X + Player.XV
                IF Player.X < ScrnXmin THEN Player.X = ScrnXmin
        CASE DD
                Player.Y = Player.Y + Player.YV
                Player.Move = TRUE
                IF Engine.TileCollide(Player) THEN Player.Y = Player.Y - Player.YV
                IF Player.Y > (Level.Ymax * TileH) - TileH THEN Player.Y = (Level.Ymax * TileH) - TileH
        CASE ELSE
END SELECT

' Calculates on what tile the player is.
' Adds (TileW/2) or (TileH/2) to X and Y to get center of the player. 
Player.TileX = (Player.X + (TileW/2)) \ TileW  
Player.TileY = (Player.Y + (TileH/2)) \ TileH

END SUB


SUB InitMap (mapcon$)
' This sub loads our map on the screen and you can use a different
' type of map loader. Map loading is not glued to the very scrolling 
' engine. This map loader first loads the map x size and map y size(in 
' number of tiles) and then the very tiles.
' You should leave(create) one line of unused tiles horizontally and
' vertically in your MAP file to avoid errors.

lockers = 0
doors = 0
OPEN pathf$ + mapcon$ FOR INPUT AS #2
INPUT #2, MapXMax
INPUT #2, MapYMax
FOR Y = 0 TO MapYMax
FOR X = 0 TO MapXMax
INPUT #2, Map(X, Y).BaseL  ' Map is loaded from a file(note INPUT #2
IF Map(X,Y).BaseL= 156 THEN lockers=lockers+1
IF Map(X,Y).BaseL= 296 OR Map(X,Y).BaseL= 311 THEN doors = doors + 1
NEXT X                     ' statement) and written in the map array.
NEXT Y

END SUB


SUB InitVariables 

' Player's starting variables.
' You can ignore most of the variable since they don't
' relate to the very scrolling engine but to a possible
' game made in it.

Player.Typ = 1           ' ID?????????
Player.X = 5 * TileW    ' Change this to where you want for player to
Player.Y = 5 * TileH    ' start(be sure not to go over the map dimensions).
Player.XV = 20            ' Player's XSpeed Change this for faster movement
Player.YV = 20            ' Player's Yspeed
Player.Frame = 1         ' We start at frame 1(looking-at-screen-sprite) :)
Player.Move = FALSE      ' Static(no movement) :)
Player.RANGE = 0         ' Ignore.
Player.Active = TRUE     ' Ignore.
Player.HIT = FALSE       ' Ignore.
Player.AI = 1            ' Ignore.
Player.MONEY = 9999      ' Ignore.
Player.HP = 9999         ' Ignore.
Player.ITEM = 1          ' Ignore.
Player.Direction = DU    ' Starting direction(down).
Player.OldX = Player.X
Player.OldY = Player.Y

RANDOMIZE TIMER 
FOR countNPC = 1 TO 40   ' We loop through of our all 40 NPCs.

NPC(countNPC).XV = 1     ' X and Y speeds of our NPCs.
NPC(countNPC).YV = 1

            
XRND = INT(RND * 5) + 23   ' We randomize the positions of our NPCs.
YRND = INT(RND * 5) + 25   
NPC(countNPC).Direction = INT(RND * 4) + 1 

NPC(countNPC).X = XRND * TileW   ' We multiply XRND or YRND with 20 to
NPC(countNPC).Y = YRND * TileH   ' put a NPC on XRND and YRND tile!
NPC(countNPC).Exists = TRUE      ' May be used with killable NPCs
                                 ' to flag if you want to display it
                                 ' or check collision with it if
                                 ' a specific NPC is dead/gone.

NPC(countNPC).OldX = NPC(countNPC).X
NPC(countNPC).OldY = NPC(countNPC).Y
NPC(countNPC).Frame = 1

NEXT countNPC     
         
Level.Xmax = MapXMax    ' Flags our level(play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU              ' Two directions so that engine will
Engine.UpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR              ' positions from left to right
Engine.UpdateCamera Level, Player  ' No warping ;)
                                   ' In other words, inital camera
                                   ' setting.
                                   
END SUB


SUB Main
' Our main loop. Checks which key the player has pressed and moves
' the player according to that.
' It also initiates Engine.DrawScreen sub which draws all our
' stuff on the screen.
' Storing old player's position is used with player to NPC
' collision in order to restore player's old position when he
' bumps with a NPC. Note how with moving up and down only the old
' Y position is stored and how with moving right and left only
' the X position is stored. Try to UNREM the lines I REMed
' and you'll see a bad thing happen.

DO
    
IF MULTIKEY(SC_1) THEN placetile=placetile-5
IF placetile <1 then placetile = 1
IF MULTIKEY(SC_2) THEN placetile=placetile+5 

IF MULTIKEY(SC_8) THEN placetile=1
IF MULTIKEY(SC_9) THEN placetile=31
IF MULTIKEY(SC_0) THEN placetile=106
IF MULTIKEY(SC_7) THEN placetile=156
IF MULTIKEY(SC_6) THEN placetile=256

WHILE MULTIKEY(SC_1) or  MULTIKEY(SC_2)
WEND 

IF MULTIKEY(SC_S) THEN
OPEN "Data\level"+STR$(location)+".map" FOR OUTPUT AS #2
PRINT #2, MapXMax
PRINT #2, MapYMax
FOR Y = 0 TO MapYMax
FOR X = 0 TO MapXMax
'IF Map(X, Y).BaseL = 1 THEN Map(X, Y).BaseL = 11
PRINT #2, RTRIM$(STR$(Map(X, Y).BaseL))+","
NEXT X                    
NEXT Y
CLOSE #2
END IF

IF MULTIKEY(SC_ENTER) THEN Map(Player.TileX, Player.Tiley).BaseL = placetile

        IF MULTIKEY(&h48) OR MULTIKEY(SC_U) THEN  ' Pressed up
            Player.Direction = DU  ' Direction=up(DU tag)
            'Player.OldX = Player.X    ' Store our old variables
            Player.OldY = Player.Y     ' (used with collision routines)
            Engine.UpdatePlayer Player, DU    ' Update player position
            Engine.UpdateCamera Level, Player ' Update camera position
            WHILE MULTIKEY(&h48)
                WEND
        END IF

        IF MULTIKEY(&h50) OR MULTIKEY(SC_J) THEN  ' Pressed Down
                        Player.Direction = DD
                        'Player.OldX = Player.X
                        Player.OldY = Player.Y
                        Engine.UpdatePlayer Player, DD
                        Engine.UpdateCamera Level, Player
                        WHILE MULTIKEY(&h50)
                WEND
        END IF
        IF MULTIKEY(&h4D) OR MULTIKEY(SC_K) THEN ' Pressed Right
                        Player.Direction = DR
                        Player.OldX = Player.X
                        'Player.OldY = Player.Y
                        Engine.UpdatePlayer Player, DR
                        Engine.UpdateCamera Level, Player
                        WHILE MULTIKEY(&h4D)
                WEND
        END IF
        IF MULTIKEY(&h4B) OR MULTIKEY(SC_H) THEN  ' Pressed Left
                        Player.Direction = DL
                        Player.OldX = Player.X
                        'Player.OldY = Player.Y
                        Engine.UpdatePlayer Player, DL
                        Engine.UpdateCamera Level, Player
                        WHILE MULTIKEY(&h4B)
                WEND
        END IF

Engine.DrawScreen           ' Draw our stuff on the screen
LOOP UNTIL MULTIKEY(&h01)   ' Loop until player presses ESC



END SUB

SUB tile_load_image ( tile as tileType )
' Sub used to load PUT files(relates to pp256_image.bi module).
' Don't break your head over it unless you are interested in
' modifying the way your program relates to pp256_image.bi
' module or the very module.
	
   tile.s_image.init = @image_init
   tile.s_image.init ( tile.s_image )
   tile.s_image.Load ( tile.s_image )
   tile.s_image.Index ( tile.s_image )
	
END SUB

SUB MainScreen
   CLS
   
DO
   GraphicText 90,25, "Space Rogue Project Map Maker", Font
   GraphicText 90,45, "1-2 Change tile; ENTER place tile", Font
   GraphicText 90,55, "S - Save map", Font
   GraphicText 90,65, "7, 8, 9, 0 - Some useful tile jumps", Font
   
   
   SCREENCOPY
   SLEEP 2
LOOP UNTIL INKEY$<>""

END SUB


SUB GraphicText (xx, yy, Textt$, tile as tileType)
'* GraphicText() subroutine:
'* Displays a text string at a graphics screen coordinate, using a bitmapped
'* character set.
'*
'* Parameters:
'*           xx - Horizontal coordinate of where printing should start or:
'*                Use CENTRETEXT to have the text centred.
'*           yy - Vertical coordinate of where printing should start.        
'*        Textt$ - The text string to be displayed.
'*        tile - Image array holding the character set to be used. Each
'*               character must in the standard ASCII order, starting with
'*               the space character(in the PUT file).
   
    MessLen = LEN(Textt$)
    IF xx = CENTRETEXT THEN
        ' Find start X coordinate for a centred text.
        w = 0
        FOR nn = 1 TO MessLen
            CharNo = ASC(MID$(Textt$, nn, 1)) - 31
            w = w + GetWidth (CharNo, tile)
        NEXT nn
        xx = (320 - w) \ 2
 
    END IF

    ' Get character's sprite depth.
    CharDepth = GetDepth(1,tile)

    ' Loop to display each character of Text$.
    FOR n = 1 TO MessLen
        CharNo = ASC(MID$(Textt$, n, 1)) - 32
        CharWidth = GetWidth(CharNo, tile)
    ' Put the character on the screen.
        PUT (xx, yy), @Tile.s_image.p_data[Tile.s_image.p_dataindex[CharNo]], TRANS

        xx = xx + CharWidth
    NEXT n


END SUB


FUNCTION GetDepth (ImNo,tilem as tileType)
' Function used to acquire depth of a character sprite
' (due the R.E.Lope's method used to store and display sprites
' on the screen I have to use this lame way to get the sprite
' depth). This code is pending for correction.
' Only one error can appear with this sub; if you use the last
' character from your font set. So just create one image behind your
' last character in the font set in PP256 of any size(ie, 1*1).
    GetDepth = @Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo+1]]-@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo]]

END FUNCTION

FUNCTION GetWidth (ImNo,tilem as tileType)
' Function used to acquire width of a character sprite
' (due the R.E.Lope's method used to store and display sprites
' on the screen I have to use this lame way to get the sprite
' depth). This code is pending for correction.
' Only one error can appear with this sub; if you use the last
' character from your font set. So just create one image behind your
' last character in the font set in PP256 of any size(ie, 1*1).

    GetWidth = (@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo+1]]-@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo]])/4

END FUNCTION


