'  !!!!  THIS DOESN'T WORK YET.  Further, we aren't trying to fix it at the
'                                  moment, and we won't unless we think
'                                  there's significant demand for it.
'
'    
'    
'                                                             
'             QTetris:  A QBasic Tetris Implementation        
'             QTDual:  A Two-Player Version of QTetris        
'                                                             
'    
'                                                             
'            Copyright (C) 1998 by Belly Laugh Software.      
'                                                             
'    
'                                                             
'                        Version 1.00 Beta                    
'                                                             
'    
'    


'  The pieces are held in one array; the playing field is held in
'    another.  Individual variables determine the current piece
'    and its position (and "rotation") for each player.

'  A third array holds the color pallette.  Version 1 will only support
'    one color pallette (in one screen mode -- 80x24), but it will
'    be designed so that the addition of other modes will be SMOP.

'  Variable List:  (Constants will be considered variables for our purposes.)
'    ARRAYS:
'         S%(x,y)        Holds the color attribute of the screen at
'                          position x, y (within the playing field).
'                          0 indicates background; any other number
'                          indicates a piece of some kind or a border.
'                          Note that the current (unfrozen) pieces
'                          (one for each player) are not included here.
'                        The maximum playing field dimensions are
'                          40 x 20 for single-player mode.  For this
'                            version, however, the maximum will be 15x20
'                            for each player.  The long dimension is the
'                            direction of fall -- the "height" for the
'                            vertical player and the "length" for the
'                            horizontal player.  The short dimension is
'                            the "width" for both players.
'                          The maximum piece size is five by five, so
'                             the maximum that any non-empty piece can
'                             extend beyond the playing area is four,
'                             so five is the necessary buffer.  Apply it
'                             to the right and bottom of the 20x20 grid,
'                             and we now have a 25x25 maximum grid for
'                             the screen.
'         P%(i,r,x,y)    Holds the color attribute of piece i at
'                          relative position (x,y) and rotation r.
'                          0 indicates background -- i.e. this spot
'                          can overlap; any other color is solid.
'         PP%(i,r)       Holds the placement points scored by placing
'                          piece i at rotation r in the single-player
'                          game.  Placement points are not earned in
'                          this version of the game because a difficult
'                          placement for one player is simple for the
'                          other, and vice-versa.  Thus, all placements
'                          are essentially equal, more or less.
'         PN$(i)         Holds the Piece Name of piece i.
'         DP%(n,l)       Holds the number of points scored by dropping
'                          any piece n lines on level l.  This works
'                          the same in this version as in the single-
'                          player game, except that the horizontal
'                          player "drops" pieces to the right, not down.
'         Prob%(i,l)     Holds an integer directly related to the
'                          probability that piece i will be the piece
'                          selected at any given point on level l in a
'                          future version of the game.  Included in the
'                          piece-set format as a "hook" for a future
'                          improvement.  Not yet implemented.
'         C%(i)          Holds the actual color (in the case of single-
'                          palette screen modes, e.g. MDA, CGA; in
'                          the case of VGA modes this would be the
'                          "attribute") used on the screen when the
'                          above arrays indicate color i.
'         CN$(i)         Holds the NAME of the color.  Only important
'                          for piece editor, so not even declared in QTET.Q.
'         C$(i)          In the case of text mode only, holds the
'                          character displayed (in the color C$(i))
'                          when P% or S% indicates color i.
'                          This will usually be set to one of the
'                          following:  , , , or .  Other
'                          characters are, however, allowed.
'    VALUES:
'         PSetSpec$      File Specification for piece set (8 chars).
'         BorderC%       The number of the color for the borders.
'         PW%            The width of the panel, used to offset
'                             playing field display.  Constant.
'         NumOfPieces%   Number of pieces in the current set.
'         CM%            Holds the current Color Mode.
'                        Single-digit modes are text-based and map
'                         to screen mode 0.  Higher modes are graphics.
'                        0    Text mode, 80x24.
'                        1    Text mode.  Really 80x24; Used as 40x24
'                                         via  versus  for a square look.
'         NumOfColors%   The number of colors in the current scheme.

'         HORIZONTAL PLAYER ONLY:
'         HP%            Holds the number of the current piece.
'         HR%            Holds the current rotation.
'         HX%            Holds the current horizontal location of the piece.
'         HY%            Holds the current vertical location of the piece.
'         IR%            Holds a proposed rotation.
'         IX%            Holds a proposed horizontal location.
'         IY%            Holds a proposed vertical location.
'         VERTICAL PLAYER ONLY:
'         VP%            Holds the number of the current piece.
'         VR%            Holds the current rotation.
'         VX%            Holds the current horizontal location of the piece.
'         VY%            Holds the current vertical location of the piece.
'         WR%            Holds a proposed rotation.
'         WX%            Holds a proposed horizontal location.
'         WY%            Holds a proposed vertical location.
'         BOTH COMBINED:
'         NP%            Next Piece.  Whichever player "freezes" his piece
'                             first will get this piece to replace it.
'         level%         Holds the current level.
'         lines%         Holds the number of lines thus far completed
'                             plus the number of columns thus far completed.
'         LevP%          Holds the number of points scored for advancing a
'                             level.
'         LevC%          Holds the Level Criterion:  How many pieces placed?
'         LevCM%         Holds the Level Criterion Met:  How many pieces
'                             have been placed since level change?
'         LP%            Holds the number of points scored for each completed
'                             line or column.
'         drops%         Holds the number of drops that have been executed
'                             either vertically or horizontally.  It is
'                             realized that "drop" is a strange word for the
'                             horizontal player, but it is used out of
'                             convention and by analogy.
'         dropl%         Holds the total length of all the drops that have
'                             been executed.
'         dropP%         Holds the total points scored in drops thus far.
'         placed%        Holds the number of pieces placed so far in the game.
'         pPoints%       Holds the number of points scored thus far by placing
'                             point-carrying pieces in the single-player game.
'                        NOT USED IN THIS VERSION.
'         score%         Composite score, formed from the above.
'                        Formula:  score% = LevP%*level% + LP%*lines% + dropP%
'         FMX%           Holds the horizontal size of the playing field for
'                             the vertical player and the vertical size for
'                             the horizontal player.
'         FMY%           Holds the vertical size of the playing field for the
'                             vertical player and the horizontal size for the
'                             horizontal player.
'         PMX%           Holds the horizontal size of the pieces.
'         PMY%           Holds the vertical size of the pieces.
'         NumOfLevels%   Holds the number of levels of play for which there
'                             are new piece probablilities.
'         DV!            Stands for Delay Value.  A piece is moved down when
'                        the value of Timer changes by at least this much.
'         InitDV!        This comes with the piece set and is the starting
'                             value for DV!.
'         Accel!         This comes with the piece set and should be a
'                             little less than one.  DV! is multiplied by
'                             it (less a random adjustment) each time
'                             a level is attained.
'         RAccel!        This comes with the piece set and is related to
'                             the above random adjustment.
'
'    Other variables Used:  Count%, Go$, Temp$, Temp!, Temp%, Temp2%
'
'          These are used only at the local level.  Thus, it is safe
'              for any routine to use them for its own purposes
'              without restoring them, as long as it does not need
'              to keep info in them while calling another routine.
'
'    FLAGS:
'
'         Continue%      True% until CheckInsertHeight turns it
'                             off when the next piece will not fit
'                             on the board.  At this point the game
'                             is over.
'         Frozen%        False% until FreezePiece turns it on,
'                             at which point it is time to move on
'                             to the next piece.  FreezePiece sets
'                             Frozen% to the player needing a new
'                             piece.
'         Okay%          Boolean return value used by certain subs.
'                        TestVert and TestHoriz return True% if the move is
'                             kosher or False% if it is unnacceptable.
'                        VertDrop (or HorizDrop) checks it to see what
'                             VertDown (for vert.  player) or HorizRight
'                             (horiz. player) received as an answer.  This
'                             is one of the benefits of using global
'                             variables.
'                        CheckForLines uses Okay% internally.
'                        CheckForColumns uses Okay% internally.
'
'    DECLARATIONS:

Option Base 1

False% = 0: True% = NOT(False%)

PW% = 16 ' Actually the panel is 15 wide, but this also includes
         '  the border.

'  To determine the number of pieces (for dimensioning), we need
'    the name of the piece set.  While we're at it, let's pick up
'    some other info we need for dimensioning:
'
Open "QTet.CFG" for input as #1
     Line input #1, PSetSpec$
     input #1, CM%  '    ColorMode
     Line input #1, Temp$  '  Color Scheme File Spec
  close #1

Go$ = PSetSpec$ + ".SET"
Open Go$ for input as #1
     input #1, NumOfPieces%
     input #1, NumOfRotations%
     input #1, PMX% ' Piece Max X
     input #1, PMY% ' Piece Max Y
     input #1, FMX% ' Field Max X
     input #1, FMY% ' Field Max Y
     input #1, NumOfLevels%   '  The number of levels that MATTER for piece
                              '    selection.  There are, of course,
                              '    infinitely many levels  (in theory).
     input #1, InitDV!  ' \
     input #1, Accel!   '  >  These affect the speed of falling pieces.
     input #1, RAccel!  ' /
  close #1

Open Temp$ for input as #1
     input #1, NumOfColors%
  close #1

if (FMX% > FMY%) then Temp% = FMY%: FMY% = FMX%: FMX% = Temp%
if (FMX% > 15) then FMX% = 15
if (FMY% < FMX% + 5) then FMY% = FMX% + 5
if (FMY% > 20) then FMY% = 20

'    Now we can dimension our arrays:

DIM S%(FMY%+5,FMY%+5)
DIM P%(NumOfPieces%,NumOfRotations%,PMX%,PMY%)
'  Dim PP%(NumOfPieces%,NumOfRotations%)


Dim DP%(FMY%,NumOfLevels%)

Dim Prob%(NumOfPieces%,NumOfLevels%)

'  Now the color-related arrays:

Dim C%(NumOfColors%)
Dim CN$(NumOfColors%)
if (CM% < 10) then DIM C$(NumOfColors%)

'    READ IN ALL THE REMAINING STUFF FROM THE FILES

Go$ = PSetSpec$ + ".SET"
Open Go$ for input as #1
     input #1, NumOfPieces%    '\
     input #1, NumOfRotations% ' \
     input #1, PMX%            '  \
     input #1, PMY%            '   \
     input #1, dummy% '   FMX% '    \  These have already been read once, but
     input #1, dummy% '   FMY% '    /    we must read past them anyway.
     input #1, NumOfLevels%    '   /
     input #1, InitDV!         '  /
     DV! = InitDV!
     input #1, Accel!          ' /
     input #1, RAccel!         '/

     For CP% = 1 to NumOfPieces%
          Line Input #1, PN$(CP%)
          for CR% = 1 to NumOfRotations%
               for CX% = 1 to PMX%
                    for CY% = 1 to PMY%
                         Input #1, P%(CP%,CR%,CX%,CY%)
                      next CY%
                 next CX%
               Input #1, dummy%    ' Not relevant in this version.
               'Input #1, PP%(CP%,CR%)
            next CR%
          CR% = 1: VR% = 1: HR% = 1
          for level% = 1 to NumOfLevels%
               Input #1, Prob%(CP%,level%)
            next level%
       next CP%
     CP% = 1: VP% = 1: HP% = 1

     For level% = 1 to NumOfLevels%
          for lines% = 1 to FMY%
               Input #1, DP%(lines%,level%)
            next lines%
       next level%

     input #1, LevC%     ' How many pieces must be placed to advance a level?
     input #1, LevP%     ' How many points are scored for advancing a level?
     input #1, LP%       ' How many points are scored for completing a line?

  close #1

Open "QTet.CFG" for input as #1
     Line input #1, Go$  '  Already read piece file spec, but read past.
     input #1, CM%  '  Already read, but we must read past anyhow.
     Line input #1, Go$  '  Color Scheme File Spec.  Read once, but need again.
  close #1

Open Go$ for input as #1 ' Color Scheme File
     input #1, NumOfColors%   ' Already read, but read past.
     For Count% = 1 to NumOfColors%
          Line Input #1, CN$(Count%)
          Input #1, C%(Count%)
          if (CM% < 10) then Line Input #1, C$(Count%)
       next Count%
  close #1

Gosub InitMovementKeys
Gosub InitDisplay
Gosub InitScreenArray ' (fill undisplayed borders)
Gosub SelectNextPiece
     HP% = NP%: VP% = NP%

'  Player% Settings:
     V% = 1: H% = -1
     Player% = False%  ' Not acting on any particular player yet.

'  If not (V%) then ? "Houston, we have a problem.": Stop

VX% = FMX%\2: HY% = FMX%\2: VY% = 1: HX% = 1

'         ********************************************************
'         **                                                    **
'         **        M A I N    L O O P                          **
'         **                                                    **
'         ********************************************************

          Continue% = True%
          While (Continue%)
               Gosub NextPiece
               Gosub FallingDelay  '  Add one delay so the user will
                                   '  quit trying to act on the
                                   '  previous piece before the keys
                                   '  come back on for this piece.
               Frozen% = False%
               While (Frozen% = False%)
                    Gosub AllowVert
                    Gosub AllowHoriz
                    Gosub FallingDelay
                    Gosub HoldVert          '  They will be examined next
                    Gosub HoldHoriz         '   time around the loop.
                                            '   (That is, IF we are still
                                            '    on the same piece.)
                    '  Gosub OldAdvance
                    Gosub Advance
                 WEND
               Gosub CheckInsertHeight
            WEND

'         ********************************************************

'         Now, the game is over; clean up.
'
          Gosub GameOverMessage

          Gosub CreateGameScore '  Saves the game's score info in
                                '    a temporary file, which is read
                                '    by the scoreboard program

          run "HIGHDUAL.Q"

'         ********************************************************

          STOP  ' jic

'

'   SUBROUTINES:

Advance:
     'VERTICAL:
          WR% = VR%: WX% = VX%: WY% = VY% + 1
          Gosub HoldHoriz
          Gosub TestVert
          if Not (Okay%) then
              Gosub AllowHoriz
              Gosub DisAllowVert         ' Do NOT hold them to be
                                         '  examined later.   Kill
                                         '  them.  Only use keys
                                         '  pressed after the
                                         '  piece change is complete.
              Gosub FreezeVert
              Gosub CheckForLines
            else
               Gosub UnDisplayVert
               VY% = WY%      ' Carry out the proposal.
                              ' (The piece falls one space.)
               Gosub AllowHoriz
               Gosub DisplayVert
            end if

     'HORIZONTAL:
          IR% = HR%: IX% = HX% + 1: IY% = HY%
          Gosub HoldVert
          Gosub TestHoriz
          if Not (Okay%) then
              Gosub AllowVert
              Gosub DisAllowHoriz        ' Do NOT hold them to be
                                         '  examined later.   Kill
                                         '  them.  Only use keys
                                         '  pressed after the
                                         '  piece change is complete.
              Gosub FreezeHoriz
              Gosub CheckForColumns
            else
               Gosub UnDisplayHoriz
               HX% = IX%      ' Carry out the proposal.
                              ' (The piece "falls" one space to the right.)
               Gosub AllowVert
               Gosub DisplayHoriz
            end if
     Return

'OldAdvance:
'                    PR% = CR%: PX% = CX%: PY% = CY% + 1 ' top left is origin
'                    Gosub TestProposal
'                    if Not (Okay%) then
'                        Gosub DisAllowMovementKeys ' Do NOT hold them to be
'                                                   '  examined later.   Kill
'                                                   '  them.  Only use keys
'                                                   '  pressed after the
'                                                   '  piece change is complete.
'                        Gosub FreezePiece
'                        Gosub CheckForLines
'                      else
'                         Gosub UnDisplayPiece
'                         CY% = PY%      ' Carry out the proposal.
'                                        ' (The piece falls.)
'                         Gosub DisplayPiece
'                      end if
'     Return

NextPiece:
'***********************************
'      CP% = NP%                  ' *
'      color 15,0: locate 2,70: ? CR%: color 7,0
Select Case (Frozen%)            ' *
     Case is = V%                ' *
          VP% = NP%              ' *
          VY% = 1                ' *
     Case is = H%                ' *
          HP% = NP%              ' *
          HX% = 1                ' *
  end select                     ' *
      Gosub SelectNextPiece      ' *
      Gosub UpdateStatsPanel     ' *
      Gosub ReDrawPlayingField   ' *
      Gosub ReDrawBorders        ' *
  Return                         ' *
'***********************************

SelectNextPiece:
'*************************************************
     NP% = rnd(1)*1793 mod NumOfPieces% + 1  '   *
     '  This will, of course, have to change '   *
     '   to reflect the values in Prob%.     '   *
  Return       '                                 *
'*************************************************

FallingDelay:
'**************************************
     Temp! = Timer  '                 *
     dummy$ = Inkey$               '  *
     While (Timer < Temp! + DV!)   '  *
       WEND    '                      *
  Return  '                           *
'**************************************

'   New Key List:
'
'    #    Location       USE
'
'    1    F1             Help
'    2    F2             SaveScreen
'    3    F3             ToggleSound
'    4    F4
'    5    F5
'    6    F6
'    7    F7
'    8    F8
'    9    F9
'   10    F10            ExitQues
'   11    UP             VertRot
'   12    LEFT           VertLeft
'   13    RIGHT          VertRight
'   14    DOWN           VertDown
'   15    INS            VertDrop
'   16    F              HorizDrop
'   17    A              HorizRot
'   18    W              HorizUp
'   19    X              HorizDown
'   20    S              HorizRight
'

AllowVert:
     VertAllow% = True%
     For TK% = 11 to 15
          Key(TK%) ON
       next TK%
     Gosub AllowKeys
  Return

AllowHoriz:
     For TK% = 16 to 20
          Key(TK%) ON
       next TK%
     HorizAllow% = True%
     Gosub AllowKeys
  Return

AllowKeys:
     If ((VertAllow%<>False%) and (HorizAllow%<>False%)) then
          For TK% = 1 to 10
               Key(TK%) ON
            next TK%
       end if
  Return


HoldVert:
     VertAllow% = False%
     For TK% = 11 to 15
          Key(TK%) STOP
       next TK%
     Gosub HoldKeys
  Return

HoldHoriz:
     For TK% = 16 to 20
          Key(TK%) STOP
       next TK%
     HorizAllow% = False%
     Gosub HoldKeys
  Return

HoldKeys:
    For TK% = 1 to 10
         Key(TK%) STOP
      next TK%
  Return

DisAllowVert:
     VertAllow% = False%
     For TK% = 11 to 15
          Key(TK%) OFF
       next TK%
     Gosub DisAllowKeys
  Return

DisAllowHoriz:
     For TK% = 16 to 20
          Key(TK%) OFF
       next TK%
     HorizAllow% = False%
     Gosub DisAllowKeys
  Return

DisAllowKeys:
    For TK% = 1 to 10
         Key(TK%) OFF
      next TK%
  Return


'AllowMovementKeys:
''**********************************
'  For TK% = 1 to 18           '   *
'     Key(TK%) On         '        *
'    next TK%        '             *
'  Return  '                       *
''**********************************
'HoldMovementKeys:
''************************************
'  For TK% = 1 to 18 '               *
'     Key(TK%) Stop       '          *
'    next TK%                  '     *
'  Return  '                         *
''************************************
'
'DisAllowMovementKeys:
''************************************
'  For TK% = 1 to 18 '               *
'     Key(TK%) Off        '          *
'    next TK%                  '     *
'  Return  '                         *
'************************************

InitMovementKeys:
'***********************************
     On Key(1)  Gosub Help       ' *
     On Key(2)  Gosub KeyPause   ' * (Saves Screen, too)
     On Key(3)  Gosub ToggleSound' *
     On Key(4)  Gosub Key4       ' *
     On Key(5)  Gosub Key5       ' *
     On Key(6)  Gosub Key6       ' *
     On Key(7)  Gosub Key7       ' *
     On Key(8)  Gosub Key8       ' *
     On Key(9)  Gosub Key9       ' *
     On Key(10) Gosub ExitQues   ' ************************
     On Key(11) Gosub VertRot      ' (rotate backwards)   *
     On Key(12) Gosub VertLeft     '                      *
     On Key(13) Gosub VertRight    '                      *
     On Key(14) Gosub VertDown     ' (one line down)      *
     '                             ************************
     ' INS = VertDrop              *
     Key 15, Chr$(0)+Chr$(82) '    *
     ' F = HorizDrop               *
     Key 16, Chr$(0)+Chr$(33) '    *
     ' A = HorizRot                *
     Key 17, Chr$(0)+Chr$(30) '    *
     ' W = HorizUp                 *
     KEY 18, CHR$(0)+Chr$(17)
     '  Key 18, Chr$(0)+Chr$(17) '    *
     ' X = HorizDown               *
     Key 19, Chr$(0)+Chr$(45) '    *
     ' S = HorizRight              *
     Key 20, Chr$(0)+Chr$(31) '    *
     '                            '*
     On Key(15) Gosub VertDrop    '*
     On Key(16) Gosub HorizDrop   '*
     On Key(17) Gosub HorizRot    '*
     On Key(18) Gosub HorizUp     '*
     On Key(19) Gosub HorizDown   '*
     On Key(20) Gosub HorizRight  '*
   Return      '                  '*
'***********************************

Key4:
Key5:
Key6:
Key7:
Key8:
Key9:
     Return

VertLeft:
'*************************************
     Gosub HoldVert           '      *
     WR% = VR%: WY% = VY%     '      *
     WX% = VX% - 1            '      *
     Gosub HoldHoriz          '      *
     Gosub TestVert           '      *
     If NOT(Okay%) then       '      *
       Gosub AllowHoriz       '      *
       Gosub AllowVert        '      *
      Else     '                     *
        Gosub UnDisplayVert      '   *
        VX% = VX% - 1            '   *
        Gosub AllowHoriz         '   *
        Gosub DisplayVert        '   *
        Gosub AllowVert          '   *
     End If                      '   *
  Return       '                     *
'*************************************

VertRight:
'*************************************
     Gosub HoldVert           '      *
     WR% = VR%: WY% = VY%     '      *
     WX% = VX% + 1            '      *
     Gosub HoldHoriz          '      *
     Gosub TestVert           '      *
     If NOT(Okay%) then       '      *
       Gosub AllowHoriz       '      *
       Gosub AllowVert        '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayVert      '      *
     VX% = WX%                '      *
     Gosub AllowHoriz         '      *
     Gosub DisplayVert        '      *
     Gosub AllowVert          '      *
  Return       '                     *
'*************************************

VertDown:
'*************************************
     Gosub HoldVert           '      *
     WR% = VR%: WX% = VX%     '      *
     WY% = VY% + 1            '      *
     Gosub HoldHoriz          '      *
     Gosub TestVert           '      *
     If NOT(Okay%) then       '      *
       Gosub AllowHoriz       '      *
       Gosub AllowVert        '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayVert      '      *
     VY% = WY%                '      *
     Gosub AllowHoriz         '      *
     Gosub DisplayVert        '      *
     Gosub AllowVert          '      *
  Return       '                     *
'*************************************

HorizRight:
'*************************************
     Gosub HoldHoriz          '      *
     IY% = HY%: IR% = HR%     '      *
     IX% = HX% + 1            '      *
     Gosub HoldVert           '      *
     Gosub TestHoriz          '      *
     If NOT(Okay%) then       '      *
       Gosub AllowVert        '      *
       Gosub AllowHoriz       '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayHoriz     '      *
     HX% = IX%                '      *
     Gosub AllowVert          '      *
     Gosub DisplayHoriz       '      *
     Gosub AllowHoriz         '      *
  Return       '                     *
'*************************************

HorizDown:
'*************************************
     Gosub HoldHoriz          '      *
     IX% = HX%: IR% = HR%     '      *
     IY% = HY% + 1            '      *
     Gosub HoldVert           '      *
     Gosub TestHoriz          '      *
     If NOT(Okay%) then       '      *
       Gosub AllowVert        '      *
       Gosub AllowHoriz       '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayHoriz     '      *
     HY% = IY%                '      *
     Gosub AllowVert          '      *
     Gosub DisplayHoriz       '      *
     Gosub AllowHoriz         '      *
  Return       '                     *
'*************************************

HorizUp:
'*************************************
     Gosub HoldHoriz          '      *
     IX% = HX%: IR% = HR%     '      *
     IY% = HY% - 1            '      *
     Gosub HoldVert           '      *
     Gosub TestHoriz          '      *
     If NOT(Okay%) then       '      *
       Gosub AllowVert        '      *
       Gosub AllowHoriz       '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayHoriz     '      *
     HR% = IR%                '      *
     Gosub AllowVert          '      *
     Gosub DisplayHoriz       '      *
     Gosub AllowHoriz         '      *
  Return       '                     *
'*************************************

VertRot:
'*************************************
     Gosub HoldVert           '      *
     WX% = VX%: WY% = VY%     '      *
     WR% = VR% + 1            '      *
     if (WR% > NumOfRotations%) then WR% = 1
     Gosub HoldHoriz          '      *
     Gosub TestVert           '      *
     If NOT(Okay%) then       '      *
       Gosub AllowHoriz       '      *
       Gosub AllowVert        '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayVert      '      *
     VR% = WR%                '      *
     Gosub AllowHoriz         '      *
     Gosub DisplayVert        '      *
     Gosub AllowVert          '      *
  Return       '                     *
'*************************************

HorizRot:
'*************************************
     Gosub HoldHoriz          '      *
     IX% = HX%: IY% = HY%     '      *
     IR% = HR% + 1            '      *
     if (IR% > NumOfRotations%) then IR% = 1
     Gosub HoldVert           '      *
     Gosub TestHoriz          '      *
     If NOT(Okay%) then       '      *
       Gosub AllowVert        '      *
       Gosub AllowHoriz       '      *
       Return  '                     *
      End If   '                     *
     Gosub UnDisplayHoriz     '      *
     HR% = IR%                '      *
     Gosub AllowVert          '      *
     Gosub DisplayHoriz       '      *
     Gosub AllowHoriz         '      *
  Return       '                     *
'*************************************


KeyPause:
'*********************************
     Gosub HoldHoriz          '  *
     Gosub HoldVert           '  *
     Gosub SaveScreen         '  *
     Gosub InitDisplay        '  *
     Gosub UpdateStatsPanel   '  *
     Gosub ReDrawPlayingField '  *
     Gosub ReDrawBorders      '  *
     Gosub DisplayHoriz       '  *
     Gosub DisplayVert        '  *
     Gosub AllowHoriz         '  *
     Gosub AllowVert          '  *
  Return       '                 *
'*********************************

VertDrop:
'***************************
     Okay% = True%  '      *
     Temp% = 0      '      *
     While (Okay%)  '      *
          Gosub VertDown ' *
          Temp%=Temp%+1  ' *
       WEND         '      *********************
     Temp% = Temp% - 1   '                     *
     if (Temp%>0) then drops% = drops% + 1   ' *
     dropl% = dropl% + Temp%       '           *
     If (level% <= NumOfLevels%) Then        ' *
        dropP% = dropP% + DP%(Temp%,level%)  ' *
       else              '                     *
        dropP%=dropP%+DP%(Temp%,NumOflevels%)' *
       end if            '                     *
     score% = LevP%*level% + LP%*lines% + dropP%
     Gosub UpdateStatsPanel        '           *
  Return       '                               *
'***********************************************

HorizDrop:
'***************************
     Okay% = True%  '      *
     Temp% = 0      '      *
     While (Okay%)  '      ***
          Gosub HorizRight ' *
          Temp%=Temp%+1    ' *
       WEND         '        *******************
     Temp% = Temp% - 1   '                     *
     if (Temp%>0) then drops% = drops% + 1   ' *
     dropl% = dropl% + Temp%       '           *
     If (level% <= NumOfLevels%) Then        ' *
        dropP% = dropP% + DP%(Temp%,level%)  ' *
       else              '                     *
        dropP%=dropP%+DP%(Temp%,NumOflevels%)' *
       end if            '                     *
     score% = LevP%*level% + LP%*lines% + dropP%
     Gosub UpdateStatsPanel        '           *
  Return       '                               *
'***********************************************

TestVert:
'############################################################
     Okay% = True%  ' (default)                             #
     If (VX% + PMX% <= 1) then Okay% = False%     '         #
     For Count% = 1 to PMX%        '                        #
          For Temp% = 1 to PMY%    '                        #
               If (P%(VP%,WR%,Count%,Temp%)>0) then    '    #
                    'First, check to see if it overlaps
                    '  anything frozen:
                         if (S%((FMY%-FMX%)+WX%+Count%-1,WY%+Temp%-1)>0) then Okay% = False%
                    'Next check to see if it overlaps the other
                    '  player's unfrozen piece:
                    if ((FMY%-FMX%+WX%+Count%-1>=HX%) and (FMY%-FMX%+WX%+Count%-1<=HX%+PMX%-1) and (WY%+Temp%-1>=FMY%-FMX%+HY%) and (WY%+Temp%-1<=FMY%-FMX%+HY%+PMY%-1)) then
                       ' It is within subscript range, so
                       '  the possibility exists.  Check:
                       QY% = WY% + Temp% + FMX% - FMY% - HY%
                       QX% = FMY% - FMX% + WX% + Count% - HX%
                       if (P%(HP%,HR%,QX%,QY%)>0) then
                            Okay% = False%
                            if (UseSound%) then
                                  sound 6000,.8
                                  sound 3000,.8
                                  sound 1000,.8
                               end if
                         End if
                     end if
                 end if  '                                  #
            next Temp%   '                                  #
       next Count%       '                                  #
   If WY% > FMY% then    '                                  #
        If (UseSound%) then sound 200,1                '    #
        Okay% = False%   '                                  #
     end if              '                                  #
   If ((UseSound%) and (not(Okay%))) then sound 37,.5  '    #
  Return                 '                                  #
'############################################################


TestHoriz:
'############################################################
     Okay% = True%  ' (default)                             #
     If (HY% + PMY% <= 1) then Okay% = False%     '         #
     if (HY% + PMY% > FMY%) then Okay% = False% '
     For Count% = 1 to PMX%        '                        #
          For Temp% = 1 to PMY%    '                        #
               If (P%(HP%,IR%,Count%,Temp%)>0) then    '    #
                    'First, check to see if it overlaps
                    '  anything frozen:
                         if (S%(IX%+Count%-1,(FMY%-FMX%)+IY%+Temp%-1)>0) then Okay% = False%
                    'Next check to see if it overlaps the other
                    '  player's unfrozen piece:
                    if ((IX%+Count%-1>=FMY%-FMX%+VX%) and (IX%+Count%-1<=FMY%-FMX%+VX%+PMX%-1) and (FMY%-FMX%+IY%+Temp%-1>=VY%) and (FMY%-FMX%+IY%+Temp%-1<=VY%+PMY%-1)) then
                       ' It is within subscript range, so
                       '  the possibility exists.  Check:
                       QY% = FMY% - FMX% + IY% + Temp% - VY%
                       QX% = IX% + Count% - VX% + FMX% - FMY%
                       if (P%(VP%,VR%,QX%,QY%)>0) then
                            Okay% = False%
                            if (UseSound%) then
                                  sound 1000,.8
                                  sound 3000,.8
                                  sound 6000,.8
                               end if
                         End if
                     end if
                 end if  '                                  #
            next Temp%   '                                  #
       next Count%       '                                  #
   If IX% > FMY% then    '                                  #
        If (UseSound%) then sound 200,1                '    #
        Okay% = False%   '                                  #
     end if              '                                  #
   If ((UseSound%) and (not(Okay%))) then sound 37,.5  '    #
  Return                 '                                  #
'############################################################

'TestProposal:
''############################################################
'     Okay% = True%  ' (default)                             #
'     For Count% = 1 to PMX%        '                        #
'          For Temp% = 1 to PMY%    '                        #
'               If (P%(CP%,PR%,Count%,Temp%)>0) then    '    #
'                    if (S%(PMX%+PX%+Count%-1,PY%+Temp%-1)>0) then Okay% = False%
'                 end if  '                                  #
'            next Temp%   '                                  #
'       next Count%       '                                  #
'   If PY% > FMY% then    '                                  #
'        If (UseSound%) then sound 200,1                '    #
'        Okay% = False%   '                                  #
'     end if              '                                  #
'   If ((UseSound%) and (not(Okay%))) then sound 37,.5  '    #
'  Return                 '                                  #
''############################################################

'FreezePiece:
''######################################
'     for Count% = 1 to PMX%   '       #
'          for Temp% = 1 to PMY%    '  #
'               S%(PMX%+CX%+Count%-1,CY%+Temp%-1) = S%(PMX%+CX%+Count%-1,CY%+Temp%-1) + P%(CP%,PR%,Count%,Temp%)
'            next Temp%             '  #
'       next Count%            '       #
'     Frozen% = True%          '       #
''     pPoints%=pPoints%+PP%(CP%,CR%) ' #
'     placed% = placed% + 1    '       #
'     LevCM% = LevCM% + 1      '       #
'     if (LevCM%>=LevC%) then gosub AdvanceLevel
'     score% = LevP%*level% + LP%*lines% + dropP% + pPoints%
'     Gosub UpdateStatsPanel   '       #
'     If (CX% + PMX% > FMX%) then   '  #
'         CX% = FMX% - PMX%    '       #
'       end if  '                      #
'     if (CX% < 1) then CX% = 1     '  #
'  Return  '                           #
''######################################

FreezeVert:
'######################################
     for Count% = 1 to PMX%   '       #
          for Temp% = 1 to PMY%    '  #
               Temp2% = S%(FMY%-FMX%+VX%+Count%-1,VY%+Temp%-1)  '\  One line originally,
               Temp2% = Temp2% + P%(VP%,VR%,Count%,Temp%)       ' >   split to facilitate
               S%(FMY%-FMX%+VX%+Count%-1,VY%+Temp%-1) = Temp2%  '/    debugging.
            next Temp%             '  #
       next Count%            '       #
     Frozen% = V%             '       #
'     pPoints%=pPoints%+PP%(CP%,CR%) ' #
     placed% = placed% + 1    '       #
     LevCM% = LevCM% + 1      '       #
     if (LevCM%>=LevC%) then gosub AdvanceLevel
     score% = LevP%*level% + LP%*lines% + dropP% + pPoints%
     Gosub UpdateStatsPanel   '       #
     If (VX% + PMX% > FMX%) then   '  #
         VX% = FMX% - PMX%    '       #
       end if  '                      #
     if (VX% < 1) then VX% = 1     '  #
     Gosub NextPiece          '       #
  Return  '                           #
'######################################

FreezeHoriz:
'######################################
     for Count% = 1 to PMX%   '       #
          for Temp% = 1 to PMY%    '  #
               S%(HX%+Count%-1,FMY%-FMX%+HY%+Temp%-1) = S%(HX%+Count%-1,FMY%-FMX%+HY%+Temp%-1) + P%(HP%,HR%,Count%,Temp%)
            next Temp%             '  #
       next Count%            '       #
     Frozen% = H%             '       #
'     pPoints%=pPoints%+PP%(CP%,CR%) ' #
     placed% = placed% + 1    '       #
     LevCM% = LevCM% + 1      '       #
     if (LevCM%>=LevC%) then gosub AdvanceLevel
     score% = LevP%*level% + LP%*lines% + dropP% + pPoints%
     Gosub UpdateStatsPanel   '       #
     If (HY% + PMY% > FMY%) then   '  #
         HY% = FMY% - PMY%    '       #
       end if  '                      #
     if (HY% < 1) then HY% = 1     '  #
     Gosub NextPiece          '       #
  Return  '                           #
'######################################

AdvanceLevel:
'###################################
     LevCM% = 0     '              #
     level% = level% + 1      '    #
     If (UseSound%) then '         ###############################
          Play "T255"         '                                  #
          For TheNote% = 1 to 30 step 2 '                        #
               TheNote$=Str$(TheNote%) '                         #
               TheNote$=Right$(TheNote$,Len(TheNote$)-1)    '    #
               TheNote$="N"+TheNote$   '                         #
               Play TheNote$       '                             #
            next TheNote%     '                                  #
        End If                                              '    #
     DV! = DV! * Accel!       '                                  #
     DV! = DV! * (1 - (rnd(1) * (1 - RAccel!)))   '              #
  Return  '                                                      #
'#################################################################


CheckForLines:
'#########################################################################
     For Temp% = 1 to PMY%         '                                     #
          Okay% = True% ' Line is, by default, complete.                 #
          if (VY%+Temp%-1>FMY%) then Okay% = False%    '                 #
          For Count% = 1 to FMX%   '                                     #
               if (S%(FMY%-FMX%+Count%,VY%+Temp%-1)<=0) then Okay% = False% ' #
            next Count%            '                                     #
          If (Okay%) Then          '                                     #
               lines% = lines% + 1 '                                     #
               score% = LevP%*level% + LP%*lines% + dropP%            '  #
               For Temp2% = VY% + Temp% - 1 to 2 step -1              '  #
                    For Count% = 1 to FMX%             '               ###
                         S%(FMY%-FMX%+Count%, Temp2%) = S%(FMY%-FMX%+Count%, Temp2%-1)
                      next Count%  '                             ###     #
                 next Temp2%       '                          ###        #
               Gosub UpdateStatsPanel                  '   ###           #
               Gosub ReDrawPlayingField                '###              #
            End If       '                           ###                 #
       next Temp%        '                        ###                    #
  Return                 '                     ###                       #
'#########################################################################

CheckForColumns:
'#########################################################################
     For Temp% = 1 to PMX%         '                                     #
          Okay% = True% ' Line is, by default, complete.                 #
          if (HX%+Temp%-1>FMX%) then Okay% = False%    '                 #
          For Count% = 1 to FMY%   '                                     #
               if (S%(HX%+Temp%,FMY%-FMX%+Count%-1)<=0) then Okay% = False% ' #
            next Count%            '                                     #
          If (Okay%) Then          '                                     #
               lines% = lines% + 1 '   (We may distinguish someday...)   #
               score% = LevP%*level% + LP%*lines% + dropP%            '  #
               For Temp2% = HX% + Temp% - 1 to 2 step -1              '  #
                    For Count% = 1 to FMY%             '               ###
                         S%(Temp2%, FMY%-FMX%+Count%) = S%(Temp2%-1,FMY%-FMX%+Count%)
                      next Count%  '                             ###     #
                 next Temp2%       '                          ###        #
               Gosub UpdateStatsPanel                  '   ###           #
               Gosub ReDrawPlayingField                '###              #
            End If       '                           ###                 #
       next Temp%        '                        ###                    #
  Return                 '                     ###                       #
'#########################################################################

CheckInsertHeight:  ' (and width.  If one player's game is over, then
'                      the whole game is over for both.  This is a
'                      cooperative game, somewhat.)
'##############################################
     '  Basically, this checks to see that    #
     '    the top line of the playing field   #
     '    is clean.  Otherwise, the game      #
     '    is over, so we set a flag.          #
     For Count% = 1 to FMX%   '               #
          if (S%(FMY%-FMX%+Count%,1) > 0)    Then Continue% = False%
       next Count%            '               #
     For Count% = 1 to FMX%   '               #
          if (S%(1,FMY%-FMX%+Count%) > 0)    Then Continue% = False%
       next Count%            '               #
  Return  '                                   #
'##############################################

InitScreenArray:
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
     BorderC% = 3   ' (1/4 Normal)                              &
     For Count% = 1 to (FMY%-FMX%) -1        '                  &
          For Temp% = 1 to (FMY%-FMX%) -1    '                  &
               S%(Count%,Temp%) = BorderC%   '                  &
            next Temp%                       '                  &
       next Count%                           '                  &
     For Count% = 1 to FMY%        '                            &
          For Temp% = 1 to PMX%    '                            &
               S%(FMY%+Temp%,Count%) = BorderC%        '        &
            next Temp%                       '                  &
       next Count%                           '                  &
     For Count% = 1 to FMX%        '                            &
          For Temp% = 1 to PMY%    '                            &
               S%(Count%,FMY%+Temp%) = BorderC%        '        &
            next Temp%                       '                  &
       next Count%                           '                  &
  Return       '                                                &
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

'     BorderC% = 1
'     For Count% = 1 to PMX%   '                                 &
'          For Temp% = 1 to FMY%+PMY%         '                  &
'               S%(Count%,Temp%) = BorderC%   '                  &
'               S%(PMX% + FMX% + Count%, Temp%) = BorderC%   '   &
'            next Temp%        '                                 &
'       next Count%            '                                 &
'     For Count% = 1 to PMY%   '                                 &
'          For Temp% = 1 to FMX%+2*PMX%       '                  &
'               S%(Temp%,FMY%+Count%) = BorderC%             '   &
'            next Temp%        '                                 &
'       next Count%            '                                 &
'  Return            '                                           &
''&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

InitDisplay:
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&
     Select Case CM%          '                                  ::
          Case 0    '  (text:  80x24)                            &&
               Screen 0 : cls '                                  ::
               Gosub InitTextPanel           '                   &&
          Case 1    '  (text:  80x24==>40x24, "square pixels")   ::
               Screen 0 : cls '                                  &&
               Gosub InitTextPanel           '                   ::
       End Select   '                                            &&
     Gosub ReDrawBorders      '                                  ::
     Gosub ReDrawPlayingField ' (misnamed in this first case)    &&
  Return            '                                            ::
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&

InitTextPanel:
     Color 7
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&
     locate 1,1: print "Current Piece:";     '   ::
     locate 3,1: print "Next Piece:";        '   &&
     locate 12,1: print "Score:";            '   ::
     locate 13, 2: print "Level:";           '   &&
     locate 14, 4: print "Crit.:";           '   ::
     locate 15, 2: print "Lines:";           '   &&
     locate 16, 2: print "Drops:";           '   ::
     locate 17, 4: print "Length:";          '   &&
     locate 18, 4: print "Points:";          '   ::
     locate 19, 2: print "Pieces:";          '   &&
'     locate 20, 4: print "Points:";          '   ::
     locate 22, 1: print "HELP: PRESS F1";   '   &&
     locate 5,2: print "";   '                  ::
     locate 11,2: print "";  '                  &&
     Select Case CM%          '                  ::
          Case 0              '                  &&
               Temp% = 8      '                  ::
          Case 1              '                  &&
               Temp% = 13     '                  ::
       end select             '                  &&
     for Count% = 3 to Temp%  '                  ::
          locate 5,Count%     '                  &&
          print "";          '                  ::
          locate 11,Count%    '                  &&
          print "";          '                  ::
       next Count%            '                  &&
     locate 5,Temp%           '                  ::
     print "";               '                  &&
     locate 11,Temp%          '                  ::
     print "";               '                  &&
     For Count% = 6 to 10     '                  ::
          locate Count%,2     '                  &&
          print "";          '                  ::
          locate Count%,Temp% '                  &&
          print "";          '                  ::
       next Count%            '                  &&
  Return       '                                 ::
'&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&::&&

UpdateStatsPanel:
'::::::::::::::::::::::::::::
     color 7   '           ::
     locate 2,2          ' ::
     print PN$(CP%);     ' ::
     locate 4,2          ' ::
     print PN$(NP%);     ' ::
     locate 12,8         ' ::
     print score%;       ' ::
     locate 13,9         ' ::
     print level%;       ' ::
     locate 14,11        ' ::
     print (LevC%-LevCM%); ':
     locate 15,9         ' ::
     print lines%;       ' ::
     locate 16,9         ' ::
     print drops%;       ' ::
     locate 17,12        ' ::
     print dropL%;       ' ::
     locate 18,12        ' ::
     print dropP%;       ' ::
     locate 19,10        ' ::
     print placed%;      ' ::
'     locate 20,12        ' ::
'     print pPoints%;     ' ::
     Gosub ShowNextPiece ' ::
  Return       '           ::
'::::::::::::::::::::::::::::

ReDrawBorders:
'::::::::::::::::::::::::::::::::::
     For Count% = 1 to FMY%   '  ::
          Select Case CM%     '  ::
               Case 0         '  ::
                    locate Count%, PW% + FMY% + 1
               Case 1         '  ::
                    locate Count%, PW% + FMY% * 2 + 1
            End Select        '  ::
          print "";          '  ::
          locate FMY%+1, PW% + Count%
          Select Case CM%     '  ::
               Case 0         '  ::
                    Print "ͼ" ' ::
               Case 1    '       ::
                    Print "ͼ" '::
            End Select        '  ::
       next Count%            '  ::
  Return       '                 ::
'::::::::::::::::::::::::::::::::::
'     For Count% = 1 to FMY%   '  ::
'          locate Count%, PW%  '  ::
'          color 7             '  ::
'          print "";          '  ::
'          Select Case CM%     '  ::
'               Case 0         '  ::
'                    locate Count%, PW% + FMX% + 1
'               Case 1         '  ::
'                    locate Count%, PW% + FMX% * 2
'            End Select        '  ::
'          print "";          '  ::
'       next Count%            '  ::
'  Return       '                 ::
''::::::::::::::::::::::::::::::::::

ShowNextPiece:
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate 5+Count%,2+Temp%                 '  ::
                         color C%(P%(NP%,CR%,Temp%,Count%)+1)    '  ::
                         print C$(P%(NP%,CR%,Temp%,Count%)+1);   '  ::
                    Case 1         '                                ::
                         locate 5+Count%,1+Temp%*2               '  ::
                         color C%(P%(NP%,CR%,Temp%,Count%)+1)    '  ::
                         print C$(P%(NP%,CR%,Temp%,Count%)+1);   '  ::
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%                 '                                ::
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

UnDisplayVert:
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                         ::
          For Temp% = 1 to PMX%    '                                         ::
               Select Case CM%     '                                         ::
                    Case 0         '                                         ::
                         locate VY%+Count%-1,PW%+FMY%-FMX%+Temp%+VX% -1    ' ::
                         color 0                                           ' ::
                         if (P%(VP%,VR%,Temp%,Count%)>0) then print " ";   ' ::
                    Case 1                                                 ' ::
                         locate VY%+Count%-1,PW%+FMY%-FMX%+Temp%*2-1+VX%*2-2'::
                         color 0                                           ' ::
                         if (P%(VP%,VR%,Temp%,Count%)>0) then print " ";   ' ::
                    End Select     '                                         ::
               Next Temp%          '                                         ::
          Next Count%              '                                         ::
     Return                        '                                         ::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

UnDisplayHoriz:
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                         ::
          For Temp% = 1 to PMX%    '                                         ::
               Select Case CM%     '                                         ::
                    Case 0         '                                         ::
                         locate FMY%-FMX%+HY%+Count%-1,PW%+Temp%+HX% -1    ' ::
                         color 0                                           ' ::
                         if (P%(HP%,HR%,Temp%,Count%)>0) then print " ";   ' ::
                    Case 1                                                 ' ::
                         locate FMY%-FMX%+HY%+Count%-1,PW%+Temp%*2-1+HX%*2-2'::
                         color 0                                           ' ::
                         if (P%(HP%,HR%,Temp%,Count%)>0) then print " ";   ' ::
                    End Select     '                                         ::
               Next Temp%          '                                         ::
          Next Count%              '                                         ::
     Return                        '                                         ::
'::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

'UnDisplayPiece:
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'     For Count% = 1 to PMY%        '                                ::
'          For Temp% = 1 to PMX%    '                                ::
'               Select Case CM%     '                                ::
'                    Case 0         '                                ::
'                         locate CY%+Count%-1, PW%+Temp%+CX%  -1  '  ::
''                         color C%(1)                             ' ::
'                         color 0                                 '  ::
'                         if (P%(CP%,CR%,Temp%,Count%)>0) then print " ";
'                    Case 1         '                                ::
'                         locate CY%+Count%-1,PW%+Temp%*2-1 +CX% -1' ::
'                         color C%(1)                             '  ::
'                         if (P%(CP%,CR%,Temp%,Count%)>0) then print "  ";
'                 End Select        '                                ::
'            next Temp%             '                                ::
'       next Count%  '                                               ::
'  Return            '                                               ::
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DisplayVert:
on error goto CheckForSubscriptErrorVert
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate VY%+Count%-1, PW%+FMY%-FMX%+Temp%+VX% -1
                         color C%(P%(VP%,VR%,Temp%,Count%)+1)    '  ::
                         if (P%(VP%,VR%,Temp%,Count%)>0) then print C$(P%(VP%,VR%,Temp%,Count%)+1);
                    Case 1         '                                ::
                         locate VY%+Count%-1,PW%+FMY%-FMX%+Temp%*2-1+VX%*2-2
                         color C%(P%(VP%,VR%,Temp%,Count%)+1)    '  ::
                         if (P%(VP%,VR%,Temp%,Count%)>0) then print C$(P%(VP%,VR%,Temp%,Count%)+1);
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%  '                                               ::
FixSubscriptErrorVert:                            '                 ::
On Error goto 0                                   '                 ::
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DisplayHoriz:
on error goto CheckForSubscriptErrorHoriz
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to PMY%        '                                ::
          For Temp% = 1 to PMX%    '                                ::
               Select Case CM%     '                                ::
                    Case 0         '                                ::
                         locate HY%+FMY%-FMX%+Count%-1, PW%+Temp%+HX% -1
                         color C%(P%(HP%,HR%,Temp%,Count%)+1)    '  ::
                         if (P%(HP%,HR%,Temp%,Count%)>0) then print C$(P%(HP%,HR%,Temp%,Count%)+1);
                    Case 1         '                                ::
                         locate FMY%-FMX%+HY%+Count%-1,PW%+Temp%*2-1+HX%*2-2
                         color C%(P%(HP%,HR%,Temp%,Count%)+1)    '  ::
                         if (P%(HP%,HR%,Temp%,Count%)>0) then print C$(P%(HP%,HR%,Temp%,Count%)+1);
                 End Select        '                                ::
            next Temp%             '                                ::
       next Count%  '                                               ::
FixSubscriptErrorHoriz:                           '                 ::
On Error goto 0                                   '                 ::
  Return            '                                               ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


'DisplayPiece:
'on error goto CheckForSubscriptError
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'     For Count% = 1 to PMY%        '                                ::
'          For Temp% = 1 to PMX%    '                                ::
'               Select Case CM%     '                                ::
'                    Case 0         '                                ::
'                         locate CY%+Count%-1, PW%+Temp%+CX% -1   '  ::
'                         color C%(P%(CP%,CR%,Temp%,Count%)+1)    '  ::
'                         if (P%(CP%,CR%,Temp%,Count%)>0) then print C$(P%(CP%,CR%,Temp%,Count%)+1);
'                    Case 1         '                                ::
'                         locate CY%+Count%-1,PW%+Temp%*2-1+CX% - 1 '::
'                         color C%(P%(CP%,CR%,Temp%,Count%)+1)    '  ::
'                         if (P%(CP%,CR%,Temp%,Count%)>0) then print C$(P%(CP%,CR%,Temp%,Count%)+1);
'                 End Select        '                                ::
'            next Temp%             '                                ::
'       next Count%  '                                               ::
'FixSubscriptError:
'On Error goto 0
'  Return            '                                               ::
'':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CheckForSubscriptErrorVert:
     if (err=9) then resume FixSubscriptErrorVert
     On Error goto 0
resume next

CheckForSubscriptErrorHoriz:
     if (err=9) then resume FixSubscriptErrorHoriz
     On Error goto 0
resume next

ReDrawPlayingField:
':::::::::::::::::::::::::::::::::::::::::::::::::::::::
     For Count% = 1 to FMY%        '                  ::
          For Temp% = 1 to FMY%    '                  ::
               Select Case CM%     '                  ::
                    Case 0         '                  ::
                     locate Count%, PW%+Temp%     '   ::
                     color C%(S%(Temp%,Count%)+1)   ' ::
                     Print C$(S%(Temp%,Count%)+1);  ' ::
                    Case 1         '                  ::
                     locate Count%, PW%-1+2*Temp% '   ::
                     color C%(S%(Temp%,Count%)+1)  '  ::
                     Print C$(S%(Temp%,Count%)+1); '  ::
                 End Select        '                  ::
            next Temp%             '                  ::
       next Count%  '                                 ::
  Return            '                                 ::
':::::::::::::::::::::::::::::::::::::::::::::::::::::::

Help:
  Gosub DisAllowVert
  Gosub DisAllowHoriz
  HelpDoneFlag% = False%
     Screen ,,3,3
          color 15,0: cls
          Print "QTDual Help:"
          Open "QTDual.HLP" for input as #1
               Go$ = ""
               While ((Go$ <> "<EOF>") and (HelpDoneFlag% = False%))
                    If (Go$ = "") then
                         Print: Print "Do you wish to continue viewing help? (y/n)"
                         While ((Go$ <> "Y") and (Go$<>"N"))
                              Go$ = UCase$(Inkey$)
                           WEND
                         If (Go$ = "N") then HelpDoneFlag% = True%
                      else
                         Print Go$
                         ssT! = TIMER
                         While (ssT! + .15 > TIMER): WEND
                      end if
                    Line Input #1, Go$
                 WEND
               Print "END OF HELP:  Press any key."
               While (Inkey$ <> ""): WEND
               While (Inkey$ = ""): WEND
            Close #1
     Screen ,,0,0
  Gosub AllowVert
  Gosub AllowHoriz
  Return

ExitQues:
  Gosub DisAllowVert
  Gosub DisAllowHoriz
     Screen ,,1,1
          cls
          print "Are you sure you want to abort this game? (y/n)";
          Go$ = ""
          While ((Go$<>"Y") and (Go$ <> "N"))
              Go$ = UCase$(Inkey$)
            WEND
          If (Go$ = "Y") then Continue% = False%
     Screen ,,0,0
  Gosub AllowVert
  Gosub AllowHoriz
  Return

ToggleSound:
     UseSound% = NOT(UseSound%)
  Return

SaveScreen:
  Gosub DisAllowVert
  Gosub DisAllowHoriz
     Screen ,,2,2
     While (Inkey$ <> ""): WEND
     While (Inkey$ = "")
          ssX% = rnd(1)*40+15
          ssY% = rnd(1)*15+4
          locate ssY%, ssX%: print "Press Any Key"
          color rnd(1)*16,0
          ssT! = TIMER
          While (ssT! + .5 > TIMER): WEND
          locate ssY%, ssX%: Print "             "
       WEND
     Screen ,,0,0
     Gosub AllowVert
     Gosub AllowHoriz
  Return

GameOverMessage:
'[][][][][][][][][][][][][][][][][][][][][][][][]
     locate FMY%\2, PW% + FMY%\2             ' []
     color 31  '                               []
     print " G A M E   O V E R ";            ' []
     locate FMY%\2+1, PW%+FMY%\2+5           ' []
     print "   PRESS ANY KEY   ";            ' []
     While (Inkey$="")                       ' []
          for Temp% = 2500 to 2480 step -5   ' []
                If (UseSound%) then sound Temp%, .5
            next Temp%                       ' []
       WEND    '                               []
  Return       '                               []
'[][][][][][][][][][][][][][][][][][][][][][][][]

CreateGameScore:
'[][][][][][][][][][][][][][][][][][][][][][][][]
     Open "qtdscore.dat" for output as #1    '
          Print #1, PSetSpec$                '
          score% = LevP%*level% + LP%*lines% + dropP% ' jic
          Print #1, score%       ' 1
          Print #1, level%       ' 2
          Print #1, LevP%        ' 3
          Print #1, lines%       ' 4
          Print #1, LP%          ' 5
          Print #1, drops%       ' 6
          Print #1, dropl%       ' 7
          Print #1, dropP%       ' 8
          Print #1, placed%      ' 9
       Close #1     '
  Return            '
