'    
'    
'                                                             
'             QTetris:  A QBasic Tetris Implementation        
'               QTetMenu:  A Menu System for QTetris          
'                                                             
'    
'                                                             
'            Copyright (C) 1997 by Belly Laugh Software.      
'                                                             
'    
'                                                             
'                        Version 1.00  Beta                   
'                                                             
'    
'    

Begin:

GOSUB MainMenu
SELECT CASE VAL(Go$)
     CASE 1
          PRINT "1. QTet";
          GOSUB PleaseWait
          RUN "QTet.Q"
     CASE 2
          PRINT "1. QTDual";
          GOSUB PleaseWait
          RUN "QTDual.Q"
     CASE 3
          PRINT "3. Select";
          GOSUB SelectPieceSet
     CASE 4
          PRINT "4. PSED";
          GOSUB PleaseWait
          RUN "PSED.Q"
     CASE 5
          PRINT "5. HighScor";
          GOSUB PleaseWait
          RUN "HighScor.Q"
     CASE 6
          PRINT "6. Exit";
          LOCATE 24, 1: FOR x% = 1 TO 25: PRINT : NEXT x%
          CLS : SYSTEM
  END SELECT

GOTO Begin

SYSTEM

ReadList:
     OPEN "PSED.LST" FOR INPUT AS #1
          INPUT #1, NumOfSets%
          IF NOT (NSetsDetermined%) THEN
               NSetsDetermined% = True%
               DIM SetName$(NumOfSets% + 20)
            END IF
          FOR count% = 1 TO NumOfSets%
               INPUT #1, SetName$(count%)
            NEXT count%
       CLOSE #1
  RETURN

UpDateList:
     GOSUB ReadList
     Found% = False%
     FOR count% = 1 TO NumOfSets%
          IF (UCASE$(SetName$(count%)) = UCASE$(PSetSpec$)) THEN Found% = True%
       NEXT count%
     IF NOT (Found%) THEN
          NumOfSets% = NumOfSets% + 1
          SetName$(NumOfSets%) = PSetSpec$
          GOSUB WriteList
       END IF
  RETURN

WriteList:
          OPEN "PSED.LST" FOR OUTPUT AS #1
               PRINT #1, NumOfSets%
               FOR count% = 1 TO NumOfSets%
                    PRINT #1, SetName$(count%)
                 NEXT count%
            CLOSE #1
  RETURN

PleaseWait:
LOCATE 1, 1: COLOR 15, 0
PRINT : PRINT : PRINT :
PRINT "      "
PRINT "      ۱"
PRINT "                                                               ۱"
PRINT "               QTetris:  A QBasic Tetris Implementation        ۱"
PRINT "                                                               ۱"
PRINT "      ۱"
PRINT "                                                               ۱"
PRINT "              Copyright (C) 1998 by Belly Laugh Software.      ۱"
PRINT "                                                               ۱"
PRINT "      ۱"
PRINT "                                                               ۱"
PRINT "                          Version 1.00  Beta                   ۱"
PRINT "                                                               ۱"
PRINT "      ۱"
PRINT "      "
PRINT
PRINT "                         P L E A S E     W A I T . . ."

RETURN

MainMenu:
COLOR 15, 0: CLS
PRINT : PRINT : PRINT
PRINT "      "
PRINT "      "
PRINT "                                                               "
PRINT "               QTetris:  A QBasic Tetris Implementation        "
PRINT "                                                               "
PRINT "      "
PRINT "                                                               "
PRINT "              Copyright (C) 1998 by Belly Laugh Software.      "
PRINT "                                                               "
PRINT "      "
PRINT "                                                               "
PRINT "                          Version 1.00  Beta                   "
PRINT "                                                               "
PRINT "      "
PRINT "      "
PRINT
PRINT "                            M A I N     M E N U"
PRINT "      -----------------------------------------------------------------"
PRINT "      1.  Play QTetris    3.  Select Piece Set     5.  View High Scores"
PRINT "      2.  Play QTDual     4.  Edit Piece Set       6.  Exit"
PRINT
PRINT "        Enter the number of the option of your choice:  ";
Go$ = "": freq = 37: maxfreq = 17000
WHILE ((Go$ <> "1") AND (Go$ <> "2") AND (Go$ <> "3") AND (Go$ <> "4") AND (Go$ <> "5") AND (Go$ <> "6"))
  IF (Go$ <> "") THEN
     freq = freq * 1.05 + 1
     IF freq > maxfreq THEN freq = 37
     SOUND freq, .5
   END IF
  Go$ = INKEY$: WEND
RETURN

SelectPieceSet:
          GOSUB ReadList
          COLOR 7, 0: CLS
          PRINT "Choose a piece set:"
          IF (NumOfSets% > 80) THEN NumOfSets% = 80
          FOR count% = 1 TO NumOfSets%
               LOCATE 2 + (count% MOD 20), 18 * (count% \ 20) + 2
               Temp$ = STR$(count%)
               Temp$ = RIGHT$(Temp$, LEN(Temp$) - 1)
               Temp$ = Temp$ + ":  "
               PRINT Temp$;
               PRINT SetName$(count%)
            NEXT count%
          LOCATE 24, 1: COLOR 0, 7
          PRINT "Enter the number of the set you want:";
          INPUT count%
          PSetSpec$ = SetName$(count%)
          OPEN "QTet.CFG" FOR INPUT AS #1
               INPUT #1, Temp$
               INPUT #1, Temp%
               INPUT #1, Temp$
            CLOSE #1
          OPEN "QTet.CFG" FOR OUTPUT AS #1
               PRINT #1, PSetSpec$
               PRINT #1, Temp%
               PRINT #1, Temp$
            CLOSE #1
   RETURN

