defint a-z
randomize timer

'this includes all our declarations for the non Tree related routines
#include once "syn3d.bi"

init

main


sub init ()
    
    SDL_FLAGS = SDL_HWSURFACE OR SDL_OPENGL OR SDL_GL_DOUBLEBUFFER
    'SDL_FLAGS = SDL_FLAGS OR SDL_FULLSCREEN
    
    if SDL_Init(SDL_INIT_EVERYTHING) <> 0 THEN end 1
    
    selectRes
    
    video = SDL_SetVideoMode (SCR_WIDTH, SCR_HEIGHT, SCR_BITS, SDL_FLAGS)
    if video = 0 then
        SDL_Quit
        end 1
    end if
    
    
    SDL_WM_SetCaption "display", ""
    
    glViewport 0, 0, SCR_WIDTH, SCR_HEIGHT
    glMatrixMode GL_PROJECTION
    glLoadIdentity
    
    FOVy = 40
    aspect! = SCR_WIDTH / SCR_HEIGHT
    znear! = .1
    zfar! = 1000
    
    gluPerspective FOVy, aspect!, znear!, zfar!
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    
    
    glShadeModel GL_SMOOTH
    glClearColor .5, .5, .5, 1
    glClearDepth 1.0
    glEnable GL_DEPTH_TEST
    glDepthFunc GL_LEQUAL
    glEnable GL_COLOR_MATERIAL
    glHint GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
    
    lightAmbient(0) = .2
    lightAmbient(1) = .2
    lightAmbient(2) = .2
    lightAmbient(3) = 1
    
    lightDiffuse(0) = 1
    lightDiffuse(1) = 1
    lightDiffuse(2) = .9
    lightDiffuse(3) = 1
    
    lightSpecular(0) = lightDiffuse(0)
    lightSpecular(1) = lightDiffuse(1)
    lightSpecular(2) = lightDiffuse(2)
    lightSpecular(3) = 1
        
    lightEmission(0) = 0
    lightEmission(1) = 0
    lightEmission(2) = 0
    lightEmission(3) = 1
    
    glEnable GL_LIGHTING
    glLightModelfv GL_LIGHT_MODEL_AMBIENT, @lightAmbient(0)
    glShadeModel GL_SMOOTH
    
    lightPosition(0) = 0
    lightPosition(1) = 20
    lightPosition(2) = 0
    
    glLightfv GL_LIGHT1, GL_AMBIENT, @lightAmbient(0)
    glLightfv GL_LIGHT1, GL_DIFFUSE, @lightDiffuse(0)
    glLightfv GL_LIGHT1, GL_SPECULAR, @lightSpecular(0)
    glLightfv GL_LIGHT1, GL_POSITION, @lightPosition(0)
    
    glEnable GL_LIGHT1
    glEnable GL_COLOR_MATERIAL    
    glColorMaterial GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE
    
    glMaterialfv GL_FRONT_AND_BACK, GL_SPECULAR, @lightSpecular(0)
    glMaterialfv GL_FRONT_AND_BACK, GL_EMISSION, @lightEmission(0)
    glMaterialf GL_FRONT_AND_BACK, GL_SHININESS, 75
    
    lightAmbient(0) = 0
    lightAmbient(1) = 0
    lightAmbient(2) = 0
    lightAmbient(3) = 1
    
    lightDiffuse(0) = 1 / 2
    lightDiffuse(1) = 1 / 2
    lightDiffuse(2) = .9 / 2
    lightDiffuse(3) = 1
    
    lightSpecular(0) = lightDiffuse(0)
    lightSpecular(1) = lightDiffuse(1)
    lightSpecular(2) = lightDiffuse(2)
    lightSpecular(3) = 1
    
    glLightfv GL_LIGHT2, GL_AMBIENT, @lightAmbient(0)
    glLightfv GL_LIGHT2, GL_DIFFUSE, @lightDiffuse(0)
    glLightfv GL_LIGHT2, GL_SPECULAR, @lightSpecular(0)
    
        
    glEnable GL_LIGHT1
    glEnable GL_LIGHTING
    
    glCullFace GL_BACK
    glEnable GL_CULL_FACE
    glEnable GL_TEXTURE_2D
    
    glHint GL_LINE_SMOOTH_HINT, GL_NICEST
    if linesmoothing then glEnable GL_LINE_SMOOTH
    'glLineWidth 2
    
    'glBlendFunc GL_SRC_ALPHA, GL_ONE
    glBlendFunc GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA
    glAlphaFunc GL_GREATER, .5
    glEnable GL_BLEND
    glEnable GL_ALPHA_TEST
    
    glEnable GL_RESCALE_NORMAL
    
    
    zback = 20
    yheight = 0
    
    xres = SCR_WIDTH
    yres = SCR_HEIGHT
    xcen = xres / 2
    ycen = yres / 2
    
    xzratio! = xres / 1.6
    yzratio! = yres / 1.6
    
    camx = 0
    camy = 0
    'camz = 15
    
    rad = 3.141592 / 180
    
    glLoadIdentity
    
end sub



sub main ()

    fpsr = 1
    waitticks = ticks + 1000
    do
        
        checkinputs        
        drawview
        
        SDL_GL_SwapBuffers
        SDL_PumpEvents
        
        tickspassed = ticks
        ticks = SDL_GetTicks
        
        tickspassed = ticks - tickspassed
        fpsr = (fpsr + tickspassed / 20) / 2
    
        fp = fp + 1
        if ticks > nextticks then
            nextticks = ticks + 1000
            fps = fp
            fp = 0
        end if

        locate 1,1:print fps
        
        
        'body.yangle = body.yangle + 1
        'if body.yangle >= 360 then body.yangle = body.yangle - 360
        
    loop
    
end sub

sub checkinputs ()
    
    keys = SDL_GetKeyState(null)
    if keys[SDLK_ESCAPE] then deinit
    
    while SDL_PollEvent(@event)
        if event.type = SDL_EXIT then deInit
    wend
    

end sub


sub drawview ()
    
    dim dataset as objectinfo ptr
    
    glPolygonMode GL_FRONT_AND_BACK, GL_FILL
    
    glClear  GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT
    
    glLoadIdentity
    
    glTranslatef 0, -yheight, -zback
    
    glRotatef camrx, 1, 0, 0
    glRotatef camry, 0, -1, 0
    glRotatef camrz, 0, 0, 1
    
    glLightfv GL_LIGHT1, GL_POSITION, @lightPosition(0)
    
    glTranslatef -camx, -camy, -camz
    
    glPushMatrix
    
    'draw something
    
    glPopMatrix
    
    glFlush
    
    
end sub


