'$include: "\SDL\SDL.bi"
'$include: "\GL\gl.bi"
'$include: "\GL\glu.bi"
'$include: "\GL\glext.bi"
'$include: '\SDL\SDL_image.bi'
'$include: '\GL\glfw.bi'

const MAX_OBJ = 1, MAX_POLIES = 2000, MAX_REFS = 4

const PATH_FONTS="data/fontimg/"

type polytype

    x(MAX_REFS)    as single
    y(MAX_REFS)    as single
    z(MAX_REFS)    as single
    u(MAX_REFS)    as double
    v(MAX_REFS)    as double
    nx(MAX_REFS)   as single
    ny(MAX_REFS)   as single
    nz(MAX_REFS)   as single
    pnt(MAX_REFS) as integer
    c(MAX_REFS,2)    as single
    refs    as integer
    dot     as single
    smoothingGroup  as byte
    
    'which terrain texture to use
    texnum  as integer
    'designates the viewmode
    tex as integer
end type


type objectinfo
    geometry(MAX_OBJ, MAX_POLIES) as polytype
    lastindex(MAX_OBJ)  as integer
    lastobj as integer
    
    tex(MAX_OBJ)    as unsigned integer
    hastex(MAX_OBJ) as integer
    
    xangle  as single
    yangle  as single
    zangle  as single
    
    modxangle as single
    modyangle as single
    modzangle as single
    
    xpos    as single
    ypos    as single
    zpos    as single
    
end type


declare sub cartesian2sphere (x!, y!, z!, r!, an1!, an2!)
declare sub cross (dataset as objectinfo ptr, cobj, cindex)
declare sub cross2 (x1!, y1!, z1!, x2!, y2!, z2!, x3!, y3!, z3!, nx!, ny!, nz!)
declare sub deinit ()
declare function dot! (x0!, y0!, z0!, x1!, y1!, z1!)
declare sub drawobj (dataset as objectinfo ptr)
declare sub init ()
declare sub init_gl ()
declare sub main ()
declare sub checkinputs ()
declare sub drawview ()
declare sub findxyz (x,y, nx as gldouble, ny as gldouble, nz as gldouble)
declare function font_draw(x1,y1,c,a,text$)
declare sub font_loadfont (font$)
declare sub font_xy(length,height,text$)
declare sub fprint (xloc, yloc, txt$)
declare sub hud_2dplane_clear()
declare sub hud_2dplane_set()
declare sub load_acfile (acfile$, dataset as objectinfo ptr)
declare sub loadobjfile (objfile$, dataset as objectinfo ptr)
declare sub load_colors (modelfil$, dataset as objectinfo ptr)
declare sub load_texture (texFil$, tex as gluint)
declare sub load_textureAlpha (texFil$, tex as gluint)
declare sub rotpnt (x1!, y1!, z1!, rotx!, roty!, rotz!, nx!, ny!, nz!)
declare sub selectRes ()
declare sub smoothnormals (dataset as objectInfo ptr, group as byte)
declare sub sphere2cartesian (radius!, height!, x!, y!, z!, an1!, an2!)
declare function u! (an!)

    

dim shared zback as single, yheight as single, xzratio!, yzratio!, znear!, zfar!, rad as single
dim shared camx as single, camy as single, camz as single
dim shared camrx as single, camry as single, camrz as single

dim shared lightAmbient(4) as GLFLOAT, lightDiffuse(4) as GLFLOAT, lightPosition(4) as GLFLOAT
dim shared lightSpecular(4) as GLFLOAT, lightEmission(4) as GLFLOAT

dim shared video as SDL_Surface ptr
dim shared keys as Uint8 ptr, mouse as Uint8, event as SDL_EVENT, mousex, mousey, mbutton as uint8

dim shared vind, wiremode

dim shared fpsr as double, fps, fp, ticks, tickspassed, nextticks, waitticks

dim shared dataset as objectinfo ptr

dim shared SCR_WIDTH, SCR_HEIGHT, SCR_BITS, SDL_FLAGS, linesmoothing

'matricies for gluunproject
dim shared fieldmatrix(15) as GLDOUBLE, viewmatrix(3) as glint, projectionmatrix(15) as gldouble

'font specific
dim shared fontimg(96) as unsigned integer, fontdl(96) as GLuint, charwidth(96)
              'characters 32 - 126           
dim shared fontheight,fontwidth  
dim shared fontxs!,fontys!,fontxoff
dim shared font_cblue, font_cwhite


sub cartesian2sphere (x!, y!, z!, r!, an1!, an2!)
    
    r! = sqr(x! ^ 2 + y! ^ 2 + z! ^ 2)
    an2! = atan2(x!, z!) * 180 / 3.14159
    an1! = acos(y! / r!) * 180 / 3.14159

end sub


sub cross (dataset as objectinfo ptr, cobj, cindex)
    
    'dim x1!, y1!, z1!, x2!, y2!, z2!, x3!, y3!, z3!, d2!, d3!, dn!, nx!, ny!, nz!
    
    refs = dataset->geometry(cobj, cindex).refs
    
    x1! = dataset->geometry(cobj, cindex).x(0)
    y1! = dataset->geometry(cobj, cindex).y(0)
    z1! = dataset->geometry(cobj, cindex).z(0)
    
    x2! = dataset->geometry(cobj, cindex).x(1) - x1!
    y2! = dataset->geometry(cobj, cindex).y(1) - y1!
    z2! = dataset->geometry(cobj, cindex).z(1) - z1!
    
    'f = dataset->geometry(cobj,cindex).refs - 1
    x3! = dataset->geometry(cobj, cindex).x(2) - x1!
    y3! = dataset->geometry(cobj, cindex).y(2) - y1!
    z3! = dataset->geometry(cobj, cindex).z(2) - z1!
    
    d2! = sqr(x2! ^2 + y2! ^2 + z2! ^2)
    d3! = sqr(x3! ^2 + y3! ^2 + z3! ^2)
    
    x2! = x2! / d2!
    y2! = y2! / d2!
    z2! = z2! / d2!
    
    x3! = x3! / d3!
    y3! = y3! / d3!
    z3! = z3! / d3!
    
    nx! = y2! * z3! - z2! * y3!
    ny! = z2! * x3! - x2! * z3!
    nz! = x2! * y3! - y2! * x3!
    
    d! = sqr(nx! * nx! + ny! * ny! + nz! * nz!)
    
    'if d! = 0 then d! = 1
    
    nx! = nx! / d!
    ny! = ny! / d!
    nz! = nz! / d!
                
    for i = 0 to refs - 1
        dataset->geometry(cobj, cindex).nx(i) = nx!
        dataset->geometry(cobj, cindex).ny(i) = ny!
        dataset->geometry(cobj, cindex).nz(i) = nz!
    next
    
end sub

sub cross2 (x1!, y1!, z1!, x2!, y2!, z2!, x3!, y3!, z3!, nx!, ny!, nz!)
    
    ax1! = x1!
    ay1! = y1!
    az1! = z1!
    ax2! = x2! - ax1!
    ay2! = y2! - ay1!
    az2! = z2! - az1!
    
    ax3! = x3! - ax1!
    ay3! = y3! - ay1!
    az3! = z3! - az1!
    
    d2! = sqr(ax2! ^2 + ay2! ^2 + az2! ^2)
    d3! = sqr(ax3! ^2 + ay3! ^2 + az3! ^2)
    
    ax2! = ax2! / d2!
    ay2! = ay2! / d2!
    az2! = az2! / d2!
    
    ax3! = ax3! / d3!
    ay3! = ay3! / d3!
    az3! = az3! / d3!
    
    nx! = ay2! * az3! - az2! * ay3!
    ny! = az2! * ax3! - ax2! * az3!
    nz! = ax2! * ay3! - ay2! * ax3!
    
    d! = sqr(nx! * nx! + ny! * ny! + nz! * nz!)
    nx! = nx! / d!
    ny! = ny! / d!
    nz! = nz! / d!
    
end sub


sub deinit ()
    
    SDL_Quit
    end 1

end sub


function dot! (x0!, y0!, z0!, x1!, y1!, z1!)
    
    mag0! = sqr(x0! * x0! + y0! * y0! + z0! * z0!)
    mag1! = sqr(x1! * x1! + y1! * y1! + z1! * z1!)
    
    x2! = x0! / mag0!
    y2! = y0! / mag0!
    z2! = z0! / mag0!
    
    x3! = x1! / mag1!
    y3! = y1! / mag1!
    z3! = z1! / mag1!
    
    a! = acos(x2! * x3! + y2! * y3! + z2! * z3!) * 180 / 3.14159
    
    dot! = a!
end function

sub drawObj (dataset as objectinfo ptr)
    
    cobj = 0
    
            glBegin GL_TRIANGLES
                for cindex = 0 to dataset->lastindex(cobj)
                    if dataset->geometry (cobj, cindex).refs = 3 then
                        for cvert = 0 to 2
                            glColor3f dataset->geometry(cobj, cindex).c(cvert, 0), dataset->geometry(cobj, cindex).c(cvert, 1), dataset->geometry(cobj, cindex).c(cvert, 2)
                            if wiremode = 1 then glColor3f dataset->geometry(cobj, cindex).c(cvert, 0) * .5, dataset->geometry(cobj, cindex).c(cvert, 1) * .5, dataset->geometry(cobj, cindex).c(cvert, 2) * .5
                            glNormal3f dataset->geometry(cobj, cindex).nx(cvert), dataset->geometry(cobj, cindex).ny(cvert), dataset->geometry(cobj, cindex).nz(cvert)
                            glVertex3f dataset->geometry(cobj, cindex).x(cvert), dataset->geometry(cobj, cindex).y(cvert), dataset->geometry(cobj, cindex).z(cvert)                    
                        next
                    end if            
                next
            glEnd
           
            glBegin GL_QUADS
                for cindex = 0 to dataset->lastindex(cobj)
                    if dataset->geometry (cobj, cindex).refs = 4 then
                        for cvert = 0 to 3
                            glColor3f dataset->geometry(cobj, cindex).c(cvert, 0), dataset->geometry(cobj, cindex).c(cvert, 1), dataset->geometry(cobj, cindex).c(cvert, 2)
                            if wiremode = 1 then glColor3f dataset->geometry(cobj, cindex).c(cvert, 0) * .5, dataset->geometry(cobj, cindex).c(cvert, 1) * .5, dataset->geometry(cobj, cindex).c(cvert, 2) * .5
                            glNormal3f dataset->geometry(cobj, cindex).nx(cvert), dataset->geometry(cobj, cindex).ny(cvert), dataset->geometry(cobj, cindex).nz(cvert)
                            glVertex3f dataset->geometry(cobj, cindex).x(cvert), dataset->geometry(cobj, cindex).y(cvert), dataset->geometry(cobj, cindex).z(cvert)
                        next
                    end if            
                next
            glEnd
            
end sub

sub findxyz (x,y, nx as gldouble, ny as gldouble, nz as gldouble)
    
    dim winx as glfloat, winy as glfloat, winz as glfloat
    'based on code at NEHE.gamedev.net
    winx = x
    winy = viewmatrix(3) - y
    
    glGetDoublev GL_MODELVIEW_MATRIX, @fieldmatrix(0)
    
    glReadPixels winx, winy, 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, @winz
    
    gluUnProject winx, winy, winz, @fieldmatrix(0), @projectionmatrix(0), @viewmatrix(0), @nx, @ny, @nz

    
end sub


function font_draw(x1,y1,c,a,text$) 'update.11.21.05
    
    txtlen=len(text$): if txtlen=0 then exit function 'exit if null
    
    xs!=fontxs!
    ys!=fontys!
    
    xoff=fontxoff
    
    r!=((c SHR 16) and 255)/255
    g!=((c SHR 8) and 255)/255
    b!=(c and 255)/255    
    a!=(255-a)/255
    
    glPushMatrix
    glEnable GL_TEXTURE_2D
    glTranslatef x1,y1,0
    glScalef xs!,ys!,0            
            
    for i=0 to txtlen-1
      char=asc(mid$(text$,i+1,1))-32
      glBindTexture GL_TEXTURE_2D, fontimg(char)
      glColor4f r!,g!,b!,a!      
      glCallList fontdl(char)
      charpx=charwidth(char)+xoff
      glTranslatef charpx,0,0
      px+=charpx
    next
    
    px-=xoff
    
    glDisable GL_TEXTURE_2D
    glPopMatrix
    
    return px*xs!
    
  end function
  
sub font_loadfont (font$)
        
    fontfolder$ = PATH_FONTS + font$ + "/"
    fontwidth = 16
    fontheight = 16
    
    glGenTextures 95, @fontimg(0)
    dim tempimg as SDL_Surface ptr
    dim pnts(3,3) as single
    dim temp as uinteger ptr, cc as unsigned integer
    'x/y/u/v
    
    pnts(0,0) = 0
    pnts(0,1) = 0
    pnts(1,0) = 0
    pnts(1,1) = 1
    pnts(2,0) = 1
    pnts(2,1) = 1
    pnts(3,0) = 1
    pnts(3,1) = 0
    
    
    for ch = 32 to 126
        fil$ = fontfolder$ + ltrim$(rtrim$(str$(ch))) + ".png"
        tempimg = IMG_Load(fil$)
        
        SDL_SetAlpha tempimg, SDL_SRCALPHA, 255
        
        glBindTexture GL_TEXTURE_2D, fontimg(ch-32)

        'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST
        'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST
        glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR
        glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR

        glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA, tempimg->w, tempimg->h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tempimg->pixels

        minx = fontwidth
        maxx = 0
        cc = 16777215
        for x = 0 to fontwidth - 1
            for y = 0 to fontheight - 1
                temp = tempimg->pixels + y * tempimg->pitch + x * tempimg->format->BytesPerPixel
                if *temp <> cc then
                    if x < minx then minx = x
                    if x > maxx then maxx = x
                end if
            next
        next
        
        minx = minx - 1
        if minx < 0 then minx = 0
        if maxx - minx < 3 then
            minx = minx - 2
            maxx = maxx + 2
        end if
        
        charwidth(ch-32) = maxx-minx + 1
        if ch = 32 then charwidth(0) = 10
        
        pnts(0,2) = minx / 15
        pnts(0,3) = 0
        pnts(1,2) = minx / 15
        pnts(1,3) = 1
        pnts(2,2) = maxx / 15
        pnts(2,3) = 1
        pnts(3,2) = maxx / 15
        pnts(3,3) = 0
        
        fontdl(ch-32) = glGenLists(1)
        glNewList fontdl(ch-32), GL_COMPILE
            glBegin GL_QUADS
                for i = 0 to 3
                    glTexCoord2f pnts(i,2), pnts(i,3)
                    glVertex2f pnts(i,0) * charwidth(ch-32), pnts(i, 1) * fontheight
                next
            glEnd
        glEndList
        SDL_FreeSurface tempimg
    next
    
    
end sub

  sub font_xy(length,height,text$) 'update.11.21.05
    
    txtlen=len(text$): if txtlen=0 then exit function 'exit if null    
    
    xs!=fontxs!
    ys!=fontys!
        
    xoff=fontxoff
    
    for i=0 to txtlen-1
      char=asc(mid$(text$,i+1,1))-32      
      charx=charwidth(char)+xoff      
      px+=charx
    next
    
    px-=xoff    
    
    length=px
    height=fontheight        
    
  end sub  
  
sub fprint (xloc, yloc, txt$)
    
    d = font_draw (xloc * fontwidth * fontxs!, yloc  * fontheight * fontys!, font_cwhite, 0, txt$)
    
end sub

sub hud_2dplane_clear()
    
    glMatrixMode GL_PROJECTION
    glPopMatrix
    glMatrixMode GL_MODELVIEW
    
    glEnable GL_LIGHTING
    glEnable GL_DEPTH_TEST
    glPopMatrix
    glFlush
    
  end sub  

sub hud_2dplane_set()
    
    glMatrixMode GL_PROJECTION
    glPushMatrix
    glLoadIdentity
    glMatrixMode GL_MODELVIEW  
   
    glDisable GL_DEPTH_TEST
    glDisable GL_LIGHTING
    glLoadIdentity
    
    'glOrtho 0,xres,yres-1,-1,-1,1
    glOrtho 0,SCR_WIDTH, SCR_HEIGHT -1,-1,-1,1
    
  end sub
  

sub load_acfile (acfile$, dataset as objectinfo ptr)
    
    dim subobjs, cobj, a$, pnt, f, m$, lastloc, pindex, lenf, csurf, cu(3) as double, cv(3) as double, cpnt(3), gpnt
    dim numvert, verts(MAX_POLIES,3) as single, numsurf, cindex, g, refs
    dim tempxyz(3, 3)' as single
        'vert, xyz
    dim a, b, c, cpoly

    'dim texspace as AUX_RGBImageRec ptr
    'dim texspace as SDL_Surface ptr
    
    dataset->lastindex(cobj) = 0
    
    dim minmax(1,2) as single
    'min/max, x/y/z
    
    'for a = 0 to 1
    '    for b = 0 to 2
    '        if a = 0 then minmax(a,b) = 999
    '        if a = 1 then minmax(a,b) = -999
    '    next
    'next
        
    lasty = 0
    open acfile$ for input as #1
        do
            input #1, a$
            if a$ = "OBJECT world" then exit do
        loop
        input #1, a$ 'kids
        
        subobjs = val(right$(a$, len(a$) - 5))
        dataset->lastobj = subobjs - 1
                
        'glGenTextures subobjs, @dataset->tex(0)
                
        for cobj = 0 to subobjs - 1
            
            'dataset->hastex(cobj) = 0
            
            input #1, a$
            input #1, a$
            input #1, a$
            input #1, a$
            input #1, a$
            if left$(a$, 7) = "texture" then                
                'texspace = auxDIBImageLoad(right$(a$, len(a$) - 8))
                'texfile$ = "data/" + left$(right$(a$, len(a$) - 9), len(right$(a$, len(a$) - 9)) - 1)
                'texspace = IMG_Load(texfile$)
                
                input #1, a$
                input #1, a$
                'dataset->hastex(cobj) = 1
                
                'glBindTexture GL_TEXTURE_2D, @dataset->tex(cobj)
                'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST
                'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST
                'glTexImage2D GL_TEXTURE_2D, 0, GL_RGB, texspace->w, texspace->h, 0, GL_RGB, GL_UNSIGNED_BYTE, texspace->pixels                
                
                'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR
                'glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST
                'gluBuild2DMipmaps GL_TEXTURE_2D, GL_RGB, texspace->w, texspace->h, GL_RGB, GL_UNSIGNED_BYTE, texspace->pixels
        
                'SDL_FreeSurface texspace
            end if
            
            input #1, a$ 'numvert xxx
            numvert = val(right$(a$, len(a$) - 8))
                                    
            
            for pnt = 0 to numvert-1
                input #1, a$
                lastloc = 1
                pindex = 0
                for f = 1 to len(a$)
                    m$ = mid$(a$, f, 1)
                    if m$ = " " or f = len(a$) then                        
                        lenf = f - lastloc
                        if f = len(a$) then lenf = f + 1 - lastloc
                        verts(pnt, pindex) = val(mid$(a$, lastloc, lenf))                        
                        lastloc = f + 1
                        
                        
                        pindex = pindex + 1
                    end if                                        
                next
                
                            
            next
            
            input #1, a$ 'numsurf xxx
            numsurf = val(right$(a$, len(a$) - 8))
            
            cindex = 0
                        
                       
                        
            for csurf = 0 to numsurf - 1
                
                input #1, a$
                input #1, a$
                input #1, a$ 'refs xxx
                refs = val(right$(a$, len(a$) - 5))
            
                for gpnt = 0 to refs - 1
                    input #1, a$
                    lastloc = 1
                    pindex = 0
                    for f = 1 to len(a$)
                        m$ = mid$(a$, f, 1)
                        if m$ = " " or f = len(a$) then                        
                            lenf = f - lastloc
                            if f = len(a$) then lenf = f + 1 - lastloc
                            if pindex = 0 then cpnt(gpnt) = val(mid$(a$, lastloc, lenf))
                            if pindex = 1 then cu(gpnt) = val(mid$(a$, lastloc, lenf))
                            if pindex = 2 then cv(gpnt) = 1 - val(mid$(a$, lastloc, lenf))
                            lastloc = f + 1
                            pindex = pindex + 1
                        end if
                    next
                                        
                next
                                

                if refs = 3 then
                    dataset->geometry (cobj, cindex).refs = 3
                    for f = 0 to 2
                        dataset->geometry (cobj, cindex).x(f) = verts(cpnt(f), 0)
                        dataset->geometry (cobj, cindex).y(f) = verts(cpnt(f), 1)
                        dataset->geometry (cobj, cindex).z(f) = verts(cpnt(f), 2)                        
                        dataset->geometry (cobj, cindex).u(f) = cu(f)
                        dataset->geometry (cobj, cindex).v(f) = cv(f)
                        dataset->geometry (cobj, cindex).pnt(f) = cpnt(f)
                        dataset->geometry (cobj, cindex).tex = 0
                        for ff = 0 to 2
                            dataset->geometry (cobj, cindex).c(f,ff) = 1
                        next
                    next
                    
                    cross dataset, cobj, cindex
                    
                    if cindex > dataset->lastindex(cobj) then dataset->lastindex(cobj) = cindex
                    cindex = cindex +1
                                        
                end if
                
                if refs = 4 then
                    dataset->geometry (cobj, cindex).refs = 4
                    for f = 0 to 3
                        dataset->geometry (cobj, cindex).x(f) = verts(cpnt(f), 0)
                        dataset->geometry (cobj, cindex).y(f) = verts(cpnt(f), 1)
                        dataset->geometry (cobj, cindex).z(f) = verts(cpnt(f), 2)   
                        dataset->geometry (cobj, cindex).u(f) = cu(f)
                        dataset->geometry (cobj, cindex).v(f) = cv(f)                        
                        dataset->geometry (cobj, cindex).pnt(f) = cpnt(f)
                        dataset->geometry (cobj, cindex).tex = 0
                        for ff = 0 to 2
                            dataset->geometry (cobj, cindex).c(f,ff) = 1
                        next
                    next
                    
                    cross dataset, cobj, cindex
                    if cindex > dataset->lastindex(cobj) then dataset->lastindex(cobj) = cindex
                    cindex = cindex +1
                                                            
                end if
                         
                 
                
            next
            
            input #1, a$
            
        next
        
    
    close #1
    
end sub

sub load_colors (modelfil$, dataset as objectinfo ptr)
    
    open modelfil$ + ".colors" for input as #1
    for i = 0 to dataset->lastindex(0)
        for vert = 0 to 3
            input #1, dataset->geometry(0, i).c(vert,0)
            input #1, dataset->geometry(0, i).c(vert,1)
            input #1, dataset->geometry(0, i).c(vert,2)
        next
    next
    close #1
    
end sub

sub loadobjfile (objfile$, dataset as objectinfo ptr)

    scale! = .5

    dim subobjs, cobj, a$, pnt, f, m$, lastloc, pindex, lenf, csurf, gpnt
    dim numvert, verts(MAX_POLIES,2) as single, numsurf, cindex, g, refs
    dim norms(MAX_POLIES,2) as double, texts(MAX_POLIES,1) as single
    dim a, b, c, cpoly

    'dim texspace as AUX_RGBImageRec ptr
    dim texspace as SDL_Surface ptr
    
    dim minmax(1,2) as single
    'min/max, x/y/z
    
    for a = 0 to 1
        for b = 0 to 2
            if a = 0 then minmax(a,b) = 999
            if a = 1 then minmax(a,b) = -999
        next
    next
        
    
    
    cobj = 0
    
    
    input #1, a$
    input #1, a$
    dataset->hastex(cobj) = 0
    
    
    v = 0
    vn = 0
    vt = 0
    f = 0
    open objfile$ for input as #1
        
        while not eof(1)
            input #1, a$
                
            'v -0.31503613 2.36375111 0.33460410
            if left$(a$, 2) = "v " then
                v = v + 1
                if v > max_polies then v = max_polies
                lastloc = 3
                pindex = 0
                for ff = 3 to len(a$)
                    m$ = mid$(a$, ff, 1)
                    if m$ = " " or ff = len(a$) then                        
                        lenf = ff - lastloc
                        if ff = len(a$) then lenf = ff + 1 - lastloc
                        verts(v, pindex) = val(mid$(a$, lastloc, lenf)) * scale!
                        lastloc = ff + 1
                        
                        if verts(v,pindex) < minmax(0,pindex) then minmax(0,pindex) = verts(v,pindex)
                        if verts(v,pindex) > minmax(1,pindex) then minmax(1,pindex) = verts(v,pindex)
                            
                        pindex = pindex + 1
                    end if                                        
                next
            end if
            
            'vn 0.83376820 -0.27984900 0.47593606
            if left$(a$, 2) = "vn" then
                vn = vn + 1
                if vn > max_polies then vn = max_polies
                lastloc = 4
                pindex = 0
                for ff = 4 to len(a$)
                    m$ = mid$(a$, ff, 1)
                    if m$ = " " or ff = len(a$) then                        
                        lenf = ff - lastloc
                        if ff = len(a$) then lenf = ff + 1 - lastloc
                        ff$ = mid$(a$, lastloc, lenf)
                        norms(vn, pindex) = val(ff$)' * scale!
                        lastloc = ff + 1
                        
                        pindex = pindex + 1
                    end if                                        
                next
            end if
            
            'vt 0 1
            if left$(a$, 2) = "vt" then
                vt=vt+1
                if vt > max_polies then vt = max_polies
                lastloc = 4
                pindex = 0
                for ff = 4 to len(a$)
                    m$ = mid$(a$, ff, 1)
                    if m$ = " " or ff = len(a$) then                        
                        lenf = ff - lastloc
                        if f = len(a$) then lenf = ff + 1 - lastloc
                        texts(vt, pindex) = val(mid$(a$, lastloc, lenf))                        
                        lastloc = ff + 1
                        pindex = pindex + 1
                    end if                                        
                next
            end if            
            
            'f 381//381 384//384 383//383 382//382
            if left$(a$, 2) = "f " then
                lastloc = 3
                ind = 0
                for ff = 3 to len(a$)
                    m$ = mid$(a$, ff, 1)
                    if m$ = " " or ff = len(a$) then                        
                        lenf = ff - lastloc
                        if ff = len(a$) then lenf = ff + 1 - lastloc
                        ff$ = mid$(a$, lastloc, lenf)
                        
                        flastloc = 1
                        fpindex = 0
                        for fs = 1 to len(ff$)
                            ms$ = mid$(ff$, fs, 1)
                            if ms$ = "/" or fs = len(ff$) then
                                flenf = fs - flastloc
                                if flenf > 0 then
                                    if fs = len(ff$) then flenf = fs + 1 - flastloc
                                    if fpindex = 0 then cv = val(mid$(ff$, flastloc, flenf))
                                    if fpindex = 1 then cvt = val(mid$(ff$, flastloc, flenf))
                                    if fpindex = 2 then cvn = val(mid$(ff$, flastloc, flenf))
                                end if
                                flastloc = fs + 1
                                fpindex = fpindex + 1
                            end if
                        next
                        
                        if cv > max_polies then cv = max_polies
                        if cvn > max_polies then cvn = max_polies
                        if cvt > max_polies then cvt = max_polies
                        dataset->geometry(cobj,f).x(ind) = verts(cv, 0)
                        dataset->geometry(cobj,f).y(ind) = verts(cv, 1)
                        dataset->geometry(cobj,f).z(ind) = verts(cv, 2)
                        dataset->geometry(cobj,f).nx(ind) = norms(cvn, 0)
                        dataset->geometry(cobj,f).ny(ind) = norms(cvn, 1)
                        dataset->geometry(cobj,f).nz(ind) = norms(cvn, 2)
                        dataset->geometry(cobj,f).u(ind) = texts(cvt, 0)
                        dataset->geometry(cobj,f).v(ind) = texts(cvt, 1)
                        dataset->geometry(cobj,f).pnt(ind) = cv
                        dataset->geometry(cobj,f).tex = 0
                        
                        dataset->geometry(cobj,f).c(ind,0) = 1'unitcolor(0)
                        dataset->geometry(cobj,f).c(ind,1) = 1'unitcolor(1)
                        dataset->geometry(cobj,f).c(ind,2) = 1'unitcolor(2)
                        
                        ind = ind + 1
                        lastloc = ff + 1
                    end if
                next
                
                dataset->geometry(cobj,f).refs = ind
                cross dataset, cobj, f
                f = f + 1
            end if
            
            dataset->lastindex(cobj) = f - 1
        wend
        
    close #1
    
   
    
end sub

sub load_texture (texFil$, tex as gluint)
    
    'create a temperary sdl surface to load the image to
    dim tempimg as sdl_surface ptr
    
    'load the image
    tempimg = IMG_LOAD(texFil$)
    
    'create the texture space
    glGenTextures 1, @tex
    
    'pick our texture to bind to
    glBindTexture GL_TEXTURE_2D, tex
    
    'set the texture information
    glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR
    glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR
    glTexImage2D GL_TEXTURE_2D, 0, GL_RGB, tempimg->w, tempimg->h, 0, GL_RGB, GL_UNSIGNED_BYTE, tempimg->pixels
    
    'free the surface from memory
    SDL_FreeSurface tempimg
    
    
end sub

sub load_textureAlpha (texFil$, tex as gluint)
    
    'the reason this routine is different from above is because glTexImage2d will use the Alpha channel also (GL_RGBA)
    
    'create a temperary sdl surface to load the image to
    dim tempimg as sdl_surface ptr
    
    'load the image
    tempimg = IMG_LOAD(texFil$)
    
    'create the texture space
    glGenTextures 1, @tex
    
    'pick our texture to bind to
    glBindTexture GL_TEXTURE_2D, tex
    
    'set the texture information
    glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR
    glTexParameteri GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR
    glTexImage2D GL_TEXTURE_2D, 0, GL_RGBA, tempimg->w, tempimg->h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tempimg->pixels
    
    'free the surface from memory
    SDL_FreeSurface tempimg
    
    
end sub

sub rotpnt (x1!, y1!, z1!, rotx!, roty!, rotz!, nx!, ny!, nz!)
    
    rx! = 3.141592 / 180 * rotx!
    ry! = 3.141592 / 180 * roty!
    rz! = 3.141592 / 180 * rotz!
    
    'x
    nx1! = x1!
    ny1! = z1! * sin(rx!) + y1! * cos(rx!)
    nz1! = z1! * cos(rx!) - y1! * sin(rx!)

    'y
    nx2! = nx1! * cos(ry!) - nz1! * sin(ry!)
    ny2! = ny1!
    nz2! = nx1! * sin(ry!) + nz1! * cos(ry!)
   
    'z
    nx3! = nx2! * cos(rz!) - ny2! * sin(rz!)
    ny3! = nx2! * sin(rz!) + ny2! * cos(rz!)
    nz3! = nz2!

    nx! = nx3!
    ny! = ny3!
    nz! = nz3!
    
end sub

sub selectRes ()
    
    screen 15,,2
    
    line (0,0) - (399,299), 7, bf
    
    color 15,7
    
    out &h3c8, 9
    out &h3c9, 16
    out &h3c9, 24
    out &h3c9, 48
    
    out &h3c8, 8
    out &h3c9, 32
    out &h3c9, 32
    out &h3c9, 32
    
    dim list(200) as glfwvidmode
    
    if glfwInit <> GL_TRUE then 
        print "could not init"
        end 1
    end if
    
    d = glfwGetVideoModes(@list(0), 200)
    
    
    apage = 0
    bpage = 1
    
    open "selres.dat" for input as #1
    input #1, SCR_WIDTH
    input #1, SCR_HEIGHT
    input #1, SCR_BITS
    input #1, fullscreen
    input #1, linesmoothing
    close #1
    
    for i = 0 to d - 1
        if SCR_WIDTH = list(i).Width and SCR_HEIGHT = list(i).Height and SCR_BITS = (list(i).RedBits + list(i).GreenBits + list(i).BlueBits) then sel = i
    next
    
    do
        swap apage, bpage
        screenset apage, bpage
        
        cls
        
        color 15,7
        
        st$ = "Select Resolution"
        
        locate 3, 25 - len(st$) / 2: print st$
        rone = 7
        row = rone
        col = 10
        for i = 0 to d - 1
            
            st$ = ltrim$(rtrim$(str$(list(i).Width)))
            st$ += "x"
            st$ += ltrim$(rtrim$(str$(list(i).Height)))
            st$ += "x"
            st$ += ltrim$(rtrim$(str$(list(i).RedBits + list(i).GreenBits + list(i).BlueBits)))
            
            color 8,7
            if sel = i then color 9,7
            if hover = i then color 15, 7
            
            if i = d / 2 then
                row = rone
                col = 30
            end if
            
            locate row, col:print st$
            
            getmouse x,y,,buttons
            
            x0 = (col - 1) * 8 - 12 + 1
            y0 = (row - 1)* 8 + 1
            x1 = x0 + 5
            y1 = y0 + 5
            
            c = 8
            if sel = i then c = 9
            if hover = i then c = 15
            line (x0,y0) - (x1, y1), 8, b
            if c <> 8 then line (x0+1,y0+1) - (x1-1, y1-1), c, bf
            
            
            x0 = (col - 1) * 8
            y0 = (row - 1)* 8
            x1 = x0 + len(st$) * 8 - 1
            y1 = y0 + 7
            
            if x >= x0 and x <= x1 and y >= y0 and y <= y1 then
                hover = i
                if buttons and 1 then sel = hover
            end if
            
            'line (x0,y0) - (x1, y1), 8,b
            row = row + 1
        next
        
        st$ = "Full Screen"
        bx = 25 - len(st$) / 2
        by = d / 2 + rone  + 3
        
        x2 = (bx - 1) * 8 - 12 + 1
        y2 = (by - 1)* 8 + 1
        x3 = x2 + 5
        y3 = y2 + 5
        
        line (x2,y2) - (x3, y3), 8, b
        
        x0 = (bx - 1) * 8
        x1 = x0 + (len(st$) + 2)  * 8
        y0 = (by - 1) * 8
        y1 = y0 + 7
        
        c = 8
        if fullscreen = 1 then c = 9
        if x >= x0 and x <= x1 and y >= y0 and y <= y1 and tim# < timer then
            c = 15
            if (buttons and 1) then
                fullscreen = 1 - fullscreen
                tim# = timer + 1
            end if
        end if
        
        color c, 7
        if c <> 8 then line (x2 + 1,y2 + 1) - (x3 - 1, y3 - 1), c, bf
        locate by, bx:print st$
        
        st$ = "Line Smoothing"
        bx = 25 - len(st$) / 2
        by = d / 2 + rone  + 5
        
        x2 = (bx - 1) * 8 - 12 + 1
        y2 = (by - 1)* 8 + 1
        x3 = x2 + 5
        y3 = y2 + 5
        
        line (x2,y2) - (x3, y3), 8, b
        
        x0 = (bx - 1) * 8
        x1 = x0 + (len(st$) + 2)  * 8
        y0 = (by - 1) * 8
        y1 = y0 + 7
        
        c = 8
        if linesmoothing = 1 then c = 9
        if x >= x0 and x <= x1 and y >= y0 and y <= y1 and tim# < timer then
            c = 15
            if (buttons and 1) then
                linesmoothing = 1 - linesmoothing
                tim# = timer + 1
            end if
        end if
        
        color c, 7
        if c <> 8 then line (x2 + 1,y2 + 1) - (x3 - 1, y3 - 1), c, bf
        locate by, bx:print st$
        'line (x0,y0) - (x1,y1), c, b    
        
        
        st$ = "Continue"
        bx = 25 - len(st$) / 2
        by = d / 2 + 15
        
        x0 = (bx - 2) * 8
        x1 = x0 + (len(st$) + 2)  * 8
        y0 = (by - 2) * 8
        y1 = y0 + 3 * 8
        
        c = 8
        if x >= x0 and x <= x1 and y >= y0 and y <= y1 then
            c = 15
            if buttons and 1 then exit do
        end if
        color c, 7
        locate by, bx:print st$
        line (x0,y0) - (x1,y1), c, b    
        
        if multikey(&h1) then 
            SDL_Quit
            glfwTerminate
            end
        end if
        if multikey(&h1c) then exit do
        osel = sel
        if waitticks < ticks then
            if multikey(&h4B) then sel = sel - d / 2
            if multikey(&h4D) then sel = sel + d / 2
            if multikey(&h48) then sel = sel - 1
            if multikey(&h50) then sel = sel + 1
        end if
        
        if osel <> sel then waitticks = ticks + 150
        
        if sel < 0 then sel = sel + d
        if sel > d - 1 then sel = sel - d
        
        ticks = SDL_GetTicks
    loop
    
    SCR_WIDTH = list(sel).Width
    SCR_HEIGHT = list(sel).Height
    SCR_BITS = list(sel).RedBits + list(sel).GreenBits + list(sel).BlueBits
    if fullscreen = 1 then SDL_FLAGS = SDL_FLAGS OR SDL_FULLSCREEN
    
    glfwTerminate
    screen 0
    
    open "selres.dat" for output as #1
    print #1, SCR_WIDTH
    print #1, SCR_HEIGHT
    print #1, SCR_BITS
    print #1, fullscreen
    print #1, linesmoothing
    close #1

end sub

sub smoothnormals (dataset as objectInfo ptr, group as byte)
    
    dim nx!, ny!, nz!
    dim curpoly, chkpoly, nshared
    dim smoothed(MAX_POLIES, 3), pnt(4,2) as single
    dim sharedvertex(MAX_POLIES, 1)
    dim a,b
    
    cobj = 0
    
    'for cobj = 0 to nobj
        for a = 0 to dataset->lastindex(cobj)
            for b = 0 to 2
                smoothed(a,b) = 0
            next
        next
        
        for curpoly = 0 to dataset->lastindex(cobj)
            if dataset->geometry(cobj, curpoly).smoothingGroup = group then
                refs = dataset->geometry(cobj, curpoly).refs
                for cvert = 0 to refs - 1
                    a = cvert
                    b = a + 1
                    c = a - 1
                    if b >= refs then b -= refs
                    if c <= -1 then c += refs
                    
                    pnt(0,0) = dataset->geometry(0,curpoly).x(cvert)
                    pnt(0,1) = dataset->geometry(0,curpoly).y(cvert)
                    pnt(0,2) = dataset->geometry(0,curpoly).z(cvert)
                    pnt(1,0) = dataset->geometry(0,curpoly).x(b)
                    pnt(1,1) = dataset->geometry(0,curpoly).y(b)
                    pnt(1,2) = dataset->geometry(0,curpoly).z(b)
                    pnt(2,0) = dataset->geometry(0,curpoly).x(c)
                    pnt(2,1) = dataset->geometry(0,curpoly).y(c)
                    pnt(2,2) = dataset->geometry(0,curpoly).z(c)
                    
                    cross2 pnt(0,0), pnt(0,1), pnt(0,2), pnt(1, 0), pnt(1, 1), pnt(1, 2), pnt(2, 0), pnt(2, 1), pnt(2, 2), nx!, ny!, nz!
                
                    dataset->geometry(0,curpoly).nx(cvert) = nx!
                    dataset->geometry(0,curpoly).ny(cvert) = ny!
                    dataset->geometry(0,curpoly).nz(cvert) = nz!
                next
            end if
        next    
            
        for curpoly = 0 to dataset->lastindex(cobj)
            if dataset->geometry(cobj, curpoly).smoothingGroup = group then
                refs = dataset->geometry(cobj, curpoly).refs
                for cvert = 0 to refs - 1
                    
                    if smoothed(curpoly, cvert) = 0 then
                        
                        nx! = 0
                        ny! = 0
                        nz! = 0
                        
                        nshared = 0
                        
                        x0! = dataset->geometry(cobj, curpoly).x(cvert)
                        y0! = dataset->geometry(cobj, curpoly).y(cvert)
                        z0! = dataset->geometry(cobj, curpoly).z(cvert)
                        
                        for chkpoly = 0 to dataset->lastindex(cobj)
                            if dataset->geometry(cobj, chkpoly).smoothingGroup = group then
                                refs2 = dataset->geometry(cobj, chkpoly).refs
                                for cvert2 = 0 to refs2 - 1
                                    if smoothed(chkpoly, cvert2) = 0 then
                                        ofs! = .001
                                        x1! = dataset->geometry(cobj, chkpoly).x(cvert2)
                                        y1! = dataset->geometry(cobj, chkpoly).y(cvert2)
                                        z1! = dataset->geometry(cobj, chkpoly).z(cvert2)
                                        
                                        if x1! > x0! - ofs! and x1! < x0! + ofs! then
                                            if y1! > y0! - ofs! and y1! < y0! + ofs! then
                                                if z1! > z0! - ofs! and z1! < z0! + ofs! then
                                                    nx! += dataset->geometry(cobj, chkpoly).nx(cvert2)
                                                    ny! += dataset->geometry(cobj, chkpoly).ny(cvert2)
                                                    nz! += dataset->geometry(cobj, chkpoly).nz(cvert2)
                                                    sharedvertex(nshared, 0) = chkpoly
                                                    sharedVertex(nshared, 1) = cvert2
                                                    nshared += 1
                                                end if
                                            end if
                                        end if
                                    end if
                                next
                            end if
                        next
                        
                        nx! /= nshared
                        ny! /= nshared
                        nz! /= nshared
                        
                        for sharedpoly = 0 to nshared - 1
                            poly = sharedvertex(sharedpoly, 0)
                            vert = sharedvertex(sharedpoly, 1)
                            
                            dataset->geometry(cobj, poly).nx(vert) = nx!
                            dataset->geometry(cobj, poly).ny(vert) = ny!
                            dataset->geometry(cobj, poly).nz(vert) = nz!
                            smoothed(poly, vert) = 1
                            
                        next
                        
                        
                    end if
                    
                next
            end if
        next
        
    
    
end sub


sub sphere2cartesian (radius!, height!, x!, y!, z!, an1!, an2!)
    
    f! = radius! * sin(rad * an1!)
    y! = height! * cos(rad * an1!)
    z! = f! * cos(rad * an2!)
    x! = f! * sin(rad * an2!)
    
    
end sub

function u! (an!)
    a! = an!
    while a! >= 360: a! = a! - 360: wend
    while a! <= -1: a! = a! + 360:wend
        
    u! = a!
    
end function
