' BRICKO!                                                      Davey Taylor
'                                                                  99 02 17
'
' Hey! Finally got network support working! :)
'
' If you have any problems, please contact me at
' logiclord@swipnet.se

'$DYNAMIC
DECLARE SUB IPXSend (SSock%, PData$, DAddr$, DSock%)   '// Network routs
DECLARE SUB IPXWork ()
DECLARE SUB IPXCloseSocket (Socket%)
DECLARE FUNCTION IPXCancelL% ()
DECLARE FUNCTION IPXListen% (Socket%)
DECLARE FUNCTION IPXGetAdress$ ()
DECLARE FUNCTION IPXInstalled% ()
DECLARE FUNCTION IPXOpenSocket% (Socket%)

DECLARE SUB SBDeinit ()                        '// SFX routs
DECLARE SUB SBBlaster (DMA%, ADR%, IRQ%)
DECLARE SUB SBSnd (SNum%)
DECLARE SUB SBWrite (DSPD%)
DECLARE FUNCTION SBReset% ()

DECLARE SUB MouseGStat (B%, X%, Y%)         '// Mouse routs
DECLARE SUB MouseSpeed (X%, Y%)
DECLARE SUB MouseLimit (X%, Y%, H%, V%)
DECLARE SUB MouseReset ()
DECLARE SUB MouseHide ()
DECLARE SUB MouseShow ()
DECLARE SUB Mouse (AX%, BX%, cx%, dx%)
DECLARE FUNCTION MouseActive% ()

DECLARE SUB FLC (row%, col%)                '// Font Locate
DECLARE SUB FPR (fz%, text$)                '// Font Print

DECLARE SUB TFX ()                          '// Title effects

DEFINT A-Z

TYPE RegTypeX
 AX AS INTEGER: BX AS INTEGER: cx AS INTEGER: dx AS INTEGER: bp AS INTEGER
 si AS INTEGER: di AS INTEGER: cf AS INTEGER: ds AS INTEGER: es AS INTEGER
END TYPE

TYPE ECBt                   '// ECB (Event Control Block)
 LinkOfs AS INTEGER: LinkSeg AS INTEGER
 ESROfs AS INTEGER: ESRSeg AS INTEGER
 InUseF AS STRING * 1: CompnC AS STRING * 1
 Socket AS INTEGER
 IPXWSpace AS STRING * 4: DrvWSpace AS STRING * 12
 LocalNode AS STRING * 6
 Fragments AS INTEGER
 FragOfs AS INTEGER: FragSeg AS INTEGER
 FragSize AS INTEGER
END TYPE

TYPE IPXt                   '// IPX (Packet eXchange)
 Checksum AS INTEGER: Length AS INTEGER
 Control AS STRING * 1: PType AS STRING * 1
 DestAddr AS STRING * 10: DestSock AS INTEGER
 SrceAddr AS STRING * 10: SrceSock AS INTEGER
 PData AS STRING * 1024
END TYPE

TYPE HiST                   '// HiScore
 PName AS STRING * 20
 PScore AS INTEGER
END TYPE

CONST False = 0, True = NOT False
CONST GID = 14              '// Game ID

DIM BN(361, 4) AS INTEGER   '// Block ON
DIM BF(361, 4) AS INTEGER   '// Block OFF
DIM SN(91, 4)  AS INTEGER   '// Snapp ON
DIM SF(91, 4)  AS INTEGER   '// Snapp OFF
DIM BB(361, 7) AS INTEGER   '// Block Border
DIM LA(29, 17) AS INTEGER   '// Local Area
DIM RA(29, 14) AS INTEGER   '// Remote Area
DIM BA(29, 17) AS INTEGER   '// Backup Area
DIM PL(15, 2) AS INTEGER    '// Palette
DIM HI(7) AS HiST           '// HiScores

DIM SHARED TL(91, 91) AS INTEGER         '// Title
DIM SHARED FD(65, 91) AS INTEGER         '// Font
DIM SHARED FR AS INTEGER, FC AS INTEGER  '// Current Position
                                    
DIM SHARED Regs AS RegTypeX              '// ASM Registers

DIM SHARED ECBs AS ECBt, ECBr AS ECBt             '// Variables needed by
DIM SHARED IPXs AS IPXt, IPXr AS IPXt             '// IPX Communiation routs

DIM SHARED SB                                     '// Variables needed by
DIM SHARED SBD, SBA, SBI                          '// SoundBlaster routs
DIM SHARED SBPP, SBAP, SBLP

PRINT "Loading...";

IF NOT MouseActive THEN
 PRINT
 PRINT "No mousedriver!"
 END
END IF

OPEN "bricko.sfx" FOR BINARY ACCESS READ AS #1
X$ = CHR$(0)
GET #1, , X$
DIM SHARED SndDat(ASC(X$)) AS STRING
FOR N = 0 TO ASC(X$)
 GET #1, , Z
 SndDat(N) = SPACE$(Z)
 GET #1, , SndDat(N)
NEXT N
CLOSE #1

'// Read HiScores
OPEN "BRICKO.HI" FOR BINARY ACCESS READ AS #1
FOR N = 0 TO 7
 GET #1, , HI(N)
NEXT N
CLOSE #1

'// Generate new random seed
RANDOMIZE TIMER

SB = True

SBBlaster SBD, SBA, SBI                           '// Get BLASTER
SELECT CASE SBD                                   '// Select Ports
 CASE 0: SBPP = &H87: SBAP = &H0: SBLP = &H1
 CASE 1: SBPP = &H83: SBAP = &H2: SBLP = &H3
 CASE 3: SBPP = &H82: SBAP = &H6: SBLP = &H7
 CASE ELSE: SB = False
END SELECT
IF SBReset = 0 THEN SB = False                   '// Reset the DSP

'// Set screenmode
SCREEN 12

'// Clear palette
FOR N = 0 TO 15
 OUT &H3C7, N: OUT &H3C8, N
 OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
NEXT N

OPEN "bricko.gfx" FOR BINARY ACCESS READ AS #1    '// Read GFX (dirty way)

X$ = SPACE$(180)                             '// Read title
FOR Y = 0 TO 91
 GET #1, , X$
 FOR X = 0 TO 179
  PSET (X, 0), ASC(MID$(X$, X + 1, 1))
 NEXT X
 GET (0, 0)-(179, 0), TL(0, Y)
NEXT Y

X$ = SPACE$(100)                             '// Read borders
FOR Y = 0 TO 99
 GET #1, , X$
 FOR X = 0 TO 99
  PSET (X, Y), ASC(MID$(X$, X + 1, 1))
 NEXT X
NEXT Y
GET (0, 0)-(19, 19), BB(0, 0): GET (20, 0)-(79, 19), BB(0, 1)
GET (80, 0)-(99, 19), BB(0, 2): GET (0, 20)-(19, 79), BB(0, 3)
GET (80, 20)-(99, 79), BB(0, 4): GET (0, 80)-(19, 99), BB(0, 5)
GET (20, 80)-(79, 99), BB(0, 6): GET (80, 80)-(99, 99), BB(0, 7)

X$ = SPACE$(140)                             '// Read bricks
FOR Y = 0 TO 79
 GET #1, , X$
 FOR X = 0 TO 139
  PSET (X, Y), ASC(MID$(X$, X + 1, 1))
 NEXT X
NEXT Y
GET (40, 0)-(59, 19), BN(0, 0): GET (60, 0)-(79, 19), BF(0, 0)
GET (40, 20)-(59, 59), BN(0, 1): GET (60, 20)-(79, 59), BF(0, 1)
GET (0, 0)-(19, 59), BN(0, 2): GET (20, 0)-(39, 59), BF(0, 2)
GET (0, 60)-(39, 79), BN(0, 3): GET (40, 60)-(79, 79), BF(0, 3)
GET (80, 0)-(139, 19), BN(0, 4): GET (80, 20)-(139, 39), BF(0, 4)

X$ = SPACE$(35)                              '// Read net bricks
FOR Y = 0 TO 19
 GET #1, , X$
 FOR X = 0 TO 34
  PSET (X, Y), ASC(MID$(X$, X + 1, 1))
 NEXT X
NEXT Y
GET (10, 0)-(14, 4), SN(0, 0): GET (15, 0)-(19, 4), SF(0, 0)
GET (10, 5)-(14, 14), SN(0, 1): GET (15, 5)-(19, 14), SF(0, 1)
GET (0, 0)-(4, 14), SN(0, 2): GET (5, 0)-(9, 14), SF(0, 2)
GET (0, 15)-(9, 19), SN(0, 3): GET (10, 15)-(19, 19), SF(0, 3)
GET (20, 0)-(34, 4), SN(0, 4): GET (20, 5)-(34, 9), SF(0, 4)

X$ = SPACE$(28)                              '// Read font
FOR Z = 0 TO 45
 FOR Y = 0 TO 15
  GET #1, , X$
  FOR X = 0 TO 27
   PSET (X, Y), ASC(MID$(X$, X + 1, 1))
  NEXT X
 NEXT Y
 GET (0, 0)-(13, 15), FD(0, Z)
 GET (14, 0)-(27, 15), FD(0, Z + 46)
NEXT Z

CLOSE #1

'// Read Palette
OPEN "bricko.pal" FOR BINARY ACCESS READ AS #1
X$ = CHR$(0)
FOR N = 0 TO 15
 GET #1, , X$: PL(N, 0) = ASC(X$) \ 4
 GET #1, , X$: PL(N, 1) = ASC(X$) \ 4
 GET #1, , X$: PL(N, 2) = ASC(X$) \ 4
NEXT N
CLOSE #1

NotFirst = False

StartOver:

IF NotFirst THEN
 '// Fadeout Palette
 FOR X = 49 TO 0 STEP -1
  WAIT &H3DA, 8
  FOR N = 0 TO 15
   OUT &H3C7, N: OUT &H3C8, N
   FOR Z = 0 TO 2
    OUT &H3C9, PL(N, Z) / 49 * X
   NEXT Z
  NEXT N
 NEXT X
ELSE
 NotFirst = True
END IF

CLS

'// Clear palette
FOR N = 0 TO 15
 OUT &H3C7, N: OUT &H3C8, N
 OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
NEXT N

TFX

FLC 0, 0: FPR 1, "V"
FPR 0, LTRIM$(STR$(GID \ 20)) + "." + LTRIM$(STR$(GID \ 2 MOD 10))
IF NOT GID AND 1 THEN FLC 1, 0: FPR 0, "Beta"


FLC 9, 0: FPR 1, "New Game: Single or Multiplayer?"
FLC 9, 33
IF MultiGame THEN FPR 0, ":Multi! " ELSE FPR 0, ":Single!"

'// Fadein Palette
FOR X = 0 TO 49
 WAIT &H3DA, 8
 FOR N = 0 TO 15
  OUT &H3C7, N: OUT &H3C8, N
  FOR Z = 0 TO 2
   OUT &H3C9, PL(N, Z) / 49 * X
  NEXT Z
 NEXT N
NEXT X

WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer

DO
 TFX
 SELECT CASE INKEY$
  CASE "S", "s": MultiGame = False
  CASE "M", "m": MultiGame = True
  CASE CHR$(0) + "K", CHR$(0) + "M", CHR$(0) + "H", CHR$(0) + "P"
   MultiGame = NOT MultiGame
  CASE CHR$(13): EXIT DO
  CASE CHR$(27): GOTO Quit
 END SELECT
 FLC 9, 33
 IF MultiGame THEN FPR 0, ":Multi! " ELSE FPR 0, ":Single!"
LOOP

IF MultiGame THEN

 IF IPXInstalled = False THEN
  FLC 11, 0: FPR 1, "IPX not installed! Press ": FPR 0, "ENTER!"
  MultiGame = False
  DO
   TFX
   SELECT CASE INKEY$
    CASE CHR$(13): GOTO StartOver
    CASE CHR$(27): GOTO Quit
   END SELECT
  LOOP
 END IF

 MyAddr$ = IPXGetAdress                        '// This Node
 EnAddr$ = STRING$(4, &H0) + STRING$(6, &HFF)  '// Nearest Network
                                     
 '// Setup ECB send block
 ECBs.ESROfs = 0: ECBs.ESRSeg = 0     '// Don't use an ESR
 ECBs.LocalNode = STRING$(6, &HFF)    '// Nearest network
 ECBs.Fragments = 1                   '// Send 1 fragments
 ECBs.FragSeg = VARSEG(IPXs)          '// Fragment location
 ECBs.FragOfs = VARPTR(IPXs)
                                     
 '// Setup ECB recieve block
 ECBr.ESROfs = 0: ECBr.ESRSeg = 0     '// Don't use an ESR
 ECBr.LocalNode = STRING$(6, &HFF)    '// Nearest network
 ECBr.Fragments = 1                   '// Recieve 1 fragments
 ECBr.FragSeg = VARSEG(IPXr)          '// Fragment location
 ECBr.FragOfs = VARPTR(IPXr)
                                     
 '// Setup IPX send fragment
 IPXs.PType = CHR$(4)                 '// Packet exchange
 IPXs.SrceAddr = MyAddr$

 FLC 11, 0: FPR 1, "Multiplayer: Host or Client?"
 DO
  TFX
  SELECT CASE INKEY$
   CASE "H", "h": MultiMode = False
   CASE "C", "c": MultiMode = True
   CASE CHR$(0) + "K", CHR$(0) + "M", CHR$(0) + "H", CHR$(0) + "P"
    MultiMode = NOT MultiMode
   CASE CHR$(13): EXIT DO
   CASE CHR$(27): GOTO Quit
  END SELECT
  FLC 11, 33
  IF MultiMode THEN
   FPR 0, ":Host!  "
  ELSE
   FPR 0, ":Client!"
  END IF
 LOOP

 FLC 13, 0: FPR 1, "Multiplayer: Choose Game Type!"
 IF MultiMode THEN
  DO
   TFX
   SELECT CASE INKEY$
    CASE CHR$(0) + "M", CHR$(0) + "P"
     MultiTypeS = (MultiTypeS + 1) MOD 7
    CASE CHR$(0) + "H", CHR$(0) + "K"
     MultiTypeS = MultiTypeS - 1
     IF MultiTypeS < 0 THEN MultiTypeS = 6
    CASE CHR$(13): EXIT DO
    CASE CHR$(27): GOTO Quit
   END SELECT
   FLC 13, 33
   SELECT CASE MultiTypeS
    CASE 0: FPR 0, ":Ordinary"
    CASE 1: FPR 0, ":30 sec! "
    CASE 2: FPR 0, ":1 min!  "
    CASE 3: FPR 0, ":2 min!  "
    CASE 4: FPR 0, ":3 min!  "
    CASE 5: FPR 0, ":4 min!  "
    CASE 6: FPR 0, ":5 min!  "
   END SELECT
  LOOP
 ELSE
  FLC 13, 33: FPR 1, ":Client!"
 END IF

 FLC 15, 0: FPR 1, "Multiplayer: IPX socket?"
 IF MultiMode THEN FLC 16, 0: FPR 1, "Press ENTER for random!"
 FLC 15, 33: FPR 0, ":"
 FLC 15, 34
 SNI$ = ""
 DO
  TFX
  I$ = UCASE$(INKEY$)
  SELECT CASE I$
   CASE "0" TO "9", "A" TO "F"
    IF LEN(SNI$) < 3 THEN
     IF SNI$ = "FF" AND I$ = "F" THEN I$ = "E"
     SNI$ = SNI$ + I$
     FPR 0, I$
    END IF
   CASE CHR$(8)
    IF LEN(SNI$) > 0 THEN
     SNI$ = LEFT$(SNI$, LEN(SNI$) - 1)
     FLC FR, FC - 1: FPR 0, " ": FLC FR, FC - 1
    END IF
   CASE CHR$(13)
    IF SNI$ = "" THEN
     IF MultiMode THEN
      SNI$ = HEX$(INT(RND * 4095))
      FPR 0, SNI$
     END IF
    ELSE
     ISock = VAL("&H" + SNI$)
     EXIT DO
    END IF
   CASE CHR$(27): GOTO Quit
  END SELECT
 LOOP

 IF IPXOpenSocket(&H4000 + ISock) < 1 THEN
  FLC 17, 0: FPR 1, "Error opening IPX socket! Press ": FPR 0, "ENTER!"
  DO
   TFX
   SELECT CASE INKEY$
    CASE CHR$(13): GOTO StartOver
    CASE CHR$(27): GOTO Quit
   END SELECT
  LOOP
 END IF
 IF IPXOpenSocket(&H4001 + ISock) < 1 THEN
  IPXCloseSocket (&H4000 + ISock)
  FLC 17, 0: FPR 1, "Error opening IPX socket! Press ": FPR 0, "ENTER!"
  DO
   TFX
   SELECT CASE INKEY$
    CASE CHR$(13): GOTO StartOver
    CASE CHR$(27): GOTO Quit
   END SELECT
  LOOP
 END IF

 IF MultiMode THEN                                      '// Create connection
  FLC 18, 0: FPR 1, "Waiting for client... "
  DO
   TFX
   IF ECBr.InUseF = CHR$(0) THEN                        '// Data recieved
    IF LEFT$(IPXr.PData, 4) = "ZBCL" THEN               '// Client looking
     IF MID$(IPXr.PData, 5, 2) = MKI$(GID) THEN         '// Version check
      FPR 0, "Found!"
      ReAddr$ = IPXr.SrceAddr
      LTr$ = "ZBIG" + CHR$(MultiTypeS)
      IPXSend &H4001 + ISock, LTr$, ReAddr$, &H4001 + ISock
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
      EXIT DO
     ELSE
      IPXSend &H4001 + ISock, "ZBIG" + CHR$(&HFF), IPXr.SrceAddr, &H4001 + ISock
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     END IF
    END IF
    IF IPXListen(&H4000 + ISock) > 0 THEN GOTO NetErr
   END IF
   IF INKEY$ = CHR$(27) THEN
    IF IPXCancelL > 0 THEN GOTO NetErrC
    IPXCloseSocket &H4000 + ISock
    IPXCloseSocket &H4001 + ISock
    FPR 0, "Aborted! Press ": FPR 1, "ENTER!"
    DO
     SELECT CASE INKEY$
      CASE CHR$(13): GOTO StartOver
      CASE CHR$(27): GOTO Quit
     END SELECT
    LOOP
   END IF
   IPXWork
  LOOP
 ELSE
  FLC 17, 0: FPR 1, "Looking for host... "
  S! = TIMER: ST! = S!
  N = True
  DO
   TFX
   IF ST! > .2 THEN
    ST! = TIMER
    IPXSend &H4000 + ISock, "ZBCL" + MKI$(GID), EnAddr$, &H4000 + ISock
    WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
   END IF
   IF ECBr.InUseF = CHR$(0) THEN                        '// Data recieved
    IF LEFT$(IPXr.PData, 4) = "ZBIG" THEN               '// Initialize
     MultiTypeS = ASC(MID$(IPXr.PData, 5, 1))
     IF MultiTypeS < 7 THEN
      FPR 0, "Found!"
      ReAddr$ = IPXr.SrceAddr
      LTr$ = ""
      EXIT DO
     ELSE
      FPR 0, "Version! Press ": FPR 1, "ENTER!"
      IPXCloseSocket &H4000 + ISock
      IPXCloseSocket &H4001 + ISock
      DO
       TFX
       SELECT CASE INKEY$
        CASE CHR$(13): GOTO StartOver
        CASE CHR$(27): GOTO Quit
       END SELECT
      LOOP
     END IF
    END IF
    IF IPXListen(&H4001 + ISock) > 0 THEN GOTO NetErr
   END IF
   I$ = INKEY$
   IF ABS(TIMER - S!) >= 2 OR I$ = CHR$(27) THEN
    IF N = True AND I$ <> CHR$(27) THEN
     N = False
     S! = TIMER
    ELSE
     FPR 0, "Not Found! Press ": FPR 1, "ENTER!"
     IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
     IPXCloseSocket &H4000 + ISock
     IPXCloseSocket &H4001 + ISock
     DO
      TFX
      SELECT CASE INKEY$
       CASE CHR$(13): GOTO StartOver
       CASE CHR$(27): GOTO Quit
      END SELECT
     LOOP
    END IF
   END IF
   IPXWork
  LOOP
 END IF
END IF

Games = 0
Won = 0
Lost = 0
LNB& = 0
RNB& = 0

GameStart:

SELECT CASE MultiTypeS               '// Choose timer
 CASE 1: TimeL = 300
 CASE 2: TimeL = 600
 CASE 3: TimeL = 1200
 CASE 4: TimeL = 1800
 CASE 5: TimeL = 2400
 CASE 6: TimeL = 3000
END SELECT
IF MultiTypeS THEN MultiType = True ELSE MultiType = False

NPack = 0

FOR X = 49 TO 0 STEP -1              '// Palette fadeout
 WAIT &H3DA, 8
 FOR N = 0 TO 15
  OUT &H3C7, N: OUT &H3C8, N
  FOR Z = 0 TO 2
   OUT &H3C9, PL(N, Z) / 49 * X
  NEXT Z
 NEXT N
NEXT X

CLS

MouseReset
MouseSpeed 16, 16
MouseLimit 0, 0, 639, 479

'// Clear Areas
FOR Y = 0 TO 17
 FOR X = 0 TO 29
  LA(X, Y) = 0
  IF Y < 15 THEN RA(X, Y) = 0
 NEXT X
NEXT Y

IF MultiGame THEN
 BX = 20: BY = 70: GH = 29
 GV = 14: UX = 24: UY = 400
 LINE (UX - 2, UY - 2)-(UX + 151, UY + 76), 14, B
ELSE
 BX = 20: BY = 90: GH = 29: GV = 17
END IF

FOR Y = 0 TO GV
 FOR X = 0 TO GH
  PUT (BX + X * 20, BY + Y * 20), BF(0, 0), PSET
  IF MultiGame THEN PUT (UX + X * 5, UY + Y * 5), SF(0, 0), PSET
  IF Y = 0 AND X <= GH \ 3 THEN
   PUT (BX + X * 60, BY - 20), BB(0, 1), PSET
   PUT (BX + X * 60, BY + GV * 20 + 20), BB(0, 6), PSET
  END IF
 NEXT X
 IF Y <= GV \ 3 THEN
  PUT (BX - 20, BY + Y * 60), BB(0, 3), PSET
  PUT (BX + GH * 20 + 20, BY + Y * 60), BB(0, 4), PSET
 END IF
NEXT Y
PUT (BX - 20, BY - 20), BB(0, 0), PSET
PUT (BX + GH * 20 + 20, BY - 20), BB(0, 2), PSET
PUT (BX - 20, BY + GV * 20 + 20), BB(0, 5), PSET
PUT (BX + GH * 20 + 20, BY + GV * 20 + 20), BB(0, 7), PSET

IF MultiGame THEN
 FLC 0, 0: FPR 0, "BRICKO Multiplayer Game!"
 FLC 26, 26: FPR 1, "Your Score:"
 FLC 28, 26: FPR 1, "Remote Score:"
 IF MultiType THEN
  FLC 26, 14: FPR 1, "Timer:"
 END IF
ELSE
 FLC 0, 0: FPR 0, "BRICKO Single Player Game!"
 FLC 2, 30: FPR 1, "Score:"
END IF
IF NOT MultiGame OR NOT MultiType THEN
 FLC 2, 2: FPR 1, "Press ENTER when finished! "
END IF

FOR X = 0 TO 49                         '// Palette fadein
 WAIT &H3DA, 8
 FOR N = 0 TO 15
  OUT &H3C7, N: OUT &H3C8, N
  FOR Z = 0 TO 2
   OUT &H3C9, PL(N, Z) / 49 * X
  NEXT Z
 NEXT N
NEXT X

WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer

PNZ = 0: MHD$ = ""
Score = 0: RScore = 0
Done = False: RDone = False
DO
 ST! = TIMER

 IF MultiGame AND MultiMode THEN
  IPXr.PData = ""
  IF IPXListen(&H4000 + ISock) > 0 THEN GOTO NetErr
 END IF

 MDD$ = ""
 DOK = False
 IF Done THEN GOTO DScore

 FOR Y = GV TO 0 STEP -1
  FOR X = 0 TO GH
   SELECT CASE LA(X, Y)
    CASE 1   'Z1
     IF Y < GV THEN
      IF LA(X, Y + 1) = 0 THEN
       MDD$ = MDD$ + CHR$(X) + CHR$(Y)
       LA(X, Y) = 0: LA(X, Y + 1) = 1
       PUT (BX + X * 20, BY + Y * 20), BF(0, 0), PSET
       PUT (BX + X * 20, BY + Y * 20 + 20), BN(0, 0), PSET
      END IF
     END IF
    CASE 2   'Y2
     IF Y < GV - 1 THEN
      IF LA(X, Y + 2) = 0 THEN
       MDD$ = MDD$ + CHR$(X) + CHR$(Y)
       LA(X, Y) = 0: LA(X, Y + 1) = 2: LA(X, Y + 2) = 9
       PUT (BX + X * 20, BY + Y * 20), BF(0, 1), PSET
       PUT (BX + X * 20, BY + Y * 20 + 20), BN(0, 1), PSET
      END IF
     END IF
    CASE 3   'Y3
     IF Y < GV - 2 THEN
      IF LA(X, Y + 3) = 0 THEN
       MDD$ = MDD$ + CHR$(X) + CHR$(Y)
       LA(X, Y) = 0: LA(X, Y + 1) = 3: LA(X, Y + 3) = 9
       PUT (BX + X * 20, BY + Y * 20), BF(0, 2), PSET
       PUT (BX + X * 20, BY + Y * 20 + 20), BN(0, 2), PSET
      END IF
     END IF
    CASE 4   'X2
     IF Y < GV THEN
      IF LA(X, Y + 1) + LA(X + 1, Y + 1) = 0 THEN
       MDD$ = MDD$ + CHR$(X) + CHR$(Y)
       LA(X, Y) = 0: LA(X + 1, Y) = 0
       LA(X, Y + 1) = 4: LA(X + 1, Y + 1) = 9
       PUT (BX + X * 20, BY + Y * 20), BF(0, 3), PSET
       PUT (BX + X * 20, BY + Y * 20 + 20), BN(0, 3), PSET
      END IF
     END IF
    CASE 5   'X3
     IF Y < GV THEN
      IF LA(X, Y + 1) + LA(X + 1, Y + 1) + LA(X + 2, Y + 1) = 0 THEN
       MDD$ = MDD$ + CHR$(X) + CHR$(Y)
       LA(X, Y) = 0: LA(X + 1, Y) = 0: LA(X + 2, Y) = 0
       LA(X, Y + 1) = 5: LA(X + 1, Y + 1) = 9: LA(X + 2, Y + 1) = 9
       PUT (BX + X * 20, BY + Y * 20), BF(0, 4), PSET
       PUT (BX + X * 20, BY + Y * 20 + 20), BN(0, 4), PSET
      END IF
     END IF
   END SELECT
  NEXT X
 NEXT Y

 IF PNZ THEN
  Z = PNZ - 1
  X = PNX
  SELECT CASE Z
   CASE 0
    IF LA(X, 0) = 0 THEN DOK = True
   CASE 1
    IF LA(X, 0) + LA(X, 1) = 0 THEN DOK = True
   CASE 2
    IF LA(X, 0) + LA(X, 1) + LA(X, 2) = 0 THEN DOK = True
   CASE 3
    IF LA(X, 0) + LA(X + 1, 0) = 0 THEN DOK = True
   CASE 4
    IF LA(X, 0) + LA(X + 1, 0) + LA(X + 2, 0) = 0 THEN DOK = True
  END SELECT
  IF DOK THEN
   SBSnd 0
   SELECT CASE Z
    CASE 0: LA(X, 0) = 1: Score = Score + 1
    CASE 1: LA(X, 0) = 2: LA(X, 1) = 9: Score = Score + 2
    CASE 2: LA(X, 0) = 3: LA(X, 1) = 9: LA(X, 2) = 9: Score = Score + 3
    CASE 3: LA(X, 0) = 4: LA(X + 1, 0) = 9: Score = Score + 2
    CASE 4: LA(X, 0) = 5: LA(X + 1, 0) = 9: LA(X + 2, 0) = 9: Score = Score + 3
   END SELECT
   PUT (BX + X * 20, BY), BN(0, Z), PSET
  END IF
 END IF

DScore:

 '// Display score(s)
 IF MultiGame THEN
  FLC 28, 39: FPR 0, STR$(RScore)
  IF MultiType THEN
   TimeL = TimeL - 1
   IF TimeL < 0 THEN GOTO NetScore
   FLC 26, 21: FPR 0, STR$(TimeL \ 10) + " "
  END IF
  FLC 26, 39
  NPack = (NPack + 1) MOD 256
 ELSE
  FLC 2, 36
 END IF
 FPR 0, STR$(Score)

 IF MultiGame THEN
  IF MultiMode THEN
   PS! = TIMER: N = 0: Z = True
   DO
    IF ECBr.InUseF = CHR$(0) THEN
     IF LEFT$(IPXr.PData, 5) = "ZBCT" + CHR$(NPack) AND IPXr.SrceAddr = ReAddr$ THEN
      '// HOST GOT DATA!!
    
      D = CVI(MID$(IPXr.PData, 8, 2)) - 1
      H = CVI(MID$(IPXr.PData, 12 + D * 2, 2)) - 1
     
      FOR N = 0 TO H
       X = ASC(MID$(IPXr.PData, 14 + D * 2 + N * 2, 1))
       Y = ASC(MID$(IPXr.PData, 15 + D * 2 + N * 2, 1))
       IF X AND 128 THEN
        X = X AND 127
        PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
        PUT (UX + X * 5 + 5, UY + Y * 5), SN(0, RA(X, Y) - 1), PSET
        RA(X + 1, Y) = RA(X, Y)
        RA(X, Y) = 0
       ELSE
        PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
        PUT (UX + X * 5 - 5, UY + Y * 5), SN(0, RA(X, Y) - 1), PSET
        RA(X - 1, Y) = RA(X, Y)
        RA(X, Y) = 0
       END IF
      NEXT N

      FOR N = 0 TO D
       X = ASC(MID$(IPXr.PData, 10 + N * 2, 1))
       Y = ASC(MID$(IPXr.PData, 11 + N * 2, 1))
       PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
       PUT (UX + X * 5, UY + Y * 5 + 5), SN(0, RA(X, Y) - 1), PSET
       RA(X, Y + 1) = RA(X, Y)
       RA(X, Y) = 0
      NEXT N
     
      PNZ = ASC(MID$(IPXr.PData, 6, 1))
      PNX = ASC(MID$(IPXr.PData, 7, 1))
     
      IF PNZ AND 128 THEN
       PNZ = PNZ AND 127
       RA(PNX, 0) = PNZ
       SELECT CASE PNZ
        CASE 1: RScore = RScore + 1
        CASE 2, 4: RScore = RScore + 2
        CASE 3, 5: RScore = RScore + 3
       END SELECT
       '// PUT
       PUT (UX + PNX * 5, UY), SN(0, PNZ - 1), PSET
      END IF
      EXIT DO
     ELSEIF LEFT$(IPXr.PData, 4) = "ZBCS" AND IPXr.SrceAddr = ReAddr$ THEN
      GOTO NetScore
     ELSE
      IF LEFT$(IPXr.PData, 4) = "ZBCF" AND IPXr.SrceAddr = ReAddr$ THEN
       LINE (UX - 2, UY - 2)-(UX + 151, UY + 76), 7, B
       IF Done = True THEN GOTO NetScore
       RDone = True
      END IF
      IF IPXListen(&H4000 + ISock) > 0 THEN GOTO NetErr
     END IF
    END IF
    IF ABS(TIMER - PS!) >= .2 THEN
     PS! = TIMER
     IF Z THEN
      Z = False
     ELSE
      IF N < 16 THEN
       N = N + 1: Z = True
       IPXSend &H4001 + ISock, LTr$, ReAddr$, &H4001 + ISock
       WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
      ELSE
       '// REMOTE FAILURE
       GOTO RemoteFail
      END IF
     END IF
    END IF
    IPXWork
   LOOP
  ELSE
   '// CLIENT SEND DATA!
   Z = PNZ
   IF DOK THEN Z = Z + 128
   LTr$ = "ZBCT"
   LTr$ = LTr$ + CHR$(NPack) + CHR$(Z) + CHR$(PNX)
   LTr$ = LTr$ + MKI$(LEN(MDD$) \ 2) + MDD$
   LTr$ = LTr$ + MKI$(LEN(MHD$) \ 2) + MHD$
   IPXSend &H4000 + ISock, LTr$, ReAddr$, &H4000 + ISock
   WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
  END IF
 END IF

 MHD$ = ""
 IPXr.PData = ""
 PS! = TIMER: N = 0: Z = True
 IF MultiGame THEN
  IF IPXListen(&H4001 + ISock) > 0 THEN GOTO NetErr
 END IF

 MouseShow

 DO
  MouseGStat MB, MX, MY
  IF Done THEN MB = 0
  IF MB = 1 AND LB = 0 THEN RB = 1 ELSE RB = 0
  LB = MB

  '// Mouse click
  IF RB THEN
   IF MX >= BX AND MY >= BY THEN
    IF MX < BX + GH * 20 + 20 AND MY < BY + GV * 20 + 20 THEN
     RX = (MX - BX) \ 20: RY = (MY - BY) \ 20
     IF LA(RX, RY) = 0 THEN                      '// Empty
      SBSnd 4
     ELSEIF LA(RX, RY) < 6 THEN                  '// Brick
      SBSnd 1
      IF MX - BX - ((MX - BX) \ 20) * 20 > 8 THEN BMI = True ELSE BMI = False
      OK = False
      MA = LA(RX, RY) - 1
      SELECT CASE MA + 1
       CASE 1                                    '// Z1
        IF BMI THEN
         IF RX > 0 THEN                          '// Check if far left
          IF LA(RX - 1, RY) = 0 THEN
           OK = True
           LA(RX - 1, RY) = 1
          END IF
         END IF
        ELSE
         IF RX < GH THEN                         '// Check if far right
          IF LA(RX + 1, RY) = 0 THEN
           OK = True
           LA(RX + 1, RY) = 1
          END IF
         END IF
        END IF
        IF OK THEN LA(RX, RY) = 0
       CASE 2                                    '// Y2
        IF BMI THEN
         IF RX > 0 THEN                          '// Check if far left
          IF LA(RX - 1, RY) + LA(RX - 1, RY + 1) = 0 THEN
           OK = True
           LA(RX - 1, RY) = 2: LA(RX - 1, RY + 1) = 9
          END IF
         END IF
        ELSE
         IF RX < GH THEN                         '// Check if far right
          IF LA(RX + 1, RY) + LA(RX + 1, RY + 1) = 0 THEN
           OK = True
           LA(RX + 1, RY) = 2: LA(RX + 1, RY + 1) = 9
          END IF
         END IF
        END IF
        IF OK THEN LA(RX, RY) = 0: LA(RX, RY + 1) = 0
       CASE 3                                    '// Y3
        IF BMI THEN
         IF RX > 0 THEN                          '// Check if far left
          IF LA(RX - 1, RY) + LA(RX - 1, RY + 1) + LA(RX - 1, RY + 2) = 0 THEN
           OK = True
           LA(RX - 1, RY) = 3: LA(RX - 1, RY + 1) = 9: LA(RX - 1, RY + 2) = 9
          END IF
         END IF
        ELSE
         IF RX < GH THEN                         '// Check if far right
          IF LA(RX + 1, RY) + LA(RX + 1, RY + 1) + LA(RX + 1, RY + 2) = 0 THEN
           OK = True
           LA(RX + 1, RY) = 3: LA(RX + 1, RY + 1) = 9: LA(RX + 1, RY + 2) = 9
          END IF
         END IF
        END IF
        IF OK THEN LA(RX, RY) = 0: LA(RX, RY + 1) = 0: LA(RX, RY + 2) = 0
       CASE 4                                    '// X2
        IF BMI THEN
         IF RX > 0 THEN                          '// Check if far left
          IF LA(RX - 1, RY) = 0 THEN
           OK = True
           LA(RX - 1, RY) = 4: LA(RX, RY) = 9: LA(RX + 1, RY) = 0
          END IF
         END IF
        ELSE
         IF RX < GH - 1 THEN                     '// Check if far right
          IF LA(RX + 2, RY) = 0 THEN
           OK = True
           LA(RX, RY) = 0: LA(RX + 1, RY) = 4: LA(RX + 2, RY) = 9
          END IF
         END IF
        END IF
       CASE 5                                    '// X3
        IF BMI THEN
         IF RX > 0 THEN                          '// Check if far left
          IF LA(RX - 1, RY) = 0 THEN
           OK = True
           LA(RX - 1, RY) = 5: LA(RX, RY) = 9: LA(RX + 1, RY) = 9: LA(RX + 2, RY) = 0
          END IF
         END IF
        ELSE
         IF RX < GH - 2 THEN                     '// Check if far right
          IF LA(RX + 3, RY) = 0 THEN
           OK = True
           LA(RX, RY) = 0: LA(RX + 1, RY) = 5: LA(RX + 2, RY) = 9: LA(RX + 3, RY) = 9
          END IF
         END IF
        END IF
      END SELECT
     
      MouseHide                                            '// Move brick
      IF OK THEN
       PUT (BX + RX * 20, BY + RY * 20), BF(0, MA), PSET
       IF BMI THEN
        MHD$ = MHD$ + CHR$(RX) + CHR$(RY)
        PUT (BX + RX * 20 - 20, BY + RY * 20), BN(0, MA), PSET
       ELSE
        MHD$ = MHD$ + CHR$(RX OR 128) + CHR$(RY)
        PUT (BX + RX * 20 + 20, BY + RY * 20), BN(0, MA), PSET
       END IF
      END IF
      MouseShow

     END IF
    END IF
   END IF
  END IF
 
  IF MultiGame AND NOT MultiMode THEN
   IF ECBr.InUseF = CHR$(0) THEN
    IF LEFT$(IPXr.PData, 5) = "ZBHT" + CHR$(NPack) AND IPXr.SrceAddr = ReAddr$ THEN
     '// CLIENT GOT DATA!!
     
     D = CVI(MID$(IPXr.PData, 8, 2)) - 1
     H = CVI(MID$(IPXr.PData, 12 + D * 2, 2)) - 1
    
     MouseHide
    
     FOR N = 0 TO D
      X = ASC(MID$(IPXr.PData, 10 + N * 2, 1))
      Y = ASC(MID$(IPXr.PData, 11 + N * 2, 1))
      PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
      PUT (UX + X * 5, UY + Y * 5 + 5), SN(0, RA(X, Y) - 1), PSET
      RA(X, Y + 1) = RA(X, Y)
      RA(X, Y) = 0
     NEXT N
    
     IF ASC(MID$(IPXr.PData, 6, 1)) AND 128 THEN
      RA(PNX, 0) = PNZ
      SELECT CASE PNZ
       CASE 1: RScore = RScore + 1
       CASE 2, 4: RScore = RScore + 2
       CASE 3, 5: RScore = RScore + 3
      END SELECT
      '// PUT
      PUT (UX + PNX * 5, UY), SN(0, PNZ - 1), PSET
     END IF
    
     PNZ = ASC(MID$(IPXr.PData, 6, 1)) AND 127
     PNX = ASC(MID$(IPXr.PData, 7, 1))
    
     FOR N = 0 TO H
      X = ASC(MID$(IPXr.PData, 14 + D * 2 + N * 2, 1))
      Y = ASC(MID$(IPXr.PData, 15 + D * 2 + N * 2, 1))
      IF X AND 128 THEN
       X = X AND 127
       PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
       PUT (UX + X * 5 + 5, UY + Y * 5), SN(0, RA(X, Y) - 1), PSET
       RA(X + 1, Y) = RA(X, Y)
       RA(X, Y) = 0
      ELSE
       PUT (UX + X * 5, UY + Y * 5), SF(0, RA(X, Y) - 1), PSET
       PUT (UX + X * 5 - 5, UY + Y * 5), SN(0, RA(X, Y) - 1), PSET
       RA(X - 1, Y) = RA(X, Y)
       RA(X, Y) = 0
      END IF
     NEXT N

     MouseShow

     EXIT DO
    ELSEIF LEFT$(IPXr.PData, 4) = "ZBHS" AND IPXr.SrceAddr = ReAddr$ THEN
     GOTO NetScore
    ELSE
     IF LEFT$(IPXr.PData, 4) = "ZBHF" AND IPXr.SrceAddr = ReAddr$ THEN
      LINE (UX - 2, UY - 2)-(UX + 151, UY + 76), 7, B
      IF Done = True THEN GOTO NetScore
      RDone = True
     END IF
     IF IPXListen(&H4001 + ISock) > 0 THEN GOTO NetErr
    END IF
   END IF
   IF ABS(TIMER - PS!) >= .2 THEN
    PS! = TIMER
    IF Z THEN
     Z = False
    ELSE
     IF N < 16 THEN
      N = N + 1: Z = True
      IPXSend &H4000 + ISock, LTr$, ReAddr$, &H4000 + ISock
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     ELSE
      '// REMOTE FAILURE
      GOTO RemoteFail
     END IF
    END IF
   END IF
  ELSE
   IF ABS(TIMER - ST!) >= .1 THEN EXIT DO
  END IF
  IF MultiGame THEN IPXWork
 LOOP

 IF NOT MultiGame OR MultiMode THEN
  PNZ = INT(RND * 5) + 1
  A = 0
  IF PNZ > 3 THEN A = A + 1
  IF PNZ > 4 THEN A = A + 1
  PNX = INT(RND * (GH + 1 - A))
 END IF

 IF MultiGame AND MultiMode THEN
  '// HOST SEND DATA
 
  Z = PNZ
  IF DOK THEN Z = Z OR 128
  LTr$ = "ZBHT"
  LTr$ = LTr$ + CHR$(NPack) + CHR$(Z) + CHR$(PNX)
  LTr$ = LTr$ + MKI$(LEN(MDD$) \ 2) + MDD$
  LTr$ = LTr$ + MKI$(LEN(MHD$) \ 2) + MHD$
  IPXSend &H4001 + ISock, LTr$, ReAddr$, &H4001 + ISock
  WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
 END IF
 MouseHide

 SELECT CASE INKEY$
  CASE CHR$(13)
   IF (NOT MultiGame OR NOT MultiType) AND NOT Done THEN
    SBSnd 3
    FOR Y = BY TO BY + GV * 20 + 19                          '// Darken Area
     LINE (BX + (Y AND 1), Y)-(BX + GH * 20 + 19, Y), 0, , 21845
    NEXT Y
    FLC 2, 2
    IF MultiGame THEN
     FPR 1, "Please wait...            "
     FOR N = 0 TO 4
      S! = TIMER: WHILE ABS(TIMER - S!) < .1: WEND
      IF MultiMode THEN
       IPXSend &H4001 + ISock, "ZBHF", ReAddr$, &H4001 + ISock
      ELSE
       IPXSend &H4000 + ISock, "ZBCF", ReAddr$, &H4000 + ISock
      END IF
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     NEXT N
     IF RDone THEN GOTO NetScore
     FLC 2, 2
     FPR 1, "Waiting for remote..."
     Done = True
    ELSE
     FPR 1, "Finished: ": FPR 0, "Y"                          '// Disp. Msg.
     FPR 1, "es or ": FPR 0, "N": FPR 1, "o!  Final"
     DO: I$ = UCASE$(INKEY$): LOOP UNTIL I$ = "Y" OR I$ = "N" OR I$ = CHR$(27)
     IF I$ = "Y" THEN GOTO HiScore                            '// HiScr. scrn.
     FLC 2, 2: FPR 1, "Press ENTER when finished! "
     FOR Y = 0 TO GV: FOR X = 0 TO GH                        '// Restore Area
      IF LA(X, Y) = 0 THEN
       PUT (BX + X * 20, BY + Y * 20), BF(0, 0), PSET
      ELSEIF LA(X, Y) < 6 THEN
       PUT (BX + X * 20, BY + Y * 20), BN(0, LA(X, Y) - 1), PSET
      END IF
     NEXT X: NEXT Y
     WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer
    END IF
   END IF
  CASE CHR$(27)
   S! = TIMER
   SBSnd 3
   FOR Y = BY TO BY + GV * 20 + 19                           '// Darken Area
    LINE (BX + (Y AND 1), Y)-(BX + GH * 20 + 19, Y), 0, , 21845
   NEXT Y
   FLC 2, 2
   IF MultiGame THEN                                         '// Disp. Msg.
    FPR 1, "Surrender: ": FPR 0, "Y"
   ELSE
    FPR 1, "Abort Game: ": FPR 0, "Y"
   END IF
   FPR 1, "es or ": FPR 0, "N": FPR 1, "o!     "
   DO
    I$ = UCASE$(INKEY$)
    IF MultiGame AND ABS(TIMER - S!) >= 3 THEN EXIT DO
   LOOP UNTIL I$ = "Y" OR I$ = "N" OR I$ = CHR$(27)
   IF I$ = "Y" THEN
    IF MultiGame THEN
     FLC 2, 2: FPR 1, "Please Wait...       "
     Score = 0
     FOR N = 0 TO 4
      S! = TIMER: WHILE ABS(TIMER - S!) < .1: WEND
      IF MultiMode THEN
       IPXSend &H4001 + ISock, "ZBHS", ReAddr$, &H4001 + ISock
      ELSE
       IPXSend &H4000 + ISock, "ZBCS", ReAddr$, &H4000 + ISock
      END IF
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     NEXT N
     GOTO NetScore                                         '// Display scores
    END IF
    GOTO StartOver
   END IF
   FLC 2, 2
   IF NOT MultiGame OR NOT MultiType THEN
    IF Done THEN
     FPR 1, "Waiting for remote...      "
    ELSE
     FPR 1, "Press ENTER when finished! "
    END IF
   ELSE
    FPR 1, SPACE$(27)
   END IF
   IF NOT Done THEN
    FOR Y = 0 TO GV: FOR X = 0 TO GH                       '// Restore Area
     IF LA(X, Y) = 0 THEN
      PUT (BX + X * 20, BY + Y * 20), BF(0, 0), PSET
     ELSEIF LA(X, Y) < 6 THEN
      PUT (BX + X * 20, BY + Y * 20), BN(0, LA(X, Y) - 1), PSET
     END IF
    NEXT X: NEXT Y
    WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer
   END IF
 END SELECT
 IF TimeL \ 10 <> LTime AND LTime < 21 THEN SBSnd 5
 LTime = TimeL \ 10
LOOP

NetScore:
 MouseHide

 FLC 2, 2: FPR 1, "Verifying scores...  "

 IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC

 IF MultiMode THEN                              '// Verify host scores
  S! = TIMER
  DO
   IF ECBr.InUseF = CHR$(0) THEN
    IF LEFT$(IPXr.PData, 4) = "ZBCV" AND IPXr.SrceAddr = ReAddr$ THEN
     RScore = CVI(MID$(IPXr.PData, 5, 2))
     FOR N = 0 TO 4
      S! = TIMER: WHILE ABS(TIMER - S!) < .1: WEND
      IPXSend &H4000 + ISock, "ZBHV" + MKI$(Score), ReAddr$, &H4000 + ISock
      WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     NEXT N
     EXIT DO
    ELSE
     IF IPXListen(&H4001 + ISock) > 0 THEN GOTO NetErr
    END IF
   END IF
   IPXWork
  LOOP WHILE ABS(TIMER - S!) < 4
  IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
 ELSE                                           '// Verify client scores
  S! = TIMER:  Z = 0
  DO
   IF ECBr.InUseF = CHR$(0) THEN
    IF LEFT$(IPXr.PData, 4) = "ZBHV" AND IPXr.SrceAddr = ReAddr$ THEN
     RScore = CVI(MID$(IPXr.PData, 5, 2))
     EXIT DO
    ELSE
     IF IPXListen(&H4000 + ISock) > 0 THEN GOTO NetErr
    END IF
   END IF
   IF ABS(TIMER - S!) >= .4 THEN
    IF Z = 10 THEN
     IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
     EXIT DO
    END IF
    IPXSend &H4001 + ISock, "ZBCV" + MKI$(Score), ReAddr$, &H4001 + ISock
    WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
    Z = Z + 1
   END IF
   IPXWork
  LOOP
 END IF

 FOR N = 0 TO 15                                '// White palette
  OUT &H3C7, N: OUT &H3C8, N
  OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
 NEXT N
 CLS

 TFX
 FLC 7, 15: FPR 1, "BRICKO NetScore!"

 Games = Games + 1
 IF Score > RScore THEN
  IF RScore = 0 THEN
   FLC 9, 13: FPR 0, "Remote  Surrendered!"
  ELSE
   FLC 9, 14: FPR 0, "You won this game!"
  END IF
  Won = Won + 1
 ELSEIF Score = RScore THEN
  FLC 9, 17: FPR 0, "It is a tie!"
 ELSE
  IF Score = 0 THEN
   FLC 9, 15: FPR 0, "You Surrendered!"
  ELSE
   FLC 9, 14: FPR 0, "You lost the game!"
  END IF
 
  Lost = Lost + 1
 END IF
 LNB& = LNB& + Score
 RNB& = RNB& + RScore
 FLC 11, 4: FPR 1, "Player    Score  Won    Lost   Bricks"
 FLC 13, 6: FPR 1, "You"
 FLC 13, 15: FPR 0, STR$(Score)
 FLC 13, 22: FPR 0, STR$(Won)
 FLC 13, 29: FPR 0, STR$(Lost)
 FLC 13, 36: FPR 0, STR$(INT(100 / (450& * Games) * LNB&)) + "',"
 FLC 15, 6: FPR 1, "Remote"
 FLC 15, 15: FPR 0, STR$(RScore)
 FLC 15, 22: FPR 0, STR$(Lost)
 FLC 15, 29: FPR 0, STR$(Won)
 FLC 15, 36: FPR 0, STR$(INT(100 / (450& * Games) * RNB&)) + "',"
 FLC 19, 6: FPR 1, "Games played:": FPR 0, STR$(Games)
 FLC 21, 6: FPR 1, "Ties        :": FPR 0, STR$(Games - Won - Lost)

 IF MultiMode THEN
  FLC 27, 12: FPR 1, "Press ENTER to continue!"
  FLC 29, 11: FPR 1, "Press ESCAPE to abort game!"
 ELSE
  FLC 27, 15: FPR 1, "Waiting for host..."
  FLC 29, 14: FPR 1, "Press ESC to abort..."
 END IF

 FOR X = 0 TO 49                                 '// Palette flash
  WAIT &H3DA, 8
  FOR Y = 0 TO 15
   OUT &H3C7, Y: OUT &H3C8, Y
   FOR Z = 0 TO 2
    OUT &H3C9, 63 - (63 - PL(Y, Z)) / 49 * X
   NEXT Z
  NEXT Y
 NEXT X

 WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer

 IPXr.PData = ""
 IF MultiMode THEN
  DO
   TFX
   SELECT CASE INKEY$
    CASE CHR$(13)
     IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
     LTr$ = "ZBIG" + CHR$(MultiTypeS)
     IPXSend &H4001 + ISock, LTr$, ReAddr$, &H4001 + ISock
     WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     GOTO GameStart
    CASE CHR$(27)
     IPXSend &H4001 + ISock, "ZBHD", ReAddr$, &H4001 + ISock
     WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
     IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
     IPXCloseSocket &H4000 + ISock
     IPXCloseSocket &H4001 + ISock
     GOTO StartOver
   END SELECT
   IF ECBr.InUseF = CHR$(0) THEN
    IF LEFT$(IPXr.PData, 4) = "ZBCD" AND IPXr.SrceAddr = ReAddr$ THEN
     IPXCloseSocket &H4000 + ISock
     IPXCloseSocket &H4001 + ISock
     GOTO StartOver
    ELSE
     IF IPXListen(&H4000 + ISock) > 0 THEN GOTO NetErr
    END IF
   END IF
   IPXWork
  LOOP
 ELSE
  DO
   TFX
   IF INKEY$ = CHR$(27) THEN
    IPXSend &H4000 + ISock, "ZBCD", ReAddr$, &H4000 + ISock
    WHILE ECBs.InUseF > CHR$(0): IPXWork: WEND
    IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
    IPXCloseSocket &H4000 + ISock
    IPXCloseSocket &H4001 + ISock
    GOTO StartOver
   END IF
   IF ECBr.InUseF = CHR$(0) THEN
    IF LEFT$(IPXr.PData, 4) = "ZBIG" AND IPXr.SrceAddr = ReAddr$ THEN
     GOTO GameStart
    ELSEIF LEFT$(IPXr.PData, 4) = "ZBHD" AND IPXr.SrceAddr = ReAddr$ THEN
     IPXCloseSocket &H4000 + ISock
     IPXCloseSocket &H4001 + ISock
     GOTO StartOver
    ELSE
     IF IPXListen(&H4001 + ISock) > 0 THEN GOTO NetErr
    END IF
   END IF
   IPXWork
  LOOP
 END IF

HiScore:
 FOR N = 0 TO 15                                '// White palette
  OUT &H3C7, N: OUT &H3C8, N
  OUT &H3C9, 63: OUT &H3C9, 63: OUT &H3C9, 63
 NEXT N
 CLS

 TFX
 FLC 7, 15: FPR 1, "BRICKO HiScores!"

 FOR N = 0 TO 7
  IF Score >= HI(N).PScore THEN
   FOR Z = 7 TO N + 1 STEP -1
    HI(Z) = HI(Z - 1)
   NEXT Z
   HI(N).PScore = Score
   HI(N).PName = "Enter Your Name!"
   EXIT FOR
  END IF
 NEXT N

 IF N = 8 THEN
  FLC 9, 11: FPR 0, "You didn't reach HiScore!"
 ELSE
  FLC 9, 13: FPR 0, "You reached HiScore!"
 END IF

 FLC 11, 5: FPR 1, "Place:  Name:                 Score:"
 FOR Z = 1 TO 8
  FLC 11 + Z * 2, 6: FPR -(Z = N + 1), STR$(Z)
  FLC 11 + Z * 2, 15: FPR -(Z = N + 1), HI(Z - 1).PName
  FLC 11 + Z * 2, 36: FPR -(Z = N + 1), STR$(HI(Z - 1).PScore)
 NEXT Z

 FOR X = 0 TO 49                                 '// Palette flash
  WAIT &H3DA, 8
  FOR Y = 0 TO 15
   OUT &H3C7, Y: OUT &H3C8, Y
   FOR Z = 0 TO 2
    OUT &H3C9, 63 - (63 - PL(Y, Z)) / 49 * X
   NEXT Z
  NEXT Y
 NEXT X

 WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer

 IF N < 8 THEN
  Valid$ = CHR$(0) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789!?:.;,'`" + CHR$(34)
  Z = True
  NN$ = ""
  DO
   TFX
   I$ = UCASE$(INKEY$)
   IF INSTR(Valid$, I$) > 1 THEN
    IF Z = True THEN
     Z = False
     FLC 13 + N * 2, 15: FPR 1, SPACE$(LEN(HI(N).PName))
     FLC 13 + N * 2, 15
    END IF
    IF LEN(NN$) < 20 THEN
     NN$ = NN$ + I$
     FPR 1, I$
    END IF
   ELSEIF I$ = CHR$(13) THEN
    IF LEN(NN$) > 0 THEN
     SBSnd 2
     HI(N).PName = NN$
     EXIT DO
    END IF
   ELSEIF I$ = CHR$(8) THEN
    IF Z = True THEN
     Z = False
     FLC 13 + N * 2, 15: FPR 1, SPACE$(LEN(HI(N).PName))
     FLC 13 + N * 2, 15
    END IF
    IF LEN(NN$) > 0 THEN
     NN$ = LEFT$(NN$, LEN(NN$) - 1)
     FLC FR, FC - 1: FPR 0, " ": FLC FR, FC - 1
    END IF
   ELSEIF I$ = CHR$(27) THEN
    IF Z = True THEN
     Z = False
     FLC 13 + N * 2, 13: FPR 1, SPACE$(LEN(HI(N).PName))
     FLC 13 + N * 2, 13: FPR 1, "Anynomous"
     HI(N).PName = "Anonymous"
     EXIT DO
    END IF
   END IF
  LOOP
 END IF

 FLC 29, 11: FPR 1, "Press ENTER to continue!"
 WHILE INKEY$ <> CHR$(13): TFX: WEND

 GOTO StartOver

RemoteFail:
 MouseHide
 SBSnd 3
 FOR Y = BY TO BY + GV * 20 + 19                           '// Darken Area
  LINE (BX + (Y AND 1), Y)-(BX + GH * 20 + 19, Y), 0, , 21845
 NEXT Y
 FLC 2, 2: FPR 1, "Remote Failure! Press ": FPR 0, "ENTER!"'// Disp. Msg.

 WHILE INKEY$ <> "": WEND                          '// Clear kbd. buffer

 DO
  SELECT CASE UCASE$(INKEY$)
   CASE CHR$(13)
    IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
    IPXCloseSocket &H4000 + ISock
    IPXCloseSocket &H4001 + ISock
    GOTO StartOver
   CASE CHR$(27)
    IF ECBr.InUseF > CHR$(0) THEN IF IPXCancelL > 0 THEN GOTO NetErrC
    IPXCloseSocket &H4000 + ISock
    IPXCloseSocket &H4001 + ISock
    GOTO Quit
  END SELECT
 LOOP

NetErrC:
 SCREEN 0                                            '// Screen Fixup
 COLOR 7, 0, 0: CLS
 PRINT "IPX error!"
 PRINT "Closing sockets... ERROR! Events not cancelled!"
 GOTO NetErrNC

NetErr:
 SCREEN 0                                            '// Screen Fixup
 COLOR 7, 0, 0: CLS
 PRINT "IPX error!"
 PRINT "Closing sockets... ";
 IPXCloseSocket &H4000 + ISock
 IPXCloseSocket &H4001 + ISock
 PRINT "OK!"

NetErrNC:
 PRINT
 END

Quit:                                                '// Quit game
 FOR X = 49 TO 0 STEP -1                             '// Fadeout Palette
  WAIT &H3DA, 8
  FOR N = 0 TO 15
   OUT &H3C7, N: OUT &H3C8, N
   FOR Z = 0 TO 2
    OUT &H3C9, PL(N, Z) / 49 * X
   NEXT Z
  NEXT N
 NEXT X

 SCREEN 0                                            '// Screen Fixup
 COLOR 7, 0, 0: CLS

 SBDeinit
 PRINT "BRICKO! // LogicLord"

 '// Write HiScores
 OPEN "BRICKO.HI" FOR BINARY ACCESS WRITE AS #1
 FOR N = 0 TO 7
  PUT #1, , HI(N)
 NEXT N
 CLOSE #1
 
 PRINT
 END

REM $STATIC
DEFSNG A-Z
SUB FLC (row%, col%)
 IF row% >= 0 AND row% < 30 THEN FR = row%
 IF col% >= 0 AND col% < 45 THEN FC = col%
END SUB

SUB FPR (fz%, text$)
 I$ = ":;!?" + CHR$(34) + "'`,.ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
 T$ = UCASE$(text$)
 f% = -(fz% = 0)
 FOR N% = 1 TO LEN(T$)
  PUT (FC * 14, FR * 16), FD(0, f% * 46 + INSTR(I$, MID$(T$, N%, 1))), PSET
  FC = FC + 1
  IF FC = 45 THEN FC = 0: FR = FR + 1
 NEXT N%
END SUB

DEFINT A-Z
FUNCTION IPXCancelL
 'Cancel Listen
 ' Output:
 '  IPXCancelL             = 0 Successful
 '                         > 0 Error:
 '                              &HF9 - Event in use
 '                              &HFC - Event cancelled
 '                              &HFF - Unsuccessful

 'IF ECBr.InUseF = CHR$(0) THEN STOP

 Regs.BX = &H6              'Function &H6 - CANCEL EVENT
 Regs.es = VARSEG(ECBr)     'Event Control Block
 Regs.si = VARPTR(ECBr)
 CALL InterruptX(&H7A, Regs, Regs)
 IPXCancelL = Regs.AX AND 255
END FUNCTION

SUB IPXCloseSocket (Socket)
 'Closes an IPX socket
 ' Input:
 '  Socket                 Socket to close

 'IF ASC(ECBr.InUseF) > 0 THEN STOP
 'IF ASC(ECBs.InUseF) > 0 THEN STOP

 Regs.BX = &H1              'Function &H1 - CLOSE SOCKET
 Regs.dx = Socket
 CALL InterruptX(&H7A, Regs, Regs)
END SUB

DEFSNG A-Z
FUNCTION IPXGetAdress$
 'Get internetwork address
 ' Output:
 '  IPXGetAdress           Internetwork address

 AddrS$ = STRING$(10, 0)
 IF LEN(AddrS$) = 10 THEN
  Regs.BX = &H9              'Function &H9 - GET INTERNETWORK ADDRESS
  Regs.es = VARSEG(AddrS$)
  Regs.si = SADD(AddrS$)
  CALL InterruptX(&H7A, Regs, Regs)
 END IF
 IPXGetAdress$ = AddrS$
END FUNCTION

DEFINT A-Z
FUNCTION IPXInstalled
 'Checks if IPX is installed
 ' Output:
 '  IPXInstalled           IPX is installed - True/False

 Regs.AX = &H7A00
 CALL InterruptX(&H2F, Regs, Regs)
 IF (Regs.AX AND &HFF) = &HFF THEN IPXInstalled = True ELSE IPXInstalled = False
END FUNCTION

FUNCTION IPXListen (Socket)
 'Listen for an IPX packet
 ' Input:
 '  Socket                 Socket to listen on
 ' Output:
 '  IPXListen              Completion code

 IF ECBr.InUseF > CHR$(0) THEN STOP

 ECBr.Socket = Socket
 ECBr.FragSize = 2078       'Maximum amount of data
 Regs.BX = &H4              'Function &H4 - LISTEN FOR PACKET
 Regs.es = VARSEG(ECBr)     'Event Control Block
 Regs.si = VARPTR(ECBr)
 CALL InterruptX(&H7A, Regs, Regs)
 IPXListen = Regs.AX AND &HFF
END FUNCTION

FUNCTION IPXOpenSocket (Socket)
 'Open an IPX socket
 ' Input:
 '  Socket                 Socket to open, usually &H0 or &H4000 to &H7FFF
 ' Output:
 '  IPXOpenSocket          > 0 Socket number (dynamically allocated socket)
 '                         < 0 Error:
 '                              &HFE - Socket table full
 '                              &HFF - Socket already open

 'IF ASC(ECBr.InUseF) > 0 THEN STOP
 'IF ASC(ECBs.InUseF) > 0 THEN STOP

 Regs.BX = &H0              'Function &H0 - OPEN SOCKET
 Regs.AX = &H0              'Socket longevity - open until close or terminate
 Regs.dx = Socket           'Use socket &H0 for dynamic allocation
 CALL InterruptX(&H7A, Regs, Regs)
 IF (Regs.AX AND &HFF) = 0 THEN
  IPXOpenSocket = Regs.dx              'Socket open OK
 ELSE
  IPXOpenSocket = -(Regs.AX AND &HFF)  'Socket open ERROR
 END IF
END FUNCTION

SUB IPXSend (SSock, PData$, DAddr$, DSock)
 'Send an IPX packet
 ' Input:
 '  PData$                 Data to be sent
 '  DAddr$                 Destination address
 '  DSock                  Destination socket
 ' Output:
 '  IPXSend                = 0 Successful
 '                         > 0 Error:

 ECBs.Socket = SSock
 ECBs.FragSize = 30 + LEN(PData$)
 IPXs.Length = 30 + LEN(PData$)
 IPXs.DestAddr = DAddr$
 IPXs.DestSock = DSock
 IPXs.PData = PData$
 Regs.BX = &H3              'Function &H3 - SEND PACKET
 Regs.es = VARSEG(ECBs)     'Event Control Block
 Regs.si = VARPTR(ECBs)
 CALL InterruptX(&H7A, Regs, Regs)
 'IPXSend = ASC(ECBs.CompnC)
END SUB

SUB IPXWork
 'Permits the IPX driver to do some work

 Regs.BX = &HA              'Function &HA - RELINQUISH CONTROL
 CALL InterruptX(&H7A, Regs, Regs)
END SUB

SUB Mouse (AX, BX, cx, dx)
 Regs.AX = AX: Regs.BX = BX
 Regs.cx = cx: Regs.dx = dx
 CALL INTERRUPT(51, Regs, Regs)
 AX = Regs.AX: BX = Regs.BX
 cx = Regs.cx: dx = Regs.dx
END SUB

FUNCTION MouseActive
 DEF SEG = 0
 mseg& = 256 * PEEK(207) + PEEK(206)
 moff& = 256 * PEEK(205) + PEEK(204)
 IF mseg& OR moff& THEN
  DEF SEG = mseg&
  IF PEEK(moff&) = 207 THEN
   MouseActive = False
  ELSE
   MouseActive = True
  END IF
 ELSE
  MouseActive = False
 END IF
 DEF SEG
END FUNCTION

SUB MouseGStat (B, X, Y)
 Mouse 3, B, X, Y
END SUB

DEFSNG A-Z
SUB MouseHide
 CALL Mouse(2, 0, 0, 0)
END SUB

DEFINT A-Z
SUB MouseLimit (X, Y, H, V)
 Mouse 7, 0, X, H
 Mouse 8, 9, Y, V
END SUB

DEFSNG A-Z
SUB MouseReset
 Mouse 0, 0, 0, 0
END SUB

SUB MouseShow
 Mouse 1, 0, 0, 0
END SUB

DEFINT A-Z
SUB MouseSpeed (X, Y)
 Mouse 15, 0, X, Y
END SUB

SUB MouseSXY (X, Y)
 Mouse 4, 0, X, Y
END SUB

SUB SBBlaster (DMA, ADR, IRQ)
 EB$ = ENVIRON$("BLASTER")
 IF LEN(EB$) = 0 THEN SB = 0: EXIT SUB

 EB$ = ENVIRON$("BLASTER")
 FOR I = 1 TO LEN(EB$)
  SELECT CASE MID$(EB$, I, 1)
   CASE "A": ADR = VAL("&H" + MID$(EB$, I + 1, 3))   '// Get Adress
   CASE "I": IRQ = VAL(MID$(EB$, I + 1, 1))          '// Get IRQ
   CASE "D": DMA = VAL(MID$(EB$, I + 1, 1))          '// Get DMA
  END SELECT
 NEXT
END SUB

DEFSNG A-Z
SUB SBDeinit
 SBWrite &HD3            '// DAC speaker OFF
 OUT &HA, SBD + &H4      '// Disable DMA
END SUB

DEFINT A-Z
FUNCTION SBReset
 OUT SBA + &H6, 1                          'Reset the SB's DSP
 S! = TIMER: WHILE ABS(TIMER - S!) < .2: WEND
 OUT SBA + &H6, 0
 S! = TIMER: WHILE ABS(TIMER - S!) < .2: WEND

 IF INP(SBA + &HE) AND &H80 <> &H80 THEN EXIT FUNCTION
 IF INP(SBA + &HA) = &HAA THEN
  OUT SBA + &H4, &H0                       'Reset mixer
  OUT SBA + &H5, 0
  OUT SBA + &H4, &H22                      'Set maximum volume
  OUT SBA + &H5, 255

  SBWrite &HD1                             'DAC speaker on

  SBReset = True
 END IF
END FUNCTION

SUB SBSnd (SNum)
 IF NOT SB THEN EXIT SUB                          '// If no SB, exit

 Length& = LEN(SndDat(SNum)) - 1                  '// Get length, segment and offset
 Segment& = VARSEG(SndDat(SNum))
 Offset& = SADD(SndDat(SNum))

 IF Segment& < 0 THEN Segment& = Segment& + 65536 '// Remove bit 7 sign
 IF Offset& < 0 THEN Offset& = Offset& + 65536

 MemLoc& = Segment& * 16 + Offset&                '// Calculate memory location

 OUT &HA, &H4 + SBD                               '// Disable DMA
 OUT &HC, &H0                                     '// Clear flip-flop
 OUT &HB, SBD + &H48                              '// 8-bit single cycle
 'OUT &HB, 0 '// ???

 PAddr = (MemLoc& AND &HF0000) \ &H10000          '// Calculate page

 OUT SBPP, PAddr                                  '// Program DMA controller
 OUT SBAP, MemLoc& AND &HFF
 OUT SBAP, (MemLoc& AND &HFFFF&) \ &H100
 OUT SBLP, Length& AND &HFF
 OUT SBLP, Length& \ &H100

 OUT &HA, SBD                                     '// Enable DMA

 SBWrite &H40                                     '// Time constant
 SBWrite 211                                      '// 22050hz Mono

 SBWrite &H14                                     '// 8-bit PCM output
 SBWrite Length& AND &HFF                         '// Length
 SBWrite Length& \ &H100
END SUB

SUB SBWrite (DSPD)                           '// Write to SB's DSP
 S! = TIMER
 WHILE INP(SBA + 12) AND &H80
  IF INT(TIMER - S!) <> 0 THEN EXIT SUB
 WEND
 OUT SBA + 12, DSPD
END SUB

SUB TFX STATIC
 WAIT &H3DA, 8
 IF zdur >= 0 THEN zdur = zdur - 1
 IF idur >= 0 THEN idur = idur - 1
 IF zdur = -1 THEN
  zdur = -2
  idur = RND * 200
 ELSEIF idur = -1 THEN
  idur = -2
  zdur = RND * 20
  zlen = INT(RND * 46) + 1
  zpos = INT(RND * (92 - zlen * 2))
 END IF
 X! = 0
 FOR Y = 0 TO 91
  IF idur = -2 AND Y > zpos AND Y < zpos + zlen * 2 THEN
   V! = 1 - (ABS(Y - zpos - zlen) / zlen)
   X! = X! + (RND * 4 - 2)
   PUT (230 + X! * V!, Y), TL(0, Y), PSET
  ELSE
   PUT (230, Y), TL(0, Y), PSET
   LINE (129, Y)-(229, Y), 0
   LINE (410, Y)-(510, Y), 0
  END IF
 NEXT Y
END SUB

