
defint A-Z
declare function Engine.TileCollide% (Character as any) ' Sub used for collision with tiles.
declare function NumericInput (numinput)
declare sub Engine.DrawPlayer (Player as any)        ' Sub used to draw our hero on the screen.
declare sub Engine.DrawScreen () ' Sub used to draw all our stuff on the screen and to control the page flipping.
declare sub AINPC (currentNPC%)  ' Sub used to move and control the movement of NPCs.
declare sub Engine.DrawNPC ()    ' Sub used to draw the NPCs.
declare sub InitVariables ()     ' This sub is used to initate various variables(player starting position, ect).
declare sub Engine.DrawMap ()    ' Sub used to draw our map on the screen(paste the tiles).
declare sub InitMap (mapcon$)    ' This sub loads our map in the Map array(used in Engine.DrawMap sub).
declare sub Engine.UpdatePlayer (Player as any, Direction%)   ' Sub used to update position of the player.
declare sub Engine.UpdateCamera (Level as any, Player as any) ' Sub used to update position of the camera.
declare sub Main ()        ' Main loop where statements for player control are.
declare sub MainScreen ()  ' Extra sub for title screen.
declare sub UnFogWalls (XcurT, YcurT, model)
declare sub AddLight (illumination%, XTil%, YTil%)
declare sub Engine.DrawInterface ()
declare sub Engine.DrawStatus()
declare sub Engine.DrawWepInv()
declare sub Engine.DrawEquipInv()
declare sub Engine.DrawItemsInv()
declare sub Engine.DrawSaveGame()
declare sub ExamineLocation()
declare sub OperateWith()
declare sub Engine.DrawAttackAnim()
declare sub Engine.DrawLockers()
declare sub Engine.DrawCorpses()
declare sub NewNText (inputtext$)
declare sub NewBText (inputtext$, inputarray%)
declare sub Engine.DrawBattleScreen()
declare sub LoadGame (position)
declare sub LoadGameMenu ()
declare sub AttackLHand()
declare sub AttackRHand()
declare sub RunAway()
declare sub Levelize()
declare sub CaptureScreen()
declare sub MainMenu()
declare sub NewGame()
declare sub WriteHighScore ()
declare sub ReadHighScore ()
declare sub neoENCpass (Offset%, Length&, password$)
declare sub neoENCdepass (Offsett%, Lengthh&, passsword$)
declare sub Options ()
declare sub LoadNPCs (modenpc)
declare sub Credits ()
declare sub Instructions ()
declare sub ArtificialLights(Xart, Yart)
declare sub SkipTurn ()
declare sub ChangeLocation (ldirection)
declare SUB ElevatorChange (elevel)
declare sub Elevator()
declare sub CheckForDoors ()
'============================================================================
declare sub Engine.DoCollision (currentNPC%)   ' Sub used to detect the collison between
                                               ' the player and the NPCs.
'============================================================================

' pp256_image.bi module is used for PUT file loading(Pixel Plus 256
' standard file format) while rel_collide.bi module is used for
' pixel perfect collision.
#include "fbgfx.bi"
#include "pp256_image.bi"  
#include "rel_collide.bi"

' SpriteType is used to hold character related data(from the player
' to NPCs).
type SpriteType
         Typ            as integer    ' Character ID(used with NPCs).
         X              as single     ' World X position of the character.
         Y              as single     ' World Y position of the character.
         XV             as single     ' X Speed of the character.
         YV             as single     ' Y speed of the character.
         Frame          as integer    ' Used to display the proper image of the character from the PUT file.
         Move           as integer    ' Is the character moving?
         Level          as integer    ' Character's level
         Experience     as integer    ' Character's experience
         AttackL        as SINGLE   ' Character's attack level
         defenseL       as SINGLE
         Money          as integer
         LWeapon        as integer    ' Flags which weapons is in left hand
         RWeapon        as integer
         Armour         as integer
         Boots          as integer
         AI             as integer    
         Direction      as integer   
         TileX          as integer    
         TileY          as integer     
         Frame2         as integer             
         OldX           as integer     
         OldY           as integer  
         Exists as integer
         MovingTime as integer ' Used to count the number of moves(mock-tile by tile movement)
         Alive as integer
         Health as integer
         MaxHealth as integer
         Kills as integer
         MedPack as integer
         Food as integer
         ElecDistruptor as integer
         Antidote as integer
         AcidBomb as integer
         Shield as integer
         Steroids as integer
         Drugged as integer
         Bomb as integer
         FoodStatus as integer ' Is the player hungry, starving, etc.
         FoodCount as integer  ' Used to count how much till being hungry, etc.
         ShieldStatus as integer ' Is shield activated or not
         defense as integer      ' Total player's defense(defense level + armour strenght)
         MainArm as integer      ' Which arm is the player's main arm(left or right)
         StartAttack as integer  ' Enemies' start attack strenght(used to balance the gameplay)
         Poisoned as integer     ' Is the player poisoned or not
         ReMove as integer       ' If you escape from battle you move again
         AttackMode as integer   ' Flags if you attacked or the NPC(neccessary)
         SName as string ' Character's name
         NextExp as integer
         AttackHand as integer
         LHandStamina as single
         RHandStamina as single
         PoisonCount as integer
         Score as integer
         Oxygen as integer
         Oxycount AS integer
         Oxywear as integer
end type

' Used to hold data related to scrolling(camera position, ect).
type LevelType
        Xmax    as integer     ' Maximum number of tiles a map has.
        Ymax    as integer 
        CamX    as integer     ' Pixel*Pixel Camera Position.
        CamY    as integer 
        TileX   as integer     ' Tile postion of the camera.
        TileY   as integer     ' Calculated by CamX\TileSize.
        Xpos    as integer     ' Pixel position inside the tile
        Ypos    as integer     ' 0 to 19 (used for scrolling).
end type

type MapLayerType
       BaseL    as integer          ' Holds the tile numbers for every map element.
       LightStat  as integer        ' Flags the amount of light specific tile has.
       FogStat  as integer          ' Flags if the tile has been revealed by the player or not.
end type

type ObjectType
    Typ      as integer
    X        as integer
    Y        as integer
    Frame    as integer
    Mode     as integer
    Exist    as integer
    TileX    as integer
    TileY    as integer
end type

'***********************************************
' Variables and the sub used to load PUT files into arrays.
type tileType
s_image	    as ImageType		
init	  	    as sub ( byref tile as tileType )	 
load_image   as sub ( byref tile as tileType )	  
end type
declare sub tile_load_image ( byref tile as tileType )
'***********************************************

' Subs used to print custom font text on the screen.
declare sub GraphicText (xx%, yy%, Textt$, byref tile as tileType)
declare function GetDepth% (ImNo%,byref tilem as tileType)
declare function GetWidth% (ImNo%,byref tilem as tileType)


' Declare your constants here!
const NULL = 0
const CENTRETEXT = -1

' Change these constants to suit your screen mode needs 
' and tile size.
' Game screen constants(Full Screen 320*200); not the 
' total screen size!
const ScrnXmax = 300, ScrnYmax = 300
const ScrnXmid = ScrnXmax/2, ScrnYmid = ScrnYmax/2
const ScrnXmin = 0, ScrnYmin = 0

'Tile dimensions 20*20
const TileW = 20
const TileH = 20

' Number of tiles per screen 320\20=16, 200\20=10
' Used to calculate the Engine.DrawMap sub.
const ScrnTileXmax = ScrnXmax \ TileW
const ScrnTileYmax = ScrnYmax \ TileH

' Directional constants for easy sprite handling
' DN=Neutral(not Moving), DR=Right...........
const DN = 0, DR = 1, DU = 2, DL = 3, DD = 4

' More needed constants.
const FALSE = 0
const TRUE = 1

' Arrays that hold our sprites, tiles and our font.
dim shared Tiles as tileType
dim shared Tiles2 as tileType
dim shared Sprites as tileType
dim shared Sprites2 as tileType
dim shared Sprites3 as tileType
dim shared Sprites4 as tileType
dim shared Sprites5 as tileType
dim shared Sprites6 as tileType
dim shared Font as tileType
dim shared Font2 as tileType
dim shared Font3 as tileType
dim shared Font4 as tileType
dim shared Font5 as tileType
dim shared Font6 as tileType
dim shared Font7 as tileType

' Map array used to hold the map data(which tiles go where in the map).
redim shared Map(8, 150, 150) as MapLayerType         

dim shared Level as LevelType    ' Used to hold data related to
                                 ' scrolling(camer position, ect).
dim shared Player as SpriteType  ' Our Player.
dim shared NPC(10,51) as SpriteType ' Our non-player controled sprites.
                                    ' We have defined 40 elements(max of 
                                    ' 40 NPCs per map).
dim shared Locker(10, 51) as ObjectType
dim shared Corpse(10, 51) as ObjectType
dim shared Door(10, 31) as ObjectType

dim shared pathf$ ' This variable used to locate the dir of your files.

' Some variables we use in our program.                            
dim shared mapy$, countNPC, ltext$
dim shared Frame, Frame4, Frame2, Frame3 ' Variables used to time animations.
dim shared FPS, FPS2, Starttime& ' Variables used to count FPS.
dim shared minutes, seconds, hours
dim shared MapXMax, MapYMax      ' Variables used to set the
                                 ' size of our map.
dim shared IconStatus, ArrowStatus, Mode, WorkingMode, mapblink, Turn, BattleTurn
' Mode : If it's normal mode(=1) or battle mode(=2)
' WorkingMode : Flags which menu(option) is active during a 
' specific mode
' Turn : Flags whose turn it is, player's(=1) or NPCs(=2)
' BattleTurn: In battle it flags whose turn it is
' ArrowStatus and IconStatus are used to flag on which icon the
' mouse cursor is in order to draw a red frame around it
dim shared SwordYPos, MoveSwordMode, RumbleEnemy, RumblePlayer
dim shared AttackAnim, AnimCount, countdeath, countbatanim, countendelay
' Variables used during the battle mode to enable sword movement
' and rumbling of the icons when someone is hit
' SwordYPos - variable used to move the sword during the battle
' MoveSwordMode - used to move and set the sword on various
' positions(from the player to the middle and to the enemy) during
' the battle
' countdeath - used to count the end of the battle when you beat
' the enemy
' countbatanim - important variable used to enable the curtain
' effect when a battle starts or ends(MUST BE >147 IN NORMAL
' MODE!!!)
dim shared trigger(8) as integer
' Used to flag if the player has some of the special objects in
' the game.
dim shared damageresult as integer
' Used during the battle to calculate the damage

dim shared mousefree, keyboardfree, Location, currentNPC
dim shared numoflock, numofdoor
' mousefree and keyboardfree variables are used to prevent
' double mouse or keyboard clicks
' Location flags on with level in the ship the player is(IMPORTANT
' because the proper NPCs are controled according to this variable)
dim shared mx, my, buttons ' mouse variables
dim shared numofnpcs
' used to flag number of npcs according to Location

dim shared weaponsinv(9) as integer
dim shared equipmentinv(9) as integer
dim shared itemsinv(9) as integer
' Used in inventory menus to flag which item or weapon is on
' which position in the specific inventory

' Used to display text messages according to player's action;
' ntext is for normal mode and btext is for messages during
' the battle,
dim shared ntext(5) as string
dim shared btext(5) as string
dim shared btextfont(5) as integer ' flags during the battle red or
                                   ' orange text line
                                   
' Used during the battle to set which text should appear when
' you attack the enemy(according to the weapons)
dim shared prebtext$
dim shared skipbattle, flaglight, xmov, GameLoaded, sshoot, cursorspr
dim shared heroletter$(8)
dim shared savepos(8) as integer
dim shared savename(8) as string
DIM SHARED GameSpeed, FMODStatus, FullScreen, PlaySound, Pal$, SoundVol, Music
                                   
' Used to hold images neccessary to enable the curtain effect
dim shared bimage1(88220) as integer
dim shared bimage2(88220) as integer
dim shared bimage3(88220) as integer
dim shared mbimage(307900) as integer
dim shared instimage(307900) as integer

' Initiate our screen mode. 2 work pages minimum.
' Change 0 to 1 for full screen mode.
screen 18,8,2,1
SETMOUSE 0,0,0 ' Hides the mouse cursor.

' If your working files are in the directory where the compiled
' file is pathf$ should be "".
pathf$ = "d:\working\freebasic\mycoding\scroll\"
pathf$=""

' Load the battle background image into an array.
screenset 1,0
screenlock
bload pathf$ + "Graphics\BATBGR.BMP", 0
get (0,0)-(296,296), bimage1(0)
screenunlock
screenlock
bload pathf$ + "Graphics\MMENU.BMP", 0
get (0,0)-(639,479), mbimage(0)
screenunlock

' Load all our sprites. Too many files, I know, and they are
' placed all around the files very messy.
Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT1.PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT11.PUT"
Tile_load_image ( Tiles2 )
Sprites.s_image.m_filename = pathf$ + "Graphics\SROGUE1.PUT"
Tile_load_image ( Sprites )
Sprites2.s_image.m_filename = pathf$ + "Graphics\SROGUE2.PUT"
Tile_load_image ( Sprites2 )
Sprites3.s_image.m_filename = pathf$ + "Graphics\SROGUE0.PUT"
Tile_load_image ( Sprites3 )
Sprites4.s_image.m_filename = pathf$ + "Graphics\SROGUE4.PUT"
Tile_load_image ( Sprites4 )
Sprites5.s_image.m_filename = pathf$ + "Graphics\SROGUE5.PUT"
Tile_load_image ( Sprites5 )
Sprites6.s_image.m_filename = pathf$ + "Graphics\SROGUE3.PUT"
Tile_load_image ( Sprites6 )
Font.s_image.m_filename = pathf$ + "Fonts\SROGUE4.FNT"
Tile_load_image ( Font )
Font2.s_image.m_filename = pathf$ + "Fonts\SROGUE3.FNT"
Tile_load_image ( Font2 )
Font3.s_image.m_filename = pathf$ + "Fonts\SROGUE1.FNT"
Tile_load_image ( Font3 )
Font4.s_image.m_filename = pathf$ + "Fonts\SROGUE2.FNT"
Tile_load_image ( Font4 )
Font5.s_image.m_filename = pathf$ + "Fonts\SROGUE5.FNT"
Tile_load_image ( Font5 )
Font6.s_image.m_filename = pathf$ + "Fonts\SROGUE6.FNT"
Tile_load_image ( Font6 )
Font7.s_image.m_filename = pathf$ + "Fonts\SROGUE7.FNT"
Tile_load_image ( Font7 )

                

init_palette_data  pathf$ + "normal.pal" ' Load our palette.

xmov = 0
sshoot = 1
SoundVol = 3
Music = TRUE
PlaySound = TRUE
GameSpeed = 1
Pal$ = "NORMAL.PAL"

MainMenu


end ' End program.


sub AINPC (currentNPC)

if NPC(Location, currentNPC).Move = FALSE and abs(Player.TileX-NPC(Location, currentNPC).TileX)<5 and abs(Player.TileY-NPC(Location, currentNPC).TileY)<5 then

addnomov=0
IF NPC(Location, currentNPC).Move = FALSE THEN
IF Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY).FogStat = 0 THEN addnomov=addnomov+1
IF Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY+1).FogStat = 0 OR Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY+1).BaseL>55 THEN addnomov=addnomov+1
IF Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY-1).FogStat = 0 OR Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY-1).BaseL>55 THEN addnomov=addnomov+1
IF Map(Location, NPC(Location, currentNPC).TileX+1, NPC(Location, currentNPC).TileY).FogStat = 0 OR Map(Location, NPC(Location, currentNPC).TileX+1, NPC(Location, currentNPC).TileY).BaseL>55 THEN addnomov=addnomov+1
IF Map(Location, NPC(Location, currentNPC).TileX-1, NPC(Location, currentNPC).TileY).FogStat = 0 OR Map(Location, NPC(Location, currentNPC).TileX-1, NPC(Location, currentNPC).TileY).BaseL>55 THEN addnomov=addnomov+1
IF addnomov=5 THEN EXIT SUB
END IF

if Player.TileX>NPC(Location, currentNPC).TileX then 
NPC(Location, currentNPC).Direction=1  
NPC(Location, currentNPC).Move = TRUE   
isfree=TRUE
if Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY).FogStat = 0 and Map(Location, NPC(Location, currentNPC).TileX+1, NPC(Location, currentNPC).TileY).FogStat = 0 then
NPC(Location, currentNPC).Direction=0  
NPC(Location, currentNPC).Move = FALSE
isfree=FALSE
end if
for countcolNPC=1 to numofnpcs
if (Map(Location, NPC(Location, currentNPC).TileX+1,NPC(Location, currentNPC).TileY).BaseL>55) OR (NPC(Location, countcolNPC).Alive=TRUE and countcolNPC<>currentNPC and NPC(Location,currentNPC).TileX+1=NPC(Location,countcolNPC).TileX and NPC(Location,currentNPC).TileY=NPC(Location,countcolNPC).TileY) then
isfree= FALSE
goto skipnextcolNPC1:
end if
next countcolNPC
skipnextcolNPC1:
if isfree = FALSE and Player.TileY>=NPC(Location, currentNPC).TileY then NPC(Location, currentNPC).Direction=2   
if isfree = FALSE and Player.TileY<NPC(Location, currentNPC).TileY then NPC(Location, currentNPC).Direction=4   
end if
if Player.TileX<NPC(Location, currentNPC).TileX then 
NPC(Location, currentNPC).Direction=3   
NPC(Location, currentNPC).Move = TRUE  
isfree=TRUE
if Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY).FogStat = 0 and Map(Location, NPC(Location, currentNPC).TileX-1, NPC(Location, currentNPC).TileY).FogStat = 0 then
NPC(Location, currentNPC).Direction=0  
NPC(Location, currentNPC).Move = FALSE
isfree=FALSE
end if
for countcolNPC=1 to numofnpcs
if (Map(Location, NPC(Location, currentNPC).TileX-1,NPC(Location, currentNPC).TileY).BaseL>55) OR (NPC(Location, countcolNPC).Alive=TRUE and countcolNPC<>currentNPC and NPC(Location,currentNPC).TileX-1=NPC(Location,countcolNPC).TileX and NPC(Location,currentNPC).TileY=NPC(Location,countcolNPC).TileY) then
isfree= FALSE
goto skipnextcolNPC2:
end if
next countcolNPC
skipnextcolNPC2:
if isfree = FALSE and Player.TileY>=NPC(Location, currentNPC).TileY then NPC(Location, currentNPC).Direction=2   
if isfree = FALSE and Player.TileY<NPC(Location, currentNPC).TileY then NPC(Location, currentNPC).Direction=4   
end if

'IF NPC(Location, currentNPC).Direction = 0 THEN
if Player.TileY<NPC(Location, currentNPC).TileY then
NPC(Location, currentNPC).Direction=2 
NPC(Location, currentNPC).Move = TRUE
isfree=TRUE
if Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY).FogStat = 0 and Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY-1).FogStat = 0 then
NPC(Location, currentNPC).Direction=0  
NPC(Location, currentNPC).Move = FALSE
isfree=FALSE
end if
for countcolNPC=1 to numofnpcs
if (Map(Location, NPC(Location, currentNPC).TileX,NPC(Location, currentNPC).TileY-1).BaseL>55) OR (NPC(Location, countcolNPC).Alive=TRUE and countcolNPC<>currentNPC and NPC(Location,currentNPC).TileY-1=NPC(Location,countcolNPC).TileY and NPC(Location,currentNPC).TileX=NPC(Location,countcolNPC).TileX) then
isfree= FALSE
goto skipnextcolNPC3:
end if
next countcolNPC
skipnextcolNPC3:
if isfree = FALSE and Player.TileX>NPC(Location, currentNPC).TileX then NPC(Location, currentNPC).Direction=1   
if isfree = FALSE and Player.TileX<NPC(Location, currentNPC).TileX then NPC(Location, currentNPC).Direction=3
end if
if Player.TileY>NPC(Location, currentNPC).TileY then
NPC(Location, currentNPC).Direction=4 
NPC(Location, currentNPC).Move = TRUE    
isfree=TRUE
if Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY).FogStat = 0 and Map(Location, NPC(Location, currentNPC).TileX, NPC(Location, currentNPC).TileY+1).FogStat = 0 then 
NPC(Location, currentNPC).Direction=0  
NPC(Location, currentNPC).Move = FALSE
isfree=FALSE
end if
for countcolNPC=1 to numofnpcs
if (Map(Location, NPC(Location, currentNPC).TileX,NPC(Location, currentNPC).TileY+1).BaseL>55) OR (NPC(Location, countcolNPC).Alive=TRUE and countcolNPC<>currentNPC and NPC(Location,currentNPC).TileY+1=NPC(Location,countcolNPC).TileY and NPC(Location,currentNPC).TileX=NPC(Location,countcolNPC).TileX) then
isfree= FALSE
goto skipnextcolNPC4:
end if
next countcolNPC
skipnextcolNPC4:
if isfree = FALSE and Player.TileX>=NPC(Location, currentNPC).TileX then NPC(Location, currentNPC).Direction=1  
if isfree = FALSE and Player.TileX<NPC(Location, currentNPC).TileX then NPC(Location, currentNPC).Direction=3
end if
'END IF

end if

skiprnddirec:

if NPC(Location, currentNPC).Direction=0 then NPC(Location, currentNPC).Move = FALSE

if NPC(Location, currentNPC).Move = TRUE then
select case NPC(Location, currentNPC).Direction
        case 1 
                NPC(Location, currentNPC).OldX = NPC(Location, currentNPC).X
                NPC(Location, currentNPC).X = NPC(Location, currentNPC).X + NPC(Location, currentNPC).XV
                if Engine.TileCollide(NPC(Location, currentNPC)) then 
                NPC(Location, currentNPC).X = NPC(Location, currentNPC).X - NPC(Location, currentNPC).XV
                NPC(Location, currentNPC).Move = FALSE
                end if
                if NPC(Location, currentNPC).X > (Level.Xmax * TileW) - TileW then NPC(Location, currentNPC).X = (Level.Xmax * TileW) - TileW
        case 2
                NPC(Location, currentNPC).OldY = NPC(Location, currentNPC).Y 
                NPC(Location, currentNPC).Y = NPC(Location, currentNPC).Y - NPC(Location, currentNPC).YV
                if Engine.TileCollide(NPC(Location, currentNPC)) then 
                NPC(Location, currentNPC).Y = NPC(Location, currentNPC).Y + NPC(Location, currentNPC).YV
                NPC(Location, currentNPC).Move = FALSE
                end if
                if NPC(Location, currentNPC).Y < ScrnYmin then NPC(Location, currentNPC).Y = ScrnYmin
        case 3
                NPC(Location, currentNPC).OldX = NPC(Location, currentNPC).X 
                NPC(Location, currentNPC).X = NPC(Location, currentNPC).X - NPC(Location, currentNPC).XV
                if Engine.TileCollide(NPC(Location, currentNPC)) then 
                NPC(Location, currentNPC).X = NPC(Location, currentNPC).X + NPC(Location, currentNPC).XV
                NPC(Location, currentNPC).Move = FALSE
                end if
                if NPC(Location, currentNPC).X < ScrnXmin then NPC(Location, currentNPC).X = ScrnXmin
        case 4
                NPC(Location, currentNPC).OldY = NPC(Location, currentNPC).Y 
                NPC(Location, currentNPC).Y = NPC(Location, currentNPC).Y + NPC(Location, currentNPC).YV
                if Engine.TileCollide(NPC(Location, currentNPC)) then 
                NPC(Location, currentNPC).Y = NPC(Location, currentNPC).Y - NPC(Location, currentNPC).YV
                NPC(Location, currentNPC).Move = FALSE
                end if
                if NPC(Location, currentNPC).Y > (Level.Ymax * TileH) - TileH then NPC(Location, currentNPC).Y = (Level.Ymax * TileH) - TileH
        case else
end select
end if

end sub


sub Engine.DoCollision (currentNPC)

end sub

sub Engine.DrawMap 
' This sub draws our map on the screen. Can and should be used
' to implement other possible layers which are pasted over it.

' We need to MOD our Cam variables with TileW and TileH to get 
' the correct offset inside the tile.
' Note how the constants are used.
'==========BaseLayer====================
' Calculate the first tile to draw
Level.TileX = Level.CamX \ TileW        
Level.TileY = Level.CamY \ TileH
                               
' Get the offset inside the tile
Level.Xpos = Level.CamX mod TileW          
Level.Ypos = Level.CamY mod TileH           

' Formula for X(the loop below).
' (X * TileW) = video screen coordinate(0 to 320 Step 20).
' (X * TileW) - Level.Xpos = tile offset that we have to show from 
' 0 to 20 - Level.Xpos
' Assuming Level.Xpos = 4
' So if X * TileW = 0 then (X * TileW)- Level.Xpos = -4
' We start Drawing from X = -4 to X = -4 + TileW
' ie(for tile size 20*20), we draw our first tile from X = -4 to 
' X = 16 then the next tile from X = 17 to X = 17 + 20

' Loop through our visible screen and draw tiles on it.
for XT = 0 to ScrnTileXmax          '16 tiles(320/20)
for YT = 0 to ScrnTileYmax          '11 tiles(200/20)

' We flag which tile to draw. Note how the Map array is used.
tilep = Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL
tilep=tilep+4
Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat=0

' Nearest light
'IF Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL<61 THEN
if XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY then AddLight 3, XT + Level.TileX, YT + Level.TileY

if Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL<171 THEN 'OR Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL>110 then
if XT + Level.TileX=Player.TileX+1 and YT+Level.TileY=Player.TileY then AddLight 3, XT + Level.TileX, YT + Level.TileY
if XT + Level.TileX=Player.TileX-1 and YT+Level.TileY=Player.TileY then AddLight 3, XT + Level.TileX, YT + Level.TileY
if XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY+1 then AddLight 3, XT + Level.TileX, YT + Level.TileY
if XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY-1 then AddLight 3, XT + Level.TileX, YT + Level.TileY

' Second near light
if Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL<171 then
if Map(Location, Player.TileX+1, Player.TileY).BaseL<171 then
if XT + Level.TileX=Player.TileX+2 and YT+Level.TileY=Player.TileY then AddLight 2, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and XT + Level.TileX=Player.TileX+1 and YT+Level.TileY=Player.TileY+1 then AddLight 2, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and XT + Level.TileX=Player.TileX+1 and YT+Level.TileY=Player.TileY-1 then AddLight 2, XT + Level.TileX, YT + Level.TileY
end if

if Map(Location, Player.TileX-1, Player.TileY).BaseL<171 then 
if XT + Level.TileX=Player.TileX-2 and YT+Level.TileY=Player.TileY then AddLight 2, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and XT + Level.TileX=Player.TileX-1 and YT+Level.TileY=Player.TileY-1 then AddLight 2, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and XT + Level.TileX=Player.TileX-1 and YT+Level.TileY=Player.TileY+1 then AddLight 2, XT + Level.TileX, YT + Level.TileY
end if
if Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY+2 then AddLight 2, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY-2  then AddLight 2, XT + Level.TileX, YT + Level.TileY
end if


' Farest lights
if Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL<171 then
if Map(Location, Player.TileX+2, Player.TileY).BaseL<171 and Map(Location, Player.TileX+1, Player.TileY).BaseL<171 then
if XT + Level.TileX=Player.TileX+3 and YT+Level.TileY=Player.TileY then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
if Player.TileX >1 then
if Map(Location, Player.TileX-2, Player.TileY).BaseL<171 and Map(Location, Player.TileX-1, Player.TileY).BaseL<171 then
if XT + Level.TileX=Player.TileX-3 and YT+Level.TileY=Player.TileY then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
end if
if Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and Map(Location, Player.TileX, Player.TileY+2).BaseL<171 then
if XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY+3 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
if Player.TileY >1 and Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX, Player.TileY-2).BaseL<171 then
if XT + Level.TileX=Player.TileX and YT+Level.TileY=Player.TileY-3 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if

if Map(Location, Player.TileX+1, Player.TileY).BaseL<171 and Map(Location, Player.TileX+2, Player.TileY).BaseL<171 then
if Map(Location, Player.TileX+1, Player.TileY+1).BaseL<171 AND Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and XT + Level.TileX=Player.TileX+2 and YT+Level.TileY=Player.TileY+1 then AddLight 1, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX+1, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and XT + Level.TileX=Player.TileX+2 and YT+Level.TileY=Player.TileY-1 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
if Player.TileX >1 then
if Map(Location, Player.TileX-1, Player.TileY).BaseL<171 and Map(Location, Player.TileX-2, Player.TileY).BaseL<171 then
if Map(Location, Player.TileX-1, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and XT + Level.TileX=Player.TileX-2 and YT+Level.TileY=Player.TileY-1 then AddLight 1, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX-1, Player.TileY+1).BaseL<171 and Map(Location, Player.TileX, Player.TileY+1).BaseL<171 and XT + Level.TileX=Player.TileX-2 and YT+Level.TileY=Player.TileY+1 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
end if
if Map(Location, Player.TileX,Player.TileY+1).BaseL<171 and Map(Location, Player.TileX, Player.TileY+2).BaseL<171 then
if Map(Location, Player.TileX+1, Player.TileY+1).BaseL<171 and Map(Location, Player.TileX+1, Player.TileY).BaseL<171 and XT + Level.TileX=Player.TileX+1 and YT+Level.TileY=Player.TileY+2 then AddLight 1, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX-1, Player.TileY+1).BaseL<171 and Map(Location, Player.TileX-1, Player.TileY).BaseL<171 and XT + Level.TileX=Player.TileX-1 and YT+Level.TileY=Player.TileY+2 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if
if Player.TileY >1 and Map(Location, Player.TileX, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX, Player.TileY-2).BaseL<171 then
if Map(Location, Player.TileX-1, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX-1, Player.TileY).BaseL<171 and XT + Level.TileX=Player.TileX-1 and YT+Level.TileY=Player.TileY-2 then AddLight 1, XT + Level.TileX, YT + Level.TileY
if Map(Location, Player.TileX+1, Player.TileY-1).BaseL<171 and Map(Location, Player.TileX+1, Player.TileY).BaseL<171 and XT + Level.TileX=Player.TileX+1 and YT+Level.TileY=Player.TileY-2 then AddLight 1, XT + Level.TileX, YT + Level.TileY
end if

end if

end if


'ArtificialLights XT, YT
UnFogWalls XT, YT, 1 

retracty = 0
IF tilep=306+4 THEN retracty = 13

tilep = tilep - Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat
if Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat>0 then 
Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1
IF Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL = 301 THEN Map(Location, XT + Level.TileX, YT + Level.TileY+1).FogStat=1
END IF

' Explained with the comments above and in Engine.DrawPlayer sub.
IF tilep> 0 and tilep<157 AND Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[tilep-1]], pset


IF tilep> 170 AND Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20-retracty), @Tiles2.s_image.p_data[Tiles2.s_image.p_dataindex[tilep-1-170]], pset

if Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=0 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[146-1]], pset

next YT
next XT

' We loop through the collidable tiles twice because I use
' a quirky way to give the right lightning of the collidable
' tiles(walls).
for XT = 0 to ScrnTileXmax        
for YT = 0 to ScrnTileYmax
tilep = Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL
tilep=tilep+4
UnFogWalls XT, YT, 2 
ArtificialLights XT, YT
retracty = 0
IF tilep=306+4 THEN retracty = 13
tilep = tilep - Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat
'if Map(Location, XT + Level.TileX, YT + Level.TileY).BaseL>105 then
if Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat>0 then Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1
IF tilep> 0 and tilep<157 AND Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[tilep-1]], pset
IF tilep> 170 AND Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20-retracty), @Tiles2.s_image.p_data[Tiles2.s_image.p_dataindex[tilep-1-170]], pset

if Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=0 then put ((XT * TileW) - Level.Xpos+20, (YT * TileH) - Level.Ypos+20), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[146-1]], pset
'end if
next YT
next XT



MapXPos = 480-((MapXmax/2)*2)
MapYPos = 110-((MapYmax/2)*2)
subtractcol = 0
if mapblink < 25 then subtractcol = 1
for X = 0 to MapXmax          
for Y = 0 to MapYmax          
if Map(Location, X, Y).BaseL<56 then coll=77-subtractcol
if Map(Location, X, Y).BaseL>55 then coll=74-subtractcol
if Map(Location, X, Y).BaseL>170 then coll=72-subtractcol
if Map(Location, X, Y).BaseL=67 then coll=125-subtractcol
if Map(Location, X, Y).BaseL=306 OR Map(Location, X, Y).BaseL=321 then coll=154-subtractcol
if Map(Location, X, Y).BaseL=16 OR Map(Location, X, Y).BaseL=11 OR Map(Location, X, Y).BaseL=21 then coll=28-subtractcol

'IF Map(Location, X, Y).BaseL>65 then coll=74-subtractcol
if X = Player.TileX and Y= Player.TileY then coll=46-subtractcol*3
'IF Map(Location, X, Y).FogStat=1 THEN LINE (500+2*X,100+2*Y)-(502+2*X,102+2*Y),coll, BF
'IF Map(Location, X, Y).FogStat=0 THEN LINE (500+2*X,100+2*Y)-(502+2*X,102+2*Y),0, BF

if Map(Location, X, Y).FogStat=1 then line (MapXPos+2*X,MapYPos+10+2*Y)-(MapXPos+2+2*X,MapYPos+12+2*Y),coll, BF
if Map(Location, X, Y).FogStat=0 then line (MapXPos+2*X,MapYPos+10+2*Y)-(MapXPos+2+2*X,MapYPos+12+2*Y),0, BF

next Y
next X

line (MapXPos+2*MapXmax,MapYPos+15+2*MapYmax)-(MapxPos+2*(MapXmax+1),MapYPos+10),0, BF
line (MapXPos+2*0,MapYPos+15+2*MapYmax)-(MapXPos+2*(MapXmax+1),MapYPos+10+2*MapYmax),0, BF

'tilep = Map(Location, Player.TileX, Player.TileY).BaseL
'tilep=tilep+1
'Map(Location, Player.TileX, Player.TileY).LightStat=3
'PUT (Player.X+20 - Level.CamX, Player.Y+20 - Level.CamY), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[tilep-1]], PSET


' ==========FringeLayer====================
' Not implemented!
' ==========ObjectLayer====================
' Not implemented!

end sub


sub Engine.DrawNPC
'This is the main sub where we move our NPCs

if Turn=2 and Mode=1 and countbatanim>147 then

if NPC(Location, currentNPC).Alive = TRUE then AINPC currentNPC
if NPC(Location, currentNPC).Move=TRUE then NPC(Location, currentNPC).MovingTime=NPC(Location, currentNPC).MovingTime-1
if NPC(Location, currentNPC).MovingTime = 0 OR NPC(Location, currentNPC).Move=FALSE then 
NPC(Location, currentNPC).Move=FALSE
if Player.TileX=NPC(Location, currentNPC).TileX and Player.TileY=NPC(Location, currentNPC).TileY and NPC(Location, currentNPC).Alive = TRUE then
    Mode = 2
    BattleTurn = 2
    WorkingMode = 0
    SwordYPos=129
    MoveSwordMode = 0
    RumbleEnemy = 0
    RumblePlayer = 0
    AttackAnim = 0
    Player.AttackMode = 2
    Player.ShieldStatus=FALSE
    Player.Drugged = FALSE
    Player.RHandStamina=10
    Player.LHandStamina=10
    countbatanim = 0

for countNPC = 1 to numofnpcs  
NPCFrame = (NPC(Location, countNPC).Typ)*5
NPCFrame = NPCFrame - Map(Location, NPC(Location, countNPC).TileX, NPC(Location, countNPC).TileY).LightStat
if NPC(Location, countNPC).Alive = TRUE then
if NPC(Location, countNPC).X - Level.CamX<301 and NPC(Location, countNPC).Y - Level.CamY<301 then
if Map(Location, NPC(Location, countNPC).TileX, NPC(Location, countNPC).TileY).FogStat=1 then put ((NPC(Location, countNPC).X + 20 - Level.CamX), (NPC(Location, countNPC).Y + 20 - Level.CamY-5)), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[NPCFrame-1]], TRANS
end if
end if
next countNPC

    get (22,22)-(319,319), bimage2(0)
    get (22,22)-(319,319), bimage3(0)
    for bt=1 to 5
    btext(bt)=""
    next bt
    goto skipnextNPC:
end if
gonextnpc:
currentNPC=currentNPC+1
if currentNPC>numofnpcs then Turn = 1
if currentNPC<=numofnpcs then
NPC(Location, currentNPC).Move=FALSE
NPC(Location, currentNPC).MovingTime=10
NPC(Location, currentNPC).Direction = 0
NPC(Location, currentNPC).TileX = NPC(Location, currentNPC).X / TileW
NPC(Location, currentNPC).TileY = NPC(Location, currentNPC).Y / TileH
if abs(Player.TileX-NPC(Location, currentNPC).TileX)>4 OR abs(Player.TileY-NPC(Location, currentNPC).TileY)>4 THEN goto gonextnpc:
if NPC(Location, currentNPC).Alive = FALSE THEN goto gonextnpc:
end if
end if

end if

skipnextNPC:

for countNPC = 1 to numofnpcs  
                       
NPC(Location, countNPC).TileX = NPC(Location, countNPC).X / TileW
NPC(Location, countNPC).TileY = NPC(Location, countNPC).Y / TileH

NPCFrame = (NPC(Location, countNPC).Typ)*5

NPCFrame = NPCFrame - Map(Location, NPC(Location, countNPC).TileX, NPC(Location, countNPC).TileY).LightStat


'AINPC countNPC  ' AI for NPCs. We use AI on the current NPC in the 
                ' loop. Note how the AINPC sub is declared and how 
                ' countNPC value is passed into the AINPC sub!
                ' This sub also moves the NPCs.

' If NPC exists(not dead or similar) draw it.
if NPC(Location, countNPC).Alive = TRUE then

if NPC(Location, countNPC).X - Level.CamX<301 and NPC(Location, countNPC).Y - Level.CamY<301 then
if Map(Location, NPC(Location, countNPC).TileX, NPC(Location, countNPC).TileY).FogStat=1 then put ((NPC(Location, countNPC).X + 20 - Level.CamX), (NPC(Location, countNPC).Y + 20 - Level.CamY-5)), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[NPCFrame-1]], TRANS
end if
end if

next countNPC

if Turn=1 then put ((Player.X+20 - Level.CamX), (Player.Y+20 - Level.CamY-5)), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[Player.Frame-1]], TRANS

end sub


sub Engine.DrawPlayer (Player as SpriteType)
' This sub uses direction constant defined at module level(DN,DR...)
' to flag the right sprite to be displayed.



' Formula:
' Player.X - Level.CamX :
' puts the player at the center of the screen.
' So if Player.X = 500 then Level.CamX = Player.X - ScrnYmid(ScrnYmid = 320/2 = 160)
' Level.CamX: 500 - 160 = 340
' Player.X = 500
' Xcenter:500 - 340 = 160(ScrnXmid)
' Same goes for Y.
' See Engine.UpdateCamera for more Details :)
' Sprite(SpriteIndex(Sprite.Frame) is the current frame of 
' the Sprite(calculated above).

if Player.Frame <> 0 then    ' Just to be sure to prevent errors. 
                             ' Player.Frame can be 0 but since in
                             ' the PUT statement we paste 
                             ' Player.Frame - 1 sprite we have to
                             ' use this. R.E.Lope's sprite loading
                             ' routine counts the sprites from 0
                             ' while PP256 from 1. That's why in
                             ' all the PUT statements you'll see
                             ' "- 1" after the number of sprite.

' A classic PUT statement with a bit quirky way of pointing to the
' memory address where the sprite is saved(with a pointer). Explore 
' that method by looking into pp256_image.bi if really interested. 
' Otherwise, just use it like it's used in this engine.                             
'IF Player.Move = TRUE THEN 
'IF Frame3=2 THEN Player.Frame=Player.Frame+1
'IF Player.Frame>1 THEN PUT ((Player.OldX - Level.CamX), (Player.OldY - Level.CamY)), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[Player.Frame-1]], TRANS
'END IF
'IF Player.Frame>1 AND Frame3=2 AND Player.Move=FALSE THEN Player.Frame=Player.Frame-1

put ((Player.X+20 - Level.CamX), (Player.Y+20 - Level.CamY-5)), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[Player.Frame-1]], TRANS
 
'PUT ((340), (0)), @tiles.s_image.p_data[tiles.s_image.p_dataindex[placetile-1]], TRANS
           
end if
            
end sub


sub Engine.DrawScreen
' This sub draws our stuff on the screen and controls the page
' flipping.

FPS = FPS + 1                     ' Used to count FPS.
if StartTime& + 1 < timer then
 FPS2 = FPS
 FPS = 0
 seconds = seconds + 1
 StartTime& = timer
if seconds = 60 then 
minutes = minutes+1
seconds=0
end if
if minutes = 60 then
minutes=0
hours = hours + 1
end if
end if


' Frame variables are used to time all kind of animations in our
' game like walking. Play with these variables to change the
' speed of walk animation.
Frame3 = (Frame3 mod 3) + 1 
if Frame3 = 1 then Frame = (Frame mod 2) + 1     
if Frame = 0 then Frame = 1
Frame2 = (Frame2 mod 2) + 1  
Frame4 = (Frame4 mod 6) + 1 
mapblink = int(rnd * 50) + 1


' Hide our work page and draw stuff on it.
screenset 1, 0

' We clear our work page(LINE statement) and draw our player
' and NPCs sprites on it(sprites on the clear background - 
' better collision detection).
cls


Levelize
Engine.DrawMap            ' Draw our map tiles on the screen.
'Engine.DrawMap   
Engine.DrawCorpses
Engine.DrawLockers
Engine.DrawPlayer Player  ' Draw our player on the scren.
Engine.DrawNPC
Engine.DrawInterFace
' Print some variables on the screen with our custom font routine.
'GraphicText 4,355, "FPS:" + STR$(FPS2), Font
'GraphicText 4,365, "Player.TileX:" + STR$(Player.TileX), Font
'GraphicText 4,425, "Num of doors:" + STR$(countdeath), Font

'GraphicText 4,385, "Level.TileY:" + STR$(NPC(Location,4).Typ), Font
'GraphicText 4,425, "Mouse:"+STR$(mx)+","+STR$(my)+","+STR$(buttons), Font

' One of those ugly "nitpick" pieces of code used to capture the
' proper map screen with proper player's position when he attack 
' the enemy. We need to capute the map screen on this position when
' you attack the enemy for the curtain effect and we do that
' using this skipbattle variable. Check in the code to see
' where this variable is initiated and used.
if skipbattle = TRUE then
CaptureScreen
skipbattle = FALSE
end if

cursorspr = 22
if Turn = 2 and Mode=1 then cursorspr=45
if BattleTurn = 2 and Mode=2 then cursorspr=45
if Player.Alive = FALSE THEN cursorspr=45
if countbatanim<147 then cursorspr=45
put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[cursorspr-1]], TRANS
'PUT (mx, my), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[18-1]], TRANS

'SCREENSYNC  ' Wait for vertical sync.
screencopy      ' Copy our work page on the screen.
SCREENSYNC   ' Wait for vertical sync.
sleep 2
IF GameSpeed=2 THEN sleep 11

if multikey(SC_S) then
bsave "screenshot"+LTRIM$(RTRIM$(STR$(sshoot)))+".bmp", 0, 3072000
sshoot=sshoot+1
if Mode = 1 then NewNText$ "Screenshot taken!"
if Mode = 2 then NewBText$ "Screenshot taken!", 2
while multikey(SC_S)
wend
end if

' If I use vertical blank syncing before SCREENCOPY I get
' a notable amount of trembling. Please test it yourself
' a let me know if you get any trembling.

end sub

function Engine.TileCollide (Character as SpriteType) static
' Crappy tile*tile collision detection ;)
' Returns TRUE if collision is detected, FALSE if not.
' Pixel perfect collision with map tiles is not an option since
' tiles don't feature TRANSPARENT color. You can use another layer
' for trees and similar static objects and then apply pixel by
' pixel collision on that layer.
'EXIT SUB
' Init the function to be FALSE(no collision).
Engine.TileCollide = FALSE

' 4 checks are done to be sure ;)
' This checks all the corners of the character for tile collision.
' + 10 in Character.Y for up-left and up-right corner is used to
' create an illusion of "foot" collision.
' Up-Left corner of Character
X = Character.X + 1       
Y = Character.Y+1
gosub CheckForTile      ' Checks for collision.

' Up-Right corner of the character.
X = Character.X + 19
Y = Character.Y+1
gosub CheckForTile

' Down-Right corner of the character.
X = Character.X + 19
Y = Character.Y + 19
gosub CheckForTile

' Down-Left corner of the character.
X = Character.X + 1
Y = Character.Y + 19
gosub CheckForTile

exit function

' Checks for collision:(Bounding BoxType)
CheckForTile:
TX = X \ TileW          ' Character.X\TileW=Character.TileX
TY = Y \ TileH          ' Character.Y\TileH=Character.TileY

' In this example, all tiles above 5 are colliding.
if Map(Location, TX, TY).BaseL > 55 then
   Engine.TileCollide = TRUE
   Character.Move = FALSE
end if

return          ' Check for the next coordinate.

end function


sub Engine.UpdateCamera (Level as LevelType, Player as SpriteType) 

' Updates CAMX, CAMY in relation to Player.X, Player.Y to achieve
' ZELDA style scrolling engine.
' Sample Code:
' CODE: CASE DR
        ' Right Direction of movement.
' CODE: Level.CamX = Player.X - ScrnXmid
        ' Centers our player and moves the camera to where
        ' the player is going.
        ' ie, Assume: Player.X=1200, ScrnMid=Constant 160(middle of the screen)
        ' Level.CamX: 1200-160=1040
        ' To get the TileX:
        ' TileX=Level.CamX\TileW=1040\20=52(This will be used with 
        ' Engine.DrawMap).
' CODE: IF Level.CamX < ScrnXmin THEN Level.CamX = ScrnXmin
        ' Checks if Level.CamX<0, zero it if its negative to prevent 
        ' errors. ScrnYmin=0(constant).
' CODE: IF Level.CamX > (Level.Xmax * TileW) - ScrnXmax THEN Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        ' Checks if Level.CamX > (Level.Xmax * TileW) - ScrnXmax
        ' ScrnXmax = Maximum number of PIXELS our map has.
        ' Level.Xmax = Maximum number of tiles our map has.
        ' TileW = Width of our tile(constant).
        ' ScrnXmax = 320(constant).
        ' To calculate: Level.Xmax = MapXmax
        ' Formula:(Level.Xmax * TileW) - ScrnXmax
        ' Level.Xmax = 36  ->> this is an example.
        ' (36*20)-320 = 400
        ' Level.CamX =4 00
        ' To calculate TileX:
        ' Level.CamX\TileW
        ' 400\20 = 20
        ' TileX = 20(Start Drawing from 20 to 36) in Engine.DrawMap sub.
        ' 16 is the first tile to draw in X direction.
        ' 36-20 = 16(See, we have to draw 20 tiles horizontally!!!)
        ' Same goes for Y.
        ' See Engine.DrawMap SUB for more details. ;)

select case Player.Direction
        case DR
                Level.CamX = Player.X - ScrnXmid
                if Level.CamX < ScrnXmin then Level.CamX = ScrnXmin
                if Level.CamX > (Level.Xmax * TileW) - ScrnXmax then Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        case DU
                Level.CamY = Player.Y - ScrnYmid
                if Level.CamY < ScrnYmin then Level.CamY = ScrnYmin
                if Level.CamY > (Level.Ymax * TileH) - ScrnYmax then Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        case DL
                Level.CamX = Player.X - ScrnXmid
                if Level.CamX < ScrnXmin then Level.CamX = ScrnXmin
                if Level.CamX > (Level.Xmax * TileW) - ScrnXmax then Level.CamX = (Level.Xmax * TileW) - ScrnXmax
        case DD
                Level.CamY = Player.Y - ScrnYmid
                if Level.CamY < ScrnYmin then Level.CamY = ScrnYmin
                if Level.CamY > (Level.Ymax * TileH) - ScrnYmax then Level.CamY = (Level.Ymax * TileH) - ScrnYmax
        case else
end select

end sub

sub Engine.UpdatePlayer (Player as SpriteType, Direction) 
' Updates the player's position according to player's direction.
' ZELDA style pixel by pixel free movement.
' Sample Code:
' CODE: CASE DR
      ' Direction of player's movement.
' CODE: Player.X = Player.X + Player.XV
      ' Adds Xspeed to Player's X position since we are moving right.
' CODE: IF Engine.TileCollide(Player) THEN Player.X = Player.X - Player.XV
        ' Check for collision. If collided with valid "collidable" tile
        ' subtract Xspeed to return the player to it's original place.
        ' Also prevents player sticking to tiles when changing direction.
' CODE: IF Player.X > (Level.Xmax * TileW) - TileW THEN Player.X = (Level.Xmax * TileW) - TileW
        ' Checks if player is outside the map boudaries.
        ' Subtracting TileW is necessary to prevent errors if your
        ' speed is greater than 1. Also used for padding.

select case Direction
        case DR
                
                
                ' Flag that player is moving. This flags animation of the player
                ' (REM this for no animation). We need to flag this before 
                ' checking for tile collision since in tile collision sub movement
                ' is flagged as FALSE upon collision with a tile.
                
                Player.X = Player.X + Player.XV
                if Engine.TileCollide(Player) then 
                    Player.X = Player.X - Player.XV
                    Player.Move = FALSE
                    end if
                if Player.X > (Level.Xmax * TileW) - TileW then Player.X = (Level.Xmax * TileW) - TileW
        case DU
                
               Player.Y = Player.Y - Player.YV 
                if Engine.TileCollide(Player) then 
                    Player.Y = Player.Y + Player.YV
                    Player.Move = FALSE
                end if
                
                if Player.Y < ScrnYmin then Player.Y = ScrnYmin
        case DL
                Player.X = Player.X - Player.XV
        
                if Engine.TileCollide(Player) then 
                    Player.X = Player.X + Player.XV
                    Player.Move = FALSE
                    end if
                if Player.X < ScrnXmin then Player.X = ScrnXmin
        case DD
                Player.Y = Player.Y + Player.YV
              
                if Engine.TileCollide(Player) then 
                    Player.Y = Player.Y - Player.YV
                    Player.Move = FALSE
                    end if
                if Player.Y > (Level.Ymax * TileH) - TileH then Player.Y = (Level.Ymax * TileH) - TileH
        case else
end select

' Calculates on what tile the player is.
' Adds (TileW/2) or (TileH/2) to X and Y to get center of the player. 
Player.TileX = (Player.X + (TileW/2)) \ TileW  
Player.TileY = (Player.Y + (TileH/2)) \ TileH

end sub


sub InitMap (mapcon$)
' This sub loads our map on the screen and you can use a different
' type of map loader. Map loading is not glued to the very scrolling 
' engine. This map loader first loads the map x size and map y size(in 
' number of tiles) and then the very tiles.
' You should leave(create) one line of unused tiles horizontally and
' vertically in your MAP file to avoid errors.

open pathf$ + mapcon$ for input as #2
input #2, MapXMax
input #2, MapYMax
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #2, Map(Location, X, Y).BaseL  ' Map is loaded from a file(note INPUT #2
next X                     ' statement) and written in the map array.
next Y
close #2

end sub


sub InitVariables 
    
randomize timer 

'******************* Same for every new game
mousefree = FALSE
keyboardfree = FALSE
Mode = 1
WorkingMode = 0
countbatanim = 150
countdeath=0  
hours = 0
minutes = 0
seconds = 0
skipbattle = FALSE
for ctrig=1 to 8
trigger(ctrig)=0
next ctrig
Player.Alive = TRUE
Player.Typ = 1    
Player.ReMove = FALSE
Player.FoodStatus=3
Player.FoodCount = 0
Player.Poisoned=FALSE
Player.PoisonCount = 17
Player.Oxywear = FALSE
Player.Oxygen = 3
Player.Score = 0
Turn = 1
currentNPC=1
Location = 1

for cbtext = 1 to 5
btext(cbtext) = ""
next cbtext

for cntext = 1 to 5
ntext(cntext) = ""
next cntext

for cwinv = 1 to 7
weaponsinv(cwinv) = 0
next cwinv

for citv = 1 to 7
itemsinv(citv) = 0
next citv

' Kill all lockers(new game)
' We loop through 8 levels though the game
' features 6. You can change this but be
' sure to change this in save/load
' routines too.
for loca=1 to 8
for cloc=1 to 50  
Locker(loca, cloc).Exist=FALSE
next cloc
next loca

' Kill all corpses(new game)
for loca=1 to 8
for ccoc=1 to 50  
Corpse(loca, ccoc).Exist=FALSE
next ccoc
next loca

' Kill all NPCs(new game)
for loca=1 to 8
for ccoc=1 to 50  
NPC(loca, ccoc).Alive=FALSE
next ccoc
next loca

' Kill all doors(new game)
for loca=1 to 8
for cdoor=1 to 30  
Door(loca, cdoor).Exist=FALSE
next cdoor
next loca

' Set ALL the game lockers(first element in the
' array is the floor). We open the map file and check for
' lockers(tile numbers above 144). If a locker is on that position
' set it's coordinates according to the position in the map
' file.

' We loop through the ship levels. During this looping we will
' set the doors, corpses and NPCs too.
FOR lockLocation = 1 TO 4
    
numoflock = 0
numofdoor = 0
open pathf$ + "Data\level"+LTRIM$(RTRIM$(STR$(lockLocation)))+".map" for input as #2
input #2, MapXMax
input #2, MapYMax
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #2, Map(lockLocation, X, Y).BaseL
if Map(lockLocation, X, Y).BaseL = 156 then
Map(lockLocation, X, Y).BaseL = 67
numoflock = numoflock + 1
Locker(lockLocation, numoflock).X = X*TileW
Locker(lockLocation, numoflock).Y = Y*TileH
end if
if Map(lockLocation, X, Y).BaseL = 296 OR Map(lockLocation, X, Y).BaseL = 311 then
numofdoor = numofdoor + 1
Door(lockLocation, numofdoor).X = X*TileW
Door(lockLocation, numofdoor).Y = Y*TileH
Door(lockLocation, numofdoor).Exist = TRUE
Door(lockLocation, numofdoor).Mode  = 0
IF Map(lockLocation, X, Y).BaseL = 296 THEN Door(lockLocation, numofdoor).Typ  = 1
IF Map(lockLocation, X, Y).BaseL = 311 THEN Door(lockLocation, numofdoor).Typ  = 2
end if
next X                  
next Y
close #2

for cloc=1 to numoflock 
    
Locker(lockLocation, cloc).Exist=TRUE
IF lockLocation = 1 THEN Locker(lockLocation, cloc).Frame=31
IF lockLocation = 2 THEN Locker(lockLocation, cloc).Frame=36
IF lockLocation = 4 THEN Locker(lockLocation, cloc).Frame=31
Locker(lockLocation, cloc).Mode=1

IF lockLocation = 1 THEN
rndl = int(rnd * 30) + 1
if rndl < 5 then Locker(lockLocation, cloc).Typ = 1
if rndl >4 and rndl<12 then Locker(lockLocation, cloc).Typ = 9
if rndl > 11 and rndl<20 then Locker(lockLocation, cloc).Typ = 2
if rndl > 19 and rndl<26 then Locker(lockLocation, cloc).Typ = 1
if rndl > 25 then Locker(lockLocation, cloc).Typ = 4
END IF

IF lockLocation = 2 THEN
rndl = int(rnd * 30) + 1
if rndl < 10 then Locker(lockLocation, cloc).Typ = 1
if rndl >9 and rndl<16 then Locker(lockLocation, cloc).Typ = 9
if rndl > 15 and rndl<24 then Locker(lockLocation, cloc).Typ = 2
if rndl > 23 then Locker(lockLocation, cloc).Typ = 4
if rndl > 27 then Locker(lockLocation, cloc).Typ = 7
END IF

IF lockLocation = 4 THEN
rndl = int(rnd * 41) + 1
if rndl < 15 then Locker(lockLocation, cloc).Typ = 1
if rndl >14 and rndl<26 then Locker(lockLocation, cloc).Typ = 9
if rndl > 25 and rndl<32 then Locker(lockLocation, cloc).Typ = 2
if rndl > 31 then Locker(lockLocation, cloc).Typ = 4
if rndl > 35 then Locker(lockLocation, cloc).Typ = 7
if rndl > 38 then Locker(lockLocation, cloc).Typ = 6
END IF

next cloc

' With the following lines we can set how much medpacks in
' level lockers we will have as well as antidotes.
' *******************
IF lockLocation=1 THEN endmedpack=5
IF lockLocation=2 THEN endmedpack=6
IF lockLocation=3 THEN endmedpack=0
IF lockLocation=4 THEN endmedpack=10
FOR cl=1 TO endmedpack
backlocky1:
rndml = int(rnd * numoflock) + 1 
IF Locker(lockLocation, rndml).Typ = 3 then goto backlocky1:
IF Locker(lockLocation, rndml).Typ <>3 THEN Locker(lockLocation, rndml).Typ = 3
NEXT cl

IF lockLocation=1 THEN endantid=0
IF lockLocation=2 THEN endantid=0
IF lockLocation=3 THEN endantid=0
IF lockLocation=4 THEN endantid=2
FOR cl=1 TO endantid
IF endantid = 0 THEN goto exitantid:
backlocky2:
rndml = int(rnd * numoflock) + 1 
IF (Locker(lockLocation, rndml).Typ = 3) OR  (Locker(lockLocation, rndml).Typ >4 AND Locker(lockLocation, rndml).Typ <9) then goto backlocky2:
IF Locker(lockLocation, rndml).Typ <>6 THEN Locker(lockLocation, rndml).Typ = 6
NEXT cl
exitantid:
' ***********************************

IF lockLocation=2 THEN
FOR cla=26 TO 33
rndml = int(rnd * 8) + 1
IF rndml=2 THEN 
Locker(lockLocation, cla).Typ = 10
goto exitcarm4:
END IF
IF cla=33 THEN Locker(lockLocation, cla).Typ = 10
NEXT cla
exitcarm4:
FOR claa=18 TO 24
rndml = int(rnd * 8) + 1
IF rndml=2 THEN 
Locker(lockLocation, claa).Typ = 5
goto exitcarm3:
END IF
IF claa=24 THEN Locker(lockLocation, claa).Typ = 5
NEXT claa
END IF
exitcarm3:

IF lockLocation=4 THEN
    
FOR clab=1 TO 6
rndml = int(rnd * 8) + 1
IF rndml=2 THEN 
Locker(lockLocation, clab).Typ = 11
goto exitcarm:
END IF
IF clab=6 THEN Locker(lockLocation, clab).Typ = 11
NEXT clab
exitcarm:
FOR clab=8 TO 40
rndml = int(rnd * 8) + 1
IF rndml=2 THEN 
Locker(lockLocation, clab).Typ = 12
goto exitcarm2:
END IF
IF clab=40 THEN Locker(lockLocation, clab).Typ = 12
NEXT clab
END IF
exitcarm2:


' We set the number of corpses according to level and set
' what each corpse gives when examines.
' *************** ********* *******
IF lockLocation = 1 THEN numofcorpses = 8
IF lockLocation = 2 THEN numofcorpses = 12
IF lockLocation = 3 THEN numofcorpses = 12
IF lockLocation = 4 THEN numofcorpses = 18

for ccor=1 to numofcorpses
Corpse(lockLocation, ccor).Exist=TRUE
IF lockLocation <3 THEN
rndfram = int(rnd * 4) + 1
if rndfram = 1 then Corpse(lockLocation, ccor).Frame=1
if rndfram = 2 then Corpse(lockLocation, ccor).Frame=6
if rndfram = 3 then Corpse(lockLocation, ccor).Frame=11
if rndfram = 4 then Corpse(lockLocation, ccor).Frame=16
END IF
IF lockLocation >2 THEN
rndfram = int(rnd * 6) + 1
if rndfram = 1 then Corpse(lockLocation, ccor).Frame=1
if rndfram = 2 then Corpse(lockLocation, ccor).Frame=6
if rndfram = 3 then Corpse(lockLocation, ccor).Frame=11
if rndfram = 4 then Corpse(lockLocation, ccor).Frame=16
if rndfram = 5 then Corpse(lockLocation, ccor).Frame=21
if rndfram = 6 then Corpse(lockLocation, ccor).Frame=26
END IF
Corpse(lockLocation, ccor).Mode=1
redornd1:
IF lockLocation = 1 THEN
if ccor<5 then
rndx = int(rnd * 58) + 1
rndy = int(rnd * 32) + 25
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
if ccor>4 then
rndx = int(rnd * 58) + 1
rndy = int(rnd * 25) + 1
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
END IF

IF lockLocation = 2 THEN
if ccor<7 then
rndx = int(rnd * 68) + 1
rndy = int(rnd * 35) + 20
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
if ccor>6 then
rndx = int(rnd * 68) + 1
rndy = int(rnd * 35) + 1
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
END IF

IF lockLocation = 3 THEN
if ccor<10 then
rndx = int(rnd * 78) + 1
rndy = int(rnd * 35) + 40
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
if ccor>9 then
rndx = int(rnd * 78) + 1
rndy = int(rnd * 40) + 1
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
END IF

IF lockLocation = 4 THEN
if ccor<10 then
rndx = int(rnd * 78) + 1
rndy = int(rnd * 35) + 40
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
if ccor>9 then
rndx = int(rnd * 78) + 1
rndy = int(rnd * 40) + 1
Corpse(lockLocation, ccor).X=rndx*TileW
Corpse(lockLocation, ccor).Y=rndy*TileH
end if
END IF

Corpse(lockLocation, ccor).TileX = (Corpse(lockLocation, ccor).X + (TileW/2)) \ TileW  
Corpse(lockLocation, ccor).TileY = (Corpse(lockLocation, ccor).Y + (TileH/2)) \ TileH

' Check if on free tile...
if Map(lockLocation, Corpse(lockLocation, ccor).TileX, Corpse(lockLocation, ccor).TileY).BaseL>55 then goto redornd1:

IF lockLocation=1 THEN 
if Corpse(lockLocation, ccor).TileX<19 and Corpse(lockLocation, ccor).TileY>13 and Corpse(lockLocation, ccor).TileY<32 then goto redornd1:
END IF

if Map(lockLocation, Corpse(lockLocation, ccor).TileX, Corpse(lockLocation, ccor).TileY).BaseL=16 OR Map(lockLocation, Corpse(lockLocation, ccor).TileX, Corpse(lockLocation, ccor).TileY).BaseL=11 OR Map(lockLocation, Corpse(lockLocation, ccor).TileX, Corpse(lockLocation, ccor).TileY).BaseL=21 then goto redornd1:
for relopc=1 to ccor
if ccor<>relopc and Corpse(lockLocation, ccor).Y=Corpse(lockLocation, relopc).Y and Corpse(lockLocation, ccor).X=Corpse(lockLocation, relopc).X then goto redornd1:
next relopc

IF lockLocation = 1 THEN
if ccor=1 then Corpse(lockLocation, ccor).Typ = 0
if ccor=2 then Corpse(lockLocation, ccor).Typ = 2
if ccor=3 then Corpse(lockLocation, ccor).Typ = 2
if ccor=4 then Corpse(lockLocation, ccor).Typ = 3
if ccor=5 then Corpse(lockLocation, ccor).Typ = 4
if ccor=6 then Corpse(lockLocation, ccor).Typ = 9
if ccor=7 then Corpse(lockLocation, ccor).Typ = 1

rndc = int(rnd * 2) + 1
if rndc = 1 and ccor=2 then Corpse(lockLocation, ccor).Exist = FALSE

IF ccor=8 THEN
Corpse(lockLocation, ccor).X=13*TileW
Corpse(lockLocation, ccor).Y=18*TileH
Corpse(lockLocation, ccor).TileX = (Corpse(lockLocation, ccor).X + (TileW/2)) \ TileW  
Corpse(lockLocation, ccor).TileY = (Corpse(lockLocation, ccor).Y + (TileH/2)) \ TileH
Corpse(lockLocation, ccor).Typ = 10
END IF

END IF

IF lockLocation=2 THEN
if ccor=1 then Corpse(lockLocation, ccor).Typ = 3
if ccor=2 then Corpse(lockLocation, ccor).Typ = 2
if ccor=3 then Corpse(lockLocation, ccor).Typ = 1
if ccor=4 then Corpse(lockLocation, ccor).Typ = 0
if ccor=5 then Corpse(lockLocation, ccor).Typ = 4
if ccor=6 then Corpse(lockLocation, ccor).Typ = 2
if ccor=7 then Corpse(lockLocation, ccor).Typ = 1
if ccor=8 then Corpse(lockLocation, ccor).Typ = 3
if ccor=9 then Corpse(lockLocation, ccor).Typ = 4
if ccor=10 then Corpse(lockLocation, ccor).Typ = 1
if ccor=11 then Corpse(lockLocation, ccor).Typ = 2
if ccor=12 then Corpse(lockLocation, ccor).Typ = 2
END IF

IF lockLocation=4 THEN
if ccor=1 then Corpse(lockLocation, ccor).Typ = 1
if ccor=2 then Corpse(lockLocation, ccor).Typ = 6
if ccor=3 then Corpse(lockLocation, ccor).Typ = 1
if ccor=4 then Corpse(lockLocation, ccor).Typ = 2
if ccor=5 then Corpse(lockLocation, ccor).Typ = 8
if ccor=6 then Corpse(lockLocation, ccor).Typ = 2
if ccor=7 then Corpse(lockLocation, ccor).Typ = 1
if ccor=8 then Corpse(lockLocation, ccor).Typ = 3
if ccor=9 then Corpse(lockLocation, ccor).Typ = 4
if ccor=10 then Corpse(lockLocation, ccor).Typ = 1
if ccor=11 then Corpse(lockLocation, ccor).Typ = 3
if ccor=12 then Corpse(lockLocation, ccor).Typ = 2
if ccor=13 then Corpse(lockLocation, ccor).Typ = 5
if ccor=14 then Corpse(lockLocation, ccor).Typ = 4
if ccor=15 then Corpse(lockLocation, ccor).Typ = 11
if ccor=16 then Corpse(lockLocation, ccor).Typ = 7
if ccor=17 then Corpse(lockLocation, ccor).Typ = 7
if ccor=18 then Corpse(lockLocation, ccor).Typ = 2
END IF

next ccor

NEXT lockLocation

' *************** ********* *******

Player.X = 30 * TileW    
Player.Y = 57 * TileH    
Player.XV = 2            
Player.YV = 2           
Player.Frame = 1         ' We start at frame 1(looking-at-screen-sprite) :)
Player.Move = FALSE      ' Static(no movement) :)
Player.Direction = DU    ' Starting direction(down).
Player.OldX = Player.X
Player.OldY = Player.Y
Player.TileX = 30
Player.TileY = 57         
Player.Level = 1           
Player.Experience = 0      
Player.AttackL = 1        
Player.defenseL = 1  
Player.Money = 0  
Player.Kills = 0  

Player.LWeapon = 0       
Player.RWeapon = 0
if Player.MainArm=1 then Player.LWeapon=1
if Player.MainArm=2 then Player.RWeapon=1
Player.Armour = 1         
Player.Boots = 4
Player.Health = 60
Player.MaxHealth = 60
Player.MedPack = 0
Player.Food = 1
Player.ElecDistruptor = 0
Player.AcidBomb = 0
Player.Shield = 0
Player.Antidote = 0
Player.Steroids = 0
Player.Bomb = 0


for ceqinv = 1 to 7
equipmentinv(ceqinv)= 0
'if ceqinv = 2 then equipmentinv(ceqinv)= 6
'if ceqinv = 7 then equipmentinv(ceqinv)= 3
next ceqinv

for cloc = 1 TO 8
' We set the number of NPCs according to level and randomize
' their positions with certain variables as well as their
' type.
if cloc=1 THEN numofnpcs = 14
if cloc=2 THEN numofnpcs = 22
if cloc=4 THEN numofnpcs = 30
for cnpc=1 to numofnpcs
NPC(cloc, cnpc).Alive = TRUE
NPC(cloc, cnpc).YV = 2
NPC(cloc, cnpc).XV = 2
NPC(cloc, cnpc).Move=FALSE
repeatrpos:
IF cloc = 1 THEN
IF cnpc>8 THEN
rndx = int(rnd * 58) + 1
rndy = int(rnd * 25) + 1
rndtyp = int(rnd * 2) + 1
IF rndtyp = 1 THEN NPC(cloc, cnpc).Typ = 1
IF rndtyp = 2 THEN NPC(cloc, cnpc).Typ = 3
IF cnpc=9 OR cnpc=11 THEN NPC(cloc, cnpc).Typ = 4
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
END IF
IF cnpc<9 THEN
rndx = int(rnd * 58) + 1
rndy = int(rnd * 30) + 25
rndtyp = int(rnd * 4) + 1
IF rndtyp = 1 THEN NPC(cloc, cnpc).Typ = 1
IF rndtyp = 2 THEN NPC(cloc, cnpc).Typ = 3
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 7
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
IF NPC(cloc,cnpc).Y/TileH > 50 AND NPC(cloc,cnpc).X/TileW>20 AND NPC(cloc,cnpc).X/TileW<40 then goto repeatrpos:
END IF
END IF
IF cloc = 2 THEN
IF cnpc>11 THEN
rndx = int(rnd * 58) + 1
rndy = int(rnd * 35) + 1
rndtyp = int(rnd * 5) + 1
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 2
IF rndtyp <3 THEN NPC(cloc, cnpc).Typ = 1
IF cnpc=13 OR cnpc=15 OR cnpc=17 THEN NPC(cloc, cnpc).Typ = 5
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
END IF
IF cnpc<12 THEN
rndx = int(rnd * 58) + 1
rndy = int(rnd * 35) + 30
rndtyp = int(rnd * 6) + 1
IF rndtyp = 1 THEN NPC(cloc, cnpc).Typ = 5
IF rndtyp = 2 THEN NPC(cloc, cnpc).Typ = 8
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 11
IF rndtyp >5 THEN NPC(cloc, cnpc).Typ = 4
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
'IF NPC(cloc,cnpc).X/TileW > 50 AND NPC(cloc,cnpc).Y/TileH>20 AND NPC(cloc,cnpc).Y/TileH<40 then goto repeatrpos:
END IF
END IF

IF cloc=3 THEN
IF cnpc>15 THEN
rndx = int(rnd * 40) + 1
rndy = int(rnd * 77) + 1
rndtyp = int(rnd * 5) + 1
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 2
IF rndtyp <3 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=16 OR cnpc=17 OR cnpc=18 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=19 OR cnpc=20 THEN NPC(cloc, cnpc).Typ = 8
IF cnpc=23 THEN NPC(cloc, cnpc).Typ = 7
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
END IF
IF cnpc<16 THEN
rndx = int(rnd * 35) + 40
rndy = int(rnd * 77) + 1
rndtyp = int(rnd * 6) + 1
IF rndtyp = 1 THEN NPC(cloc, cnpc).Typ = 8
IF rndtyp = 2 THEN NPC(cloc, cnpc).Typ = 2
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 11
IF rndtyp >5 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=14 THEN NPC(cloc, cnpc).Typ = 3
IF cnpc=13 THEN NPC(cloc, cnpc).Typ = 1
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
'IF NPC(cloc,cnpc).X/TileW > 50 AND NPC(cloc,cnpc).Y/TileH>20 AND NPC(cloc,cnpc).Y/TileH<40 then goto repeatrpos:
END IF    
END IF

IF cloc=4 THEN
IF cnpc>15 THEN
rndx = int(rnd * 40) + 1
rndy = int(rnd * 77) + 1
rndtyp = int(rnd * 5) + 1
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 2
IF rndtyp <3 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=16 OR cnpc=17 OR cnpc=18 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=19 OR cnpc=20 THEN NPC(cloc, cnpc).Typ = 8
IF cnpc=23 THEN NPC(cloc, cnpc).Typ = 7
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
END IF
IF cnpc<16 THEN
rndx = int(rnd * 35) + 40
rndy = int(rnd * 77) + 1
rndtyp = int(rnd * 6) + 1
IF rndtyp = 1 THEN NPC(cloc, cnpc).Typ = 8
IF rndtyp = 2 THEN NPC(cloc, cnpc).Typ = 2
IF rndtyp >2 THEN NPC(cloc, cnpc).Typ = 11
IF rndtyp >5 THEN NPC(cloc, cnpc).Typ = 5
IF cnpc=14 THEN NPC(cloc, cnpc).Typ = 3
IF cnpc=13 THEN NPC(cloc, cnpc).Typ = 1
NPC(cloc, cnpc).X=rndx*TileW
NPC(cloc, cnpc).Y=rndy*TileH
'IF NPC(cloc,cnpc).X/TileW > 50 AND NPC(cloc,cnpc).Y/TileH>20 AND NPC(cloc,cnpc).Y/TileH<40 then goto repeatrpos:
END IF    
END IF

NPC(cloc, cnpc).TileX = NPC(cloc, cnpc).X / TileW
NPC(cloc, cnpc).TileY = NPC(cloc, cnpc).Y / TileH
IF Map(cloc, NPC(cloc, cnpc).TileX, NPC(cloc, cnpc).TileY).BaseL>55 OR Map(cloc, NPC(cloc, cnpc).TileX, NPC(cloc, cnpc).TileY).BaseL= 16 OR Map(cloc, NPC(cloc, cnpc).TileX, NPC(cloc, cnpc).TileY).BaseL= 12 OR Map(cloc, NPC(cloc, cnpc).TileX, NPC(cloc, cnpc).TileY).BaseL=21 THEN goto repeatrpos:

next cnpc
next cloc


for levc=1 to 8
if levc=1 then
MapYMax = 60
MapXMax = 60
end if
if levc=2 then
MapYMax = 70
MapXMax = 70
end if
if levc=4 then
MapYMax = 80
MapXMax = 80
end if
for Y = 0 to MapYMax
for X = 0 to MapXMax
Map(levc, X, Y).FogStat = 0  
next X                    
next Y
next levc

IF Location = 1 THEN numofnpcs = 14
LoadNPCs 1

open pathf$ + "Data\level1.map" for input as #2
input #2, MapXMax
input #2, MapYMax
close #2

Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+".PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+"1.PUT"
Tile_load_image ( Tiles2 )

Level.Xmax = MapXMax    ' Flags our level(play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU              ' Two directions so that engine will
Engine.UpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR              ' positions from left to right
Engine.UpdateCamera Level, Player  ' No warping ;)
                                   ' In other words, inital camera
                                   ' setting.
                                   
end sub


sub Main
' Our main loop. Checks which key the player has pressed and moves
' the player according to that.
' It also initiates Engine.DrawScreen sub which draws all our
' stuff on the screen.
' Storing old player's position is used with player to NPC
' collision in order to restore player's old position when he
' bumps with a NPC. Note how with moving up and down only the old
' Y position is stored and how with moving right and left only
' the X position is stored. Try to UNREM the lines I REMed
' and you'll see a bad thing happen.

do


if Mode=2 or Player.Alive = FALSE then goto skiprr:

if buttons = 1 and Player.Move = FALSE and Turn = 1 then
if ArrowStatus = 1 then goto moveleft:
if ArrowStatus = 2 then goto moveright:
if ArrowStatus = 3 then goto movedown:
if ArrowStatus = 4 then goto moveup:
end if

  if multikey(&h48) and Player.Move = FALSE and Turn = 1 then 
  moveup:
  WorkingMode = 0
  Player.Direction = DU  
  Player.OldX = Player.X   
  Player.OldY = Player.Y  
  Player.Move = TRUE
  Player.MovingTime = 10
         
  end if

        if multikey(&h50) and Player.Move= FALSE and Turn = 1 then  ' Pressed Down
            movedown: 
            WorkingMode = 0
                        Player.Direction = DD
                        Player.OldX = Player.X
                        Player.OldY = Player.Y
                        Player.Move = TRUE
                        Player.MovingTime = 10
              
        end if
        
        if multikey(&h4D) and Player.Move= FALSE and Turn = 1 then ' Pressed Right
            moveright:
            WorkingMode = 0
                        Player.Direction = DR
                        Player.OldX = Player.X
                        Player.OldY = Player.Y
                        Player.Move = TRUE
                        Player.MovingTime = 10
              
        end if
        if multikey(&h4B) and Player.Move= FALSE and Turn = 1 then  ' Pressed Left
            moveleft:
            WorkingMode = 0
                        Player.Direction = DL
                        Player.OldX = Player.X
                        Player.OldY = Player.Y
                        Player.Move = TRUE
                        Player.MovingTime = 10
                      '  WHILE MULTIKEY(&h4B)
               ' WEND
        end if
        
if Player.Move= TRUE and Mode=1 then
Engine.UpdatePlayer Player, Player.Direction
Engine.UpdateCamera Level, Player   
Player.MovingTime = Player.MovingTime - 1
if Player.MovingTime<0 then Player.MovingTime = 0
if Player.MovingTime = 0 and Player.ReMove=FALSE then 
Player.FoodCount = Player.FoodCount + 1
Player.Move = FALSE
for cNPC=1 to numofnpcs
if Player.X=NPC(Location, cNPC).X and Player.Y=NPC(Location, cNPC).Y and NPC(Location, cNPC).Alive = TRUE then
currentNPC=cNPC
    Mode = 2
    BattleTurn = 1
    WorkingMode = 0
    SwordYPos=129
    MoveSwordMode = 4
    RumbleEnemy = 0
    RumblePlayer = 0
    AttackAnim = 0
    Player.AttackMode = 1
    Player.ShieldStatus=FALSE
    Player.Drugged = FALSE
    Player.RHandStamina=10
    Player.LHandStamina=10
    countbatanim = 0
    skipbattle = TRUE
goto skiprr:
end if
next cNPC
currentNPC=1
NPC(Location, currentNPC).Direction = 0
NPC(Location, currentNPC).MovingTime=10
Turn = 2
IF Player.Oxywear = TRUE THEN
Player.Oxycount = Player.Oxycount + 1    
if Player.Oxycount = 15 then 
Player.Oxygen = Player.Oxygen - 1
Player.Oxycount = 0
END IF
if Player.Oxygen <=0 then
Player.Oxygen = 0
Player.Oxywear = FALSE
for ceqinv=1 to 7
IF equipmentinv(ceqinv)=7 THEN
equipmentinv(ceqinv)= 6
goto endeq5:
END IF
NEXT ceqinv
endeq5:
NewNText$ "You remove the mask because the oxygen has depleted."
END IF
END IF
if Player.Poisoned = TRUE then
Player.PoisonCount = Player.PoisonCount + 1
if Player.PoisonCount = 20 then Player.Health=Player.Health-1
if Player.Health = 0 THEN
Player.Alive = FALSE
countdeath = 0
END IF
if Player.PoisonCount>19 then Player.PoisonCount=0
end if
end if
if Player.MovingTime = 0 and Player.Remove=TRUE then
Player.Remove=FALSE
Player.Move=FALSE
end if
end if

skiprr:

Engine.DrawScreen           ' Draw our stuff on the screen

loop until (WorkingMode = 11) OR (Player.Alive = FALSE AND countdeath=180) OR (Player.Alive=FALSE AND countdeath>100 AND buttons = 1) OR (Player.Alive=FALSE AND countdeath>100 AND MULTIKEY(SC_ENTER))' Loop until player presses ESC

IF Player.Alive = FALSE THEN
    
WHILE MULTIKEY(SC_ENTER) OR buttons = 1
getmouse mx, my, , buttons
WEND

do
    
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Update

getmouse mx, my, , buttons
screenset 1, 0
cls
if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset
GraphicText CENTRETEXT, 203, "G A M E  O V E R", Font3

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS
'GraphicText 4,425, "Mouse:"+STR$(mx)+","+STR$(my)+","+STR$(buttons), Font
 
screencopy
SCREENSYNC
screenlock
sleep 2
screenunlock
loop until multikey(SC_ENTER) OR buttons = 1 
mousefree = FALSE
END IF

WriteHighScore


end sub

sub tile_load_image ( tile as tileType )
' Sub used to load PUT files(relates to pp256_image.bi module).
' Don't break your head over it unless you are interested in
' modifying the way your program relates to pp256_image.bi
' module or the very module.
	
   tile.s_image.init = @image_init
   tile.s_image.init ( tile.s_image )
   tile.s_image.Load ( tile.s_image )
   tile.s_image.Index ( tile.s_image )
	
end sub

sub MainScreen
   cls
   
do
   GraphicText 90,25, "Richard Eric Lope's", Font
   GraphicText 45,37, "Pixel By Pixel Scrolling Engine", Font
   GraphicText 80,59, "Edition #1, June 2005.", Font
   GraphicText CENTRETEXT,95, "FreeBASIC port by", Font
   GraphicText CENTRETEXT,105, "Richard Eric Lope and Lachie Dazdarian", Font
   GraphicText CENTRETEXT,145, "Press Any Key", Font
   
   
   screencopy
   sleep 2
loop until INKEY$<>""

end sub


sub GraphicText (xx, yy, Textt$, tile as tileType)
'* GraphicText() subroutine:
'* Displays a text string at a graphics screen coordinate, using a bitmapped
'* character set.
'*
'* Parameters:
'*           xx - Horizontal coordinate of where printing should start or:
'*                Use CENTRETEXT to have the text centred.
'*           yy - Vertical coordinate of where printing should start.        
'*        Textt$ - The text string to be displayed.
'*        tile - Image array holding the character set to be used. Each
'*               character must in the standard ASCII order, starting with
'*               the space character(in the PUT file).
   
    MessLen = len(Textt$)
    if xx = CENTRETEXT then
        ' Find start X coordinate for a centred text.
        w = 0
        for nn = 1 to MessLen
            CharNo = asc(MID$(Textt$, nn, 1)) - 31
            w = w + GetWidth (CharNo, tile)
        next nn
        xx = (640 - w) \ 2
 
    end if

    ' Get character's sprite depth.
    CharDepth = GetDepth(1,tile)

    ' Loop to display each character of Text$.
    for n = 1 to MessLen
        CharNo = asc(MID$(Textt$, n, 1)) - 32
        CharWidth = GetWidth(CharNo, tile)
    ' Put the character on the screen.
        put (xx, yy), @Tile.s_image.p_data[Tile.s_image.p_dataindex[CharNo]], TRANS

        xx = xx + CharWidth
    next n


end sub


function GetDepth (ImNo,tilem as tileType)
' Function used to acquire depth of a character sprite
' (due the R.E.Lope's method used to store and display sprites
' on the screen I have to use this lame way to get the sprite
' depth). This code is pending for correction.
' Only one error can appear with this sub; if you use the last
' character from your font set. So just create one image behind your
' last character in the font set in PP256 of any size(ie, 1*1).
    GetDepth = @Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo+1]]-@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo]]

end function

function GetWidth (ImNo,tilem as tileType)
' Function used to acquire width of a character sprite
' (due the R.E.Lope's method used to store and display sprites
' on the screen I have to use this lame way to get the sprite
' depth). This code is pending for correction.
' Only one error can appear with this sub; if you use the last
' character from your font set. So just create one image behind your
' last character in the font set in PP256 of any size(ie, 1*1).

    GetWidth = (@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo+1]]-@Tilem.s_image.p_data[Tilem.s_image.p_dataindex[ImNo]])/4

end function

sub UnFogWalls (XcurT, YcurT, model)
'Stupid waste of space but I don't have time to solve this better!

if Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).BaseL>170 then 'AND Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).BaseL<111 THEN

if model = 1 then
' Nearest light
if XcurT + Level.TileX=Player.TileX+1 and YcurT+Level.TileY=Player.TileY then AddLight 3, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-1 and YcurT+Level.TileY=Player.TileY then AddLight 3, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY+1 then AddLight 3, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY-1 then AddLight 3, XcurT + Level.TileX, YcurT + Level.TileY

' Second near light
if XcurT + Level.TileX=Player.TileX+2 and YcurT+Level.TileY=Player.TileY then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+1 and YcurT+Level.TileY=Player.TileY+1 then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+1 and YcurT+Level.TileY=Player.TileY-1 then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-2 and YcurT+Level.TileY=Player.TileY then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-1 and YcurT+Level.TileY=Player.TileY-1 then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-1 and YcurT+Level.TileY=Player.TileY+1 then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY+2 then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY-2  then AddLight 2, XcurT + Level.TileX, YcurT + Level.TileY
'********************

' Farest lights
if XcurT + Level.TileX=Player.TileX+3 and YcurT+Level.TileY=Player.TileY then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-3 and YcurT+Level.TileY=Player.TileY then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY+3 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX and YcurT+Level.TileY=Player.TileY-3 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+2 and YcurT+Level.TileY=Player.TileY+1 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+2 and YcurT+Level.TileY=Player.TileY-1 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-2 and YcurT+Level.TileY=Player.TileY-1 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-2 and YcurT+Level.TileY=Player.TileY+1 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+1 and YcurT+Level.TileY=Player.TileY+2 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-1 and YcurT+Level.TileY=Player.TileY+2 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX-1 and YcurT+Level.TileY=Player.TileY-2 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
if XcurT + Level.TileX=Player.TileX+1 and YcurT+Level.TileY=Player.TileY-2 then AddLight 1, XcurT + Level.TileX, YcurT + Level.TileY
end if
' This rechecks for light the tiles that shouldn't be
' lighted(kill me). Since this code uses tiles near the one we
' are checking for reference we need to loop throgh UnFogWalls 
' twice in each loop.
if XcurT + Level.TileX-1>=0 and YcurT + Level.TileY-1>=0 then
if YcurT + Level.TileY>Player.TileY then 
if Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX-1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY-1).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if

if YcurT + Level.TileY<Player.TileY then 
if Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX-1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if

if XcurT + Level.TileX>Player.TileX then 
if Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY-1).LightStat=0 and Map(Location, XcurT + Level.TileX-1, YcurT + Level.TileY).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if

if XcurT + Level.TileX<Player.TileX then 
if Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY-1).LightStat=0 and Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if
end if
'*************

' Fix of recheck for edges....
if XcurT + Level.TileX=0 and YcurT + Level.TileY-1>=0 then
if YcurT + Level.TileY>Player.TileY then 
if Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY-1).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if
if YcurT + Level.TileY<Player.TileY then 
if Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).LightStat=0 and Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if
end if

if XcurT + Level.TileX-1>=0 and YcurT + Level.TileY=0 then
if XcurT + Level.TileX>Player.TileX then 
if Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).LightStat=0 and Map(Location, XcurT + Level.TileX-1, YcurT + Level.TileY).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if
if XcurT + Level.TileX<Player.TileX then 
if Map(Location, XcurT + Level.TileX, YcurT + Level.TileY+1).LightStat=0 and Map(Location, XcurT + Level.TileX+1, YcurT + Level.TileY).BaseL > 60 then Map(Location, XcurT + Level.TileX, YcurT + Level.TileY).LightStat = 0
end if
end if
' ***********


if Map(Location, XT + Level.TileX, YT + Level.TileY).LightStat>0 then Map(Location, XT + Level.TileX, YT + Level.TileY).FogStat=1

end if

end sub


sub Engine.DrawInterface()
    
IconStatus = 0
ArrowStatus = 0
icontext$ = ""

' Code that changes the status of player's health according to
' food count(changes as you move). Goes from ok to starving.
if Player.FoodCount = 1000 then 
Player.FoodStatus = Player.FoodStatus - 1
IF Player.FoodStatus = 2 THEN NewNText "You are hungry."
IF Player.FoodStatus = 3 THEN NewNText "You are straving."
if Player.FoodStatus<1 then Player.FoodStatus = 1
Player.FoodCount = 0
end if

getmouse mx, my, , buttons

' Map edges
'**************
put (0, 0), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[6-1]], TRANS
put (301, 0), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[7-1]], TRANS
put (301, 301), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[8-1]], TRANS
put (0, 301), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[9-1]], TRANS

for cy=38 to 302 step 3
put (0, cy), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[11-1]], TRANS
next cy
for cy=38 to 302 step 3
put (320, cy), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[11-1]], TRANS
next cy
for cx=38 to 302 step 3
put (cx, 0), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[10-1]], TRANS
next cx
for cx=38 to 302 step 3
put (cx, 320), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[10-1]], TRANS
next cx
'**************

'In-game icons(mode1)
'**************
if Mode = 1 then
    
put (10-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[12-1]], TRANS
if WorkingMode = 1 then put (10-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[42-1]], TRANS
put (60-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[13-1]], TRANS
put (110-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[14-1]], TRANS
put (160-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[15-1]], TRANS
put (210-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[16-1]], TRANS
put (260-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[17-1]], TRANS
put (310-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[18-1]], TRANS
put (360-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[19-1]], TRANS
put (410-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[20-1]], TRANS
put (460-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[21-1]], TRANS


put (510-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[27-1]], TRANS
put (555-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[28-1]], TRANS
put (600-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[29-1]], TRANS
put (555-4, 385), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[30-1]], TRANS
'**************

'Arrows related controls and "interactive" graphics
'**************
if my>429 and my<471 and mx>509-4 and mx<551-4 then ArrowStatus = 1
if my>429 and my<471 and mx>599-4 and mx<641-4 then ArrowStatus = 2
if my>429 and my<471 and mx>554-4 and mx<596-4 then ArrowStatus = 3
if my>384 and my<426 and mx>554-4 and mx<596-4 then ArrowStatus = 4
if ArrowStatus > 0 then
select case ArrowStatus
case 1
arx=510-4
ary=430
if Map(Location, Player.TileX-1, Player.TileY).BaseL<51 then icontext$ ="Move West"
case 2
arx=600-4
ary=430
if Map(Location, Player.TileX+1, Player.TileY).BaseL<51 then icontext$ ="Move East"
case 3
arx=555-4
ary=430
if Map(Location, Player.TileX, Player.TileY+1).BaseL<51 then icontext$ ="Move South"
case 4
arx=555-4
ary=385
if Map(Location, Player.TileX, Player.TileY-1).BaseL<51 then icontext$ ="Move North"
end select
IF cursorspr = 22 THEN put (arx, ary), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[35-1]], TRANS
IF cursorspr = 22 THEN put (arx, ary), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[35-1]], TRANS
IF cursorspr = 22 THEN put (arx, ary), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[35-1]], TRANS
IF cursorspr = 22 THEN put (arx, ary), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[35-1]], TRANS
end if
if Map(Location, Player.TileX-1, Player.TileY).BaseL>55 OR NPC(Location,currentNPC).Move=TRUE then put (510-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[31-1]], TRANS
if Map(Location, Player.TileX+1, Player.TileY).BaseL>55 OR NPC(Location,currentNPC).Move=TRUE then put (600-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[33-1]], TRANS
if Map(Location, Player.TileX, Player.TileY-1).BaseL>55 OR NPC(Location,currentNPC).Move=TRUE then put (555-4, 385), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[34-1]], TRANS
if Map(Location, Player.TileX, Player.TileY+1).BaseL>55 OR NPC(Location,currentNPC).Move=TRUE then put (555-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[32-1]], TRANS
'**************

'Normal icons controls
'**************
if my>429 and my<471 then
if mx>9-4 and mx<51-4 then IconStatus = 1
if mx>59-4 and mx<101-4 then IconStatus = 2
if mx>109-4 and mx<151-4 then IconStatus = 3
if mx>159-4 and mx<201-4 then IconStatus = 4
if mx>209-4 and mx<251-4 then IconStatus = 5
if mx>259-4 and mx<301-4 then IconStatus = 6
if mx>309-4 and mx<351-4 then IconStatus = 7
if mx>359-4 and mx<401-4 then IconStatus = 8
if mx>409-4 and mx<451-4 then IconStatus = 9
if mx>459-4 and mx<501-4 then IconStatus = 10
end if
if WorkingMode>1 AND WorkingMode<13 then
put (10-4+(WorkingMode-1)*50, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[43-1]], TRANS
end if
if IconStatus >0 then
IF cursorspr = 22 THEN put (10-4+(IconStatus-1)*50, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[44-1]], TRANS
select case IconStatus
case 1
if WorkingMode <> 1 then icontext$ = "Check Player's Status"
if WorkingMode = 1 then icontext$ = "Return To Normal Screen Mode"
if (buttons = 1 and mousefree = TRUE and WorkingMode = 1) then 
WorkingMode = 0
goto skipnextcond:
end if
if (buttons = 1 and mousefree = TRUE and WorkingMode <>1) then 
WorkingMode = 1
goto skipnextcond:
end if
case 2
icontext$ = "Equip Left Hand"
if buttons = 1 and mousefree = TRUE then WorkingMode = 2
case 3
icontext$ = "Equip Right Hand"
if buttons = 1 and mousefree = TRUE then WorkingMode = 3
case 4
icontext$ = "Equip Body"
if buttons = 1 and mousefree = TRUE then WorkingMode = 4
case 5
icontext$ = "Use Item"
if buttons = 1 and mousefree = TRUE then WorkingMode = 5
case 6
icontext$ = "Examine Current Location"
if buttons = 1 and mousefree = TRUE then WorkingMode = 6
case 7
icontext$ = "Operate/Use Environment"
if buttons = 1 and mousefree = TRUE then WorkingMode = 7
case 8
icontext$ = "Skip Turn"
if buttons = 1 and mousefree = TRUE then WorkingMode = 8
case 9
icontext$ = "Save Game"
if buttons = 1 and mousefree = TRUE then 
open path$ + "Data\savepos.dat" for input as #3
for csaven=1 to 7
input #3, savename(csaven)
next csaven
for csavep=1 to 7
input #3, savepos(csavep)
next csavep
close #3
WorkingMode = 9
end if
case 10
icontext$ = "Exit To Main Menu"
if buttons = 1 and mousefree = TRUE then WorkingMode = 10
end select
end if
'***********************

end if 'end if Mode = 1 (normal mode)


if Mode = 2 then
    
put (306, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[23-1]], TRANS
put (360-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[24-1]], TRANS
put (410-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[25-1]], TRANS
put (460-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[26-1]], TRANS

put (510-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[31-1]], TRANS
put (600-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[33-1]], TRANS
put (555-4, 385), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[34-1]], TRANS
put (555-4, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[32-1]], TRANS

'Battle icons controls
'**************
if my>429 and my<471 then
if mx>309-4 and mx<351-4 then IconStatus = 1
if mx>359-4 and mx<401-4 then IconStatus = 2
if mx>409-4 and mx<451-4 then IconStatus = 3
if mx>459-4 and mx<501-4 then IconStatus = 4
end if
if WorkingMode>0 then
put (306+(WorkingMode-1)*50, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[43-1]], TRANS
end if
if IconStatus >0 then
IF cursorspr = 22 THEN put (306+(IconStatus-1)*50, 430), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[44-1]], TRANS
select case IconStatus
case 1
icontext$ = "Attack With Left Hand"
if buttons = 1 and mousefree = TRUE and MoveSwordMode=4 then WorkingMode = 1
case 2
icontext$ = "Attack With Right Hand"
if buttons = 1 and mousefree = TRUE and MoveSwordMode=4 then WorkingMode = 2
case 3
icontext$ = "Use Item"
if buttons = 1 and mousefree = TRUE and MoveSwordMode=4 then WorkingMode = 3
case 4
icontext$ = "Run Away"
if buttons = 1 and mousefree = TRUE and MoveSwordMode=4 then WorkingMode = 4
end select
end if
'***********************
end if ' end if mode=2(battle mode)

if (Mode = 1 and Turn = 2) OR countbatanim<148 then WorkingMode=0
if (Mode = 2 and BattleTurn = 2) OR countbatanim<148 then WorkingMode=0
if Mode = 1 and Player.Move = TRUE then WorkingMode = 0
if Mode = 2 and NPC(Location,currentNPC).Alive = FALSE then WorkingMode=0

IF Player.Alive = FALSE AND Mode=1 THEN 
WorkingMode = 0
countdeath=countdeath+1
IF countdeath=12 THEN NewNText$ "You fall down drained by the poisoning and die."
IF countdeath=60 THEN NewNText$ "It's always good to have an antidote."
END IF
IF Player.Alive = FALSE AND Mode=2 THEN 
WorkingMode = 0
countdeath=countdeath+1
IF countdeath = 12 THEN NewBText "You have been defeated.",1
IF countdeath = 60 THEN NewBText "Better luck next time.",1
END IF

if Mode = 1 then
if WorkingMode = 1 then Engine.DrawStatus
if WorkingMode = 2 then Engine.DrawWepInv
if WorkingMode = 3 then Engine.DrawWepInv
if WorkingMode = 4 then Engine.DrawEquipInv
if WorkingMode = 5 then Engine.DrawItemsInv
if WorkingMode = 6 then ExamineLocation
if WorkingMode = 7 then OperateWith
if WorkingMode = 9 then Engine.DrawSaveGame
if WorkingMode = 13 then Elevator

if WorkingMode = 8 then
NewNText$ "Turn skipped."
SkipTurn
end if

if WorkingMode = 10 then
line (21,21)-(319,319),0, BF 
put (22,22), bimage1(0), pset
GraphicText 124, 133, "Exit To Main Menu?", Font
GraphicText 124, 153, "1- Yes ", Font
GraphicText 184, 153, "2 - No", Font
exitmode = 0
if my>152 and my<163 then
if mx>123 and mx<165 then exitmode = 1 
if mx>183 and mx<218 then exitmode = 2
end if
if exitmode = 1 then GraphicText 124, 153, "1- Yes ", Font2
if exitmode = 2 then GraphicText 184, 153, "2 - No ", Font2
if buttons = 1 and exitmode = 1 then WorkingMode = 11
if buttons = 1 and exitmode = 2 then WorkingMode = 0
if NumericInput(1)=TRUE then WorkingMode = 11
if NumericInput(2)=TRUE then 
WorkingMode = 0
keyboardfree = FALSE
end if
end if

'**************
if NumericInput(1)=TRUE and keyboardfree = TRUE then 
if WorkingMode=1 then 
WorkingMode = 0
goto skipnextcond:
end if
if WorkingMode=0 then 
WorkingMode = 1
goto skipnextcond:
end if
end if

for wmode=2 to 10
if countbatanim>147 and NumericInput(wmode)=TRUE and WorkingMode<2 and keyboardfree = TRUE then WorkingMode = wmode
next wmode

end if 'end if Mode = 1(normal mode)

if Mode = 2 then
    
if WorkingMode = 1 then AttackLHand
if WorkingMode = 2 then AttackRHand
if WorkingMode = 3 then Engine.DrawItemsInv
if WorkingMode = 4 then RunAway
if skipbattle = FALSE then Engine.DrawBattleScreen

for wmode=1 to 4
if countbatanim>147 and BattleTurn=1 and MoveSwordMode=4 and NumericInput(wmode)=TRUE and keyboardfree = TRUE then WorkingMode = wmode
next wmode
    
end if ' end if mode=2(battle mode)

skipnextcond:
if buttons = 1 then 
mousefree = FALSE
goto skipmousefre:
end if
mousefree = TRUE
skipmousefre:

for ckinput=0 to 10
if NumericInput(ckinput)= TRUE then 
keyboardfree = FALSE
goto skipkeybfree:  
end if
next ckinput
keyboardfree = TRUE
skipkeybfree: 


addspr = 0
if mapblink < 25 then addspr = 2
put (360, 70), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[36+addspr-1]], TRANS
put (580, 70), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[37+addspr-1]], TRANS
put (360, -30), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[40-1]], TRANS
put (580, -30), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[41-1]], TRANS

'Character graphics
'***************
put (384-4, 310), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[17-1]], TRANS
put (421-4, 287), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[18-1]], TRANS

put (360-4, 266), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[24-1]], TRANS
put (483-4, 266), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[25-1]], TRANS
put (360-4, 412), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[22-1]], TRANS
put (483-4, 412), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[23-1]], TRANS

put (377-4, 266), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[26-1]], TRANS
put (383-4, 266), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[26-1]], TRANS
put (377-4, 423), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[26-1]], TRANS
put (383-4, 423), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[26-1]], TRANS

put (360-4, 270), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[27-1]], TRANS
put (360-4, 313), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[27-1]], TRANS
put (497-4, 270), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[27-1]], TRANS
put (497-4, 313), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[27-1]], TRANS

put (519, 280), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[1-1]], TRANS
put (376, 219), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[Location+1-1]], TRANS

if Player.FoodStatus<3 then put (421-4, 287), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[41-1]], TRANS
if Player.Poisoned = TRUE then put (421-4, 287), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[42-1]], TRANS

IF trigger(8) = TRUE THEN put (380+18, 310+40), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[44-1]], TRANS
    
if Player.ShieldStatus = TRUE and Mode = 2 then
put (380, 310-26), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[10-1]], TRANS
put (380, 310), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[8-1]], TRANS
put (380, 410), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[9-1]], TRANS        
end if
if Mode=2 then if Player.Drugged = TRUE then put (421-4, 287), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[40-1]], TRANS

IF Location=1 THEN levroman$="I"
IF Location=2 THEN levroman$="II"
IF Location=3 THEN levroman$="III"
IF Location=4 THEN levroman$="IV"
IF Location=5 THEN levroman$="V"

IF Location<6 THEN GraphicText 404, 253, "Level "+levroman$, Font
IF Location=6 THEN GraphicText 404, 253, " Bridge", Font

GraphicText 362, 273, "HP: "+STR$(Player.Health)+"/"+STR$(Player.MaxHealth), Font
IF Player.Oxywear = TRUE THEN GraphicText 427,273, "Oxygen: " + STR$(Player.Oxygen)+"%", Font

if Player.RWeapon >0 then
put (384-15-1, 322+3), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[(26+Player.RWeapon*2)-1]], TRANS
end if
if Player.LWeapon >0 then
put (451+1, 322+3), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[(27+Player.LWeapon*2)-1]], TRANS
end if

if Player.Armour>1 then
put (407, 310), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[(Player.Armour-2)+19-1]], TRANS
end if

if Player.Boots>4 then
put (395, 385), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[21-1]], TRANS
end if

IF Player.Oxywear = TRUE THEN put (421-10, 286), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[43-1]], TRANS


'***************

if Mode=1 then GraphicText 6, 417, icontext$, Font
if Mode=2 then GraphicText 6, 457, icontext$, Font4

if Mode = 1 and WorkingMode <> 2 and WorkingMode <> 3 and WorkingMode <> 4 and WorkingMode <> 5 and WorkingMode <> 9 and WorkingMode<13 then
GraphicText 6, 350, ntext(5), Font7
GraphicText 6, 360, ntext(4), Font6
GraphicText 6, 370, ntext(3), Font6
GraphicText 6, 380, ntext(2), Font5
GraphicText 6, 390, ntext(1), Font5
end if
if Mode=2 and WorkingMode<>3 then
for countlines=1 to 5
if btextfont(countlines)=1 then GraphicText 6, 402-countlines*10, btext(countlines), Font3
if btextfont(countlines)=2 then GraphicText 6, 402-countlines*10, btext(countlines), Font4
next countlines
end if

if countbatanim<148 and Mode = 1 then
countbatanim = countbatanim + 4
put (22,22), bimage2(0), TRANS
line (22,22)-(22+countbatanim,319), 0, BF
line (319,22)-(319-countbatanim,319), 0, BF
get (22,22)-(319,319), bimage2(0)
put (22,22), bimage3(0), pset
put (22,22), bimage2(0), TRANS
end if

end sub

sub Engine.DrawStatus()

line (21,21)-(319,319),0, BF 
put (22,22), bimage1(0), pset
hnd$ = "Right"
IF Player.MainArm = 1 THEN hnd$ = "Left"
GraphicText 30, 30, "Name: "+Player.SName, Font
GraphicText 30, 45, "Main hand: "+hnd$, Font
GraphicText 30, 60, "Health Points: "+STR$(Player.Health)+"/"+STR$(Player.MaxHealth), Font
GraphicText 30, 75, "Level: "+STR$(Player.Level), Font
al = Player.AttackL
GraphicText 30, 90, "Attack Level: "+STR$(al), Font
if Player.Armour = 1 then ArmD=1
if Player.Armour = 2 then ArmD=2
if Player.Armour = 3 then ArmD=4
dll = Player.defenseL
GraphicText 30, 105, "Defense Level: "+STR$(dll)+" + "+STR$(ArmD), Font
GraphicText 30, 120, "Experience Points: "+STR$(Player.Experience), Font
GraphicText 30, 135, "For The Next Level: "+STR$(Player.NextExp-Player.Experience)+" Experience Points", Font
if Player.RWeapon = 0 then rwep$ = "Nothing"
if Player.RWeapon = 1 then rwep$ = "Metal Pipe"
if Player.RWeapon = 2 then rwep$ = "Electrocuter"
if Player.RWeapon = 3 then rwep$ = "Ion Pistol"
if Player.RWeapon = 4 then rwep$ = "Ion Rifle"
if Player.RWeapon = 5 then rwep$ = "Distruptor"
if Player.RWeapon = 6 then rwep$ = "Raan Gutter"
if Player.LWeapon = 0 then lwep$ = "Nothing"
if Player.LWeapon = 1 then lwep$ = "Metal Pipe"
if Player.LWeapon = 2 then lwep$ = "Electrocuter"
if Player.LWeapon = 3 then lwep$ = "Ion Pistol"
if Player.LWeapon = 4 then lwep$ = "Ion Rifle"
if Player.LWeapon = 5 then lwep$ = "Distruptor"
if Player.LWeapon = 6 then lwep$ = "Raan Gutter"
arm$ = "Leather Armour"
if Player.Armour = 2 then arm$ = "Kevlar Armour"
if Player.Armour = 3 then arm$ = "Neoplex Armour"

GraphicText 30, 150, "Right Hand: "+rwep$, Font
GraphicText 30, 165, "Left Hand: "+lwep$, Font
GraphicText 30, 180, "Armour: "+arm$, Font
GraphicText 30, 195, "Money: "+STR$(Player.Money)+" $", Font
GraphicText 30, 210, "Kills: "+STR$(Player.Kills), Font
if Location = 1 then loclev$ = "Level I - Shuttle Bay"
if Location = 2 then loclev$ = "Level II - Storage Bays"
if Location = 4 then loclev$ = "Level IV - Living Quarters"
GraphicText 30, 225, "Location: "+loclev$, Font
healths$ = "Ok"
if Player.FoodStatus = 2 then healths$ = "Hungry"
if Player.FoodStatus = 1 then healths$ = "Starving"
if Player.Poisoned = TRUE then healths$ = "Poisoned"
if Player.Poisoned = TRUE and Player.FoodStatus = 2 then healths$ = "Poisoned & Hungry"
if Player.Poisoned = TRUE and Player.FoodStatus = 1 then healths$ = "Poisoned & Starving"
GraphicText 30, 240, "Health: "+healths$, Font 
IF trigger(8) = TRUE THEN GraphicText 30, 255, "Antimatter: Acquired", Font 
IF trigger(8) = FALSE THEN GraphicText 30, 255, "Antimatter: Not Acquired", Font 

hc$=""
hm$=""
hs$=""
if hours<10 then hc$="0"
if minutes<10 then hm$="0"
if seconds<10 then hs$="0"
GraphicText 30, 270, "Play time: "+hc$+STR$(hours)+":"+hm$+STR$(minutes)+":"+hs$+STR$(seconds), Font  

end sub

sub Engine.DrawWepInv()

for cwinv=1 to 4
if weaponsinv(cwinv) = 0 then winv$ = "Nothing"
if weaponsinv(cwinv) = 1 then winv$ = "Metal Pipe"
if weaponsinv(cwinv) = 2 then winv$ = "Electrocuter"
if weaponsinv(cwinv) = 3 then winv$ = "Ion Pistol"
if weaponsinv(cwinv) = 4 then winv$ = "Ion Rifle"
if weaponsinv(cwinv) = 5 then winv$ = "Distruptor"
if weaponsinv(cwinv) = 6 then winv$ = "Raan Gutter"
GraphicText 5,345+cwinv*10, STR$(cwinv)+". "+winv$, Font
if NumericInput(cwinv)=TRUE and keyboardfree = TRUE then goto executecwinv1: 
if mx>4 and mx<104 and my>344+(cwinv)*10 and my<355+(cwinv)*10 then 
GraphicText 5,345+(cwinv)*10, STR$(cwinv)+". "+winv$, Font2  
if (buttons = 1 and mousefree = TRUE) then 
executecwinv1:
keyboardfree = FALSE
tempvar = weaponsinv(cwinv)
if WorkingMode = 2 then 
weaponsinv(cwinv) = Player.LWeapon
Player.LWeapon = tempvar
if weaponsinv(cwinv)<>0 OR Player.LWeapon<>0 then 
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You equip your left hand with "+winv$+"."
end if
end if
if WorkingMode = 3 then 
weaponsinv(cwinv) = Player.RWeapon
Player.RWeapon = tempvar
if weaponsinv(cwinv)<>0 OR Player.RWeapon<>0 then 
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You equip your right hand with "+winv$+"."
end if

end if
end if
end if
next cwinv

for cwinv=5 to 8
if weaponsinv(cwinv) = 0 then winv$ = "Nothing"
if weaponsinv(cwinv) = 1 then winv$ = "Metal Pipe"
if weaponsinv(cwinv) = 2 then winv$ = "Electrocuter"
if weaponsinv(cwinv) = 3 then winv$ = "Ion Pistol"
if weaponsinv(cwinv) = 4 then winv$ = "Ion Rifle"
if weaponsinv(cwinv) = 5 then winv$ = "Distruptor"
if weaponsinv(cwinv) = 6 then winv$ = "Raan Gutter"
if cwinv=8 then winv$ = "Cancel"
if NumericInput(cwinv)=TRUE and keyboardfree = TRUE then goto executecwinv2: 
GraphicText 125,345+(cwinv-4)*10, STR$(cwinv)+". "+winv$, Font
if mx>124 and mx<224 and my>344+(cwinv-4)*10 and my<355+(cwinv-4)*10 then 
GraphicText 125,345+(cwinv-4)*10, STR$(cwinv)+". "+winv$, Font2 
if buttons = 1 and mousefree = TRUE then 
executecwinv2:
keyboardfree = FALSE
if cwinv = 8 then WorkingMode = 0
tempvar = weaponsinv(cwinv)
if WorkingMode = 2 then 
weaponsinv(cwinv) = Player.LWeapon
Player.LWeapon = tempvar
if weaponsinv(cwinv)<>0 OR Player.LWeapon<>0 then
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You equip your left hand with "+winv$+"."
end if
end if
if WorkingMode = 3 then 
weaponsinv(cwinv) = Player.RWeapon
Player.RWeapon = tempvar
if weaponsinv(cwinv)<>0 OR Player.RWeapon<>0 then 
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You equip your right hand with "+winv$+"."
end if

end if
end if
end if
next cwinv

end sub

sub Engine.DrawEquipInv()

for ceqinv=1 to 4
if equipmentinv(ceqinv)= 0 then winv$ = "Nothing"
if equipmentinv(ceqinv)= 1 then winv$ = "Leather Armour"
if equipmentinv(ceqinv)= 2 then winv$ = "Kevlar Armour"
if equipmentinv(ceqinv)= 3 then winv$ = "Noeplex Armour"
if equipmentinv(ceqinv)= 4 then winv$ = "Leather Boots"
if equipmentinv(ceqinv)= 5 then winv$ = "Sturdy Boots"
if equipmentinv(ceqinv)= 6 then winv$ = "Equip Oxygen Mask"
if equipmentinv(ceqinv)= 7 then winv$ = "Remove Oxy. Mask"
GraphicText 5,345+ceqinv*10, STR$(ceqinv)+". "+winv$, Font
if NumericInput(ceqinv)=TRUE and keyboardfree = TRUE then goto executeceqinv1:
if mx>4 and mx<104 and my>344+(ceqinv)*10 and my<355+(ceqinv)*10 then 
GraphicText 5,345+(ceqinv)*10, STR$(ceqinv)+". "+winv$, Font2  
if buttons = 1 and mousefree = TRUE then 
executeceqinv1:
keyboardfree = FALSE
'IF equipmentinv(ceqinv)=0 THEN WorkingMode = 0 
tempvar = equipmentinv(ceqinv)
if equipmentinv(ceqinv)=6 AND Player.Oxygen<=0 THEN
WorkingMode = 0
NewNText "No sense in equipping the mask since the tank is empty."
END IF
if equipmentinv(ceqinv)=6 AND Player.Oxygen>0 THEN
Player.Oxywear = TRUE
equipmentinv(ceqinv)=7
NewNText "You are now wearing the oxygen mask."
WorkingMode = 0
SkipTurn
END IF
if equipmentinv(ceqinv)=7 AND WorkingMode>0 THEN
Player.Oxywear = FALSE
equipmentinv(ceqinv)=6
NewNText "You remove the oxygen mask."
WorkingMode = 0
SkipTurn
END IF
if equipmentinv(ceqinv)<4 and equipmentinv(ceqinv)>0 then 
equipmentinv(ceqinv)= Player.Armour
Player.Armour = tempvar
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You are now wearing "+winv$+"."
SkipTurn
end if
if equipmentinv(ceqinv)>3 AND equipmentinv(ceqinv)<6 then 
equipmentinv(ceqinv)= Player.Boots
Player.Boots = tempvar
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You are now wearing "+winv$+"."
SkipTurn
end if
end if
end if
next ceqinv

for ceqinv=5 to 8
if equipmentinv(ceqinv)= 0 then winv$ = "Nothing"
if equipmentinv(ceqinv)= 1 then winv$ = "Leather Armour"
if equipmentinv(ceqinv)= 2 then winv$ = "Kevlar Armour"
if equipmentinv(ceqinv)= 3 then winv$ = "Noeplex Armour"
if equipmentinv(ceqinv)= 4 then winv$ = "Leather Boots"
if equipmentinv(ceqinv)= 5 then winv$ = "Sturdy Boots"
if equipmentinv(ceqinv)= 6 then winv$ = "Equip Oxygen Mask"
if equipmentinv(ceqinv)= 7 then winv$ = "Remove Oxy. Mask"
if ceqinv=8 then winv$ = "Cancel"
GraphicText 125,345+(ceqinv-4)*10, STR$(ceqinv)+". "+winv$, Font
if NumericInput(ceqinv)=TRUE and keyboardfree = TRUE then goto executeceqinv2:
if mx>124 and mx<224 and my>344+(ceqinv-4)*10 and my<355+(ceqinv-4)*10 then 
GraphicText 125,345+(ceqinv-4)*10, STR$(ceqinv)+". "+winv$, Font2  
if buttons = 1 and mousefree = TRUE then 
executeceqinv2:
keyboardfree = FALSE
if ceqinv = 8 then WorkingMode = 0
if WorkingMode = 4 and equipmentinv(ceqinv)>0 then
'IF equipmentinv(ceqinv)=0 THEN WorkingMode = 0 
tempvar = equipmentinv(ceqinv)
if equipmentinv(ceqinv)=6 AND Player.Oxygen<=0 THEN
WorkingMode = 0
NewNText "No sense in equipping the mask since the tank is empty."
END IF
if equipmentinv(ceqinv)=6 AND Player.Oxygen>0 THEN
Player.Oxywear = TRUE
equipmentinv(ceqinv)=7
NewNText "You are now wearing the oxygen mask."
WorkingMode = 0
SkipTurn
END IF
if equipmentinv(ceqinv)=7 AND WorkingMode>0 THEN
Player.Oxywear = FALSE
equipmentinv(ceqinv)=6
NewNText "You remove the oxygen mask."
WorkingMode = 0
SkipTurn
END IF
if equipmentinv(ceqinv)<4 and equipmentinv(ceqinv)>0 then 
equipmentinv(ceqinv)= Player.Armour
Player.Armour = tempvar
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You are now wearing "+winv$+"."
SkipTurn
end if
if equipmentinv(ceqinv)>3 AND equipmentinv(ceqinv)<6 then
equipmentinv(ceqinv)= Player.Boots
Player.Boots = tempvar
WorkingMode=0
keyboardfree = FALSE
if winv$ = "Nothing" then winv$ = "nothing"
NewNText "You are now wearing "+winv$+"."
SkipTurn
end if
end if
end if
end if
next ceqinv

end sub

sub Engine.DrawItemsInv()

for citem=1 to 4
itinv$ = STR$(citem)+". Nothing"
if citem=2 and Player.MedPack>0 then itinv$="2. Med-Pack x "+STR$(Player.MedPack)
if citem=1 and Player.Food>0 then itinv$="1. Food Ration x "+STR$(Player.Food)
if citem=3 and Player.Bomb>0 then itinv$="3. Grenade x "+STR$(Player.Bomb)
if citem=4 and Player.ElecDistruptor>0 then itinv$="4. Shocker x "+STR$(Player.ElecDistruptor)
if NumericInput(citem)=TRUE and keyboardfree = TRUE then goto executecitem1:
GraphicText 5,345+citem*10, itinv$, Font
if mx>4 and mx<125 and my>344+(citem)*10 and my<355+(citem)*10 then 
GraphicText 5,345+(citem)*10, itinv$, Font2  
if buttons = 1 and mousefree = TRUE then 
executecitem1:
keyboardfree = FALSE
if citem=1 and Player.Food>0 then 
Player.Food=Player.Food-1
Player.Health=Player.Health+10
IF Player.Level=3 THEN Player.Health=Player.Health+5 
IF Player.Level=4 THEN Player.Health=Player.Health+10 
IF Player.Level>4 THEN Player.Health=Player.Health+15 
if Player.Health>Player.MaxHealth then Player.Health = Player.MaxHealth
Player.FoodCount = 0
Player.FoodStatus=3
WorkingMode = 0
if Mode=1 then 
rndmsg = int(rnd * 3) + 1
IF rndmsg=1 THEN NewNText "It tastes horrible. But you are not hungry anymore."
IF rndmsg=2 THEN NewNText "That was chunky but not bad. You are full."
IF rndmsg=3 THEN NewNText "That was very tasty. Wouldn't mind some more."
SkipTurn
END IF
if Mode=2 then 
rndmsg = int(rnd * 3) + 1
IF rndmsg=1 THEN NewBText "It tastes horrible. But you are not hungry anymore.",2
IF rndmsg=2 THEN NewBText "That was chunky but not bad. You are full.",2
IF rndmsg=3 THEN NewBText "That was very tasty. Wouldn't mind some more.",2
WorkingMode = 0
MoveSwordMode=0
BattleTurn=2
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
end if
if citem=2 and Player.MedPack>0 then 
Player.MedPack=Player.MedPack-1
Player.Health=Player.Health+30
IF Player.Level=3 THEN Player.Health=Player.Health+5
IF Player.Level=4 THEN Player.Health=Player.Health+10
IF Player.Level>4 THEN Player.Health=Player.Health+20
if Player.Health>Player.MaxHealth then Player.Health = Player.MaxHealth
WorkingMode = 0
if Mode=1 then 
NewNText "You heal your wounds."
SkipTurn
end if
if Mode=2 then 
NewBText "You heal your wounds.",2
WorkingMode = 0
MoveSwordMode=0
BattleTurn=2
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
end if
if Mode = 2 then
if citem=3 and Player.Bomb>0 then 
Player.Bomb=Player.Bomb-1
AttackAnim = 2
AnimCount = 1
WorkingMode = 0
MoveSwordMode=2
startacid=50
prebtext$="You throw the grenade and inflict "
rndat = int(rnd * 5) + 1
damageresult = startacid-(NPC(Location, currentNPC).defenseL*8)-rndat
if damageresult<0 then damageresult=0
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
if citem=4 and Player.ElecDistruptor>0 then 
Player.ElecDistruptor=Player.ElecDistruptor-1
AttackAnim = 3
AnimCount = 1
WorkingMode = 0
MoveSwordMode=2
startacid=40
rndat = int(rnd * 5) + 1
prebtext$="You use the shocker and inflict "
if (NPC(Location,currentNPC).Typ>7 and NPC(Location,currentNPC).Typ<11) OR (NPC(Location,currentNPC).Typ=16) then startacid=60
damageresult = startacid-(NPC(Location, currentNPC).defenseL*8)-rndat
if damageresult<0 then damageresult=0
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
end if
if Mode = 1 and citem>2 then
if citem=3 and Player.Bomb>0 THEN NewNText "Only to be used during battle."
if citem=4 and Player.ElecDistruptor>0 THEN NewNText "Only to be used during battle."
if citem=3 and Player.Bomb>0 THEN WorkingMode = 0
if citem=4 and Player.ElecDistruptor>0 THEN WorkingMode = 0
end if
end if
end if
next citem

for citem=5 to 8
itinv$ = STR$(citem)+". Nothing"
if citem=5 and Player.AcidBomb>0 then itinv$="5. Acid Bomb x "+STR$(Player.AcidBomb)
if citem=6 and Player.Steroids>0 then itinv$="6. Steroids x "+STR$(Player.Steroids)
if citem=7 and Player.Shield>0 then itinv$="7. Shield x "+STR$(Player.Shield)
if citem=8 and Player.Antidote>0 then itinv$="8. Antidote x "+STR$(Player.Antidote)
if NumericInput(citem)=TRUE and keyboardfree = TRUE then goto executecitem2:
GraphicText 125,345+(citem-4)*10, itinv$, Font
if mx>124 and mx<224 and my>344+(citem-4)*10 and my<355+(citem-4)*10 then 
GraphicText 125,345+(citem-4)*10, itinv$, Font2  
if buttons = 1 and mousefree = TRUE then 
executecitem2:
keyboardfree = FALSE
if citem=8 and Player.Antidote>0 then
if Player.Poisoned=TRUE then
Player.Antidote = Player.Antidote - 1
Player.Poisoned = FALSE
Player.PoisonCount = 0
WorkingMode = 0
if Mode=1 then 
NewNText "You are cured."
WorkingMode = 0
SkipTurn
END IF
if Mode=2 then 
NewBText "You are cured.",2
MoveSwordMode=0
BattleTurn=2
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
end if
if Player.Poisoned = FALSE then
WorkingMode = 0
if Mode=1 then NewNText "You are not poisoned. No need for an antidote."
if Mode=2 then 
NewBText "You are not poisoned. No need for an antidote.",2
WorkingMode = 0
end if
end if
end if
if Mode = 2 then
if citem=5 and Player.AcidBomb>0 then 
Player.AcidBomb=Player.AcidBomb-1
AttackAnim = 1
AnimCount = 1
WorkingMode = 0
MoveSwordMode=2
rndat = int(rnd * 5) + 1
startacid=60
prebtext$="You throw the acid bomb and inflict "
if NPC(Location,currentNPC).Typ=6 OR NPC(Location,currentNPC).Typ=13 then startacid=10
damageresult = startacid-(NPC(Location, currentNPC).defenseL*8)-rndat
if damageresult<0 then damageresult=0
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
if citem=6 and Player.Steroids>0 then 
IF Player.Poisoned = FALSE THEN
if Player.Drugged=FALSE then
Player.Steroids=Player.Steroids-1
rndmsg = int(rnd * 2) + 1
if rndmsg=1 then NewBText "You feel omnipotent!",2
if rndmsg=2 then NewBText "You feel strong as an ox!",2
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
Player.Drugged=TRUE
MoveSwordMode=0
BattleTurn=2
end if
if Player.Drugged=TRUE and BattleTurn = 1 then
NewBText "I think more of this would kill me.",2
WorkingMode = 0
end if
END IF
IF Player.Poisoned = TRUE AND Player.Drugged = FALSE THEN
NewBText "You inject the steroids but they don't have an effect.",2
MoveSwordMode=0
BattleTurn=2
Player.Steroids=Player.Steroids-1
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
END IF

end if
if citem=7 and Player.Shield>0 then 
IF Player.ShieldStatus = TRUE THEN
NewBText "Energy shield already activated.",2
WorkingMode = 0
END IF
IF Player.ShieldStatus = FALSE THEN
Player.Shield=Player.Shield-1
Player.ShieldStatus=TRUE
NewBText "Energy shield activated!",2
MoveSwordMode=0
BattleTurn=2
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
END IF
end if
'WorkingMode = 0
end if
if citem>4 and Mode=1 and citem<8 then 
if citem=5 and Player.AcidBomb>0 THEN NewNText "Only to be used during battle."
if citem=6 and Player.Steroids>0 THEN NewNText "Only to be used during battle."
if citem=7 and Player.Shield>0 THEN NewNText "Only to be used during battle."
if citem=8 and Player.Antidote>0 THEN NewNText "Only to be used during battle."
if citem=5 and Player.AcidBomb>0 THEN WorkingMode = 0
if citem=6 and Player.Steroids>0 THEN WorkingMode = 0
if citem=7 and Player.Shield>0 THEN WorkingMode = 0
if citem=8 and Player.Antidote>0 THEN WorkingMode = 0
end if
end if
end if
next citem

for citem=9 to 10
itinv$ = STR$(citem)+". Nothing"
if citem=9 and trigger(3) = TRUE then itinv$="9. CPU Hacker"
if citem=10 then itinv$="0. Cancel"
if NumericInput(citem)=TRUE and keyboardfree = TRUE then goto executecitem3:
GraphicText 245,345+(citem-8)*10, itinv$, Font
if mx>244 and mx<344 and my>344+(citem-8)*10 and my<355+(citem-8)*10 then 
GraphicText 245,345+(citem-8)*10, itinv$, Font2  
if buttons = 1 and mousefree = TRUE then 
executecitem3:
keyboardfree = FALSE
if Mode = 2 then
'NewBText "Energy shield activated!",2
'WorkingMode = 0
end if
if citem=10 then WorkingMode = 0
end if
end if
next citem

end sub

function NumericInput (numinput) 
    
NumericInput = FALSE

if numinput = 1 and multikey(SC_1) then dummievar = TRUE 
if numinput = 2 and multikey(SC_2) then dummievar = TRUE 
if numinput = 3 and multikey(SC_3) then dummievar = TRUE 
if numinput = 4 and multikey(SC_4) then dummievar = TRUE 
if numinput = 5 and multikey(SC_5) then dummievar = TRUE 
if numinput = 6 and multikey(SC_6) then dummievar = TRUE 
if numinput = 7 and multikey(SC_7) then dummievar = TRUE 
if numinput = 8 and multikey(SC_8) then dummievar = TRUE 
if numinput = 9 and multikey(SC_9) then dummievar = TRUE 
if numinput = 10 and multikey(SC_0) then dummievar = TRUE 

if dummievar=TRUE then
NumericInput = TRUE 
exit function
end if



end function

sub NewNText (inputtext$)

ntext(5)=ntext(4)
ntext(4)=ntext(3)
ntext(3)=ntext(2)
ntext(2)=ntext(1)
ntext(1)=inputtext$

end sub

sub NewBText (inputtext$, inputarray%)

btext(5)=btext(4)
btext(4)=btext(3)
btext(3)=btext(2)
btext(2)=btext(1)
btextfont(5)=btextfont(4)
btextfont(4)=btextfont(3)
btextfont(3)=btextfont(2)
btextfont(2)=btextfont(1)
btext(1)=inputtext$
btextfont(1)=inputarray%

end sub

sub Engine.DrawBattleScreen()

beginbatsub:
' Set the player real defense strenght accordin the the
' defense level and the armour.
if Player.Armour = 1 then ArmD=1
if Player.Armour = 2 then ArmD=2
if Player.Armour = 3 then ArmD=4
Player.defense=Player.defenseL+ArmD

' If the curtain animation is still being played(countbatanim<148) then
' skip battle control code.
if countbatanim<148 then goto skipbatcon:

' If the NPC is dead start counting coundeath variable(to enable
' a small time frame after the battle ends).
IF Player.Alive = FALSE THEN 
'countdeath=countdeath+1
MoveSwordMode = 4
END IF

IF Player.Alive = FALSE and countdeath=12 THEN
AttackAnim = 5
AnimCount = 1
END IF

if NPC(Location,currentNPC).Alive = FALSE then
' When the enemy is dead it's always your turn
' the active option if always 0) 
BattleTurn=1
WorkingMode=0
countdeath=countdeath+1
' When a certain time has passed print some text and add one
' kill to the player's kills count.
if countdeath=12 and Player.Alive = TRUE then
AttackAnim = 4
AnimCount = 1
vtext$ = NPC(Location, currentNPC).SName
if vtext$ = "Zombie Human" then vtext$="Zombie"
killmode$=" killed!"
if (NPC(Location,currentNPC).Typ>7 and NPC(Location,currentNPC).Typ<11) OR (NPC(Location,currentNPC).Typ=16) then killmode$=" destroyed!"
if NPC(Location,currentNPC).Typ=12 THEN killmode$=" vanishes!"
NewBText "Victory! "+NPC(Location, currentNPC).SName+ killmode$,2
Player.Kills = Player.Kills + 1
end if

if countdeath=50 and Player.Alive = TRUE then
rndexp = int(rnd * 6) + 1
rndmon = int(rnd * 10) -5
Player.Experience = Player.Experience + NPC(Location, currentNPC).Experience + rndexp
NewNText "Gained "+STR$(NPC(Location, currentNPC).Experience+rndexp)+" experience points."
if Player.Experience>=Player.NextExp then 
Player.Level = Player.Level + 1
Levelize
Player.Health = Player.Health + 20
IF Player.Level=3 THEN Player.Health = Player.Health + 15
IF Player.Level>3 THEN Player.Health = Player.Health + 30
if Player.Health>Player.MaxHealth then Player.Health = Player.MaxHealth
NewNText "Level up!"
end if
if NPC(Location, currentNPC).Typ<4 then 
NewNText "Found "+STR$(21+rndmon)+" $!"
Player.Money=Player.Money+21+rndmon
end if
end if

' If you press any key or the left mouse button when the battle is
' over and at least 30 loops has passed - end battle mode and initiate
' a new curtain animation(countbatanim = 0).
for cinp=1 to 4
if (NumericInput(cinp)=TRUE and keyboardfree = TRUE) OR (buttons = 1 and mousefree=TRUE) then
if countdeath>60 AND Player.Alive=TRUE then 
Mode=1
countbatanim=0
if Player.AttackMode=1 then ' If YOU attacked the enemy when the battle is over
currentNPC=1                ' we need to switch to NPCs turn and start from the NPC 1.
NPC(Location, currentNPC).Direction = 0
NPC(Location, currentNPC).MovingTime=10
Turn = 2
for cbtext = 1 to 5
btext(cbtext) = ""
next cbtext
end if
end if
end if
next cinp

if countdeath>90 AND Player.Alive=TRUE then ' If a certain number of loops passes(if the player
Mode=1                ' doesn't click before) end battle on the same way
countbatanim=0        ' as previously explained.
if Player.AttackMode=1 then
currentNPC=1
NPC(Location, currentNPC).Direction = 0
NPC(Location, currentNPC).MovingTime=10
Turn = 2
for cbtext = 1 to 5
btext(cbtext) = ""
next cbtext
end if
end if

end if ' end if enemy is not alive

' If it's the enemy's turn(BattleTurn=2) and the sword is on
' the proper position(MoveSwordMode=0) and enemy is not shaking
' (RumbleEnemy=0) attack the player(MoveSwordMode=1)
if MoveSwordMode=0 THEN countendelay = 0
if BattleTurn=2 and MoveSwordMode=0 and RumbleEnemy=0 then MoveSwordMode = 1

' This is the sword mode when the sword is moving toward you from the
' middle(enemy is attacking you).
IF MoveSwordMode=1 THEN
countendelay = countendelay + 1
SwordYPos = SwordYPos+4
if SwordYPos>=129 then SwordYPos=129  
IF countendelay = 30 THEN MoveSwordMode=5
END IF
if MoveSwordMode=5 then
damageresult = 0 ' default damage is 0
SwordYPos = SwordYPos+4
if SwordYPos>163 then ' When the sword reaches player's position
SwordYPos=163         ' calculate damage and change the sword mode
MoveSwordMode=3       ' (make the sword travel to the middle again).
RumblePlayer=10       ' Shake the player's icon.
rndat = int(rnd * 6) + 1 ' Randomize small amount of damage.
if NPC(Location, currentNPC).Typ>7 then rndat = int(rnd * 10) + 1
minusdef=0               ' If the player is poisoned decrease his
                         ' defense capacity.
if Player.Poisoned=TRUE then minusdef=1
' Damage equals - NPC's Start Attack strenght(according to NPC's type)
' PLUS NPC's Attack Strenght * 4 MINUS Player's defense Strenght
' (minus if you are poisoned) PLUS minimum randomized damage
damageresult = NPC(Location, currentNPC).StartAttack+(NPC(Location, currentNPC).AttackL*7)-(Player.defense*(4-minusdef))+rndat
if damageresult<0 then damageresult=0
' If the player's shield is activated reduce the damage
if Player.ShieldStatus=TRUE then damageresult = damageresult/1.8
' Print text explaining what just happened.
IF NPC(Location, currentNPC).Typ < 4 THEN atmode$ = " swings"
IF NPC(Location, currentNPC).Typ = 4 THEN atmode$ = " bites"
IF NPC(Location, currentNPC).Typ = 5 THEN atmode$ = " bites"
IF NPC(Location, currentNPC).Typ = 6 THEN atmode$ = " bites"
IF NPC(Location, currentNPC).Typ = 7 THEN atmode$ = " bites"
IF NPC(Location, currentNPC).Typ > 7 AND NPC(Location, currentNPC).Typ <11 THEN atmode$ = " shoots"
IF NPC(Location, currentNPC).Typ =11 THEN atmode$ = " swings"
IF NPC(Location, currentNPC).Typ = 12 THEN atmode$ = " surrounds you"
IF NPC(Location, currentNPC).Typ =13 THEN atmode$ = " swings"
IF NPC(Location, currentNPC).Typ =14 THEN atmode$ = " swings"
IF NPC(Location, currentNPC).Typ >14 THEN atmode$ = " shoots"
NewBText NPC(Location, currentNPC).SName+atmode$+" and inflicts "+STR$(damageresult)+" damage!",1
Player.Health = Player.Health-damageresult
IF Player.Health<0 THEN Player.Health=0
if Player.Health<=0 then
Player.Alive=FALSE
countdeath = 0
GOTO beginbatsub:
'NewBText "You have been defeated.",1
'NewBText "Better luck next time.",1
end if
end if  ' end if SwordYPos>163
end if  ' end if MoveSwordMode = 1

' MoveSwordMode=2 is when the sword is traveling from the middle
' toward the enemy(you attacked the enemy).
if MoveSwordMode=2 then
SwordYPos = SwordYPos-4
if SwordYPos<96 then
SwordYPos=96
BattleTurn=2 ' Pass the turn to the enemy.
MoveSwordMode=0
countendelay = 0
RumbleEnemy=10 ' Shake the enemy's icon.
' Print the damage inflicted on the enemy.
if damageresult>=0 then NewBText prebtext$+STR$(damageresult)+" damage!",2
' Used only with some weapons and with some enemies who gain
' HP from certain weapons(the next line of code).
if damageresult<0 then NewBText "Unknown gains "+STR$(damageresult)+"health points!",2
NPC(Location,currentNPC).Health=NPC(Location,currentNPC).Health-damageresult
IF NPC(Location,currentNPC).Health>NPC(Location,currentNPC).MaxHealth THEN NPC(Location,currentNPC).Health=NPC(Location,currentNPC).MaxHealth
if NPC(Location,currentNPC).Health<=0 then
NPC(Location,currentNPC).Health = 0
NPC(Location,currentNPC).Alive = FALSE  ' If you kill the enemy this
countdeath=0                            ' resets the countdeath 
WorkingMode=0                           ' variable and flags that the
end if                                  ' enemy IS dead.

end if ' end if SwordYPos<96
end if ' end if MoveSwordMode = 1

' Mode that moves the sword to the middle and passes the
' turn to the player.
if MoveSwordMode=3 then
SwordYPos = SwordYPos-4
if SwordYPos<129 then
SwordYPos=129
BattleTurn=1
MoveSwordMode=4
RumbleEnemy=0
end if
end if

' Some variables and code that controls the shaking of the
' icons when someone is attacked.
rumben=0
rumbpl=0
if RumbleEnemy>0 then 
rumben=Frame3
RumbleEnemy=RumbleEnemy-1
end if
if RumblePlayer>0 then 
rumbpl=Frame3
RumblePlayer=RumblePlayer-1
end if

skipbatcon:


line (21,21)-(319,319),0, BF  
' If curtain animation is over paste battle background image
if countbatanim>147 then put (22,22), bimage1(0), pset


' Print the text on the battle screen(HP, names, etc)
GraphicText 38,98, NPC(Location,currentNPC).SName, Font3 
GraphicText 38,165, Player.SName, Font4 

hstatus$ = "Excellent"
if NPC(Location, currentNPC).Health<NPC(Location, currentNPC).MaxHealth*0.8 then hstatus$="Good"
if NPC(Location, currentNPC).Health<NPC(Location, currentNPC).MaxHealth*0.65 then hstatus$="Average"
if NPC(Location, currentNPC).Health<NPC(Location, currentNPC).MaxHealth*0.4 then hstatus$="Poor"
if NPC(Location, currentNPC).Health<NPC(Location, currentNPC).MaxHealth*0.2 then hstatus$="Dying"
GraphicText 38,108,"Health: "+hstatus$, Font3 
GraphicText 38,175, "HP: "+STR$(Player.Health)+"/"+STR$(Player.MaxHealth), Font4 
if MoveSwordMode=4 AND Player.Alive = TRUE then GraphicText 246,144, "Your Turn", Font4
if MoveSwordMode=1 AND SwordYPos=129 then GraphicText 246,144, "Enemy's Turn", Font4
' Paste the battle graphics.
put (134+rumben, 96), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[NPC(Location,currentNPC).Typ-1]], TRANS
put (134+rumbpl, 163), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[2-1]], TRANS
if RumbleEnemy>0 then put (134+rumben, 96), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[5-1]], TRANS
if RumblePlayer>0 then put (134+rumbpl, 163), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[5-1]], TRANS
' If the player is in some special state paste alternative faces 
' in the player's icon.

addlwep1=0
addrwep1=0
addlwep2=0
addrwep2=0
if Player.LWeapon>2 and Player.LWeapon<6 then addlwep1 = 2
if Player.RWeapon>2 and Player.RWeapon<6 then addrwep1 = 2
if Player.AttackHand=1 then
if MoveSwordMode = 2 OR RumbleEnemy>0 then addlwep2=4
end if
if Player.AttackHand=2 then
if MoveSwordMode = 2 OR RumbleEnemy>0 then addrwep2=4
end if
put (111, 227), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[11+addlwep1+addlwep2-1]], TRANS
put (157, 227), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[12+addrwep1+addrwep2-1]], TRANS

put (111-13, 229), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[19-1]], TRANS
put (157+40, 229), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[19-1]], TRANS

for countlh=1 to Player.LHandStamina
if countlh>0 then mcountlh=1
if countlh>2 then mcountlh=2
if countlh>4 then mcountlh=3
if countlh>6 then mcountlh=4
if countlh>8 then mcountlh=5
if Player.LHandStamina>0 then put (111-13, 264-mcountlh*7), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[20-1]], TRANS
next countlh
for countrh=1 to Player.RHandStamina
if countrh>0 then mcountrh=1
if countrh>2 then mcountrh=2
if countrh>4 then mcountrh=3
if countrh>6 then mcountrh=4
if countrh>8 then mcountrh=5
if Player.RHandStamina>0 then put (157+40, 264-mcountrh*7), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[20-1]], TRANS
next countrh

if Player.FoodStatus<3 then put (134+rumbpl+9, 163+4), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[41-1]], TRANS
if Player.Poisoned = TRUE then put (134+rumbpl+9, 163+4), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[42-1]], TRANS
if Player.Drugged = TRUE then put (134+rumbpl+9, 163+4), @Sprites2.s_image.p_data[Sprites2.s_image.p_dataindex[40-1]], TRANS
IF Player.Oxywear = TRUE THEN put (134+rumbpl, 163), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[3-1]], TRANS

' Paste the sword on the screen.
put (184, SwordYPos), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[4-1]], TRANS

' Paste battle animation sprites(bomb explosion, etc).
Engine.DrawAttackAnim

' This code executes the curtain animation(it's executed until
' countbatanim reaches 148(each battle is initiated with
' countbatanim = 0).
if countbatanim<148 then
countbatanim = countbatanim + 4
put (22,22), bimage2(0), pset
line (22,22)-(22+countbatanim,319), 0, BF
line (319,22)-(319-countbatanim,319), 0, BF
get (22,22)-(319,319), bimage2(0)
put (22,22), bimage1(0), pset
put (22,22), bimage2(0), TRANS
end if

' Paste the "red cross over the face of the enemy" when 
' the red cross animation ends(if we don't do this it would 
' disappear from the face of the enemy before the battle ends.
if (countdeath>12 and AttackAnim=0 and NPC(Location, currentNPC).Alive=FALSE) then put (139+rumben, 101), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[112-1]], TRANS
if countdeath>12 and AttackAnim=0 AND Player.Alive = FALSE THEN put (139+rumbpl, 168), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[112-1]], TRANS
' Get the battle screen before the battle ends to enable another
' curtain effect in normal mode(check Engine.DrawInterface sub).
if countbatanim>147 and countdeath=60 then 
get (22,22)-(319,319), bimage2(0)
END IF
'IF countdeath>30 THEN PUT (22,22), bimage2(0), TRANS

end sub

sub AttackLHand()

' This sub initiates an attack with the left hand.

' Flags which hand it attacking(only used to flag the proper
' sprite in the battle screen).
Player.AttackHand=1
' Controls the stamina for left and right hand. When the left
' hand is used we decrease it's stamina and increase right
' hand stamina(since it's not used).
if MoveSwordMode =4 then
Player.LHandStamina=Player.LHandStamina-1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina-1
IF Player.LHandStamina < 0 THEN
IF Player.LWeapon<3 OR Player.LWeapon>5 THEN NewBText "Your left hand feels very weak.",2
IF Player.LWeapon>2 AND Player.LWeapon<6 THEN NewBText "Your weapon power is very low.",2
END IF
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if

MoveSwordMode=2 ' Attack mode(move the sword on the enemy)

' Some lines used to balance the amount of damage.
' rndat is a minimum of randomized damage in the formula.
if Player.Level<4 then rndat = int(rnd * 5) + 1
if Player.Level>3 then rndat = int(rnd * 10) + 1

attat=0
startat=0

' According to player's weapon flag the proper message(hand or fire
' weapon).
prebtext$="You swing and inflict "
if Player.LWeapon>2 and Player.LWeapon<6 then prebtext$="You shoot and inflict "

'Player.LWeapon= 0 - Nothing
'Player.LWeapon= 1 - Metal Pipe
'Player.LWeapon = 2 - Electrocute Stick
'Player.LWeapon = 3 - Ion Pistol
'Player.LWeapon = 4 - Ion Rifle
'Player.LWeapon = 5 - Distruptor
'Player.LWeapon = 6 - Raan Gutter

' Set the start attack values of weapons(used in damage formula)
' and it's addition to the attack level.
select case Player.LWeapon
case 1
    startat=3
    addat = 0
case 2
    startat=4
    addat = 1
    if (NPC(Location,currentNPC).Typ>7 and NPC(Location,currentNPC).Typ<11) OR (NPC(Location,currentNPC).Typ=16) then 
    addat=2      ' This is some special code for the electrocuter
    startat=5   ' which causes EXTRA damage to mechanical enemies(flaged
    end if       ' with NPC types).
case 3
    startat = 8
    addat = 3
case 4
    startat = 15
    addat = 3
case 5
    startat = 25
    attat = 5
case 6
    attat = 5
    startat=20
end select

' Used with the Mist enemy(makes hand weapons very ineffective
' against it.
if NPC(Location,currentNPC).Typ = 12 then
if Player.LWeapon<2 OR Player.LWeapon=6 then
addat=0
startat=5
end if
end if

' If the player is on steroids double his attack strenght.
if Player.Poisoned = TRUE then addat = -2
steroid=1
if Player.Drugged = TRUE then steroid = 2

' Damage is calculated - Weapon start attack PLUST player's attack
' strenght * 5(pluse some extra with some weapons) * steroids MINUS
' NPCs defense times 3 MINUS some randomized damage

foodat! = 1
if Player.FoodStatus = 2 then foodat!=0.8
if Player.FoodStatus = 1 then foodat!=0.6

armlos!=1
staminalos!=1
' If the player's main arm is right reduce the power of damage.
if Player.MainArm=2 then
' If player's main arm is right hand reduce the power of attack
' for 40% if the weapon is hand weapon.
if Player.LWeapon<3 OR Player.LWeapon>5 then armlos!=0.6
end if
' If player's main arm is right hand reduce the power of attack
' for 20% if the weapon is fire weapon
if Player.MainArm=2 and Player.LWeapon>2 and Player.LWeapon<6 then armlos!=0.8

' If the hand stamina is 0 then reduce the power of hand weapon
' attack for 40% or fire weapon for 50%
if Player.LHandStamina<0 then
if Player.LWeapon<3 OR Player.LWeapon>5 then staminalos!=0.6
end if
if Player.LHandStamina<0 and Player.LWeapon>2 and Player.LWeapon<6 then staminalos!=0.5

if Player.LHandStamina<0 then Player.LHandStamina = 0

damageresult = staminalos!*armlos!*foodat!*(startat+(Player.AttackL*(8+addat))*steroid)-(NPC(Location, currentNPC).defenseL*6)+rndat

'NewBText STR$(staminalos!*armlos!*foodat!*(startat+(Player.AttackL*(8+addat))*steroid)),2
'NewBText STR$(staminalos!),2

' If the player's weapon is electrocuter and the enemy is mist
' add HP to him instead of inflicting damage.
if NPC(Location,currentNPC).Typ = 12 and Player.LWeapon = 2 then
if damageresult>=0 then damageresult=-damageresult
end if
if NPC(Location,currentNPC).Typ <> 12 and damageresult<0 then damageresult=0

end sub

sub AttackRHand()
' This sub initiates an attack with the right hand.

Player.AttackHand=2

if MoveSwordMode =4 then
Player.RHandStamina=Player.RHandStamina-1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina-1
IF Player.RHandStamina < 0 THEN
IF Player.RWeapon<3 OR Player.RWeapon>5 THEN NewBText "Your right hand feels very weak.",2
IF Player.RWeapon>2 AND Player.RWeapon<6 THEN NewBText "Your weapon power is very low.",2
END IF
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
end if


MoveSwordMode=2 ' Attack mode(move the sword on the enemy)

' Some lines used to balance the amount of damage.
' rndat is a minimum of randomized damage in the formula.
if Player.Level<4 then rndat = int(rnd * 5) + 1
if Player.Level>3 then rndat = int(rnd * 10) + 1

attat=0
startat=0

' According to player's weapon flag the proper message(hand or fire
' weapon).
prebtext$="You swing and inflict "
if Player.RWeapon>2 and Player.RWeapon<6 then prebtext$="You shoot and inflict "

'Player.RWeapon= 0 - Nothing
'Player.RWeapon= 1 - Metal Pipe
'Player.RWeapon = 2 - Electrocute Stick
'Player.RWeapon = 3 - Ion Pistol
'Player.RWeapon = 4 - Ion Rifle
'Player.RWeapon = 5 - Distruptor
'Player.RWeapon = 6 - Raan Gutter

' Set the start attack values of weapons(used in damage formula)
' and it's addition to the attack level.
select case Player.RWeapon
case 1
    startat=3
    addat = 0
case 2
    startat=4
    addat = 1
    if (NPC(Location,currentNPC).Typ>7 and NPC(Location,currentNPC).Typ<11) OR (NPC(Location,currentNPC).Typ=16) then 
    addat=2      ' This is some special code for the electrocuter
    startat=5   ' which causes EXTRA damage to mechanical enemies(flaged
    end if       ' with NPC types).
case 3
    startat = 8
    addat = 3
case 4
    startat = 15
    addat = 3
case 5
    startat = 25
    attat = 5
case 6
    attat = 5
    startat=20
end select

' Used with the Mist enemy(makes hand weapons very ineffective
' against it.
if NPC(Location,currentNPC).Typ = 12 then
if Player.RWeapon<2 OR Player.RWeapon=6 then
addat=0
startat=5
end if
end if

' If the player is on steroids double his attack strenght.
if Player.Poisoned = TRUE then addat = -2
steroid=1
if Player.Drugged = TRUE then steroid = 2

' Damage is calculated - Weapon start attack PLUST player's attack
' strenght * 5(pluse some extra with some weapons) * steroids MINUS
' NPCs defense times 3 MINUS some randomized damage

foodat! = 1
if Player.FoodStatus = 2 then foodat!=0.8
if Player.FoodStatus = 1 then foodat!=0.6

armlos!=1
staminalos!=1
' If the player's main arm is left reduce the power of damage.
if Player.MainArm=1 then
' If player's main arm is left reduce the power of attack
' for 40% if the weapon is hand weapon.
if Player.RWeapon<3 OR Player.RWeapon>5 then armlos!=0.6
end if
' If player's main arm is left reduce the power of attack
' for 20% if the weapon is fire weapon
if Player.MainArm=1 and Player.RWeapon>2 and Player.RWeapon<6 then armlos!=0.8

' If the hand stamina is 0 then reduce the power of hand weapon
' attack for 40% or fire weapon for 50%
if Player.RHandStamina<0 then
if Player.RWeapon<3 OR Player.RWeapon>5 then staminalos!=0.6
end if
if Player.RHandStamina<0 and Player.RWeapon>2 and Player.RWeapon<6 then staminalos!=0.5

if Player.RHandStamina<0 then Player.RHandStamina = 0
damageresult = staminalos!*armlos!*foodat!*(startat+(Player.AttackL*(8+addat))*steroid)-(NPC(Location, currentNPC).defenseL*6)+rndat

' If the player's weapon is electrocuter and the enemy is mist
' add HP to him instead of inflicting damage.
if NPC(Location,currentNPC).Typ = 12 and Player.RWeapon = 2 then
if damageresult>=0 then damageresult=-damageresult
end if
if NPC(Location,currentNPC).Typ <> 12 and damageresult<0 then damageresult=0

end sub

sub RunAway()
' Sub used to control the RunAway option during a battle.

' Randomize the possibily of running away.
rndrun = int(rnd * (Player.Level+4)) + 1

' If run away is to happen check the free positions(from 
' the enemies or walls).
if rndrun>3 then    
isfree = TRUE
checkdirec=1

' Really, really stupid code that checks Location by Location
' if it's available for an escape from the battle.
for countcolNPC=1 to numofnpcs
if (Map(Location, Player.TileX+1,Player.TileY).BaseL>55) OR (NPC(Location, countcolNPC).Alive = TRUE and countcolNPC<>currentNPC and Player.TileX+1=NPC(Location,countcolNPC).TileX and Player.TileY=NPC(Location,countcolNPC).TileY) then
isfree= FALSE
goto skipnextcolNPC11:
end if
next countcolNPC
isfree = TRUE
Player.Direction=1 ' Flag the direction of escape.
skipnextcolNPC11:

if isfree=FALSE then
for countcolNPC=1 to numofnpcs
if (Map(Location, Player.TileX-1,Player.TileY).BaseL>55) OR (NPC(Location, countcolNPC).Alive = TRUE and countcolNPC<>currentNPC and Player.TileX-1=NPC(Location,countcolNPC).TileX and Player.TileY=NPC(Location,countcolNPC).TileY) then
isfree= FALSE
goto skipnextcolNPC12:
end if
next countcolNPC
isfree = TRUE
Player.Direction=3
skipnextcolNPC12:
end if

if isfree=FALSE then
for countcolNPC=1 to numofnpcs
if (Map(Location, Player.TileX,Player.TileY-1).BaseL>55) OR (NPC(Location, countcolNPC).Alive = TRUE and countcolNPC<>currentNPC and Player.TileY-1=NPC(Location,countcolNPC).TileY and Player.TileX=NPC(Location,countcolNPC).TileX) then
isfree= FALSE
goto skipnextcolNPC13:
end if
next countcolNPC
isfree = TRUE
Player.Direction=2
skipnextcolNPC13:
end if

if isfree=FALSE then
for countcolNPC=1 to numofnpcs
if (Map(Location, Player.TileX,Player.TileY+1).BaseL>55) OR (NPC(Location, countcolNPC).Alive = TRUE and countcolNPC<>currentNPC and Player.TileY+1=NPC(Location,countcolNPC).TileY and Player.TileX=NPC(Location,countcolNPC).TileX) then
isfree= FALSE
goto skipnextcolNPC14:
end if
next countcolNPC
isfree = TRUE
Player.Direction=4
skipnextcolNPC14:
end if

' If an Location is found enable escape. 
' This IF clause triggers the player's movement
' and flags the ReMove variable which will
' return the turn to player after this movement.
if isfree=TRUE then
  WorkingMode = 0
  Player.OldX = Player.X   
  Player.OldY = Player.Y  
  Player.Move = TRUE
  Player.MovingTime = 10
  NewNText "You run away!"
  Turn=1
  Mode=1
  Player.ReMove = TRUE
  exit sub
end if

' If there is no place to escape print this message
' and pass the turn to the enemy.
if isfree = FALSE then
NewBText "Can't run away!",2
MoveSwordMode=0
BattleTurn=2
WorkingMode=0
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if

end if 'end if rndrun>1

' If the randomization chosen not to allow you to escape print
' this message and pass the turn to the enemey.
if rndrun<4 then
NewBText "Failed to run away!",2
MoveSwordMode=0
BattleTurn=2
WorkingMode=0
Player.LHandStamina = Player.LHandStamina+1
if Player.LWeapon<3 OR Player.LWeapon>5 then Player.LHandStamina = Player.LHandStamina+1
if Player.LHandStamina>10 then Player.LHandStamina = 10
Player.RHandStamina = Player.RHandStamina+1
if Player.RWeapon<3 OR Player.RWeapon>5 then Player.RHandStamina = Player.RHandStamina+1
if Player.RHandStamina>10 then Player.RHandStamina = 10
end if
end sub

sub Engine.DrawAttackAnim()

' This sub is used to draw stuff on the NPC's face according
' to special weapon used against it. AttackAnim flags the type of
' weapon and AnimCount controls the execution of the animation.
if AttackAnim>0 then
if Player.Alive= FALSE OR RumbleEnemy>0 OR MoveSwordMode=1 OR MoveSwordMode=5 OR NPC(Location,currentNPC).Alive=FALSE then
IF AttackAnim<5 THEN put (139+rumben, 101), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[80+AnimCount+(AttackAnim-1)*8-1]], TRANS
IF AttackAnim=5 THEN put (139+rumbpl, 168), @Sprites4.s_image.p_data[Sprites4.s_image.p_dataindex[80+AnimCount+(AttackAnim-2)*8-1]], TRANS
if Frame2=2 and AttackAnim< 4 then AnimCount=AnimCount+1
if Frame4=2 and AttackAnim= 4 then AnimCount=AnimCount+1
if Frame4=2 and AttackAnim= 5 then AnimCount=AnimCount+1
if AnimCount>8 then AttackAnim=0
end if
end if

end sub

sub Levelize()

' This sub flag the proper attack and defense level values and
' max HP according to player's level. This is easier to control.

select case Player.Level
    
case 1
Player.AttackL=1
Player.defenseL=1
Player.MaxHealth=60
Player.NextExp=100+30
case 2
Player.AttackL=2
Player.defenseL=1
Player.MaxHealth=70
Player.NextExp=300
case 3
Player.AttackL=3
Player.defenseL=2
Player.MaxHealth=90
Player.NextExp=700
case 4
Player.AttackL=4
Player.defenseL=2
Player.MaxHealth=120
Player.NextExp=1200
case 5
Player.AttackL=5
Player.defenseL=3
Player.MaxHealth=160
Player.NextExp=1700
case 6
Player.AttackL=6
Player.defenseL=4
Player.MaxHealth=200
Player.NextExp=2500
case 7
Player.AttackL=7
Player.defenseL=5
Player.MaxHealth=250
Player.NextExp=3500
case 8
Player.AttackL=8
Player.defenseL=6
Player.MaxHealth=300
Player.NextExp=100000
end select

end sub

sub AddLight (illumination%, XTil%, YTil%)
    
' Sub that changes the illumination of a tile only if it's less
' illuminated that we are attempting to illuminate it(necessary when
' you are near other lights).

if Map(Location, XTil%, YTil%).LightStat<illumination% then 
Map(Location, XTil%, YTil%).LightStat = illumination%

' The next line enables "half-lighting" of wall tiles that are
' under the player.
if Map(Location, XTil%, YTil%).BaseL>170 AND Player.TileY<YTil% THEN Map(Location, XTil%, YTil%).LightStat = 4
END IF

end sub

sub CaptureScreen()
    get (22,22)-(319,319), bimage2(0)
    get (22,22)-(319,319), bimage3(0)
    for bt=1 to 5
    btext(bt)=""
next bt

end sub

sub Engine.DrawLockers

for clock=1 to 50
    
Locker(Location, clock).TileX = (Locker(Location, clock).X + (TileW/2)) \ TileW  
Locker(Location, clock).TileY = (Locker(Location, clock).Y + (TileH/2)) \ TileH
if Locker(Location, clock).Exist = TRUE and Map(Location, Locker(Location, clock).TileX,Locker(Location, clock).TileY).FogStat=1 then 
lframe1= Locker(Location, clock).Frame+4
lframe1 = lframe1 - Map(Location, Locker(Location, clock).TileX, Locker(Location, clock).TileY).LightStat
lframe2 = 160 - Map(Location, Locker(Location, clock).TileX, Locker(Location, clock).TileY).LightStat
if Locker(Location, clock).X - Level.CamX<301 and Locker(Location, clock).Y - Level.CamY<301 then 
IF Locker(Location, clock).Mode = 2 THEN put ((Locker(Location, clock).X+20 - Level.CamX), (Locker(Location, clock).Y+20 - Level.CamY)), @Sprites5.s_image.p_data[Sprites5.s_image.p_dataindex[lframe1-1]], TRANS
IF Locker(Location, clock).Mode = 1 THEN put ((Locker(Location, clock).X+20 - Level.CamX), (Locker(Location, clock).Y+20 - Level.CamY)), @Tiles.s_image.p_data[Tiles.s_image.p_dataindex[lframe2-1]], TRANS
END IF
end if

next clock

end sub

sub Engine.DrawCorpses
    
for ccorp=1 to 50
    
Corpse(Location, ccorp).TileX = (Corpse(Location, ccorp).X + (TileW/2)) \ TileW  
Corpse(Location, ccorp).TileY = (Corpse(Location, ccorp).Y + (TileH/2)) \ TileH
if Corpse(Location, ccorp).Exist = TRUE and Map(Location, Corpse(Location, ccorp).TileX,Corpse(Location, ccorp).TileY).FogStat=1 then 
cframe= Corpse(Location, ccorp).Frame+4
cframe = cframe - Map(Location, Corpse(Location, ccorp).TileX, Corpse(Location, ccorp).TileY).LightStat
if Corpse(Location, ccorp).X - Level.CamX<301 and Corpse(Location, ccorp).Y - Level.CamY<301 then put ((Corpse(Location, ccorp).X+20 - Level.CamX), (Corpse(Location, ccorp).Y+20 - Level.CamY)), @Sprites5.s_image.p_data[Sprites5.s_image.p_dataindex[cframe-1]], TRANS
end if

next ccorp
    
end sub

sub ExamineLocation ()
    
WorkingMode = 0
rndt = int(rnd * 2) + 1
if rndt=1 then ltext$ = "You search around and find nothing."
if rndt=2 then ltext$ = "Nothing found."
for ccorp=1 to 50
if Player.TileX=Corpse(Location, ccorp).TileX and Player.TileY=Corpse(Location, ccorp).TileY and Corpse(Location, ccorp).Exist = TRUE and Corpse(Location, ccorp).Mode = 2 then 
rndt = int(rnd * 2) + 1
if rndt=1 then ltext$ = "Nothing else on the corpse."
if rndt=2 then ltext$ = "You search the corpse again and find nothing."
end if
if Player.TileX=Corpse(Location, ccorp).TileX and Player.TileY=Corpse(Location, ccorp).TileY and Corpse(Location, ccorp).Exist = TRUE and Corpse(Location, ccorp).Mode = 1 then
Corpse(Location, ccorp).Mode = 2
select case Corpse(Location, ccorp).Typ
case 0
rndc = int(rnd * 6) + 1
cash = 11 + rndc
ltext$ = "You search the body and find "+str$(cash)+ " $."
Player.Money = Player.Money + cash
case 1
ltext$ = "You search the corpse and find nothing."
case 2
rndt = int(rnd * 5) + 1
if rndt<5 then ltext$ = "Found a lunch pack."
if rndt<3 then ltext$ = "You find some food."
if rndt = 5 then ltext$ = "Found some dry rations."
Player.Food = Player.Food + 1
if rndt = 5 then Player.Food = Player.Food + 1
case 3
ltext$ = "You find one med-pack."
Player.MedPack = Player.MedPack + 1
case 4
rndt = int(rnd * 5) + 1
if rndt<5 then ltext$ = "You find one grenade."
if rndt= 5 then ltext$ = "You find two grenades."
Player.Bomb = Player.Bomb + 1
if rndt= 5 then Player.Bomb = Player.Bomb + 1
case 5
ltext$ = "You search and find an antidote."
Player.Antidote = Player.Antidote + 1
case 6
ltext$ = "You find some steroids."
Player.Steroids = Player.Steroids + 1
case 7
ltext$ = "You find one electric shocker."
Player.ElecDistruptor = Player.ElecDistruptor + 1
case 8
ltext$ = "You find an acid bomb."
Player.AcidBomb = Player.AcidBomb + 1
case 9
ltext$ = "You find an ion pistol."
for cwep=1 to 7
if weaponsinv(cwep)=0 then 
weaponsinv(cwep)=3
goto exitweploop1:
end if
next cwep
exitweploop1:
case 10
ltext$ = "You find an electrocuter."
for cwep=1 to 7
if weaponsinv(cwep)=0 then 
weaponsinv(cwep)=2
goto exitweploop2:
end if
next cwep
case 11
ltext$ = "You find an ion rifle."
for cwep=1 to 7
if weaponsinv(cwep)=0 then 
weaponsinv(cwep)=4
goto exitweploop2:
end if
next cwep
exitweploop2:
end select
end if
next ccorp
NewNText ltext$
SkipTurn    
end sub

sub OperateWith ()
    
ltext$ = "Nothing to operate with."
IF Map(Location, Player.TileX, Player.TileY).BaseL=16 AND WorkingMode>0 THEN 
ChangeLocation 2
ltext$ = "Now on level "+ STR$(Location)+"."
WorkingMode = 0
END IF
IF Map(Location, Player.TileX, Player.TileY).BaseL=21 AND WorkingMode>0 THEN 
ChangeLocation 1
ltext$ = "Now on level "+ STR$(Location)+"."
WorkingMode = 0
END IF

CheckForDoors

IF Location = 2 or Location = 4 THEN
    
IF Map(Location, Player.TileX, Player.TileY-1).BaseL=81 AND WorkingMode>0 THEN 
rndt = int(rnd * 2) + 1
IF rndt=1 THEN ltext$ = "The console is inoperable."
IF rndt=2 THEN ltext$ = "This console seems to be broken."
WorkingMode = 0
END IF

IF Map(Location, Player.TileX, Player.TileY-1).BaseL=76 OR Map(Location, Player.TileX, Player.TileY+1).BaseL=76 OR Map(Location, Player.TileX+1, Player.TileY).BaseL=76 OR Map(Location, Player.TileX-1, Player.TileY).BaseL=76 THEN 
IF WorkingMode>0 THEN
ltext$ = "I see no sense in operating a forklift."
WorkingMode = 0
END IF
END IF

END IF

IF Location = 1 AND Map(Location, Player.TileX, Player.TileY-1).BaseL=131 AND WorkingMode>0 THEN
rndt = int(rnd * 2) + 1
IF rndt=1 THEN ltext$ = "The console is inoperable."
IF rndt=2 THEN ltext$ = "This console seems to be broken."
WorkingMode = 0    
END IF

IF Map(Location, Player.TileX+1, Player.TileY).BaseL=271 AND WorkingMode>0 THEN 
WorkingMode = 13
EXIT SUB
END IF

WorkingMode = 0
for clock=1 to 50
if Player.TileX=Locker(Location, clock).TileX and Player.TileY=Locker(Location, clock).TileY+1 and Locker(Location, clock).Exist = TRUE and Locker(Location, clock).Mode = 2 then 
SkipTurn
rndt = int(rnd * 3) + 1
if rndt=1 then ltext$ = "Nothing else in the locker."
if rndt=2 then ltext$ = "You search and find nothing else."
if rndt=3 then ltext$ = "The locker is empty."
end if
if Player.TileX=Locker(Location, clock).TileX and Player.TileY=Locker(Location, clock).TileY+1 and Locker(Location, clock).Exist = TRUE and Locker(Location, clock).Mode = 1 then
Locker(Location, clock).Mode = 2
select case Locker(Location, clock).Typ
case 1
ltext$ = "Found nothing."
case 2
rndt = int(rnd * 5) + 1
if rndt<5 then ltext$ = "Found a lunch pack."
if rndt<3 then ltext$ = "You find some food."
if rndt= 5 then ltext$ = "Found some dry rations."
Player.Food = Player.Food + 1
if rndt= 5 then Player.Food = Player.Food + 1
case 3
ltext$ = "You find one med-pack."
Player.MedPack = Player.MedPack + 1
case 4
rndt = int(rnd * 5) + 1
if rndt<5 then ltext$ = "You find one grenade."
if rndt= 5 then ltext$ = "You find two grenades."
Player.Bomb = Player.Bomb + 1
if rndt= 5 then Player.Bomb = Player.Bomb + 1
case 5
ltext$ = "You search and find an antidote."
Player.Antidote = Player.Antidote + 1
case 6
ltext$ = "You find some steroids."
Player.Steroids = Player.Steroids + 1
case 7
ltext$ = "You find one electric shocker."
Player.ElecDistruptor = Player.ElecDistruptor + 1
case 8
ltext$ = "You find an acid bomb."
Player.AcidBomb = Player.AcidBomb + 1
case 9
rndc = int(rnd * 5) + 1
cash = 8 + rndc
ltext$ = "You find "+str$(cash)+ " $."
Player.Money = Player.Money + cash
case 10
ltext$ = "You find one kevlar armour."
for ceqinv=1 to 7
IF equipmentinv(ceqinv)=0 THEN
equipmentinv(ceqinv)= 2 
goto endeq1:
END IF
next ceqinv
case 11
ltext$ = "You find an oxygen mask and a tank."
Player.Oxygen = 23
Player.Oxycount = 0
for ceqinv=1 to 7
IF equipmentinv(ceqinv)=0 THEN
equipmentinv(ceqinv)= 6
goto endeq1:
END IF
next ceqinv
CASE 12
ltext$ = "You find a pair of sturdy boots."
for ceqinv=1 to 7
IF equipmentinv(ceqinv)=0 THEN
equipmentinv(ceqinv)= 5
goto endeq1:
END IF
next ceqinv       
endeq1:
end select
end if
next clock
NewNText ltext$
end sub

sub MainMenu

while multikey(SC_ENTER)
wend
ROption=1
keyboardfree = FALSE


do
    
MenuOption = 0


getmouse mx, my, , buttons

screenset 1, 0
cls

if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset

'PUT (0,0), mbimage(0), PSET
put (270, 100), @Sprites3.s_image.p_data[Sprites3.s_image.p_dataindex[1-1]], TRANS

put (100, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[1-1]], TRANS
put (150, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[2-1]], TRANS
put (200, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[3-1]], TRANS
put (300, 220), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[4-1]], TRANS
put (400, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[5-1]], TRANS
put (450, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[6-1]], TRANS
put (500, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[7-1]], TRANS

if mx>99 and mx<141 and my>99 and my<141 then MenuOption = 1
if mx>149 and mx<191 and my>129 and my<171 then MenuOption = 2
if mx>199 and mx<241 and my>159 and my<201 then MenuOption = 3
if mx>299 and mx<341 and my>219 and my<261 then MenuOption = 4
if mx>399 and mx<441 and my>159 and my<201 then MenuOption = 5
if mx>449 and mx<491 and my>129 and my<171 then MenuOption = 6
if mx>499 and mx<541 and my>99 and my<141 then MenuOption = 7

if MenuOption > 0 then ROption = MenuOption

if multikey(SC_RIGHT) and keyboardfree = TRUE then 
ROption = ROption + 1
keyboardfree = FALSE
end if
if multikey(SC_LEFT) and keyboardfree = TRUE then 
ROption = ROption - 1
keyboardfree = FALSE
end if
if ROption<1 then ROption = 7
if ROption>7 then ROption = 1

'IF MenuOption>0 THEN ROption = MenuOption

if ROption = 1 then put (100, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 2 then put (150, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 3 then put (200, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 4 then put (300, 220), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 5 then put (400, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 6 then put (450, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if ROption = 7 then put (500, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS

if MenuOption = 1 then put (100, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 2 then put (150, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 3 then put (200, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 4 then put (300, 220), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 5 then put (400, 160), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 6 then put (450, 130), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
if MenuOption = 7 then put (500, 100), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS

select case ROption
case 1
mtext$ = "Start New Game"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
NewGame
InitVariables 
playgame:
Main
mousefree = FALSE
keyboardfree = FALSE
end if
case 2
mtext$ = "Load Previously Saved Game"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
LoadGameMenu
if GameLoaded = TRUE then goto playgame:
end if
case 3
mtext$ = "Best Scores"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
ReadHighScore
end if
case 4
mtext$ = "Quit"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER)) then end
case 5
mtext$ = "Options"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
Options
end if
case 6
mtext$ = "Instructions"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
Instructions
end if
case 7
mtext$ = "Credits"
if (buttons=1 and mousefree = TRUE and MenuOption=ROption) OR (multikey(SC_ENTER) and keyboardfree=TRUE) then
Credits
end if
end select

if multikey(SC_RIGHT) OR multikey(SC_LEFT) OR multikey(SC_ENTER) then goto skipkeyrestore:
keyboardfree = TRUE
skipkeyrestore:
if buttons = 1 then goto skipmouserestore:
mousefree = TRUE
skipmouserestore:

GraphicText CENTRETEXT,330, mtext$, Font
GraphicText CENTRETEXT,450, "Press left/right arrow key to move and enter to confirm a choice or just use the mouse", Font6

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS

screencopy      ' Copy our work page on the screen.
SCREENSYNC   ' Wait for vertical sync.
screenlock
sleep 2
screenunlock

if multikey(SC_S) then
bsave "screenshot"+LTRIM$(RTRIM$(STR$(sshoot)))+".bmp", 0, 3072000
sshoot=sshoot+1
while multikey(SC_S)
wend
end if


loop

end sub

sub NewGame

countlet=1
countmenu=0
hand = 1
heroname$=""
for herol=1 to 8
heroletter$(herol)=""
next herol
while INKEY$ <> "": wend

do
    
getmouse mx, my, , buttons
blinker$=" "
Frame4 = (Frame4 mod 16) + 1
if Frame4>8 and countmenu=0 then blinker$="_"
a$ = INKEY$   

if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset

put (300, 90), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[2-1]], TRANS
GraphicText CENTRETEXT,145, "Please enter your name:", Font

if countmenu=0 then
if asc(ucase$(a$)) >= 65 and asc(ucase$(a$)) <= 90 and countlet<9 then
heroletter$(countlet) = a$
countlet=countlet+1
end if
if asc(a$) = 8 and countlet > 1 then
countlet=countlet-1
heroletter$(countlet) = ""
end if
end if

if countmenu = 1 then
GraphicText CENTRETEXT,190, "What is your main hand?", Font
put (270, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[13-1]], TRANS
put (330, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[14-1]], TRANS
put (305, 254), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[15-1]], TRANS
if hand=1 then put (270, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
if hand=2 then put (330, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS

if my>169+40 and my<211+40 then
if mx>279 and mx<311 then
hand=1
put (270, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[9-1]], TRANS
end if
if mx>329 and mx<371 then
hand=2
put (330, 210), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[8-1]], TRANS
end if
end if

if multikey(SC_LEFT) then hand = 1
if multikey(SC_RIGHT) then hand = 2
htext$="Right"
addx=0
if hand=1 then 
htext$="Left "
addx=3
end if
GraphicText 308+addx,230+40, htext$, Font
end if

heroname$=""
for counthname=1 to 8
heroname$=heroname$+heroletter$(counthname)
next counthname
GraphicText 300,120+40, heroname$+blinker$, Font

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS

screencopy      ' Copy our work page on the screen.
SCREENSYNC   ' Wait for vertical sync.
screenlock
sleep 2
screenunlock

if countmenu=0 and multikey(SC_ENTER) and countlet>1 then 
countmenu=countmenu+1
Player.SName = heroname$
keyboardfree = FALSE
end if

if countmenu=1 and keyboardfree = TRUE then 
if multikey(SC_ENTER) OR buttons=1 then
countmenu=countmenu+1
Player.MainArm = hand
end if
end if

if multikey(SC_ENTER) then goto skipkr:
keyboardfree = TRUE
skipkr:

loop until countmenu=2

end sub

sub WriteHighScore

'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_StopSound (FSOUND_ALL)
'IF PlaySound = TRUE AND FMODStatus = TRUE AND Music = TRUE THEN 
'mysamples(10) = FSOUND_Stream_Open("Sound/poxiemain.mp3", FSOUND_LOOP, 0, 0)
'FSOUND_Stream_SetMode(mysamples(10), FSOUND_LOOP_NORMAL)
'FSOUND_Stream_Play(6, mysamples(10))
'END IF

redim scores(5) as integer
redim textarray(10) as string
datafile$ = "data/hs.DAT"
open path$ + datafile$ for input as #3
for tar = 1 to 10
input #3, textarray(tar)
neoENCdepass sadd(textarray(tar)), len(textarray(tar)), "gigante"
next tar
close #3

for ar = 6 to 10
ar2 = ar - 5
scores(ar2) = val(textarray(ar))
next ar

if Player.Score > scores(5) then

for nameloop = 1 to 5
if Player.Score > scores(nameloop) then

cls

while multikey(SC_Y)
wend

do
    
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Update

getmouse mx, my, , buttons
screenset 1, 0
cls
if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset
GraphicText CENTRETEXT, 203, " Enter highscore?", Font
GraphicText 282, 217, "1- Yes", Font
GraphicText 335, 217, "2 - No", Font
if my>216 and my<228 then
if mx>281 and mx<322 then
GraphicText 282, 217, "1- Yes", Font2
if buttons=1 and mousefree = TRUE then goto wscore:
end if
if mx>334 and mx<370 then
GraphicText 335, 217, "2 - No", Font2
if buttons=1 and mousefree = TRUE then exit sub
end if
end if
put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS
'GraphicText 4,425, "Mouse:"+STR$(mx)+","+STR$(my)+","+STR$(buttons), Font

if multikey(SC_2) then exit sub
screencopy
SCREENSYNC
screenlock
sleep 2
screenunlock

IF buttons = 1 goto skipmhr:
mousefree = TRUE
skipmhr:

loop until multikey(SC_1)

wscore:
highname$ = Player.SName
startwrite = nameloop
goto writescore:
end if
next nameloop

writescore:
if startwrite = 5 then goto writescore2:
for m = 4 to startwrite step -1
n = m + 1
textarray(n) = textarray(m)
scores(n) = scores(m)
next m
writescore2:
scores(startwrite) = Player.Score
textarray(startwrite) = highname$

for ar = 6 to 10
ar2 = ar - 5
textarray(ar) = LTRIM$(STR$(scores(ar2)))
next ar

open path$ + datafile$ for output as #3
for tar = 1 to 10
neoENCpass sadd(textarray(tar)), len(textarray(tar)), "gigante"
print #3, textarray(tar)
next tar
close #3

ReadHighScore

end if

end sub

sub ReadHighScore

cls

while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend

redim textarray(10) as string

datafile$ = "data/hs.DAT"
open path$ + datafile$ for input as #3
for tar = 1 to 10
input #3, textarray(tar)
neoENCdepass sadd(textarray(tar)), len(textarray(tar)), "gigante"
next tar
close #3

do

'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Update 
getmouse mx, my, , buttons

Frame2 = (Frame2 mod 12) + 1
if Frame2=10 then Frame1 = (Frame1 mod 4) + 1 

screenset 1, 0
cls
screenlock
sleep 2
screenunlock
if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset
line (273,172)-(368,253), 52, BF
put (270, 165), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[12-1]], TRANS
put (270, 250), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[16-1]], TRANS
for countsb=1 to 6
put (270, 173+(countsb*11)), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[17-1]], TRANS
next countsb
for tar = 1 to 5
GraphicText 280, 182 + tar * 10, textarray(tar),Font
next tar
for ar = 6 to 10
GraphicText 340, 182 + (ar - 5) * 10, textarray(ar), Font
next ar

GraphicText CENTRETEXT, 320, "Press enter or left mouse button to exit", Font

screencopy
SCREENSYNC

loop until multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1

'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_PlaySound(1, mysamples(9))


while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend

end sub

sub neoENCdepass (Offsett%, Lengthh&, passsword$)
'DEFSNG A-Z
   if len(passsword$) = 0 then exit sub
   nowpos% = 1
   'DEF SEG = Segment%
   for I& = 0 to Lengthh& - 1
      Bytee% = peek(Offsett% + I&)
      Bytee% = Bytee% - asc(MID$(passsword$, nowpos%, 1))
      if Bytee% < 0 then Bytee% = Bytee% + 256
      poke Offsett% + I&, Bytee%
      nowpos% = nowpos% + 1
      if nowpos% > len(passsword$) then nowpos% = 1
   next I&
   'DEF SEG
end sub

sub neoENCpass (Offset%, Length&, password$)
   if len(password$) = 0 then exit sub

   nowpos% = 1
   'DEF SEG = Segment%
   for I& = 0 to Length& - 1
      Bytee% = peek(Offset% + I&)
      Bytee% = Bytee% + asc(MID$(password$, nowpos%, 1))
      if Bytee% > 255 then Bytee% = Bytee% - 256
      poke Offset% + I&, Bytee%
      nowpos% = nowpos% + 1
      if nowpos% > len(password$) then nowpos% = 1
   next I&
   'DEF SEG
end sub

sub SaveGame (position)
    
open path$ + "Data\savegame"+LTRIM$(RTRIM$(STR$(position)))+".dat" for output as #3

print #3, Location
print #3, hours
print #3, minutes
print #3, seconds
print #3, Player.X
print #3, Player.Y
print #3, Player.SName
print #3, Player.MainArm
print #3, Player.Score
print #3, Player.LWeapon
print #3, Player.RWeapon
print #3, Player.Armour
print #3, Player.Experience 
print #3, Player.Level
print #3, Player.AttackL        
print #3, Player.defenseL  
print #3, Player.Money  
print #3, Player.Kills  
print #3, Player.FoodStatus
print #3, Player.FoodCount
print #3, Player.Poisoned
print #3, Player.PoisonCount
print #3, Player.Oxywear
print #3, Player.Oxygen
print #3, Player.Oxycount
print #3, Player.Boots
print #3, Player.Health
print #3, Player.MaxHealth
print #3, Player.MedPack
print #3, Player.Food
print #3, Player.ElecDistruptor
print #3, Player.AcidBomb
print #3, Player.Shield
print #3, Player.Antidote
print #3, Player.Steroids
print #3, Player.Bomb

for cntext = 1 to 5
IF ntext(cntext) = "" THEN ntext(cntext) = "0"
print #3, ntext(cntext)
next cntext
for cwinv = 1 to 7
print #3, weaponsinv(cwinv)
next cwinv
for citv = 1 to 7
print #3, itemsinv(citv)
next citv
for ceqinv = 1 to 7
print #3, equipmentinv(ceqinv)
next ceqinv

for ctrig=1 to 8
print #3, trigger(ctrig)
next ctrig

for loca=1 to 8
for cloc=1 to 50  
print #3, Locker(loca, cloc).X
print #3, Locker(loca, cloc).Y
print #3, Locker(loca, cloc).Mode
print #3, Locker(loca, cloc).Frame
print #3, Locker(loca, cloc).Exist
print #3, Locker(loca, cloc).Typ
next cloc
next loca

for loca=1 to 8
for ccoc=1 to 50  
print #3, Corpse(loca, ccoc).X
print #3, Corpse(loca, ccoc).Y
print #3, Corpse(loca, ccoc).Mode
print #3, Corpse(loca, ccoc).Frame
print #3, Corpse(loca, ccoc).Exist
print #3, Corpse(loca, ccoc).Typ
next ccoc
next loca

for loca=1 to 8
for cdoc=1 to 30  
print #3, Door(loca, cdoc).X
print #3, Door(loca, cdoc).Y
print #3, Door(loca, cdoc).Mode
print #3, Door(loca, cdoc).Exist
print #3, Door(loca, cdoc).Typ
next cdoc
next loca

for cloc=1 to 8
for cnpc=1 to 50
print #3, NPC(cloc, cnpc).Alive
print #3, NPC(cloc, cnpc).Typ
print #3, NPC(cloc, cnpc).X
print #3, NPC(cloc, cnpc).Y
print #3, NPC(cloc, cnpc).Health
next cnpc
next cloc

for levc=1 to 8
if levc=1 then
MapYMax = 60
MapXMax = 60
end if
if levc=2 then
MapYMax = 70
MapXMax = 70
end if
if levc=4 then
MapYMax = 80
MapXMax = 80
end if
for Y = 0 to MapYMax
for X = 0 to MapXMax
print #3, Map(levc, X, Y).FogStat  
next X                    
next Y
next levc

close #3

for cntext = 1 to 5
IF ntext(cntext) = "0" THEN ntext(cntext) = ""
next cntext

open pathf$ + "Data\level"+LTRIM$(RTRIM$(STR$(Location)))+".map" for input as #2
input #2, MapXMax
input #2, MapYMax
close #2

end sub

sub Engine.DrawSaveGame()

for cspos=1 to 4
winv$=savename(cspos)
GraphicText 5,345+(cspos)*10, STR$(cspos)+". "+winv$, Font
if NumericInput(cspos)=TRUE and keyboardfree = TRUE then goto executecpos1: 
if mx>4 and mx<104 and my>344+(cspos)*10 and my<355+(cspos)*10 then 
GraphicText 5,345+(cspos)*10, STR$(cspos)+". "+winv$, Font2  
if (buttons = 1 and mousefree = TRUE) then 
executecpos1:
keyboardfree = FALSE
WorkingMode = 0
SaveGame cspos
hc$=""
hm$=""
if hours<10 then hc$="0"
if minutes<10 then hm$="0"
ptime$ = hc$+STR$(hours)+":"+hm$+STR$(minutes)
NewNText "Game saved on position "+ STR$(cspos)
savename(cspos) = Player.SName + " - " + ptime$
savepos(cspos) = 1
open path$ + "Data\savepos.dat" for output as #3
for csaven=1 to 7
print #3, savename(csaven)
next csaven
for csavep=1 to 7
print #3, savepos(csavep)
next csavep
close #3
end if
end if
next cspos

for cspos=5 to 8
winv$=savename(cspos)
if cspos = 8 then winv$ = "Cancel"
GraphicText 145,345+(cspos-4)*10, STR$(cspos)+". "+winv$, Font
if NumericInput(cspos)=TRUE and keyboardfree = TRUE then goto executecpos2: 
if mx>144 and mx<244 and my>344+(cspos-4)*10 and my<355+(cspos-4)*10 then 
GraphicText 145,345+(cspos-4)*10, STR$(cspos)+". "+winv$, Font2  
if (buttons = 1 and mousefree = TRUE) then 
executecpos2:
keyboardfree = FALSE
WorkingMode = 0

if cspos<8 then
NewNText "Game saved on position "+ STR$(cspos)
SaveGame cspos
hc$=""
hm$=""
if hours<10 then hc$="0"
if minutes<10 then hm$="0"
ptime$ = hc$+STR$(hours)+":"+hm$+STR$(minutes)
'NewNText "Game saved on position "+ STR$(cspos)
savename(cspos) = Player.SName + " - " + ptime$
savepos(cspos) = 1
open path$ + "Data\savepos.dat" for output as #3
for csaven=1 to 7
print #3, savename(csaven)
next csaven
for csavep=1 to 7
print #3, savepos(csavep)
next csavep
close #3
end if
end if
end if
next cspos
    
end sub

sub LoadGameMenu ()


while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend
    
open path$ + "Data\savepos.dat" for input as #3
for csaven=1 to 7
input #3, savename(csaven)
next csaven
for csavep=1 to 7
input #3, savepos(csavep)
next csavep
close #3

lmenupos=1
keyboardfree = FALSE
GameLoaded = FALSE
  
do

getmouse mx, my, , buttons

Frame2 = (Frame2 mod 12) + 1
if Frame2=10 then Frame1 = (Frame1 mod 4) + 1 

screenset 1, 0
cls
screenlock
sleep 2
screenunlock
if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset
GraphicText 285, 140, "L O A D  G A M E", Font5
for csaven=1 to 7
GraphicText 290, 160+(15*csaven), savename(csaven), Font
if mx>289 and mx<390 then
if my>159+(15*csaven) and my<167+(15*csaven) then lmenupos = csaven
end if
if csaven=lmenupos then GraphicText 290, 160+(15*csaven), savename(csaven), Font2
next csaven
GraphicText 290, 250+35, "Cancel", Font
if mx>289 and mx<340 and my>249+35 and my<257+35 then lmenupos = 8
if lmenupos=8 then GraphicText 290, 250+35, "Cancel", Font2

if lmenupos<8 then GraphicText 277, 160+(15*lmenupos), "*", Font2
if lmenupos=8 then GraphicText 277, 250+35, "*", Font2

if multikey(SC_DOWN) and keyboardfree = TRUE then 
lmenupos=lmenupos+1
keyboardfree = FALSE
end if
if multikey(SC_UP) and keyboardfree = TRUE then 
lmenupos=lmenupos-1
keyboardfree = FALSE
end if
if lmenupos<1 then lmenupos=1
if lmenupos>8 then lmenupos=8

if multikey(SC_ENTER) OR buttons=1 then
if lmenupos<8 and savepos(lmenupos)=1 then
LoadGame lmenupos
GameLoaded = TRUE
exit sub
end if
if lmenupos=8 then goto exitfrommyloop:
end if

if multikey(SC_DOWN) OR multikey(SC_UP) then goto skipkk:
keyboardfree = TRUE
skipkk:

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS
    
screencopy
SCREENSYNC 

loop

exitfrommyloop:
GameLoaded = FALSE
while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend

end sub

sub LoadGame (position)
    
open path$ + "Data\savegame"+LTRIM$(RTRIM$(STR$(position)))+".dat" for input as #3

input #3, Location
input #3, hours
input #3, minutes
input #3, seconds
input #3, Player.X
input #3, Player.Y
input #3, Player.SName
input #3, Player.MainArm
input #3, Player.Score
input #3, Player.LWeapon
input #3, Player.RWeapon
input #3, Player.Armour
input #3, Player.Experience 
input #3, Player.Level
input #3, Player.AttackL        
input #3, Player.defenseL  
input #3, Player.Money  
input #3, Player.Kills  
input #3, Player.FoodStatus
input #3, Player.FoodCount
input #3, Player.Poisoned
input #3, Player.PoisonCount
input #3, Player.Oxywear
input #3, Player.Oxygen
input #3, Player.Oxycount
input #3, Player.Boots
input #3, Player.Health
input #3, Player.MaxHealth
input #3, Player.MedPack
input #3, Player.Food
input #3, Player.ElecDistruptor
input #3, Player.AcidBomb
input #3, Player.Shield
input #3, Player.Antidote
input #3, Player.Steroids
input #3, Player.Bomb

for cntext = 1 to 5
input #3, ntext(cntext)
IF ntext(cntext) = "0" THEN ntext(cntext) = ""
next cntext
for cwinv = 1 to 7
input #3, weaponsinv(cwinv)
next cwinv
for citv = 1 to 7
input #3, itemsinv(citv)
next citv
for ceqinv = 1 to 7
input #3, equipmentinv(ceqinv)
next ceqinv

for ctrig=1 to 8
input #3, trigger(ctrig)
next ctrig

for loca=1 to 8
for cloc=1 to 50  
input #3, Locker(loca, cloc).X
input #3, Locker(loca, cloc).Y
input #3, Locker(loca, cloc).Mode
input #3, Locker(loca, cloc).Frame
input #3, Locker(loca, cloc).Exist
input #3, Locker(loca, cloc).Typ
next cloc
next loca

for loca=1 to 8
for ccoc=1 to 50  
input #3, Corpse(loca, ccoc).X
input #3, Corpse(loca, ccoc).Y
input #3, Corpse(loca, ccoc).Mode
input #3, Corpse(loca, ccoc).Frame
input #3, Corpse(loca, ccoc).Exist
input #3, Corpse(loca, ccoc).Typ
next ccoc
next loca

for loca=1 to 8
for cdoc=1 to 30  
input #3, Door(loca, cdoc).X
input #3, Door(loca, cdoc).Y
input #3, Door(loca, cdoc).Mode
input #3, Door(loca, cdoc).Exist
input #3, Door(loca, cdoc).Typ
next cdoc
next loca

for cloc=1 to 8
for cnpc=1 to 50
input #3, NPC(cloc, cnpc).Alive
input #3, NPC(cloc, cnpc).Typ
input #3, NPC(cloc, cnpc).X
input #3, NPC(cloc, cnpc).Y
input #3, NPC(cloc, cnpc).Health
NPC(cloc, cnpc).YV = 2
NPC(cloc, cnpc).XV = 2
NPC(cloc, cnpc).Move=FALSE
next cnpc
next cloc

for levc=1 to 8
if levc=1 then
MapYMax = 60
MapXMax = 60
end if
if levc=2 then
MapYMax = 70
MapXMax = 70
end if
if levc=4 then
MapYMax = 80
MapXMax = 80
end if
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #3, Map(levc, X, Y).FogStat  
next X                    
next Y
next levc

close #3

numoflock = 0
numofdoor = 0
open pathf$ + "Data\level"+LTRIM$(RTRIM$(STR$(Location)))+".map" for input as #2
input #2, MapXMax
input #2, MapYMax
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #2, Map(Location, X, Y).BaseL
if Map(Location, X, Y).BaseL = 156 then 
numoflock = numoflock + 1
Map(Location, X, Y).BaseL = 67
END IF
if Map(Location, X, Y).BaseL = 296 OR Map(Location, X, Y).BaseL = 311 then
numofdoor = numofdoor + 1
Door(Location, numofdoor).X = X*TileW
Door(Location, numofdoor).Y = Y*TileH
Door(Location, numofdoor).Exist = TRUE
'Door(Location, numofdoor).Mode  = 0
IF Map(Location, X, Y).BaseL = 296 THEN Door(Location, numofdoor).Typ  = 1
IF Map(Location, X, Y).BaseL = 311 THEN Door(Location, numofdoor).Typ  = 2
end if
next X                    
next Y
close #2

Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+".PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+"1.PUT"
Tile_load_image ( Tiles2 )

if Location=1 THEN numofnpcs = 14
if Location=2 THEN numofnpcs = 22
if Location=4 THEN numofnpcs = 30
LoadNPCs 2

Player.Alive = TRUE
Player.XV = 2            
Player.YV = 2           
Player.Frame = 1
Player.Move = FALSE
Player.TileX = (Player.X + (TileW/2)) \ TileW  
Player.TileY = (Player.Y + (TileH/2)) \ TileH

Level.Xmax = MapXMax    ' Flags our level(play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU              ' Two directions so that engine will
Engine.UpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR              ' positions from left to right
Engine.UpdateCamera Level, Player  ' No warping ;)
                                   ' In other words, inital camera
                                   ' setting. 

FOR cdoor = 1 TO numofdoor
Door(Location, cdoor).TileX = Door(Location, cdoor).X / TileW
Door(Location, cdoor).TileY = Door(Location, cdoor).Y / TileH
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 2 THEN Map(Location, Door(Location, cdoor).TileX+1, Door(Location, cdoor).TileY).BaseL = 1
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 1 THEN Map(Location, Door(Location, cdoor).TileX, Door(Location, cdoor).TileY-1).BaseL = 1
NEXT cdoor                                   

countdeath=0                      
mousefree = FALSE
keyboardfree = FALSE
Mode = 1
Turn = 1
WorkingMode = 0
countbatanim = 150
skipbattle = FALSE
    
end sub

sub LoadNPCs (modenpc)
    
for cloc=1 to 8
for cnpc=1 to 40
select case NPC(cloc, cnpc).Typ
case 1
NPC(cloc, cnpc).Experience = 15
NPC(cloc, cnpc).SName = "Zombie Human"
NPC(cloc, cnpc).StartAttack=0
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 30 
NPC(cloc, cnpc).MaxHealth = 30 
NPC(cloc, cnpc).AttackL = 1.2
NPC(cloc, cnpc).defenseL = 1.2
case 2
NPC(cloc, cnpc).Experience = 20
NPC(cloc, cnpc).SName = "Zombie Human"
NPC(cloc, cnpc).StartAttack=2
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 40 
NPC(cloc, cnpc).MaxHealth = 40 
NPC(cloc, cnpc).AttackL = 2
NPC(cloc, cnpc).defenseL = 1.4
case 3
NPC(cloc, cnpc).Experience = 15
NPC(cloc, cnpc).SName = "Zombie Human"
NPC(cloc, cnpc).StartAttack=0
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 25 
NPC(cloc, cnpc).MaxHealth = 25 
NPC(cloc, cnpc).AttackL = 1
NPC(cloc, cnpc).defenseL = 1.2
case 4
NPC(cloc, cnpc).Experience = 15
NPC(cloc, cnpc).SName = "Ouyi Dweller"
NPC(cloc, cnpc).StartAttack=2
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 50 
NPC(cloc, cnpc).MaxHealth = 50 
NPC(cloc, cnpc).AttackL = 1.5
NPC(cloc, cnpc).defenseL = 1.1
case 5
NPC(cloc, cnpc).Experience = 25
NPC(cloc, cnpc).SName = "Onnyui Dweller"
NPC(cloc, cnpc).StartAttack=4
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 70 
NPC(cloc, cnpc).MaxHealth = 70 
NPC(cloc, cnpc).AttackL = 1.7
NPC(cloc, cnpc).defenseL = 2
case 8
NPC(cloc, cnpc).Experience = 30
NPC(cloc, cnpc).SName = "Security Drone"
NPC(cloc, cnpc).StartAttack=5
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 60 
NPC(cloc, cnpc).MaxHealth = 60 
NPC(cloc, cnpc).AttackL = 2.6
NPC(cloc, cnpc).defenseL = 1.3
case 9
NPC(cloc, cnpc).Experience = 35
NPC(cloc, cnpc).SName = "Security Robot I"
NPC(cloc, cnpc).StartAttack=10
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 70 
NPC(cloc, cnpc).MaxHealth = 70 
NPC(cloc, cnpc).AttackL = 2.9
NPC(cloc, cnpc).defenseL = 1.8
case 7
NPC(cloc, cnpc).Experience = 10
NPC(cloc, cnpc).SName = "Mutant Firefly"
NPC(cloc, cnpc).StartAttack=0
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 25 
NPC(cloc, cnpc).MaxHealth = 25 
NPC(cloc, cnpc).AttackL = 1.2
NPC(cloc, cnpc).defenseL = 1
case 11
NPC(cloc, cnpc).Experience = 25
NPC(cloc, cnpc).SName = "Zombie Raan"
NPC(cloc, cnpc).StartAttack=5
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 40 
NPC(cloc, cnpc).MaxHealth = 40 
NPC(cloc, cnpc).AttackL = 2.2
NPC(cloc, cnpc).defenseL = 1.8
case 13
NPC(cloc, cnpc).Experience = 25
NPC(cloc, cnpc).SName = "Poison Star"
NPC(cloc, cnpc).StartAttack=5
IF modenpc = 1 THEN NPC(cloc, cnpc).Health = 60 
NPC(cloc, cnpc).MaxHealth = 60
NPC(cloc, cnpc).AttackL = 2
NPC(cloc, cnpc).defenseL = 1.8
end select
next cnpc
next cloc

end sub

sub Credits ()


while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend
 
do 

getmouse mx, my, , buttons

Frame2 = (Frame2 mod 12) + 1
if Frame2=10 then Frame1 = (Frame1 mod 8) + 1 

screenset 1, 0
cls
screenlock
sleep 2
screenunlock
if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset

ymov = -2
if Frame1 = 1 then ymov = -2
if Frame1 = 2 then ymov = -1
if Frame1 = 3 then ymov = 0
if Frame1 = 4 then ymov = 1
if Frame1 = 5 then ymov = 2
if Frame1 = 6 then ymov = 1
if Frame1 = 7 then ymov = 0
if Frame1 = 8 then ymov = -1
put (220, 70+ymov), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[10-1]], TRANS
put (320, 70+ymov), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[11-1]], TRANS
 
 
'274,170 ch 
line (373,170)-(374,169),77

GraphicText 170, 170, "Programming and design by Dean Janjic", Font
GraphicText 170, 190, "Original scrolling engine by R.E.Lope", Font
GraphicText 170, 210, "Mini Space Rogue was written and compiled in", Font
GraphicText 411, 210, "FreeBASIC", Font5
GraphicText 170, 270, "My email: lachie13@yahoo.com", Font4
GraphicText 170, 290, "My website: http://kentauri.digitalblackie.com", Font4
GraphicText 170, 310, "Official FreeBASIC website: http://www.freebasic.net", Font5

GraphicText CENTRETEXT, 420, "Press enter or left mouse button to exit", Font
'GraphicText 4,425, "Mouse:"+STR$(mx)+","+STR$(my)+","+STR$(buttons), Font

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS
    
screencopy
SCREENSYNC 

loop until multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1

exitfrommyloop:
GameLoaded = FALSE
while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend
    
end sub

sub Instructions ()


ipage=1

while multikey(SC_ENTER) OR multikey(SC_SPACE) OR buttons = 1
getmouse mx, my, , buttons
wend
 
do 

getmouse mx, my, , buttons

Frame2 = (Frame2 mod 12) + 1
if Frame2=10 then Frame1 = (Frame1 mod 8) + 1 

screenset 1, 0
cls
screenlock
sleep 2
screenunlock

'SCREENLOCK
'BLOAD pathf$ + "INST1.BMP", 0
'GET (0,0)-(639,479), instimage(0)
'SCREENUNLOCK

if multikey(SC_RIGHT) and keyboardfree = TRUE then
addpage:
ipage = ipage + 1
if ipage = 3 then
screenlock
bload pathf$ + "Graphics\INST1.BMP", 0
get (0,0)-(639,479), instimage(0)
screenunlock
end if
if ipage = 5 then
screenlock
bload pathf$ + "Graphics\INST3.BMP", 0
get (0,0)-(639,479), instimage(0)
screenunlock
end if
if ipage = 6 then
screenlock
bload pathf$ + "Graphics\INST4.BMP", 0
get (0,0)-(160,160), instimage(0)
cls
screenunlock
end if
if ipage = 9 then
screenlock
bload pathf$ + "Graphics\INST2.BMP", 0
get (0,0)-(639,479), instimage(0)
CLS
screenunlock
end if
keyboardfree = FALSE
IF ipage>10 THEN ipage = 10
end if
if multikey(SC_LEFT) and keyboardfree = TRUE then
reducepage:
ipage = ipage - 1
if ipage = 3 then
screenlock
bload pathf$ + "Graphics\INST1.BMP", 0
get (0,0)-(639,479), instimage(0)
screenunlock
end if
if ipage = 5 then
screenlock
bload pathf$ + "Graphics\INST3.BMP", 0
get (0,0)-(639,479), instimage(0)
screenunlock
end if
if ipage = 6 then
screenlock
bload pathf$ + "Graphics\INST4.BMP", 0
get (0,0)-(160,160), instimage(0)
CLS
screenunlock
end if
if ipage = 9 then
screenlock
bload pathf$ + "Graphics\INST2.BMP", 0
get (0,0)-(639,479), instimage(0)
CLS
screenunlock
end if
if ipage<1 then ipage = 1
keyboardfree = FALSE
end if

if ipage = 1 then
GraphicText 240, 150, "M I N I  S P A C E  R O G U E", Font5
GraphicText 285, 160, "(instructions)", Font2
GraphicText 155, 190, "To navigate through these instructions use left and right arrow", Font
GraphicText 155, 205, "key or the mouse(click on the arrows in the top-right corner", Font
GraphicText 155, 220, "of the screen). To exit press enter or right mouse button.", Font
end if

if ipage = 2 then
GraphicText 160, 70, "Mini Space Rogue is a Roguelike game(go figure) of a smaller scale.", Font
GraphicText 160, 85, "If you are not familiar with Roguelike games this is a turn-based,", Font
GraphicText 160, 100, "'dungeon' crawling game. It's about exploring dungeons(in this game", Font
GraphicText 160, 115, "a space ship), finding items, fighting monsters and leveling up.", Font
GraphicText 160, 130, "Roguelike games are usually about finding some object or", Font
GraphicText 160, 145, "accomplishing one task and the adventure elements are minimal.", Font
GraphicText 160, 160, "Minimal or no dialogues, no plot twists, etc.", Font
GraphicText 160, 175, "All this applies on Mini Space Rogue too.", Font

GraphicText 160, 195, "In Mini Space Rogue you play a role of a space scavenger who", Font
GraphicText 160, 210, "got stranded on abandoned bio-research space ship due the", Font
GraphicText 160, 225, "loss of antimatter on his own ship. Your goal is to", Font
GraphicText 160, 240, "to reach the engine core and acquire some antimatter", Font
GraphicText 160, 255, "in order to power-up you own ship. You must explore", Font
GraphicText 160, 270, "the ship, gather useful items and survive the attacks", Font
GraphicText 160, 285, "of monsters and security robots looming through the ship.", Font

GraphicText 160, 305, "Mini Space Rogue is both mouse and keyboard controlled game.", Font
GraphicText 160, 320, "Any action in this game you can execute either using the", Font
GraphicText 160, 335, "keyboard or the mouse.", Font

GraphicText 160, 355, "Since the game's interface can be a bit confusing in the", Font
GraphicText 160, 370, "beginning the next page will explain what each part of the", Font
GraphicText 160, 385, "interface is.", Font
end if

if ipage = 3 then
put (0,0), instimage(0)
GraphicText 220, 371, "LOCAL AREA OVERVIEW", Font5
GraphicText 87, 170, "ICON REPRESENTING THE PLAYER", Font5
GraphicText 101, 250, "ICON REPRESENTING AN ENEMY", Font5
GraphicText 220, 371, "LOCAL AREA OVERVIEW", Font5
GraphicText 200, 406, "ACTION CONTROL ICONS", Font
GraphicText 505, 364, "MOVEMENT CONTROL ICONS", Font
GraphicText 521, 271, "ILLUSTRATED PLAYER", Font
GraphicText 509, 220, "YOUR CURRENT", Font
GraphicText 509, 230, "LOCATION ON THE SHIP", Font
GraphicText 351, 191, "LEVEL MAP(THE PART YOU REVEALED)", Font
end if

if ipage = 4 then
GraphicText 160, 70-40, "Moving in Mini Space Rogue is very simple. You can move", Font
GraphicText 160, 85-40, "using either the arrow keys or the mouse(by clicking on the", Font
GraphicText 160, 100-40, "movement control icons). When a movement control icon is", Font
GraphicText 160, 115-40, "darkened then you can't move in that direction(a colliding", Font
GraphicText 160, 130-40, "object like wall might blocking your way). As you move", Font
GraphicText 160, 145-40, "you reveal parts of the current level if they aren't", Font
GraphicText 160, 160-40, "revealed already. The scope of revelation is several", Font
GraphicText 160, 175-40, "tiles around you(the lightened area).", Font

GraphicText 160, 195-40, "Each time you move, examine a location or operate with", Font
GraphicText 160, 210-40, "something turn is passed to non-player characters. You", Font
GraphicText 160, 225-40, "will not notice the turn switch when there are no", Font
GraphicText 160, 240-40, "monsters around you but when they are you won't be able to", Font
GraphicText 160, 255-40, "move until the monsters around you finish their movement.", Font

GraphicText 160, 275-40, "To execute any action but movement you need to click on an", Font
GraphicText 160, 290-40, "action control icon or press a number on the keyboard that is", Font
GraphicText 160, 305-40, "written in the top-left part of the control icon you want to use.", Font
GraphicText 160, 325-40, "This is what each icon does:", Font

GraphicText 160, 325-25, "1 - Displays player's status screen", Font2
GraphicText 160, 340-25, "2 - Calls equip left hand sub-menu", Font2
GraphicText 160, 355-25, "3 - Calls equip right hand sub-menu", Font2
GraphicText 160, 370-25, "4 - Calls equip body sub-menu", Font2
GraphicText 160, 385-25, "5 - Calls use items sub-menu", Font2
GraphicText 160, 400-25, "6 - Examines player's current location", Font2
GraphicText 160, 415-25, "7 - Operates(open, use) with something near the player", Font2
GraphicText 160, 430-25, "8 - Skips a turn(do nothing)", Font2
GraphicText 160, 445-25, "9 - Calls save game sub-menu", Font2
GraphicText 160, 460-25, "0 - Exit to main menu(it asks for confirmation) ", Font2
end if

if ipage = 5 then
put (0,0), instimage(0)
GraphicText 160, 40, "When you call for a display of the player's status(icon 1) you", Font
GraphicText 160, 55, "return to normal screen mode by calling that action again", Font
GraphicText 160, 70, "(click on the icon or press number 1) or just by clicking", Font
GraphicText 160, 85, "on any other icon.", Font

GraphicText 160, 105, "When ever you call for a sub-menu you activate it and to pick a", Font
GraphicText 160, 120, "choice in the sub-menu you need to click on it or press a number", Font
GraphicText 160, 135, "infront of that choice. When a sub-menu is activated a green", Font
GraphicText 160, 150, "border around the activated icon is placed which points out", Font
GraphicText 160, 165, "that the remaining action control icons are not active in the", Font
GraphicText 160, 180, "sense of keyboard control.", Font

GraphicText 160, 200, "Using the mouse is highly recommended and makes controling", Font
GraphicText 160, 215, "the game much easier. I recommend you use the keyboard", Font
GraphicText 160, 230, "only for movement.", Font
end if

if ipage = 6 then
put (400,228), instimage(0)
GraphicText 60, 40-20, "Hand and body equipping menus work on the swapping", Font
GraphicText 60, 55-20, "concept. When you click on a weapon in the hand", Font
GraphicText 60, 70-20, "equipping sub-menu the weapon in the hand you picked is", Font
GraphicText 60, 85-20, "changed with the one from the inventory. With hand", Font
GraphicText 60, 100-20, "sub-menus this can be nothing(fist) while when you are", Font
GraphicText 60, 115-20, "equipping the body you can only swap the current", Font
GraphicText 60, 130-20, "clothes with the existing ones in the inventory.", Font
GraphicText 60, 145-20, "Items sub-menu allows you to use various items you", Font
GraphicText 60, 160-20, "find in the ship. Some items are only to be used", Font
GraphicText 60, 175-20, "during battle and you can't used them in non-battle", Font
GraphicText 60, 190-20, "mode. I'll explain later what each item does.", Font

GraphicText 60, 210-20, "Action control icon that examines the current location", Font
GraphicText 60, 225-20, "is to be used to examine something you see on the floor", Font
GraphicText 60, 240-20, "(like a corpse). It examines only the location you are", Font
GraphicText 60, 255-20, "standing in! You will know when a location needs to be", Font
GraphicText 60, 270-20, "examined. There are no secret, hidden, pixel sized", Font
GraphicText 60, 285-20, "objects on the floor so don't click on that icon like", Font
GraphicText 60, 300-20, "crazy. There is no need for that.", Font

GraphicText 60, 320-20, "Action control icon that operates with the environment", Font
GraphicText 60, 335-20, "is to be used to open various lockers in the game(stand", Font
GraphicText 60, 350-20, "one tile under them), to use the stairs(stand on it),", Font
GraphicText 60, 365-20, "elevator, open doors and some other things. Like with the", Font
GraphicText 60, 380-20, "previous action control icon, you'll know when to use it.", Font

GraphicText 60, 400-20, "Skip turn action is only a cosmetic thing and to be", Font
GraphicText 60, 415-20, "used when you want for a monster that is approaching", Font
GraphicText 60, 430-20, "you to move closer or something like that. I don't know.", Font

GraphicText 60, 450-20, "Save game option is simple and works like weapons", Font
GraphicText 60, 465-20, "equipping sub-menu.", Font

GraphicText 460, 310, "- Stairs", Font4
GraphicText 460, 344, "- Elevator Pad", Font4
GraphicText 440, 374, "- A Locker", Font2

GraphicText 400, 190-40, "To open/close doors in Mini Space Rogue", Font3
GraphicText 400, 205-40, "you need to stand on one of the positions", Font3
GraphicText 400, 220-40, "where the red arrows are pointing.", Font3
GraphicText 400, 235-40, "Doors are operable from both sides.", Font3

end if

IF ipage = 7 THEN
GraphicText 160, 40-20, "When you attack an enemy or an enemy attacks you", Font
GraphicText 160, 55-20, "battle mode is initiated. The battle system is", Font
GraphicText 160, 70-20, "turn-based. When it's your turn you can attack", Font
GraphicText 160, 85-20, "the enemy with left or right hand or use an item.", Font
GraphicText 160, 100-20, "Every time you attack or use an item turn is", Font
GraphicText 160, 115-20, "passed to the enemy. When you attack the enemy", Font
GraphicText 160, 130-20, "according to the hand(if it's your main hand or", Font
GraphicText 160, 145-20, "not), weapon in it, you attack strength and enemy's", Font
GraphicText 160, 160-20, "defense strength damage is calculated. Minimum of", Font
GraphicText 160, 175-20, "damage is randomized. If you are attacking with your", Font
GraphicText 160, 190-20, "secondary hand(not main) your total attack strength", Font
GraphicText 160, 205-20, "will be reduced by 40%(hand weapon) or 20%(fire weapon).", Font
GraphicText 160, 220-20, "If you are hungry your total attack strength will", Font
GraphicText 160, 235-20, "be reduced by 20% while if you are starving by 40%.", Font

GraphicText 160, 255-20, "Every time you attack with one hand that hand's", Font
GraphicText 160, 270-20, "stamina is reduced(power if we are talking about fire", Font
GraphicText 160, 285-20, "weapon). When your hand stamina depletes your", Font
GraphicText 160, 300-20, "attack strength will be reduced by 40%. If you are", Font
GraphicText 160, 315-20, "using a fire weapon its power will deplete with each", Font
GraphicText 160, 330-20, "attack. If weapon's power completely depletes your", Font
GraphicText 160, 345-20, "attack strength will be reduced by 50%.", Font

GraphicText 160, 365-20, "Every time you use one hand other hand's stamina or", Font
GraphicText 160, 380-20, "weapon power will increase. Hand stamina is reduced", Font
GraphicText 160, 395-20, "faster but it increases(recharges) faster than the", Font
GraphicText 160, 410-20, "fire weapon power.", Font

END IF

IF ipage = 8 THEN
GraphicText 160, 55-20, "Since the loss of strength is less for a fire weapon", Font
GraphicText 160, 70-20, "when not used in the main hand it's recommended", Font
GraphicText 160, 85-20, "that you keep hand weapons is your main hand and", Font
GraphicText 160, 100-20, "fire weapons in your secondary hand.", Font

GraphicText 160, 120-20, "The fourth option available during battle is escape.", Font
GraphicText 160, 135-20, "You chances to escape increase as you level up. If", Font
GraphicText 160, 150-20, "you fail to escape turn is passed to the enemy.", Font

GraphicText 160, 170-20, "With each battle won you gain a certain amount of ", Font
GraphicText 160, 185-20, "experience points and when you accumulate enough of ", Font
GraphicText 160, 200-20, "them(check the player's status to see how much is", Font
GraphicText 160, 215-20, "needed for the next level) your attack and/or defense", Font
GraphicText 160, 230-20, "strength increases as well as maximum hit points value.", Font
GraphicText 160, 245-20, "You also gain some health points. That's called leveling" , Font
GraphicText 160, 260-20, "up, but I'm sure you know that from other RPG or", Font
GraphicText 160, 275-20, "Roguelike games." ,Font

GraphicText 160, 290-20, "Not all enemies react the same on different weapons. It's" , Font
GraphicText 160, 305-20, "up to you to discover these differences. Just think about", Font
GraphicText 160, 320-20, "enemies in three categories. Organic, organic humanoid" ,Font
GraphicText 160, 335-20, "and mechanical." ,Font

GraphicText 160, 355-20, "The next page will explain what each part of the battle" ,Font
GraphicText 160, 370-20, "screen is." ,Font

END IF

IF ipage = 9 THEN
put (0,0), instimage(0)
GraphicText 50, 282, "LEFT HAND STAMINA", Font4
GraphicText 220, 282, "RIGHT HAND STAMINA", Font4
GraphicText 34, 203, "PLAYER'S HEALTH", Font4
GraphicText 41, 137, "ENEMY'S HEALTH", Font4
GraphicText 180, 430, "BATTLE CONTROL ICONS", Font4
END IF

IF ipage = 10 THEN
GraphicText 160, 55-20, "Now something about items. As you move you slowly", Font
GraphicText 160, 70-20, "become more hungry and if you don't eat now and then you", Font
GraphicText 160, 85-20, "might start starving. You can't die of hunger but", Font
GraphicText 160, 100-20, "you will be weaker during battle if you are not fed.", Font
GraphicText 160, 115-20, "Keep you health on the level by eating food every time", Font
GraphicText 160, 130-20, "you become hungry. It also gives you extra 10 health points.", Font
GraphicText 160, 145-20, "Slightly more on higher experience levels. Med-pack heals", Font
GraphicText 160, 160-20, "your wounds and gives you extra 30 health points. Somewhat", Font
GraphicText 160, 175-20, "more on higher experience levels.", Font

GraphicText 160, 195-20, "Grenades, shockers and acid bombs are attack items to be", Font
GraphicText 160, 210-20, "used during battle. Steroids doubles your attack strength.", Font
GraphicText 160, 225-20, "Antidote heals you if you are poisoned. When you are", Font
GraphicText 160, 240-20, "poisoned you are much weaker during battle and slowly", Font
GraphicText 160, 255-20, "lose health points outside battle. Shield doubles your ", Font
GraphicText 160, 270-20, "your defense strength(during battle).", Font

GraphicText 160, 290-20, "To win this game it's imperative that you gain experience", Font
GraphicText 160, 305-20, "points and level up, find items, new weapons and armours.", Font

GraphicText 160, 325-20, "I probably revealed more than enough. Explore the game", Font4
GraphicText 160, 340-20, "youself and try to enjoy it.", Font4

END IF


if ipage>1 then put (590, 3), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[18-1]], TRANS
if ipage<10 then put (615, 3), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[19-1]], TRANS

if mx>589 and mx<610 and my>2 and my<20 then
if ipage>1 then put (590, 3), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[20-1]], TRANS
if mousefree = TRUE and buttons=1 then
mousefree = FALSE
goto reducepage:
end if
end if
if mx>614 and mx<636 and my>2 and my<20 then
if ipage<10 then put (615, 3), @Sprites6.s_image.p_data[Sprites6.s_image.p_dataindex[21-1]], TRANS
if mousefree = TRUE and buttons=1 then
mousefree = FALSE
goto addpage:
end if
end if

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS

if multikey(SC_RIGHT) OR multikey(SC_LEFT) OR multikey(SC_ENTER) then goto skipkeyrestore:
keyboardfree = TRUE
skipkeyrestore:

if buttons=1 then goto skipmres:
mousefree = TRUE
skipmres:

screencopy
SCREENSYNC 

loop until multikey(SC_ENTER) OR buttons = 2

exitfrommyloop:
GameLoaded = FALSE
while multikey(SC_ENTER) OR buttons = 2
getmouse mx, my, , buttons
wend
    
end sub

SUB Options ()
    
YPoss=1
    
DO
    
getmouse mx, my, , buttons

screenset 1, 0
cls
    
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Update 

Frame2 = (Frame2 MOD 12) + 1
IF Frame2=10 THEN Frame1 = (Frame1 MOD 4) + 1 

IF MULTIKEY(SC_DOWN) AND keyboardfree = TRUE THEN 
keyboardfree = FALSE
YPoss=YPoss+1
IF YPoss>5 THEN YPoss=5
END IF
IF MULTIKEY(SC_UP) AND keyboardfree = TRUE THEN 
keyboardfree = FALSE
YPoss=YPoss-1
IF YPoss<1 THEN YPoss=1
END IF

mac = 0
for cop=1 to 5
if mx>273 and mx<373 then
if my>235+(cop*15)-40 and 235+(cop*15)-30 then 
YPoss = cop
mac = cop
'IF buttons = 1 AND mousefree = TRUE THEN 
end if
end if
next cop


IF (MULTIKEY(SC_ENTER) AND keyboardfree = TRUE) OR (buttons =1 AND mousefree=TRUE AND mac>0) THEN
keyboardfree = FALSE
mousefree = FALSE
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_PlaySound(1, mysamples(9))

SELECT CASE YPoss
CASE 1
IF GameSpeed = 1 THEN 
GameSpeed = 2
GOTO skipn:
END IF
IF GameSpeed = 2 THEN 
GameSpeed = 1
GOTO skipn:
END IF
CASE 2
IF Pal$ = "NORMAL.PAL" THEN
Pal$ = "BRIGHT.PAL"
init_palette_data  pathf$ + Pal$
GOTO skipn:
END IF
IF Pal$ = "BRIGHT.PAL" THEN
Pal$ = "NORMAL.PAL"
init_palette_data  pathf$ + Pal$
GOTO skipn:
END IF    
CASE 3
SoundVol = SoundVol + 1
IF SoundVol > 4 THEN SoundVol = 0
IF SoundVol = 0 THEN SetVol = 0
IF SoundVol = 1 THEN SetVol = 63
IF SoundVol = 2 THEN SetVol = 126
IF SoundVol = 3 THEN SetVol = 190
IF SoundVol = 4 THEN SetVol = 255
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_SetSFXMasterVolume(SetVol)
CASE 4
IF Music = TRUE THEN
Music = FALSE
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Stream_Close(mysamples(10))
goto skipn:
END IF
IF Music = FALSE THEN
Music = TRUE
'IF PlaySound = TRUE AND FMODStatus = TRUE THEN 
'mysamples(10) = FSOUND_Stream_Open("Sound/poxiemain.mp3", FSOUND_LOOP, 0, 0)
'FSOUND_Stream_SetMode(mysamples(10), FSOUND_LOOP_NORMAL)
'FSOUND_Stream_Play(6, mysamples(10))
'END IF
END IF
CASE 5
keyboardfree = FALSE
mousefree = FALSE
EXIT SUB
END SELECT

END IF

IF MULTIKEY(SC_ENTER) OR MULTIKEY(SC_DOWN) OR MULTIKEY(SC_UP) OR buttons = 1 THEN GOTO skipn:
keyboardfree = TRUE
mousefree = TRUE
skipn:

spe$="Slow"
ppal$="Bright"
IF GameSpeed = 1 THEN spe$="Normal"
IF Pal$ = "NORMAL.PAL" THEN ppal$ = "Normal"
svol$ = STR$(SoundVol * 25)+"%"
mvol$ = "No"
IF Music = TRUE THEN mvol$ = "Yes"

if xmov=639 then xmov=0
xmov = xmov + 1
put (0-xmov,0), mbimage(0), pset
put (640-xmov,0), mbimage(0), pset

GraphicText 247+13, 235+(YPoss*15)-40, "*", Font2
GraphicText 260+10,210-40, "G A M E  O P T I O N S", Font5
GraphicText 260+13,250-40, "Game speed: "+spe$, Font
GraphicText 260+13,265-40, "Palette: "+ppal$, Font
GraphicText 260+13,280-40, "Volume: "+ svol$, Font
GraphicText 260+13,295-40, "Music: "+ mvol$, Font
GraphicText 260+13,310-40, "Back To Main Menu", Font
IF YPoss = 1 THEN GraphicText 260+13,250-40, "Game speed: "+spe$, Font2
IF YPoss = 2 THEN GraphicText 260+13,265-40, "Palette: "+ppal$, Font2
IF YPoss = 3 THEN GraphicText 260+13,280-40, "Volume: "+ svol$, Font2
IF YPoss = 4 THEN GraphicText 260+13,295-40, "Music: "+ mvol$, Font2
IF YPoss = 5 THEN GraphicText 260+13,310-40, "Back To Main Menu", Font2

put (mx, my), @Sprites.s_image.p_data[Sprites.s_image.p_dataindex[22-1]], TRANS


SCREENCOPY
SCREENSYNC
SLEEP 2

LOOP
    
END SUB

SUB ArtificialLights (Xart, Yart)
    
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN 
AddLight 3, Xart + Level.TileX, Yart + Level.TileY
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX+2, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+2).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-2).FogStat = 1
END IF
IF Map(Location, Xart + Level.TileX-2, Yart + Level.TileY).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-1).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+1).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-3, Yart + Level.TileY).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-2, Yart + Level.TileY-1).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-2, Yart + Level.TileY+1).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+2).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-2).BaseL = 261 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY

IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN 
AddLight 3, Xart + Level.TileX, Yart + Level.TileY
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-2, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+2).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-2).FogStat = 1
END IF
IF Map(Location, Xart + Level.TileX+2, Yart + Level.TileY).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-1).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+1).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+3, Yart + Level.TileY).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+2, Yart + Level.TileY-1).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+2, Yart + Level.TileY+1).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+2).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-2).BaseL = 266 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY

IF Map(Location, Xart + Level.TileX, Yart + Level.TileY-1).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN 
AddLight 3, Xart + Level.TileX, Yart + Level.TileY
Map(Location, Xart + Level.TileX, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY+2).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX+2, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-2, Yart + Level.TileY).FogStat = 1
END IF
IF Map(Location, Xart + Level.TileX, Yart + Level.TileY-2).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-1).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-1).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX, Yart + Level.TileY-3).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-2).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-2).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+2, Yart + Level.TileY-1).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-2, Yart + Level.TileY-1).BaseL = 251 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY

IF Map(Location, Xart + Level.TileX, Yart + Level.TileY+1).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN 
AddLight 3, Xart + Level.TileX, Yart + Level.TileY
Map(Location, Xart + Level.TileX, Yart + Level.TileY+1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX, Yart + Level.TileY-2).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX+1, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX-1, Yart + Level.TileY-1).FogStat = 1
Map(Location, Xart + Level.TileX+2, Yart + Level.TileY).FogStat = 1
Map(Location, Xart + Level.TileX-2, Yart + Level.TileY).FogStat = 1
END IF
IF Map(Location, Xart + Level.TileX, Yart + Level.TileY+2).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+1).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+1).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 2, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX, Yart + Level.TileY+3).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-1, Yart + Level.TileY+2).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+1, Yart + Level.TileY+2).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX+2, Yart + Level.TileY+1).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY
IF Map(Location, Xart + Level.TileX-2, Yart + Level.TileY+1).BaseL = 256 AND Map(Location, Xart + Level.TileX, Yart + Level.TileY).FogStat = 1 THEN AddLight 1, Xart + Level.TileX, Yart + Level.TileY

END SUB

SUB SkipTurn ()
Player.FoodCount = Player.FoodCount + 1
WorkingMode = 0
keyboardfree = FALSE
Player.Move = FALSE
currentNPC=1
NPC(Location, currentNPC).Direction = 0
NPC(Location, currentNPC).MovingTime=10
Turn = 2
if Player.Poisoned = TRUE then
Player.PoisonCount = Player.PoisonCount + 1
if Player.PoisonCount = 20 then Player.Health=Player.Health-1
if Player.PoisonCount>19 then Player.PoisonCount=0
END IF
IF Player.Oxywear = TRUE THEN
Player.Oxycount = Player.Oxycount + 1    
if Player.Oxycount = 15 then 
Player.Oxygen = Player.Oxygen - 1
Player.Oxycount = 0
END IF
if Player.Oxygen <=0 then
Player.Oxygen = 0
Player.Oxywear = FALSE
for ceqinv=1 to 7
IF equipmentinv(ceqinv)=7 THEN
equipmentinv(ceqinv)= 6
goto endeq4:
END IF
NEXT ceqinv
endeq4:
NewNText$ "You remove the mask because the oxygen has depleted."
END IF
END IF

END SUB

SUB ChangeLocation (ldirection)

IF Location = 4 THEN EXIT SUB
IF Location = 2 AND ldirection=1 THEN EXIT SUB

IF ldirection = 1 THEN 
IF Location = 1 AND Player.TileX=19 AND Player.TileY=2 THEN
Player.TileY=1
Player.Y=Player.Y-20
END IF
IF Player.TileX=1 AND Player.TileY=18 THEN
Player.TileY=20                         
Player.Y=Player.Y+40
END IF
Location = Location + 1
END IF

IF ldirection = 2 THEN 
IF Location = 2 AND Player.TileX=19 AND Player.TileY=1 THEN
Player.TileY=2
Player.Y=Player.Y+20
END IF
IF Player.TileX=1 AND Player.TileY=20 THEN
Player.TileY=18
Player.Y=Player.Y-40
END IF
Location = Location - 1
END IF

numoflock = 0
numofdoor = 0
open pathf$ + "Data\level"+LTRIM$(RTRIM$(STR$(Location)))+".map" for input as #2
input #2, MapXMax
input #2, MapYMax
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #2, Map(Location, X, Y).BaseL
if Map(Location, X, Y).BaseL = 156 then 
numoflock = numoflock + 1
Map(Location, X, Y).BaseL = 67
END IF
if Map(Location, X, Y).BaseL = 296 OR Map(Location, X, Y).BaseL = 311 then
numofdoor = numofdoor + 1
Door(Location, numofdoor).X = X*TileW
Door(Location, numofdoor).Y = Y*TileH
Door(Location, numofdoor).Exist = TRUE
'Door(Location, numofdoor).Mode  = 0
IF Map(Location, X, Y).BaseL = 296 THEN Door(Location, numofdoor).Typ  = 1
IF Map(Location, X, Y).BaseL = 311 THEN Door(Location, numofdoor).Typ  = 2
end if
next X                    
next Y
close #2

Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+".PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+"1.PUT"
Tile_load_image ( Tiles2 )

if Location=1 THEN numofnpcs = 14
if Location=2 THEN numofnpcs = 22
if Location=4 THEN numofnpcs = 30

Level.Xmax = MapXMax    ' Flags our level(play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU              ' Two directions so that engine will
Engine.UpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR              ' positions from left to right
Engine.UpdateCamera Level, Player  ' No warping ;)
                                   ' In other words, inital camera
                                   ' setting.

FOR cdoor = 1 TO numofdoor
Door(Location, cdoor).TileX = Door(Location, cdoor).X / TileW
Door(Location, cdoor).TileY = Door(Location, cdoor).Y / TileH
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 2 THEN Map(Location, Door(Location, cdoor).TileX+1, Door(Location, cdoor).TileY).BaseL = 1
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 1 THEN Map(Location, Door(Location, cdoor).TileX, Door(Location, cdoor).TileY-1).BaseL = 1
NEXT cdoor

END SUB

sub Elevator()

for celev=1 to 4
if celev = 1 then elev$ = "Level I"
if celev = 2 then elev$ = "Level II"
if celev = 3 then elev$ = "Level III"
if celev = 4 then elev$ = "Level IV"
GraphicText 5,345+celev*10, STR$(celev)+". "+elev$, Font
if NumericInput(celev)=TRUE and keyboardfree = TRUE AND celev<>Location then goto executecelev1: 
if mx>4 and mx<104 and my>344+(celev)*10 and my<355+(celev)*10 then 
GraphicText 5,345+(celev)*10, STR$(celev)+". "+elev$, Font2
if (buttons = 1 and mousefree = TRUE) AND celev<>Location then 
executecelev1:
keyboardfree = FALSE
ElevatorChange celev
WorkingMode = 0
end if
end if

IF Location = celev THEN GraphicText 5,345+(celev)*10, STR$(celev)+". "+elev$, Font3

next celev

for celev=5 to 7
if celev = 5 then elev$ = "Level V"
if celev = 6 then elev$ = "Bridge"
if celev = 7 then elev$ = "Cancel"
if NumericInput(celev)=TRUE and keyboardfree = TRUE and celev<7 AND celev<>Location then goto executecelev2: 
if NumericInput(celev)=TRUE and keyboardfree = TRUE and celev=7 then 
WorkingMode = 0
keyboardfree = FALSE
END IF
GraphicText 125,345+(celev-4)*10, STR$(celev)+". "+elev$, Font
if mx>124 and mx<224 and my>344+(celev-4)*10 and my<355+(celev-4)*10 then 
GraphicText 125,345+(celev-4)*10, STR$(celev)+". "+elev$, Font2 
if buttons = 1 and mousefree = TRUE and celev<7 AND celev<>Location then 
executecelev2:
keyboardfree = FALSE
ElevatorChange celev
WorkingMode = 0
end if
IF celev=7 and buttons = 1 and mousefree = TRUE THEN WorkingMode = 0
end if

IF Location = celev THEN GraphicText 5,345+(celev)*10, STR$(celev)+". "+elev$, Font3

next celev

end sub

SUB ElevatorChange (elevel)

' TEMP! DEMO RESTRICTIONS!!
IF elevel>2 AND elevel<>4 THEN EXIT SUB

IF Location<>elevel THEN
    
Location = elevel
    
numoflock = 0
numofdoor = 0
open pathf$ + "Data\level"+LTRIM$(RTRIM$(STR$(Location)))+".map" for input as #2
input #2, MapXMax
input #2, MapYMax
for Y = 0 to MapYMax
for X = 0 to MapXMax
input #2, Map(Location, X, Y).BaseL
if Map(Location, X, Y).BaseL = 156 then 
numoflock = numoflock + 1
Map(Location, X, Y).BaseL = 67
END IF
if Map(Location, X, Y).BaseL = 296 OR Map(Location, X, Y).BaseL = 311 then
numofdoor = numofdoor + 1
Door(Location, numofdoor).X = X*TileW
Door(Location, numofdoor).Y = Y*TileH
Door(Location, numofdoor).Exist = TRUE
'Door(Location, numofdoor).Mode  = 0
IF Map(Location, X, Y).BaseL = 296 THEN Door(Location, numofdoor).Typ  = 1
IF Map(Location, X, Y).BaseL = 311 THEN Door(Location, numofdoor).Typ  = 2
end if
next X                    
next Y
close #2

Tiles.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+".PUT"
Tile_load_image ( Tiles )
Tiles2.s_image.m_filename = pathf$ + "Graphics\SROGT"+STR$(Location)+"1.PUT"
Tile_load_image ( Tiles2 )

if Location=1 THEN numofnpcs = 14
if Location=2 THEN numofnpcs = 22
if Location=4 THEN numofnpcs = 30

Level.Xmax = MapXMax    ' Flags our level(play map) size from the
Level.Ymax = MapYMax    ' map size we have loaded.

' Not sure how much this matters but heck.     
Level.CamX = 0
Level.CamY = 0
Level.TileX = 0
Level.TileY = 0
Level.Xpos = 0
Level.Ypos = 0

Player.Direction = DU              ' Two directions so that engine will
Engine.UpdateCamera Level, Player  ' know where level TileX and TileY
Player.Direction = DR              ' positions from left to right
Engine.UpdateCamera Level, Player  ' No warping ;)
                                   ' In other words, inital camera
                                   ' setting.
 


FOR cdoor = 1 TO numofdoor
Door(Location, cdoor).TileX = Door(Location, cdoor).X / TileW
Door(Location, cdoor).TileY = Door(Location, cdoor).Y / TileH
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 2 THEN Map(Location, Door(Location, cdoor).TileX+1, Door(Location, cdoor).TileY).BaseL = 1
IF Door(Location, cdoor).Mode = 1 AND Door(Location, cdoor).Typ = 1 THEN Map(Location, Door(Location, cdoor).TileX, Door(Location, cdoor).TileY-1).BaseL = 1
NEXT cdoor

END IF

END SUB

SUB CheckForDoors ()
    
FOR cdoor=1 TO numofdoor

IF Door(Location, cdoor).Exist = TRUE THEN 
    
Door(Location, cdoor).TileX = Door(Location, cdoor).X / TileW
Door(Location, cdoor).TileY = Door(Location, cdoor).Y / TileH

IF Player.TileY=Door(Location, cdoor).TileY AND Door(Location, cdoor).Typ = 1 THEN
IF Player.TileX=Door(Location, cdoor).TileX-1 OR Player.TileX=Door(Location, cdoor).TileX+1 THEN
IF Door(Location, cdoor).Mode = 0 THEN
ltext$ = "You push the button and the door opens."
Map(Location, Door(Location, cdoor).TileX, Door(Location, cdoor).TileY-1).BaseL = 1
Door(Location, cdoor).Mode = 1
goto nextdoor:
END IF
IF Door(Location, cdoor).Mode = 1 THEN
for countNPC = 1 to numofnpcs  
if NPC(Location, countNPC).Alive = TRUE AND NPC(Location, countNPC).TileX=Door(Location, cdoor).TileX AND NPC(Location, countNPC).TileY=Door(Location, cdoor).TileY-1 THEN
ltext$ = "You push the button but the door don't react."
goto nextdoor:
end if
next countNPC    
    
ltext$ = "You push the button and the door closes."
Map(Location, Door(Location, cdoor).TileX, Door(Location, cdoor).TileY-1).BaseL = 306
Door(Location, cdoor).Mode = 0
END IF
END IF
END IF

IF Player.TileX=Door(Location, cdoor).TileX AND Door(Location, cdoor).Typ = 2 THEN
IF Player.TileY=Door(Location, cdoor).TileY-1 OR Player.TileY=Door(Location, cdoor).TileY+1 THEN
IF Door(Location, cdoor).Mode = 0 THEN
ltext$ = "You push the button and the door opens."
Map(Location, Door(Location, cdoor).TileX+1, Door(Location, cdoor).TileY).BaseL = 1
Door(Location, cdoor).Mode = 1
goto nextdoor:
END IF
IF Door(Location, cdoor).Mode = 1 THEN
for countNPC = 1 to numofnpcs  
if NPC(Location, countNPC).Alive = TRUE AND NPC(Location, countNPC).TileY=Door(Location, cdoor).TileY AND NPC(Location, countNPC).TileX=Door(Location, cdoor).TileX+1 THEN
ltext$ = "You push the button but the door don't react."
goto nextdoor:
end if
next countNPC
ltext$ = "You push the button and the door closes."
Map(Location, Door(Location, cdoor).TileX+1, Door(Location, cdoor).TileY).BaseL = 321
Door(Location, cdoor).Mode = 0
END IF
END IF
END IF

END IF

nextdoor:    
NEXT cdoor
    
END SUB

    

