'this basically just handles image loading and indexing
'Relsoft 2005
'Rel.Betterwebber.com
'Compiler = Freebasic                 

defint a-z
'option explicit

Type ImageType
	 m_size	   	   as uinteger
	 m_pitch	   as uinteger
	 m_maxindex	   as uinteger
	 m_filename	   as string
	 p_data	       as ushort ptr
	 p_dataindex   as uinteger ptr
	 init		   as sub ( byref image as ImageType )
	 load	 	   as sub ( byref image as ImageType )
	 index	 	   as sub ( byref image as ImageType )
	 destroy 	   as sub ( byref image as ImageType )
End Type

declare sub init_palette_data ( FileName as string )
declare sub image_load ( byref image as ImageType )
declare sub image_index ( byref image as ImageType )
declare sub image_destroy ( byref image as ImageType )
declare sub image_init (byref image as ImageType )


sub init_palette_data (filename as string)

    'size array to hold all 256 colours.
    dim palette_array(0 to 255) as uinteger
    dim colour as uinteger
    dim i as integer
    dim fileno as ushort

    if filename$ <> "" then
        '*** read palette data from file ***
        fileno = freefile
        open filename$ for binary as #fileno
        for i = 0 to 255
            get #fileno, , colour
            palette_array(i) = colour
        next i
        close #fileno
        for i = 0 to 255
           palette i, palette_array(i)
        next i
    else
        '*** read palette data from data statements ***
        for i = 0 to 255
            read colour
        next i
        for i = 0 to 255
           palette i, palette_array(i)
        next i

    end if

end sub


'//======================

sub image_init ( byref image as ImageType )
	image.load = @image_load
	image.index = @image_index
	image.destroy = @image_destroy
end sub

sub image_load ( byref image as ImageType )

	dim filesize as uinteger
	dim filenum as ushort

	filenum = freefile

	open image.m_filename for binary as #filenum
	image.m_size = (lof(filenum) - 7) \ 2
	close #filenum
	image.p_data = callocate(len(ushort) * image.m_size)

	bload image.m_filename, image.p_data
end sub

sub image_index (byref image as ImageType)

	dim temparray as uinteger ptr
	dim lastint as uinteger
	dim currentimage as uinteger
	dim arraysize as uinteger
	dim indexnum as uinteger
	dim x as integer, y as integer
	temparray = callocate(len(uinteger) * 1000)
	indexnum  = 0
	currentimage = 0
	lastint = image.m_size
	do
	   x = image.p_data[currentimage] \ 8
	   y = image.p_data[currentimage + 1]
	   temparray[indexnum] = currentimage
	   arraysize = (x * y) + 4
	   if arraysize mod 2 then arraysize = arraysize + 1
	   arraysize = arraysize \ 2
	   currentimage = currentimage + arraysize
	   indexnum = indexnum + 1
	loop until lastint < currentimage

	indexnum = indexnum - 1

	image.p_dataindex = callocate(len(uinteger) * indexnum )

	image.m_maxindex = indexnum - 1
	for x = 0 to indexnum - 1
	   image.p_dataindex[x] = temparray[x]
	next
	deallocate temparray

end sub


sub image_destroy (byref image as ImageType )

	deallocate image.p_data
	deallocate image.p_dataindex

end sub

