'$DYNAMIC
DECLARE SUB DrawJulia (ci!, cr!)
DECLARE SUB Delay ()

'Lookup tables
DIM Sine!(359), Cosine!(359)
DIM SHARED Xmap!(319), Ymap!(199)

FOR i% = 0 TO 359
  Sine!(i%) = SIN(i% * (3.1415 / 180))
  Cosine!(i%) = COS(i% * (3.1415 / 180))
NEXT i%

FOR i% = 0 TO 319
  Xmap!(i%) = ((i% / 319) * 16) - 4
NEXT i%

FOR i% = 0 TO 199
  Ymap!(i%) = (((i% * .625) / 199) * 16) - 2.4
NEXT i%

SCREEN 13

FOR i% = 0 TO 25
  OUT &H3C8, i%
  OUT &H3C9, i%
  OUT &H3C9, (i% / 25) * 48
  OUT &H3C9, (i% / 25) * 63
NEXT i%

FOR i% = 26 TO 70
  OUT &H3C8, i%
  OUT &H3C9, 25 + ((i% / 70) * 38)
  OUT &H3C9, 48 + ((i% / 70) * 15)
  OUT &H3C9, 63
NEXT i%

xoff! = 0
yoff! = 0
t% = 0
DO
  xoff! = Sine((t% * 3) MOD 359) / 5
  yoff! = Cosine((t% * 5) MOD 359)
  t% = t% + 1
  IF (t% > 359) THEN t% = t% - 359
 
  DrawJulia xoff!, yoff!
  Delay
LOOP UNTIL INKEY$ <> ""

REM $STATIC
SUB Delay

WAIT &H3DA, 8, 8
WAIT &H3DA, 8

END SUB

SUB DrawJulia (ci!, cr!)

LINE (79, 49)-(240, 150), 169, B

DEF SEG = &HA000

FOR y& = 0 TO 99
  FOR x& = 0 TO 159
    zr! = Xmap!(x&)
    zi! = Ymap!(y&)
    init% = 0
    FOR i% = 0 TO 70
      init% = init% + 1
      zr2! = zr! * zr!
      zi2! = zi! * zi!
      zrnew! = zr2! - zi2! + cr!
      zinew! = (2 * zr! * zi!) + ci!
      zr! = zrnew!: zi! = zinew!
      IF (zr2! + zi2! > 4) THEN
        GOTO exitloop
      END IF
    NEXT i%
    init% = 70
exitloop:
    POKE x& + (y& * 320) + 16080, init%
  NEXT x&
NEXT y&

DEF SEG

END SUB

