
#include "fbgfx.bi" 
' We included a .bi file that contains many useful constants
' (it's placed in the [\FreeBASIC\inc] directory. Check it out  
' to see what it contains. For example, keyboard scancodes used
' with MULTIKEY(scancode) statement are flagged with nice, 
' easy to use constants like "SC_E" for E key or "SC_SPACE" for 
' SPACE key.

' A user defined type named "ObjectType" containing 3 variables.
TYPE ObjectType
     x AS SINGLE
     y AS SINGLE
     speed AS SINGLE
END TYPE

' CircleM variables are used to control our circle.
DIM SHARED CircleM AS ObjectType
' We can't declare this variable with "Circle" since then FB 
' can't differ it from the statement CIRCLE thus "CircleM".
' Why using this way of variable declaring? Instead of having to 
' declare "DIM SHARED circlex AS SINGLE" for circle's X position and 
' "DIM SHARED circley AS SINGLE" for circle's Y position we can do 
' it this way. It's more cleaner and easier to read. Also, we can 
' use "ObjectType" user defined type with objects other than circle. 
' Like circles controlled by the computer(example, DIM SHARED 
' CircleNPC(4) AS ObjectType). 4 means four elements in the array(4 
' circles we can manipulate with in our program - not present in this 
' example). We can also define more data types(other than ObjectType).
' Anyway, using data types is elementary programming literacy. 
' "SHARED" means that our variables will be readable in all our subs 
' and not just in the main module. We can add more variables in the 
' TYPE block if needed(example, Mode AS INTEGER and/or Health AS 
' INTEGER). We are using "SINGLE" instead of "INTEGER" because of the 
' precision that is not present with INTEGER variables. Precision is 
' needed if we want to move the circle with speeds under 1 or with 
' speeds between round numbers(like 1.3 or 2.6). 
' Every time you need decimal precision(manipulating with variables 
' like 0.4, 0.002 or 1.435) use SINGLE. Use INTEGER with variables 
' that don't need precision(number of lives, score and similar things 
' in games).

' We set an graphic mode of our choice.
SCREEN 13,8,2,0 ' 13 means 320*200 graphic resolution; 8 means
                ' 8bit color depth; 2 means two work pages and
                ' 0 means window mode(1 would be full screen mode).
                ' When your program is running you can toggle
                ' between full screen/window mode with ALT+ENTER.
                
SETMOUSE 0,0,0  ' This line hides the mouse cursor.

CircleM.x = 150   ' Initial circle's position.
CircleM.y = 90
CircleM.speed = 1 ' Speed => 1 pixel per loop.

DO

CLS ' Clear our old work page(REM it and get smearing).

' Draw a circle on position CircleM.x, CircleM.y with
' a radius of 10 and with color 15(plain white).
CIRCLE (CircleM.x, CircleM.y), 10, 15

' According to pushed key we change the circle's coordinates.
IF MULTIKEY(SC_RIGHT) THEN CircleM.x = CircleM.x + CircleM.speed
IF MULTIKEY(SC_LEFT) THEN CircleM.x = CircleM.x - CircleM.speed
IF MULTIKEY(SC_DOWN) THEN CircleM.y = CircleM.y + CircleM.speed
IF MULTIKEY(SC_UP) THEN CircleM.y = CircleM.y - CircleM.speed

SCREENSYNC ' Wait for vertical blank(use always in all the game 
           ' game loops to get 85 FPS).

'SCREENLOCK
SLEEP 2    ' Statement used to prevent 100% CPU usage(prevents
           ' the program to use up all the computer cycles - useful
           ' and recommended).
'SCREENUNLOCK

LOOP UNTIL MULTIKEY(SC_Q) OR MULTIKEY(SC_ESCAPE) 
' Execute the loop until the user presses Q or ESCAPE.

END ' End program.

