' A simple FMOD example program that loads two sound effects,
' plays them at the user's input and also STREAMS a
' background track(water flow). A volume control is also 
' implemented. By Lachie Dazdarian, Feb. 2006.

#include "fbgfx.bi" 
#include "fmod.bi" 
' Alyway include fmod.bi!
' Be sure that fmod.dll is where the executable file is
' or in Windows/System32 directory.

const FALSE = 0
const TRUE = 1

' Declare your samples like this(FB versions 0.15 and later).
' 4 is the maximum number of samples. Change this to suit
' your needs.
DIM SHARED mysamples(4) AS INTEGER PTR

' Declare your samples like this(FB versions 0.14 and prior).
' DIM SHARED mysamples(4) AS INTEGER

' The volume variable. Default volume is set at 75%.
SoundVol = 3

FMODStatus = TRUE
' It is recommended that you use a main FMOD switch variable
' which you can set as FALSE in a setup file in cases when 
' even detecting FMOD makes your program unstable on some
' platforms(very unlikely but it doesn't harm to make
' a setup file).
PlaySound = TRUE
' A generic variable which should turn on/off music/sound
' in your program. True by default in our case.

' Initiates FMOD. If it fails main FMOD switch variable is 
' set as FALSE.
IF FMODStatus = TRUE THEN
' 48000 is mixrate in Hz. 5 is the number of
' channels. Refer to FMOD.chm for more info.
FSOUND_Init(48000, 5, 0) 
IF FSOUND_Init(48000, 5, 0) = 0 THEN FMODStatus = FALSE
END IF

IF FMODStatus = TRUE THEN
    
' Stores two sound effects into memory. First parameter is
' the sample's pool index. Check FMOD.chm for more info.
mysamples(1) = FSOUND_Sample_Load(1, "splash.wav", 0, 0, 0) 
mysamples(2) = FSOUND_Sample_Load(2, "water_drops.wav", 0, 0, 0)

' Loads the background sound as sample 3 and streams it. Long
' music files consume a lot of memory if stored into it so
' I recommend you to stream them. If you really need to load them
' into memory load them ONE by ONE. Respect your user's memory!
mysamples(3) = FSOUND_Stream_Open("river.ogg", FSOUND_LOOP, 0, 0)
FSOUND_Stream_SetMode(mysamples(3), FSOUND_LOOP_NORMAL)
FSOUND_Stream_Play(3, mysamples(3))

END IF

SCREEN 18, 8, 2, 0

counteffect = 0
RANDOMIZE TIMER

' The main loop.
DO 

' Always put FSOUND_Update in all your loops!
IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_Update

' Draws the blue background and the jumping cyan line.
LINE (0, 0) - (640, 480), 1, BF
linx = INT(RND * 640) + 1
liny = INT(RND * 480) + 1
LINE (linx, liny) - (linx+30, liny), 3

' If the user presses 1 play sample from mysamples(1) and
' if the user presses 2 play sample from mysamples(2).
' counteffect is used to prevent double sample load.
' PlaySound and FMODStatus variables are just a habit
' of mine. You don't have to use them. 
' First parameter in the FSOUND_PlaySound is the channel. 
' Refer to FMOD.chm for more details.
IF MULTIKEY(SC_1) AND counteffect = 0 THEN 
IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_PlaySound(1, mysamples(1))
counteffect = 40
END IF
IF MULTIKEY(SC_2) AND counteffect = 0 THEN 
IF PlaySound = TRUE AND FMODStatus = TRUE THEN FSOUND_PlaySound(1, mysamples(2))
counteffect = 20
END IF
counteffect = counteffect - 1
IF counteffect < 0 THEN counteffect = 0

' If the user presses S turn on/off the sound.
' This is just to show you how to CLOSE and
' OPEN a streamed track.
IF MULTIKEY(SC_S) THEN
WHILE MULTIKEY(SC_S)
SLEEP 2
WEND
' If the sound is turned on close the streaming track
' and switch PlaySound to FALSE.
IF PlaySound = TRUE THEN
IF FMODStatus = TRUE THEN FSOUND_Stream_Close(mysamples(3))
PlaySound = FALSE
GOTO skipscnd:
END IF
' If the sound is turned off open a track to stream
' and switch PlaySound to TRUE.
IF PlaySound = FALSE THEN
IF FMODStatus = TRUE THEN
mysamples(3) = FSOUND_Stream_Open("river.ogg", FSOUND_LOOP, 0, 0)
FSOUND_Stream_SetMode(mysamples(3), FSOUND_LOOP_NORMAL)
FSOUND_Stream_Play(3, mysamples(3))
PlaySound = TRUE
END IF
END IF
skipscnd:
END IF

' Volume control. This is just to show you
' how to change the master volume. Refer
' to FMOD.chm for other volume functions.
' Main volume value needs to be from
' 0(quiet) to 255(max volume).
IF MULTIKEY(SC_UP) THEN
WHILE MULTIKEY(SC_UP)
SLEEP 2
WEND
SoundVol = SoundVol + 1
IF SoundVol > 4 THEN SoundVol = 4
IF SoundVol = 0 THEN SetVol = 0
IF SoundVol = 1 THEN SetVol = 63
IF SoundVol = 2 THEN SetVol = 126
IF SoundVol = 3 THEN SetVol = 190
IF SoundVol = 4 THEN SetVol = 255
IF FMODStatus = TRUE THEN FSOUND_SetSFXMasterVolume(SetVol)
END IF
IF MULTIKEY(SC_DOWN) THEN
WHILE MULTIKEY(SC_DOWN)
SLEEP 2
WEND
SoundVol = SoundVol - 1
IF SoundVol < 0 THEN SoundVol = 0
IF SoundVol = 0 THEN SetVol = 0
IF SoundVol = 1 THEN SetVol = 63
IF SoundVol = 2 THEN SetVol = 126
IF SoundVol = 3 THEN SetVol = 190
IF SoundVol = 4 THEN SetVol = 255
IF FMODStatus = TRUE THEN FSOUND_SetSFXMasterVolume(SetVol)
END IF

' This draws the control circle(just something
' specific for this demo; nothing to do
' with FMOD).
circolor = 2
IF counteffect > 0 THEN circolor = 4
CIRCLE (620, 20), 10, circolor, , , , F

LOCATE 1, 1
PRINT "Press 1 to play sample #1"
PRINT "Press 2 to play sample #2"
PRINT "Press S to turn on/off the sound."
PRINT "Press UP/DOWN arrow key to change the volume."
PRINT "Current volume: " + STR$(SoundVol*25)+"%"
PRINT "When the circle is green you can"
PRINT "play a sample."

LOCATE 15, 1
PRINT "Press ESC to end program."

SCREENCOPY
SCREENSYNC
SLEEP 2

LOOP UNTIL MULTIKEY(SC_ESCAPE)

' Before ending a program call FSOUND_CLOSE. Always!
IF FMODStatus = TRUE THEN FSOUND_Close 
END
