' A simple file usage example for FreeBASIC.
' By Lachie Dazdarian, Feb. 2006.

#include "fbgfx.bi" 

TYPE ObjectType
X    AS INTEGER  ' Will hold the object's X position.
Y    AS INTEGER  ' Will hold the object's Y position.
Typ  AS INTEGER  ' Will flag the object's type.    
END TYPE

DIM SHARED Player AS ObjectType ' A generic player object.
DIM SHARED NPC(4) AS ObjectType ' A generic NPCs array.

SCREEN 13, 8, 2, 0

' Open data.txt for retrevieng data on
' file handle #1
OPEN "data.txt" FOR INPUT AS #1
INPUT #1, Player.X
INPUT #1, Player.Y
' Loop through 4 NPCs and load
' the variables for each one.
FOR countNPC = 1 TO 4
INPUT #1, NPC(countNPC).X 
INPUT #1, NPC(countNPC).Y 
INPUT #1, NPC(countNPC).Typ
NEXT countNPC
CLOSE #1 ' Close the file handle 
         ' after retrieving data.

DO

' Print player's x and y position.
LOCATE 1, 1
PRINT "Player's X position: "; Player.X
PRINT "Player's Y position: "; Player.Y

' Print NPC 1 and 2 data.
LOCATE 4, 1
PRINT "NPC 1, X position:" ; NPC(1).X
PRINT "NPC 1, Y position:" ; NPC(1).Y
PRINT "NPC 1, type:" ; NPC(1).Typ
PRINT "NPC 2, X position:" ; NPC(2).X
PRINT "NPC 2, Y position:" ; NPC(2).Y
PRINT "NPC 2, type:" ; NPC(2).Typ

LOCATE 12, 1
PRINT "Use arrow keys to change the player's"
PRINT "position and S to save this new"
PRINT "information into data.txt."
PRINT "Press ESC to end the program."

' Change the player's position according to
' pushed arrow key.
IF MULTIKEY(SC_RIGHT) THEN Player.X = Player.X + 1
IF MULTIKEY(SC_LEFT) THEN Player.X = Player.X - 1
IF MULTIKEY(SC_UP) THEN Player.Y = Player.Y - 1
IF MULTIKEY(SC_DOWN) THEN Player.Y = Player.Y - 1

' If the letter "S" is pushed
' save the new data into
' the same file. Only Player's
' X and Y position can be
' changed.
IF MULTIKEY(SC_S) THEN
WHILE MULTIKEY(SC_S)
SLEEP 2
WEND
OPEN "data.txt" FOR OUTPUT AS #1
PRINT #1, Player.X
PRINT #1, Player.Y
FOR countNPC = 1 TO 4
PRINT #1, NPC(countNPC).X 
PRINT #1, NPC(countNPC).Y 
PRINT #1, NPC(countNPC).Typ
NEXT countNPC
CLOSE #1
END IF

SCREENCOPY
SCREENSYNC
SLEEP 2

LOOP UNTIL MULTIKEY(SC_ESCAPE) ' End loop when ESC is pushed.

END


