'$Include: "FBGFX.BI" 
DEFINT A-Z 
Option Explicit 
ScreenRes 640,480,8,2,1 
ScreenSet 0,1 

Const FALSE=0, True = NOT FALSE 


TYPE Vector2D 
  X as Single 
  Y as Single 
END Type 


DECLARE Sub Vec_2D_Normal(a as Vector2D, b as Vector2D,rn as Vector2D,ln as Vector2D) 
DECLARE Function ClosestPointOnLine(Va as Vector2D, Vb as Vector2D,vPoint as Vector2D) as Vector2D 
DECLARE Sub Vec_2D_Normalize(v as Vector2D) 
DECLARE Function Vec_2D_Len(V as Vector2D) as Single 
DECLARE Function Vec_2D_Dot(a as Vector2D, b as Vector2D) as Single 
DECLARE Function Vec_2D_Dist(vA as Vector2D, vB as Vector2D) as Single 

Dim Pl as Vector2D, Pld as Vector2D, Radius as Single 
Dim Ero as Vector2D, Cent as Vector2D, tDist as Single 
Dim i, iAnd1, Ang, Num_Verts, In as String*1 

Pl.X = 50 
Pl.Y = 50 
Radius=10 

Read Num_Verts 
Dim Lines(Num_Verts) as Vector2D 

For i = 0 to UBOUND(Lines) 
Read Lines(i).X, Lines(i).Y 
Next 



Do 
   In = Inkey$ 
   CLS 
   
   If MultiKey(Sc_Left) then PlD.X -=.15 
   If MultiKey(Sc_Right) then PlD.X +=.15 
   If MultiKey(Sc_Up) then PlD.Y -=.15 
   If MultiKey(Sc_Down) then PlD.Y +=.15    
   
   PlD.X*=.95 
   PlD.Y*=.95 
   
   Pl.X+=PlD.X 
   Pl.Y+=PlD.Y 

   For i=0 to UBOUND(Lines)-1 step 2 
       iAnd1 = i+1 
       Vec_2D_Normal Lines(i), Lines(iAnd1), Cent, Cent 
       Ero = ClosestPointOnLine(Lines(i), Lines(iAnd1), PL) 
       tDist=Vec_2D_Dist(Pl, Ero) 
       
       If tDist<Radius Then 
           Pl.X+=(Cent.X*(Radius-tDist)) 
           Pl.Y+=(Cent.Y*(Radius-tDist)) 
       End If 
       
       Line(Lines(i).X, Lines(i).Y)-(Lines(iAnd1).X, Lines(iAnd1).Y),14 
       Line(Ero.X, Ero.Y)-(Ero.X + (Cent.X*Radius), Ero.Y + (Cent.Y*Radius)),7 
       Circle(Ero.X, Ero.Y),Radius,14 
   Next 
   

   Circle (Pl.X,Pl.Y),Radius, 1 
   PSET (Pl.X,Pl.Y), 4 

   Wait &H3da,8 
   Flip 
Loop Until In=CHR$(27) 

End 



Function ClosestPointOnLine(Va as Vector2D, Vb as Vector2D, vPoint as Vector2D) as Vector2D 
   Dim tVector1 as Vector2D, _ 
       tVector2 as Vector2D, _ 
       vReturn as Vector2D, _ 
       d as Single, _ 
       t as Single 

   tVector1.X = VPoint.X - Va.X 
   tVector1.Y = VPoint.Y - Va.Y 
   
   tVector2.X = Vb.X - Va.X 
   tVector2.Y = Vb.Y - Va.Y 
   
   Vec_2D_Normalize tVector2 
   
   d = Vec_2D_Dist(VA, VB) 
   t = Vec_2D_Dot(tVector2, tVector1) 
   
   If t<=0 Then Return Va 
   
   If t>=d Then Return Vb 
   
   vReturn.X = Va.X + (tVector2.X * t) 
   vReturn.Y = Va.Y + (tVector2.Y * t) 
   Return vReturn 
End Function 


Function Vec_2D_Dist(vA as Vector2D, vB as Vector2D) as Single 
   Dim Dx as Single, _ 
       Dy as Single 
   Dx = Va.X - Vb.X 
   Dy = Va.Y - Vb.Y 
   Vec_2D_Dist = SQR(Dx^2+Dy^2) 
End Function 


SUB Vec_2D_Normalize(v as Vector2D) 
   Dim VecLen as Single 
   VecLen = Vec_2D_Len (V) 
   v.x = v.x / VecLen 
   v.y = v.y / VecLen 
END SUB 


Function Vec_2D_Len(V as Vector2D) as Single 
   Dim TLen as Single 
   TLen = SQR(v.x^2 + v.y^2) 
   If TLen = 0 then TLen = 1 
   Vec_2D_Len = TLen 
End Function 


FUNCTION Vec_2D_Dot(a as Vector2D, b as Vector2D) as Single 
   Vec_2D_Dot = a.x*b.x + a.y*b.y 
END Function 


SUB Vec_2D_Normal(a as Vector2D, b as Vector2D, rn as Vector2D, ln as Vector2D) 
   Dim VecLen as Single, _ 
       D as Vector2D    
   
   D.x = b.x - a.x 
   D.y = b.y - a.y 
   
   VecLen = Vec_2D_Len(D) 
   
   'The reason this sub returns two values... 

   'Rn is clockwise winding... 
       Rn.x = (-D.y) / VecLen 
       Rn.y = (D.x) / VecLen 
   
   'Ln is anti-clockwise winding, which is what we're using... 
       Ln.x = (D.y) / VecLen 
       Ln.y = (-D.x) / VecLen 
END SUB 



Data 21 

Data 0,0 
Data 0,240 

Data 0,240 
Data 100,340 

Data 100,340 
Data 125,400 

Data 125,400 
Data 300,450 

Data 300,450 
Data 450,470 

Data 450,470 
Data 600,370 

Data 600,370 
Data 550,300 

Data 550,300 
Data 625,250 

Data 625,250 
Data 500,0 

Data 500,0 
Data 320,50 

Data 320,50 
Data 0,0 
