# ifndef XCP_MEMORY_SHAREDPTR_BI__
# define XCP_MEMORY_SHAREDPTR_BI__ -1

' This stuff should go into a different header, but is declared here for
' simplicity of the tutorial.
namespace xcp

	type Bool as integer
	type SizeT as uinteger

end namespace

namespace xcp.memory

	type DestroyProc as sub (byval p as any ptr)
	
	' The default destruction procedure, uses ..DEALLOCATE to free memory.
	declare sub DeallocateProc (byval p as any ptr)
	
	''' A non-intrusive reference-counting smart pointer.
	'''
	''' A SharedPtr is responsible for the sharing of a resource and,
	''' optionally, its destruction. SharedPtr objects reference some memory
	''' and keep track of how many other SharedPtrs are referencing the same
	''' memory. If the last SharedPtr that references a particular resource
	''' is destroyed, the resource is destroyed as well, if necessary.
	'''
	''' SharedPtrs pointers are designed and intended to be copied around
	''' freely, like normal pointers. Unlike normal pointers, however, the
	''' programmer's burdon of object ownership is decreased; SharedPtrs can
	''' be assumed to either be NULL or reference a valid existing resource.
	'''
	''' IMPLEMENTATION NOTES:
	''' SharedPtrs carry around a reference to a count of total SharedPtrs that
	''' reference any particular resource. The actual count variable can only
	''' be created in the constructor, given a non-NULL pointer argument. Much
	''' of the functionality is implemented in terms of SharedPtr.Swap_().
	
	type SharedPtr
	public:
		' Constructs a shared pointer from a raw pointer with an optional
		' destruction procedure - if NULL, any resource is not destroyed.
		declare constructor ( _
			byval p as any ptr = 0, _
			byval destroy as DestroyProc = @DeallocateProc _
		)
		' Constructs a shared pointer from another (shares the resource, if any).
		declare constructor ( _
			byref sp as SharedPtr _
		)
		' Destroys the shared pointer (deletes the object if no other shared
		' pointers refer to it).
		declare destructor ()
		' Behaves like 'this.Swap_(SharedPtr(sp))'.
		declare operator let ( _
			byref sp as SharedPtr _
		)
		
		' Behaves like 'this.Swap_(SharedPtr(p, destroy))'.
		declare sub Reset ( _
			byval p as any ptr = 0, _
			byval destroy as DestroyProc = @DeallocateProc _
		)
		
		' Exchanges the contents of the shared pointer with another.
		declare sub Swap_ ( _
			byref sp as SharedPtr _
		)
		
		' Returns the pointer.
		declare function Get ( _
		) as any ptr
		' Returns total number of references to object (including this one).
		declare function UseCount ( _
		) as SizeT
		' Returns 'UseCount() = 1'.
		declare function Unique ( _
		) as Bool
		
		' Returns 'this.Get() <> 0'.
		declare function ToBool ( _
		) as Bool
		''' this is messing with the 'raw pointer' ctors..
	'	declare operator cast () as integer
	
	private:
		m_p			as any ptr = any
		m_destroy		as DestroyProc = any
		m_refcount	as SizeT ptr = any
	end type
	
	' Returns 'a.Get() = b.Get()'
	declare operator = (byref a as SharedPtr, byref b as SharedPtr) as Bool
	' Returns 'a.Get() <> b.Get()'
	declare operator <> (byref a as SharedPtr, byref b as SharedPtr) as Bool
	
end namespace ' xcp.memory

# endif ' include guard

