# include "memory-sharedptr.bi"

namespace xcp.memory

	'' :::::
	sub DeallocateProc (p as any ptr)
		..deallocate(p)
	end sub
	
	'' :::::
	constructor SharedPtr (byval p as any ptr, byval destroy as DestroyProc)
	
		m_p = p
		m_destroy = destroy
		if (m_p) then
			m_refcount = new SizeT(1)
		else
			m_refcount = 0
		end if
	
	end constructor
	
	'' :::::
	constructor SharedPtr (byref sp as SharedPtr)
	
		m_p = sp.m_p
		m_destroy = sp.m_destroy
		if (m_p) then
			m_refcount = sp.m_refcount
			ASSERT(m_refcount)
			*m_refcount += 1
		else
			m_refcount = 0
		end if
	
	end constructor
	
	'' :::::
	destructor SharedPtr ()
	
		if (m_p) then
'			ASSERT(m_refcount)
			*m_refcount -= 1
			
			' last reference ?
			if (0 = *m_refcount) then
				' destroy the object, if necessary.
				if (m_destroy) then
					m_destroy(m_p)
				end if
				delete m_refcount
			end if
		end if
	
	end destructor
	
	'' :::::
	operator SharedPtr.let (byref sp as SharedPtr)
		this.Swap_(SharedPtr(sp))
	end operator

	'' :::::
	function SharedPtr.Get () as any ptr
		return m_p
	end function
	
	'' :::::
	function SharedPtr.Unique () as Bool
		return iif(m_refcount, *m_refcount = 1, false)
	end function
	
	'' :::::
	function SharedPtr.Usecount () as SizeT
		return iif(m_refcount, *m_refcount, 0)
	end function
	
	'' :::::
	sub SharedPtr.Swap_ (byref sp as SharedPtr)
	
		swap m_p, sp.m_p
		swap m_destroy, sp.m_destroy
		swap m_refcount, sp.m_refcount
	
	end sub
	
	'' :::::
	sub SharedPtr.Reset (byval p as any ptr, byval destroy as DestroyProc)
		this.Swap_(SharedPtr(p, destroy))
	end sub
	
	'' :::::
	function SharedPtr.ToBool () as Bool
		return m_p <> 0
	end function
	
	'' :::::
	'operator SharedPtr.cast () as integer
	'	return m_p <> 0
	'end operator
	
	'' :::::
	operator = (byref a as SharedPtr, byref b as SharedPtr) as Bool
		return a.get() = b.get()
	end operator
	
	'' :::::
	operator <> (byref a as SharedPtr, byref b as SharedPtr) as Bool
		return a.get() <> b.get()
	end operator

end namespace

