#include once "windows.bi"
#Include Once "win/commctrl.bi"
#Include Once "win/commdlg.bi"
#Include Once "win/shellapi.bi"

#Define IDD_DIALOG			1000

#Define IDM_MENU				10000
#Define IDM_FILE_EXIT		10001
#Define IDM_HELP_ABOUT		10101

Dim Shared hInstance As HMODULE
Dim Shared CommandLine As ZString Ptr
Dim Shared hWnd As HWND

Const ClassName="DLGCLASS"

Dim Shared As WndProc MsgList(WM_USER)

Sub Assign(mess As Long,proc As WndProc)
	MsgList(mess)=proc
End Sub

Function WndProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer

	Dim As WndProc guifunc

	GuiFunc=MsgList(uMsg)
	If Guifunc>0 Then
		Return guifunc(hWin,uMsg,wParam,lParam)
	End If

	If uMsg=WM_CLOSE Then
		DestroyWindow(hWin)
	End If
	If uMsg= WM_DESTROY Then 
		PostQuitMessage(0)
	EndIf 
	Return DefWindowProc(hWin,uMsg,wParam,lParam)
	Return FALSE

End Function


Sub OnInit
	MessageBox(NULL,"Init","",MB_OK)
End Sub

Function OnCommand(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
	Select Case HiWord(wParam)
		Case BN_CLICKED,1
			Select Case LoWord(wParam)
				Case IDM_FILE_EXIT
					SendMessage(hWin,WM_CLOSE,0,0)
					'
				Case IDM_HELP_ABOUT
					ShellAbout(hWin,"MyApp","",NULL)
					'
			End Select
			'
	End Select
	Return false
End Function

Function WinMain(ByVal hInst As HINSTANCE,ByVal hPrevInst As HINSTANCE,ByVal CmdLine As ZString ptr,ByVal CmdShow As Integer) As Integer
	Dim wc As WNDCLASSEX
	Dim msg As MSG

	wc.cbSize=SizeOf(WNDCLASSEX)
	wc.style=CS_HREDRAW or CS_VREDRAW
	wc.lpfnWndProc=@WndProc
	wc.cbClsExtra=0
	wc.cbWndExtra=DLGWINDOWEXTRA
	wc.hInstance=hInst
	wc.hbrBackground=Cast(HBRUSH,COLOR_BTNFACE+1)
	wc.lpszMenuName=Cast(ZString Ptr,IDM_MENU)
	wc.lpszClassName=@ClassName
	wc.hIcon=LoadIcon(NULL,IDI_APPLICATION)
	wc.hIconSm=wc.hIcon
	wc.hCursor=LoadCursor(NULL,IDC_ARROW)
	RegisterClassEx(@wc)

	
	hWnd=CreateDialogParam(hInstance,Cast(ZString Ptr,IDD_DIALOG),NULL,@WndProc,NULL)
	ShowWindow(hWnd,SW_SHOWNORMAL)
	UpdateWindow(hWnd)

	Do While GetMessage(@msg,NULL,0,0)
		TranslateMessage(@msg)
		DispatchMessage(@msg)
	Loop
	Return msg.wParam

End Function

'---- START ----
hInstance=GetModuleHandle(NULL)
CommandLine=GetCommandLine
InitCommonControls

Assign(WM_INITDIALOG,Cast(WndProc,@OnInit))
MsgList(WM_COMMAND)=@OnCommand

WinMain(hInstance,NULL,CommandLine,SW_SHOWDEFAULT)
MessageBox(NULL,"Exit","",MB_OK)
ExitProcess(0)

End
