' -------------------------------------
'  BASIC command processor application
'          by MystikShadows
' -------------------------------------

#INCLUDE "dir.bi"

' -------------------------------
'  Sub and Function Declarations
' -------------------------------
DECLARE SUB PrintApplicationInformation()
DECLARE SUB DisplayHelpScreen()
DECLARE SUB ProcessCommand(ToBeProcessed AS STRING)

DECLARE FUNCTION GetWordCount(WorkString AS STRING) AS LONG
DECLARE FUNCTION GetWordNumber(WorkString AS STRING, WordNumber AS LONG) AS STRING

' -----------------------------
'  Needed Constant Definitions
' -----------------------------
CONST False = 0
CONST TRue  = NOT False

CONST HeaderColor  = 15 ' White
CONST InfoColor    = 11 ' Light Cyan
CONST CommandColor = 14 ' Yellow
CONST ErrorColor   = 12 ' Light Red
CONST ResultColor  = 10 ' Light Green

' -------------------------
'  Needed Global Variables
' -------------------------
DIM SHARED CurrentCommand AS STRING
DIM SHARED CanExit        AS INTEGER

' ------------------------------------------------------
'  Start by displaying the title and general informaion
' ------------------------------------------------------
WIDTH 80, 25
COLOR 7, 1
CLS
CALL PrintApplicationInformation()

' -----------------------------------------------------
'  Main loop where commands are acquired and processed
' -----------------------------------------------------
DO WHILE CanExit = False
   ' ---------------------------
   '  Get command from the user
   ' ---------------------------
   COLOR CommandColor, 1
   PRINT "->";
   INPUT CurrentCommand
   CALL ProcessCommand(CurrentCommand)
   ' -------------------------------------------
   '  We Clear the command, ready for a new one
   ' -------------------------------------------
   CurrentCommand = ""

LOOP

' ========================================================
'  NAME........: PrintApplicationInformation()
'  PARAMETERS..: None
'  RETURN......: No value
'  ASSUMES.....: Nothing
'  CALLED FROM.: Main Program Loop
' --------------------------------------------------------
'  DESCRIPTION.: This Sub simply displays some regular
'                information to the user about this
'                current program
' ========================================================
SUB PrintApplicationInformation()

    COLOR HeaderColor, 1
    PRINT "MystikShadow's Command Processor Application"
    PRINT "Version 1.00a"
    PRINT
    COLOR InfoColor, 1
    PRINT "Type 'HELP' for a list of commands"
    PRINT "Type 'EXIT' to end the program"
    PRINT

END SUB

' ========================================================
'  NAME........: DisplayHelpScreen()
'  PARAMETERS..: None
'  RETURN......: No Value
'  ASSUMES.....: Nothing
'  CALLED FROM.: The Main Program Loop
' --------------------------------------------------------
'  DESCRIPTION.: This Sub displays a list of valid
'                commands available to the user. So that
'                he/she can learn the allowed commands.
' ========================================================
SUB DisplayHelpScreen()

    COLOR ResultColor, 1
    PRINT "Valid Commands Are:"
    PRINT
    PRINT "TIME                       Returns The Current Time"
    PRINT "DATE                       Returns The Current Date"
    PRINT "CLS                        Clears the screen"
    PRINT "CD [<PathName>]            Returns Current Path or Changes to PathName"
    PRINT "DIR <FileSpecification>    Lists files that match FileSpecification
    PRINT "REN <OldName> <NewName>    Renames an existing file to a new name"
    PRINT "RENAME <OldName> <NewName> Renames an existing file to a new name"
    PRINT "MD <FolderName>            Creates a Directory on the Disk"
    PRINT "RD <FolderName>            Removes a Directory from the disk"
    PRINT "DEL <FileSpecification>    Removes a Directory from the disk"
    PRINT "DELETE <FileSpecification> Removes a Directory from the disk"
    PRINT
END SUB

' ========================================================
'  NAME........: ProcessCommand()
'  PARAMETERS..: ToBeProcessed AS STRING
'  RETURN......: NoValue
'  ASSUMES.....: ToBeProcessed Is Not Empty
'  CALLED FROM.: Main Program Loop
' --------------------------------------------------------
'  DESCRIPTION.: This Sub is the main core of the program
'                it will take the passed command in it's
'                parameter, parse it and perform the
'                corresponding action.
' ========================================================
SUB ProcessCommand(ToBeProcessed AS STRING)

    DIM FirstWord     AS STRING
    DIM SecondWord    AS STRING
    DIM ThirdWord     AS STRING
    DIM WorkFile      AS STRING
    DIM WordCounter   AS INTEGER
    DIM FolderCounter AS INTEGER
    DIM FileCounter   AS INTEGER

    ' -------------------------------------------------
    '  First we test of the command is a valid command
    ' -------------------------------------------------
    FirstWord = TRIM$(UCASE$(GetWordNumber(ToBeProcessed, 1)))
    IF FirstWord <> "TIME"   AND FirstWord <> "DATE" AND _
       FirstWord <> "CLS"    AND FirstWord <> "CD"   AND _
       FirstWord <> "CD.."   AND FirstWord <> "CD\"  AND _
       FirstWord <> "DIR"    AND FirstWord <> "REN"  AND _
       FirstWord <> "RENAME" AND FirstWord <> "DEL"  AND _
       FirstWord <> "DELETE" AND FirstWord <> "MD"   AND _
       FirstWord <> "RD"     AND FirstWord <> "HELP" AND _
       FirstWord <> "EXIT"   THEN
       COLOR ErrorColor, 1
       PRINT "An Invalid Command Was Entered"
       PRINT
       EXIT SUB
    END IF
    ' -------------------------------------
    '  We take care of easy commands
    ' -------------------------------------
    COLOR ResultColor, 1
    SELECT CASE TRIM$(UCASE$(ToBeProcessed))
           CASE "TIME"
                PRINT TIME$
                PRINT
                EXIT SUB
           CASE "DATE"
                PRINT DATE$
                PRINT
                EXIT SUB
           CASE "CLS"
                COLOR 7, 1
                CLS
                EXIT SUB
           CASE "CD"
                PRINT CURDIR$
                PRINT
                EXIT SUB
           CASE "HELP"
                CALL DisplayHelpScreen()
                EXIT SUB
           CASE "EXIT"
                CLS
                END
    END SELECT

    ' ---------------------------------------------
    '  We get the rest of the words in the command
    ' ---------------------------------------------
    WordCounter = GetWordCount(ToBeProcessed)
    IF WordCounter = 2 THEN
       SecondWord = GetWordNumber(ToBeProcessed, 2)
    ELSEIF WordCounter = 3 THEN
       SecondWord = GetWordNumber(ToBeProcessed, 2)
       ThirdWord  = GetWordNumber(ToBeProcessed, 3)
    END IF

    ' -------------------------------------------------------------------------
    '  This SELECT CASE decides which code to executed for the command entered
    ' -------------------------------------------------------------------------
    SELECT CASE FirstWord
           ' -------------------------------
           '  THE CD command implementation
           ' -------------------------------
           CASE "CD", "CD..", "CD\"
                ' -----------------------------------------
                '  Test for the existence of the directory
                ' -----------------------------------------
                IF DIR$(SecondWord, fbDirectory) = "" AND SecondWord <> "\" THEN
                   ' -------------------------------------------------------
                   '  If the directory does not exist, we display a message
                   ' -------------------------------------------------------
                   COLOR ErrorColor, 1
                   PRINT "This Directory does not exist. Path remains unchanged."
                   PRINT CURDIR$
                   PRINT
                   COLOR ResultColor
                ELSE
                   ' ------------------------------------------------
                   '  Test to see if none spaced .. andn \ were used
                   '  Execute appropriate command in these cases.
                   ' ------------------------------------------------
                   IF FirstWord = "CD.." THEN
                      CHDIR ".."
                   ELSEIF FirstWord = "CD\" THEN
                      CHDIR "\"
                   ' ---------------------------------------------------
                   '  In all other cases we just CHDIR to the directory
                   ' ---------------------------------------------------
                   ELSE
                      ' -----------------------------------------------
                      '  If it does exist we CHDIR right to the folder
                      ' -----------------------------------------------
                      CHDIR SecondWord
                   END IF
                   PRINT CURDIR$
                END IF
                PRINT
                EXIT SUB
           ' -------------------------------
           '  The MD Command Implementation
           ' -------------------------------
           CASE "MD"
                ' -------------------------------------
                '  We test to see if the folder exists
                ' -------------------------------------
                IF DIR$(SecondWord, fbDirectory) <> "" THEN
                   ' ------------------------------------
                   '  If it does exist, we warn the user
                   ' ------------------------------------
                   COLOR ErrorColor, 1
                   PRINT "This Directory already exists, unable to create it."
                   PRINT
                   COLOR ResultColor, 1
                ELSE
                   ' -------------------------------------------------------
                   '  If it doesn't exist, we simply go ahead and create it
                   ' -------------------------------------------------------
                   MKDIR SecondWord
                END IF
                EXIT SUB
           ' -------------------------------
           '  The RD Command Implementation
           ' -------------------------------
           CASE "RD"
                ' ------------------------------------
                '  First we test if the folder exists
                ' ------------------------------------
                IF Mystik = 0 THEN 'DIR$(SecondWord, fbDirectory) = "" THEN
                   COLOR ErrorColor, 1
                   PRINT "This Directory does not exist hence cannot be removed."
                   PRINT
                   COLOR ResultColor, 1
                ' --------------------------------------------------
                '  Next we test if there are files in the directory
                ' --------------------------------------------------
                ELSEIF DIR$(CURDIR$ + "\" + SecondWord + "\*.*") <> "" THEN
                   COLOR ErrorColor, 1
                   PRINT "The Directory has files in it and cannot be removed."
                   PRINT
                   COLOR ResultColor, 1
                ' -----------------------------------------------------
                '  If all is good we go ahead and remove the directory
                ' -----------------------------------------------------
                ELSE
                   RMDIR SecondWord
                END IF
                EXIT SUB
           ' --------------------------------
           '  The DIR Command Implementation
           ' --------------------------------
           CASE "DIR"
                FolderCounter = 0
                FileCounter   = 0
                ' ----------------------------------------------------
                '  We first list the folders in the current directory
                ' ----------------------------------------------------
                IF SecondWord = "" THEN
                   WorkFile = DIR$("*", fbDirectory)
                ELSE
                   WorkFile = DIR$(SecondWord, fbDirectory)
                END IF
                DO WHILE TRIM$(WorkFile) <> ""
                   IF LEFT$(WorkFile, 1) <> "." THEN
                      FolderCounter = FolderCounter + 1
                      PRINT WorkFile & "\"
                   END IF
                   WorkFile = DIR$()
                LOOP
                ' -------------------------------------------------
                '  We then list the files in the current directory
                ' -------------------------------------------------
                IF SecondWord = "" THEN
                   WorkFile = DIR$("*")
                ELSE
                   WorkFile = DIR$(SecondWord)
                END IF
                DO WHILE TRIM$(WorkFile) <> ""
                   FileCounter = FileCounter + 1
                   PRINT WorkFile
                   WorkFile = DIR$()
                LOOP
                ' --------------------------------------------------------------
                '  We finally display the folder and file counts we accumilated
                ' --------------------------------------------------------------
                PRINT
                PRINT "There were " + STR$(FolderCounter) + " directories and " + STR$(FileCounter) + " files listed."
                PRINT
                EXIT SUB
           ' -------------------------------------------
           '  The DEL and DELETE Command Implementation
           ' -------------------------------------------
           CASE "DEL", "DELETE"
                ' ---------------------------------
                '  First we see if the file exists
                ' ---------------------------------
                IF DIR$(SecondWord) = "" THEN
                   COLOR ErrorColor, 1
                   PRINT "This file does not exist, unable to delete it."
                   PRINT
                   COLOR ResultColor, 1
                ' ----------------------------------------------------------
                '  If the file exists we go ahead and use KILL to delete it
                ' ----------------------------------------------------------
                ELSE
                   KILL SecondWord
                END IF
                EXIT SUB
           ' -------------------------------------------
           '  The REN and RENAME Command Implementation
           ' -------------------------------------------
           CASE "REN", "RENAME"
                ' ----------------------------------------------
                '  First we test that Old Filename Is not empty
                ' ----------------------------------------------
                IF SecondWord = "" THEN
                   COLOR ErrorColor, 1
                   PRINT "The name if an existing file is needed to rename the file."
                   PRINT
                   COLOR ResultColor, 1
                   EXIT SUB
                ' ---------------------------------------------
                '  Next we test that New Filename Is not empty
                ' ---------------------------------------------
                ELSEIF ThirdWord = "" THEN
                   COLOR ErrorColor, 1
                   PRINT "A new name is needed to rename the file."
                   PRINT
                   COLOR ResultColor, 1
                   EXIT SUB
                ' ----------------------------------------------
                '  Finally we test that the old filename exists
                ' ----------------------------------------------
                ELSEIF DIR$(SecondWord) = "" THEN
                   COLOR ErrorColor, 1
                   PRINT "The file you are trying to rename does not exist."
                   PRINT
                   COLOR ResultColor, 1
                   EXIT SUB
                ' --------------------------------------------------------------
                '  If all went well we go ahead and use NAME to rename the file
                ' --------------------------------------------------------------
                ELSE
                   NAME SecondWord, ThirdWord
                   EXIT SUB
                END IF
    END SELECT


END SUB

' ========================================================
'  NAME........: GetWordCount()
'  PARAMETERS..: WorkString AS STRING
'  RETURN......: 0 Or the number of words
'  ASSUMES.....: WorkString is valid string with contents
'  CALLED FROM.: ProcessCommand()
' --------------------------------------------------------
'  DESCRIPTION.: This function accepts a string as a
'                parameter, peruses it and accumulates
'                the number of words it finds in the
'                string.
' ========================================================
FUNCTION GetWordCount(WorkString AS STRING) AS LONG

    ' ----------------
    '  Work Variables
    ' ----------------
    DIM  Counter      AS LONG
    DIM  WordCounter  AS LONG
    DIM  Position     AS LONG
    DIM  Skipper      AS LONG

    ' ----------------------
    '  Initialize Variables
    ' ----------------------
    WordCounter  = 1
    Position     = 1
    ' ---------------------------------------------------------
    '  First we put ourselves at the beginning of the 1st word
    ' ---------------------------------------------------------
    IF MID$(WorkString, Position, 1) = " " THEN
       DO WHILE MID$(WorkString, Position, 1) = " "
          Position = Position + 1
       LOOP
    END IF
    ' --------------------------------------
    '  Then we start the Word Count Process
    ' --------------------------------------
    FOR Counter = Position TO LEN(WorkString)
        IF MID$(WorkString, Counter, 1) = " " THEN
           WordCounter = WordCounter + 1
           DO WHILE MID$(WorkString, Counter, 1) = " "
              Counter = Counter + 1
           LOOP
        END IF
    NEXT Counter
    ' ----------------------------------------
    '  Return the number of words accumulated
    ' ----------------------------------------
    GetWordCount = WordCounter

END FUNCTION

' ========================================================
'  NAME........: GetWordNumber()
'  PARAMETERS..: WorkString AS STRING
'                WordNumber AS LONG
'  RETURN......: "" Or the desired word Number
'  ASSUMES.....: WorkString has contents, WordNumber > 0
'  CALLED FROM.: ProcessCommand()
' --------------------------------------------------------
'  DESCRIPTION.: This function accepts a string and a
'                Word Number as paremeters, it then finds
'                the given word number and returns it to
'                the calling function.
' ========================================================
FUNCTION GetWordNumber(WorkString AS STRING, WordNumber AS LONG) AS STRING

    ' ----------------
    '  Work Variables
    ' ----------------
    DIM  Counter      AS LONG
    DIM  WordCounter  AS LONG
    DIM  Position     AS LONG
    DIM  Skipper      AS LONG
    DIM  ReturnString AS STRING

    ' ----------------------
    '  Initialize Variables
    ' ----------------------
    WordCounter  = 1
    Position     = 1
    ReturnString = ""
    ' ---------------------------------------------------------
    '  First we put ourselves at the beginning of the 1st word
    ' ---------------------------------------------------------
    IF MID$(WorkString, Position, 1) = " " THEN
       DO WHILE MID$(WorkString, Position, 1) = " "
          Position = Position + 1
       LOOP
    END IF
    ' --------------------------------------
    '  Then we start the Word Count Process
    ' --------------------------------------
    FOR Counter = Position TO LEN(WorkString)
        IF MID$(WorkString, Counter, 1) = " " THEN
           WordCounter = WordCounter + 1
           DO WHILE MID$(WorkString, Counter, 1) = " "
              Counter = Counter + 1
           LOOP
        END IF
        ' ----------------------------------------------------------
        '  If it's the wanted word number we put it in ReturnString
        ' ----------------------------------------------------------
        IF WordCounter = WordNumber THEN
           IF MID$(WorkString, Counter, 1) <> " " THEN
              ReturnString = ReturnString + MID$(WorkString, Counter, 1)
           END IF
        END IF
    NEXT Counter
    ' ---------------------------------
    '  Return the word in ReturnString
    ' ---------------------------------
    GetWordNumber = ReturnString

END FUNCTION
