Type interpreter
  Public:
    Declare Constructor (filename As String)
    Declare Destructor ()

    Declare Sub nextInstruction ()

    As uInteger ended
    As uInteger error

  Private:
    As String _filename
    As uInteger _filehandle
    As uInteger _line_number
End Type

Constructor interpreter (filename As String)
  this._filename = filename
  this._filehandle = FreeFile()
  Open filename For Input As #this._filehandle
  this._line_number = 1
  this.ended = 0
  this.error = 0
End Constructor

Destructor interpreter ()
  this.ended = Not 0
  Close this._filehandle
  this._filehandle = 0
End Destructor

Sub interpreter.nextInstruction()
Dim As String curLine, tmp
Dim As uInteger inQuote = 0

  If this.ended <> 0 Then Exit Sub

  If Eof(this._filehandle) Then
    this.ended = Not 0
    Exit Sub
  End If

  'Read the next line of input
  Line Input #this._filehandle, curLine

  'Trim leading and trailing whitespace off
  curLine = Trim(curLine)

  'There are no commands shorter than three characters, so quit now if we need to
  If Len(curLine) < 3 Then Exit Sub

  'If it's a comment, quit
  If curLine[0] = Asc("'") Then Exit Sub
  If LCase(Left(curLine, 3)) = "rem" Then Exit Sub

  'If the first five characters are "sleep" then sleep
  If LCase(Left(curLine, 5)) = "sleep" Then Sleep

  'If it's Print then search for the first quotation mark, then go until the second.
  If LCase(Left(curLine, 5)) = "print" Then
    'If there are no more characters afterwards, just do a linefeed
    If Len(curLine) <= 5 Then
      Print ""
    Else
      For i As uInteger = 5 To Len(curLine)-1
        'If it's a quotation mark, begin storing the characters beyond it - or stop, depending on where we are.
        If curLine[i] = Asc("""") Then
          inQuote = Not inQuote
          'If we were in a quotation before, quit the loop
          If inQuote = 0 Then Exit For
        Else
          If inQuote <> 0 Then
            tmp = tmp + Chr(curLine[i])
          End If
        End If
        'If we happen to hit the end of the line with no end quotation, raise an error.
        If i = Len(curLine)-1 And curLine[i] <> Asc("""") Then this.error = 1
      Next i

      Print tmp
    End If
  End If
  
  'If the command is Cls, Cls!
  If LCase(Left(curLine, 3)) = "cls" Then
    Cls
  End If

  If LCase(Left(curLine, 3)) = "end" Then
    this.ended = Not 0
  End If
End Sub

Dim As interpreter myInterpreter = interpreter("someScript2.fbsc")

Do
  myInterpreter.nextInstruction()
Loop Until myInterpreter.ended <> 0

Print ""
Print "SCRIPT ENDED."

Sleep

End