#Include Once "words_list/words_list.bas"

Type interpreter
  Public:
    Declare Constructor (filename As String)
    Declare Destructor ()

    Declare Sub nextInstruction ()

    As uInteger ended
    As uInteger error

  Private:
    As String _filename
    As uInteger _filehandle
    As uInteger _line_number
End Type

Constructor interpreter (filename As String)
  this._filename = filename
  this._filehandle = FreeFile()
  Open filename For Input As #this._filehandle
  this._line_number = 1
  this.ended = 0
  this.error = 0
End Constructor

Destructor interpreter ()
  this.ended = Not 0
  Close this._filehandle
  this._filehandle = 0
End Destructor

Sub interpreter.nextInstruction()
Dim As String curLine, tmp, thisWord
Dim As uInteger inQuote = 0

Dim As words_list wordsList = words_list()

  If this.ended <> 0 Then Exit Sub

  If Eof(this._filehandle) Then
    this.ended = Not 0
    Exit Sub
  End If

  'Read the next line of input
  Line Input #this._filehandle, curLine

  'Set the string in the wordslist to the inputted line
  wordsList.setString(curLine)

  'Get the first word, make it lowercase
  thisWord = LCase(wordsList.getWord(0))
  
  'Try different things depending on its length
  Select Case Len(thisWord)
  	'If it's a 3-character word...
  	Case 3:
  		'Check if it's END or CLS
  		Select Case thisWord
  			Case "end":
  				this.ended = Not 0
  				Exit Sub
  			Case "cls":
  				Cls
  		End Select
  	
  	'If it's a 5-character word...
  	Case 5:
  		'Check if it's SLEEP or PRINT
  		Select Case thisWord
  			Case "sleep":
  				'Variable parameters for Sleep
  				Select Case wordsList.numWords
  					Case 1:
  						Sleep
  					Case 2:
  						Sleep Val(wordsList.getWord(1))
  				  Case 3:
  				    'For multiple parameters, trim off the , in between parameters
  						Sleep Val(RTrim(wordsList.getWord(1), ",")), Val(wordsList.getWord(2))
  				End Select
  				
  			'For Print, we just have to get the next word and trim the first quotation marks off the end.
  			Case "print":
  				tmp = Mid(wordsList.getWord(1), 2, wordsList.wordLength(1)-2)
  				Print tmp
  		End Select
  End Select
End Sub

Dim As interpreter myInterpreter = interpreter("someScript3.fbsc")

Do
  myInterpreter.nextInstruction()
Loop Until myInterpreter.ended <> 0

Print ""
Print "SCRIPT ENDED."

Sleep

End