Type word
  As Integer _index
  As Integer _length
End Type

Type words_list
  Public:
    'Prepare the words list
    Declare Constructor ()
    'Destroy the words list
    Declare Destructor ()
    
    'Reset everything so the list can be re-used with a different string
    Declare Sub reuse ()
    
    'Set the string that is to be parsed and divided into words
    Declare Sub setString (tstring As String)
    'Get the entire string
    Declare Function getString () As String
    
    'Get a single word
    Declare Function getWord (tindex As uInteger) As String
    'Get the length of a word
    Declare Function wordLength (tindex As uInteger) As uInteger
    
    'Find out how many words there actually are
    Declare Property numWords () As uInteger
    
  Private:
    'The string itself
    As String _the_string
    'All the word descriptors
    As word Ptr _words
    'Number of words
    As Integer _num_words
    'Whether the string is valid
    As Byte _validity = 0
    'Whether the objects constructor has been called yet
    As Byte _created = 0
End Type

Constructor words_list ()
  'Initialize everything
  this._the_string = ""
  this._words = Allocate(1)
  this._num_words = 0
  this._validity = 0
  this._created = Not 0
End Constructor

Destructor words_list ()
  'Destroy everything
  If this._created = Not 0 Then
    this._the_string = ""
    DeAllocate(this._words)
    this._num_words = 0
    this._validity = 0
    this._created = 0
  End If
End Destructor

Sub words_list.reuse ()
  'Destroy everything, then recreate it all
  If this._created = Not 0 Then
    this._the_string = ""
    DeAllocate(this._words)
    this._words = Allocate(1)
    this._num_words = 0
    this._validity = 0
    this._created = Not 0
  End If
End Sub

Sub words_list.setString (tstring As String)
Dim As Integer i, inside_string = 0, inside_whitespace = 0, inside_comment = 0
Dim As Integer word_start = 0
  'If the constructor has been called...
  If this._created = Not 0 Then
    'Make sure the words list does not already contain a string...
    If this._validity = Not 0 And this._the_string <> "" Then
      this.reuse()
    End If
    
    'Special case for empty strings
    If tstring = "" Then
      this._validity = Not 0
      this._the_string = ""
      this._num_words = 0
      this._words = Allocate(SizeOf(word))
      this._words[0]._index = 0
      this._words[0]._length = 0
      Exit Sub
    End If
    
    'Set the string
    this._the_string = tstring
    
    If tstring[0] = Asc(" ") Then
      Do Until tstring[i] <> Asc(" ") Or i = Len(tstring)
        i += 1
        word_start = i
      Loop
    End If
    
    'Now parse through and find each word
    Do Until i = Len(tstring)
      i += 1
      
      'If this character is a space...
      If tstring[i-1] = Asc(" ") Then
        'If we're not yet inside a run of whitespace, create the most recent word
        If inside_whitespace = 0 And inside_string = 0 Then
          'Add the word
          this._num_words += 1
          this._words = ReAllocate(this._words, SizeOf(word)*this._num_words)
          this._words[this._num_words-1]._index = word_start
          this._words[this._num_words-1]._length = (i-word_start)-2
        
          'Tell ourselves that we're in a run of whitespace
          inside_whitespace = Not 0
        End If
      'Otherwise...
      Else
        'Handles whether we're in a string or not
        If tstring[i-1] = Asc("""") Then
          If inside_string = 0 Or tstring[i] <> Asc("""") Then
            inside_string = Not inside_string
          Else
            If tstring[i] = Asc("""") Then i += 1
          End If
        End If
        
        'Handles whether we're inside a comment or not
        If tstring[i-1] = Asc("'") And inside_string = 0 Then
          'If so, we quit right away, since the comment continues to the end of the line.
          i -= 1
          Exit Do
        End If
        
        'If we were in a run of whitespace, we aren't now
        If inside_whitespace = Not 0 Then
          word_start = i-1
          inside_whitespace = 0
        End If
      End If
    Loop
    
    If inside_whitespace = 0 Then
      'Add the last word
      this._num_words += 1
      this._words = ReAllocate(this._words, SizeOf(word)*this._num_words)
      this._words[this._num_words-1]._index = word_start
      this._words[this._num_words-1]._length = (i-word_start)-1
    End If
    
    'Mark the object valid
    this._validity = Not 0
  End If
End Sub

Function words_list.getString () As String
  'If it's a valid words list
  If this._validity = Not 0 Then
    'Return the string
    Return this._the_string
  End If
End Function

Function words_list.getWord (tindex As uInteger) As String
Dim tmpstr As String = ""
Dim As Integer idx, stlen, i
  'If it's a valid words list
  If this._validity = Not 0 Then
    'If the index given is valid
    If this._num_words > tindex Then
      'Get index and length of the word
      idx = this._words[tindex]._index
      stlen = this._words[tindex]._length
      'And add each character to our temporary string
      tmpstr = Mid(this._the_string, idx+1, stlen+1)
      'Return our temporory string
      Return tmpstr
    End If
  End If
  'Otherwise, return a blank string
  Return ""
End Function

Function words_list.wordLength (tindex As uInteger) As uInteger
  'If it's a valid words list
  If this._validity = Not 0 Then
    'If the index given is valid
    If this._num_words > tindex Then
      'Return length of the word
      Return this._words[tindex]._length + 1
    End If
  End If
  
  'Otherwise, return 0
  Return 0
End Function

Property words_list.numWords () As uInteger
  'If the string is valid, return the number of words
  If this._validity = Not 0 Then
    Return this._num_words
  End If
  'Otherwise return 0
  Return 0
End Property