/'* 
 @file  list.h
 @brief ENet list management 
'/
#ifndef __ENET_LIST_BI__
#define __ENET_LIST_BI__

#include "crt/stdlib.bi"

type ENetListNode
	next as ENetListNode ptr
	previous as ENetListNode ptr
end type

type ENetListIterator as ENetListNode ptr

type ENetList
	sentinel as ENetListNode
end type

declare sub enet_list_clear(as ENetList ptr)
declare function enet_list_insert(as ENetListIterator, as any ptr) as ENetListIterator
declare function enet_list_remove(as ENetListIterator) as any ptr
declare function enet_list_size(as ENetList ptr) as size_t

#define enet_list_begin(list) ((list) -> sentinel.next)
#define enet_list_end(list) (@ (list) -> sentinel)

#define enet_list_empty(list) (enet_list_begin (list) = enet_list_end (list))

#define enet_list_next(iterator) ((iterator) -> next)
#define enet_list_previous(iterator) ((iterator) -> previous)

#define enet_list_front(list) (Cast(Any Ptr, (list) -> sentinel.next))
#define enet_list_back(list) (Cast(Any Ptr, (list) -> sentinel.previous))

#EndIf	/'__ENET_LIST_BI__'/
