/'
  <Slightly modified copy of the zlib license>
 
  clTTO_client.bas -- client state management:
  	input management
  	connection management
  	client <-> server communication

  Copyright (C) 2008 Daniel Cousley

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Daniel Cousley
'/

#Include "fbgfx.bi"
#Include "cmnTTO_gstate.bi"
#Include "clTTO_client.bi"

#Include "crt.bi"
#Include "enet/enet.bi"
#Include "cmnTTO_helpers.bi"
	
Using FB

Sub getCellNumber(xOffset As Integer, yOffset As Integer, ByRef pState As t_pState)
	' Collects mouse input, and location,
	' then compresses the location into a single byte.
	Dim x As Integer
	Dim y As Integer
	Dim tMouse As Integer
	Dim tCellNum As Integer

	With pState
		
		GetMouse(x, y,, tMouse)
		If tMouse <> .ioState.mouseButton then
			.ioStateChange = 1
		End if
		.ioState.mouseButton = tMouse

		x -= xOffset
		y -= yOffset
		
		x = int(x / 64)
		y = int(y / 64)
	
		If x > 2 Or x < 0 Then
			x = -1
		EndIf
	
		If y > 2 Or y < 0 Then
			y = -1
		EndIf
		tCellNum = (y * 3) + x	
	
		If x < 0 Or y < 0 Then
			tCellNum = 255
		EndIf
	
		If tCellNum <> .ioState.cellOffset then
			.ioStateChange = 1
			.ioState.cellOffset = tCellNum
		End If
	End With
End Sub

Sub getKeyBoard(ByRef pState As t_pState)
	'Collects keyboard input
	
	If MultiKey(SC_ESCAPE) Then
		pState.ioState.keyState = eksEscape
		pState.ioStateChange = 1
	ElseIf MultiKey(SC_Y) then
		pState.ioState.keyState = eksYes
		pState.ioStateChange = 1
	ElseIf MultiKey(SC_N) then
		pState.ioState.keyState = eksNo
		pState.ioStateChange = 1
	EndIf
End Sub

sub client_connect(ByRef gameState As t_gameState)
	'Connect to a server at address >szAddr< on port >port<
	
	Dim As ENetHost Ptr client
  Dim As ENetAddress address
  Dim As ENetEvent eve
	Dim As ENetPeer Ptr peer

	If gameState.host Then
		enet_peer_disconnect_now(@gameState.host->peers[0], 0)
		enet_host_destroy(gameState.host)
	EndIf
	
  gameState.host = enet_host_create (NULL, 1, 0, 0)
  enet_address_set_host (@address, gameState.ip)
	address.port = gameState.port
		
	peer = enet_host_connect (gameState.host, @address, 1)
	
	If peer = 0 Then
		enet_host_destroy(gameState.host)
		gameState.host = 0
	End If
End sub

Sub client_Receive(ByRef gameState As t_gameState, inPacket As ENetPacket Ptr)
	'Receives data from the server, and decomposes it back into the gameState structure.
	Dim As UByte Ptr p_bData

	p_bData = inPacket->Data
	' For now the first byte should always be &HFF
	' In the future the command could be used to differentiate different actions

	If getUByte(p_bData) <> &hFF Then
		Exit sub
	EndIf	

	With gameState.p2State.ioState
		.cellOffset = getUByte(p_bData)
		.mouseButton = getUByte(p_bData)
		.keyState = getUInteger(p_bData)
	End With
	
	gameState.p2State.cellState = getUShort(p_bData)
	gameState.p1State.cellState = getUShort(p_bData)

	gameState.gState = getUInteger(p_bData)
	gameState.wWinner = getUInteger(p_bData)

	gameState.turn = getUByte(p_bData)
	
	If gameState.gState = egsEndGame Then
		gameState.isRunning = 0
	EndIf
	
End Sub


Sub client_SendGameState(ByRef gameState As t_gameState)
	'Send data to the server, composes it into a potentially more tightly packed format
	'as well as compensating for potential endianness issues.
	
	Dim outPacket As ENetPacket Ptr
	Dim As UByte Ptr p_bData
	
	outPacket = enet_packet_create (0, 7, ENET_PACKET_FLAG_RELIABLE)

	p_bData = outPacket->data
	
	pushUByte(p_bData, &hFE)	'Command

	With gameState.p1State.ioState
		pushUByte(p_bData, .cellOffset)
		pushUByte(p_bData, .mouseButton)	
		pushUInteger(p_bData, .keyState)
	End With
	
	enet_peer_send (@(gameState.host->peers[0]), 0, outPacket)

End Sub

Sub client_pump(ByRef gameState As t_gameState, interval As integer)
	'Manages enets message pump, as well as checking for a client connection timeout.
	'If there has been an input state change, the server is notified.
	Dim As ENetEvent eve
	
	If gameState.p1State.timeout <> 0 then
		If Timer - gameState.p1State.timeout > 5 Then
			gameState.p1State.timeout = 0
			gameState.gState = egsEndGame
		EndIf
	End If
	
	If gameState.host = 0 Then
		Exit sub
	EndIf
	
	Do while (enet_host_service (gameState.host, @eve, interval) > 0)
		Select case (eve.type)
			case ENET_EVENT_TYPE_CONNECT:
				gameState.p1State.timeout = 0
				gameState.gState = egsWaiting
			case ENET_EVENT_TYPE_DISCONNECT:
				gameState.gState = egsEndGame
			case ENET_EVENT_TYPE_RECEIVE:
				gameState.turn = 0
				client_Receive(gameState, eve.packet)
				enet_packet_destroy(eve.packet)
			Case else
		End select
	Loop
	'Notify the server of input changes
	If gameState.p1State.ioStateChange = 1 Then
		client_SendGameState(gameState)
		gameState.p1State.ioStateChange = 0
	EndIf
	
End Sub
