#Include "ui_button.bi"
#Include "fbgfx.bi"
#Include "crt.bi"

Using FB
Sub _iClick(ByRef self As t_uiButton, uData As Any Ptr)
	printf (!"Internal click caught\n")
End Sub

Constructor t_uiButton()
	Dim scrW As Integer
	Dim scrH As Integer
	Dim charSize As Integer
	
	ScreenControl(GET_SCREEN_SIZE, scrW, scrH)
	charSize = Width()
	With this
		._cw = scrW / Cast (Short Ptr, @charSize)[0]
		._ch = scrH / Cast (Short Ptr, @charSize)[1] 
		._x = 10
		._y = 10

		._w = 10
		._h = 1
		._txt = ""
		._needsResize = 1
		.callBack = @_iClick
		
		._colors(efgColor) = 0
		._colors(ebgColor) = RGB(192,192,192)
		._colors(ebr1Color) = RGB(128,128,128)
		._colors(ebr2Color) = RGB(64,64,64)
		._colors(efgColorIA) = 0 
		._colors(ebgColorIA) = RGB(128,128,128)
		._colors(ebr1ColorIA) = RGB(64,64,64)
		._colors(ebr2ColorIA) = RGB(32,32,32)
			
	End with
End Constructor

destructor t_uiButton()
	ImageDestroy(this._surface)
	this._txt = ""
End destructor

Sub t_uiButton._resize()
	Dim tW As Integer
	Dim tH As Integer	
	With this
		tW = (._w * ._cw) + 4
		
		tH = (._h * ._ch) + 4
		ImageDestroy(._surface)
		._surface = ImageCreate( tW, tH )
	End with
End Sub

Sub t_uiButton._redraw()
	Dim tW As Integer
	Dim tH As Integer
	Dim tX As Integer
	Dim tOffset As Integer 
	Dim visText As ZString Ptr
	Dim As UInteger bgCol, fgCol, brCol1, brCol2
	
	With this

		tW = (._w * ._cw) + 4
		tH = (._h * ._ch) + 4
		bgCol = ._colors(ebgColor)
		fgCol = ._colors(efgColor)
		brCol1 = ._colors(ebr1Color)
		brCol2 = ._colors(ebr2Color)
		
		tOffset = 0
		
		If this._mState Then
			bgCol = brCol1
			tOffset = 1
		EndIf
		
		tX = (Len(._txt) / 2) * ._cw
		
		Line ._surface, (0, 0)-( tW - 1, tH - 1), bgCol,BF
		Draw String ._surface, (Int(tW / 2) - (tX - tOffset), int(tH \ 2) - (4 - tOffset)), this._txt, fgCol
		Line ._surface, (0, 0)-( tW - 2, tH - 2), brCol1,B
		Line ._surface, (0, 0)-( tW - 1, tH - 1), brCol2,B
	End with	
End Sub

Sub t_uiButton._isClicked()
	Dim mX As Integer
	Dim mY As Integer
	Dim mB As Integer
	GetMouse(mX,mY,,mB)

	mX -= this._x
	mY -= this._y

	If mX > 0 And mX < (this._w * this._cw) + 4 Then
		If mY > 0 And mY < (this._h * this._ch) + 4 Then
			If mB = 0 Then
				If this._mState = 1 then
					this._clicked = 1
				End if
			ElseIf mB = 1 then
				this._mState = 1
				this._needsRedraw = 1
			EndIf
		EndIf
	EndIf
	
	If mB = 0 And this._mState = 1 Then
		this._mState = 0
		this._needsRedraw = 1
	EndIf
	
End Sub

Sub t_uiButton.poll()
	Dim oldState As Integer
	oldState = this._mState
	this._isClicked()
	If this._clicked then
		this._clickCB(this, this._cbData)
		this._clicked = 0
	EndIf
End Sub

Sub t_uiButton.render()
	If this._needsResize = 1 Then
		this._resize()
		this._redraw()
		this._needsResize = 0		
		this._needsRedraw = 0
	elseIf this._needsRedraw = 1 then
		this._redraw()
		this._needsRedraw = 0
	End If
	
	Put (this._x, this._y), this._surface, pset
End Sub

Property t_uiButton.xPos(newX As Integer)
	this._x = newX
End Property

Property t_uiButton.xPos() As Integer
	Return this._x
End Property

Property t_uiButton.yPos(newY As Integer)
	this._y = newY
End Property

Property t_uiButton.yPos() As Integer
	Return this._y
End Property

Property t_uiButton.wdth(newW As Integer)
	With this
		._w = newW
		If ._w < 1 Then
			._w = 1
		EndIf 
		._needsResize = 1
	End with
End Property

Property t_uiButton.wdth() As Integer
	Return this._w
End Property

Property t_uiButton.height(newH As Integer)
	With this
		._h = newH
		If ._h < 1 Then
			._h = 1
		EndIf
		._needsResize = 1
	End with
End Property
Property t_uiButton.height() As Integer
	Return this._h
End Property

Property t_uiButton.text(newText As string)
	this._txt = newText
End Property

Property t_uiButton.text() As String
	Return this._txt
End Property

Property t_uiButton.callback(newCB As t_click_CB) 
	If newCB Then
		this._clickCB = newCB 
	Else
		this._clickCB = @_iClick
	End If
End Property

Property t_uiButton.callback() As t_click_CB 
	If this._clickCB = @_iClick Then
		Return 0
	Else
		Return this._clickCB
	End If 
End Property

Property t_uiButton.callbackData(newData As Any ptr)
	this._cbData = newData 
End Property

Property t_uiButton.callbackData() As Any Ptr
	Return this._cbData
End Property

Sub t_uiButton.setColor(cElement As UInteger, newCol As UInteger)
	
	If cElement > UBound(this._colors) Then
		cElement = UBound(this._colors)
	EndIf
	
	this._colors(cElement) = newCol
	this._needsRedraw = 1
	
End Sub