'       3D RPG Engine for Qbasic/QuickBasic4.5/PDS
'
'       Program and graphics by: DarkDread
'
'       Created: December 2nd, 1999
'
'       You may use this code in your own game... and you may also use the
'       graphics provided with this code.  You must, however, give the author,
'       DarkDread, credit in your programs.
'
'       Contact: darkdread@hotmail.com
'       Website: http://www.geocities.com/TimesSquare/Ring/1683
'
DEFINT A-Z
'$DYNAMIC

DECLARE SUB PutSprite (FileName$, X%, Y%, PutType%)
DECLARE SUB ReadData (MaxX%, MaxY%)
DECLARE SUB DrawLocation ()
DECLARE SUB MoveDown ()
DECLARE SUB MoveLeft ()
DECLARE SUB MoveRight ()
DECLARE SUB MoveUp ()
'
'   Here are all of the variables that we will need.  Basically, the
'   array for holding the map data, one array for loading and displaying
'   our graphics, plus a few variables to hold the player location,
'   position, and if they have moved or not.  We use the last one to
'   determine if we need to update the graphics on screen to show the
'   player's new location.
'
DIM SHARED Map%(-3 TO 173, -3 TO 173)
DIM SHARED PlayerDir$, Moved%, PlayerX%, PlayerY%
DIM SHARED Sprite%(5000)
'
'   True/False constants.  They're used in a lot of the code.
'
CONST True = -1, False = 0
'
'   These are some constants which you may wish to pay attention to.  They
'   are used to determine where on the screen our graphics are displayed.
'   You can change the values of these to move the display to different
'   areas of the screen.  Make sure that, when you change the value of one
'   constant, you change the value of all of them accordingly.  An easy
'   way to do this is to subtract or add, the same amount to each constant.
'
'   For example, to move the graphics to the upper left of the screen,
'   subtract 60 from each Y constant and 112 from each X constant.  Note
'   that the wall aheads are X constants.
'
CONST CellY = 60, CellX = 112
CONST Cell1LeftX = 112, Cell2LeftX = 130, Cell3LeftX = 142
CONST Cell1RightX = 192, Cell2RightX = 180, Cell3RightX = 172
CONST Cell1Ahead = 129, Cell2Ahead = 142, Cell3Ahead = 150
'
'   Here, we call a SUB to read out map data (As well as set our maximum
'   X and Y values for the maze.  We also give values to the player's
'   default location, and default direction which they are facing.  Also,
'   we must set the Moved% variable to true, so that when the program is
'   run, the screen will display the graphics for the player's location in
'   the maze.
'
ReadData 10, 10
PlayerX% = 0: PlayerY% = 0: PlayerDir$ = "N"
Moved% = True
'
'   Switch to mode 13h (300x200, 256 colour VGA mode), load a background
'   graphic for the demonstration, and create empty boxes where our stats
'   and graphics will be shown.
'
SCREEN 13
DEF SEG = &HA000
BLOAD "back.bsv"
LINE (7, 7)-(127, 34), 0, BF
LINE (6, 6)-(128, 35), 4, B
LINE (111, 59)-(210, 161), 4, B
'
'   Here's the main loop.  Notice the CASE statements.  We use these to
'   check the keyboard buffer to see if the user has pressed a key.  Also,
'   the PSET statements are used to draw our mini map on the screen, as
'   well as the player's current location.
'
DO

    PSET (PlayerX% + 112, PlayerY% + 24), 120
    SELECT CASE INKEY$
        CASE CHR$(0) + CHR$(72)
            MoveUp
        CASE CHR$(0) + CHR$(80)
            MoveDown
        CASE CHR$(0) + CHR$(75)
            MoveLeft
        CASE CHR$(0) + CHR$(77)
            MoveRight
        CASE CHR$(27)
            Quit = True
    END SELECT
 
    PSET (PlayerX% + 112, PlayerY% + 24), 10
    IF Moved% THEN DrawLocation
    Moved% = False

    LOCATE 2, 2: PRINT "Location:"; PlayerX%; PlayerY%
    LOCATE 3, 2: PRINT "Compass:     "; PlayerDir$
    LOCATE 4, 2: PRINT "Map:         "

LOOP UNTIL Quit

SYSTEM
'
'   This is the data for our maze.  Of course, it doesn't have to be located
'   in the code.  You could just as easily put the numbers into a seperate
'   file and modify the map loader so that it reads from a file instead of
'   data.  But, for the purpose of this tutorial, I've left the map as DATA
'   statements.
'
DATA 00,00,00,00,00,00,00,00,00,00
DATA 00,10,00,10,10,10,10,10,10,00
DATA 00,10,00,10,00,00,00,00,10,00
DATA 00,10,00,10,00,10,10,00,10,00
DATA 00,10,00,10,00,10,10,00,10,00
DATA 00,10,00,00,00,00,00,00,10,00
DATA 00,10,00,10,10,10,10,10,10,00
DATA 00,10,00,00,00,00,00,00,10,00
DATA 00,10,10,00,10,10,00,10,10,00
DATA 00,00,00,00,00,00,00,00,00,00

REM $STATIC
SUB DrawLocation
    '
    '   Here's the meat of this code.  This is the SUB that checks the
    '   cells around the player and draws the area around them.
    '
    '   It may look a bit complicated at first, but read through the
    '   code and try to understand how it works.  Once you've discovered
    '   the methods used here, you'll be able to work with this type of
    '   engine easily.
    '
    '   Bascially, picture six cells, laid out like so, with X denoting
    '   the player (Fig. a):
    '
    '   Fig. a          Fig. b          Fig. c          Fig. d
    '    _ _ _           _ _ _           _ _ _          _ _ _
    '   |_|_|_|         ||_|_|         ||_|_|        |_||_|
    '   |_|_|_|         ||_|_|         ||_|_|        |_|_|_|
    '   |_|_|_|         |_|_|_|         |_|_|_|        |_|_|_|
    '      X               X               X              X
    '
    '   To draw the map in a first person view, the code checks each cell
    '   to see if the player could pass through it or not.  For example,
    '   if there is a wall () in the upper left cell and a walkable space
    '   () in the cell below it, then the code will put a 'turn' type wall
    '   in the upper left cell (Fig. b).  However, if there was a wall in
    '   the cell below the upper left cell as well, the code would put a
    '   regular wall there (Fig. c).  The code goes through the left and
    '   right cells, checking for walls and walkable spaces such as those in
    '   examples b and c.  Finally, the middle row of cells is used to
    '   determine if there is a wall directly ahead of the player, and if
    '   so, how many spaces (or cells) away.  For example, if there is a
    '   wall three cells away from the player, then the code will know to
    '   draw a wall, three cells ahead of the player (Fig. d).
    '
    '   A bit tougher than a 2d scrolling engine, isn't it? Don't worry if
    '   you don't quite understand it yet.  The best thing to do, is to run
    '   the code, play around with it, play around with the map (The DATA
    '   statements in the main code), and get a feeling for how it works
    '   first.  Once you are familiar with it, you can try editing parts of
    '   the code here to add other types of walls, or windows, doors, etc.
    '   Well, back to the code. ;)
    '
    '   First, we put a background on the screen.  For the purpose of this
    '   tutorial, there is no background, to keep it simple.  However, you
    '   could easily throw in a moving background simply by cycling a few
    '   sprites every time this sub is called.  You could do this like so:
    '
    '   First, make a dim shared variable, call it Frames% for example, in
    '   your main program.  Then, put code similar to this below (Assuming
    '   that you have 5 background pics that you wish to cycle, and you've
    '   named them back0.pic, back2.pic, etc, etc):
    '
    '   PutSprite "back" + RIGHT$(STR$(Frames%), 1) + ".pic", CellX, CellY
    '   Frames% = Frames% + 1
    '   IF Frames% = 5 THEN Frames% = 0
    '
    '   Simple, isn't it?  Of course, without a proper screen buffer, the
    '   display will flicker a lot.  To correct this, you'd want to use a
    '   graphics library such as GSLib, Blast!, Dash, DirectQB, or any other
    '   mode 13h lib.  If you have a graphics library, please refer to the
    '   documentation that came with it, if you wish to use it.
    '
    '   For this tutorial, I am simply using a black box for the background,
    '   like so.
    '
    LINE (CellX, CellY)-(CellX + 97, CellY + 100), 0, BF
    '
    '   Next, we determine which direction the player is facing.  This
    '   could be north, east, west, or south.
    '
    IF PlayerDir$ = "N" THEN
    '
    '   If the player is facing north, we check the cells around them
    '   and determine if the are empty or if they are a wall type.
    '
    '   First, we will place walls, and/or turns in the three cells to
    '   the left of the player.
    '
    '   If the cell one left and three up from the player is not walkable
    '   and the cell one left and two up from the player is walkable
    '   then we need to put a 'turn' wall there.
    '     
            IF Map%(PlayerX% - 1, PlayerY% - 3) > 9 AND Map%(PlayerX% - 1, PlayerY% - 2) < 10 THEN
                    PutSprite "T3.BSG", Cell3LeftX, CellY, 0
    '
    '   Otherwise, if the cell one left and two up from the player is not
    '   walkable, we put a regular wall there.
    '         
                ELSEIF Map%(PlayerX% - 1, PlayerY% - 2) > 9 THEN
                    PutSprite "LW3.BSG", Cell3LeftX, CellY, 0
            END IF
    '
    '   If the cell one left and two up from the player is not walkable
    '   and the cell one left and one up from the player is walkable then
    '   we need to put a 'turn' wall there.
    '
            IF Map%(PlayerX% - 1, PlayerY% - 2) > 9 AND Map%(PlayerX% - 1, PlayerY% - 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2LeftX, CellY, 0
    '
    '   Otherwise, if the cell one left and one up from the player is not
    '   walkable, we put a regular wall there.
    '
                ELSEIF Map%(PlayerX% - 1, PlayerY% - 1) > 9 THEN
                    PutSprite "LW2.BSG", Cell2LeftX, CellY, 0
            END IF
    '
    '   If the cell one left and one up from the player is not walkable
    '   and the cell one left from the player is walkable then we need to
    '   put a 'turn' wall there.
    '
            IF Map%(PlayerX% - 1, PlayerY% - 1) > 9 AND Map%(PlayerX% - 1, PlayerY%) < 10 THEN
                    PutSprite "T1.BSG", Cell1LeftX, CellY, 0
    '
    '   Otherwise, if the cell one left from the player is not walkable
    '   then we need to put a regular wall there.
    '
                ELSEIF Map%(PlayerX% - 1, PlayerY%) > 9 THEN
                    PutSprite "LW1.BSG", Cell1LeftX, CellY, 0
            END IF
    '
    '   Now, we will place walls and/or turns in the three cells to the
    '   right of the player.
    '
    '   If the cell one right and three up from the player is not walkable
    '   and the cell one right and two up from the player is walkable then
    '   we need to put a 'turn' wall there.
    '
            IF Map%(PlayerX% + 1, PlayerY% - 3) > 9 AND Map%(PlayerX% + 1, PlayerY% - 2) < 10 THEN
                    PutSprite "T3.BSG", Cell3RightX, CellY, 0
    '
    '   Otherwise, if the cell one right and two up from the player is not
    '   walkable then we need to put a regular wall there.
    '
                ELSEIF Map%(PlayerX% + 1, PlayerY% - 2) > 9 THEN
                    PutSprite "RW3.BSG", Cell3RightX, CellY, 0
            END IF
    '
    '   If the cell one right and two up from the player is not walkable
    '   and the cell one right and one up from the player is walkable then
    '   we need to put a 'turn' wall there.
    '
            IF Map%(PlayerX% + 1, PlayerY% - 2) > 9 AND Map%(PlayerX% + 1, PlayerY% - 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2RightX, CellY, 0
    '
    '   Otherwise, if the cell one right and one up from the player is not
    '   walkable then we need to put a regular wall there.
    '
                ELSEIF Map%(PlayerX% + 1, PlayerY% - 1) > 9 THEN
                    PutSprite "RW2.BSG", Cell2RightX, CellY, 0
            END IF
    '
    '   If the cell one right and one up from the player is not walkable
    '   and the cell one right from the player is walkable then we need to
    '   put a 'turn' wall there.
    '
            IF Map%(PlayerX% + 1, PlayerY% - 1) > 9 AND Map%(PlayerX% + 1, PlayerY%) < 10 THEN
                    PutSprite "T1.BSG", Cell1RightX, CellY, 0
    '
    '   Otherwise, if the cell one right from the player is not walkable
    '   then we need to put a regular wall there.
    '
                ELSEIF Map%(PlayerX% + 1, PlayerY%) > 9 THEN
                    PutSprite "RW1.BSG", Cell1RightX, CellY, 0
            END IF
    '
    '   Finally, we check the middle set of cells, to see if there is a
    '   wall ahead of the player in any one of these cells.
    '
    '   If the cell three up from the player is not walkable then we
    '   need to put a wall there.
    '
            IF Map%(PlayerX%, PlayerY% - 1) > 9 THEN
                    PutSprite "WA1.BSG", Cell1Ahead, CellY, 0
    '
    '   If the cell two up from the player is not walkable then we need
    '   to put a wall there.
    '
                ELSEIF Map%(PlayerX%, PlayerY% - 2) > 9 THEN
                    PutSprite "WA2.BSG", Cell2Ahead, CellY, 0
    '
    '   If the cell one up from the player is not walkable then we need
    '   to put a wall there.
    '
                ELSEIF Map%(PlayerX%, PlayerY% - 3) > 9 THEN
                    PutSprite "WA3.BSG", Cell3Ahead, CellY, 0
            END IF
    '
    '   You'll notice that when we are setting our walls, we always draw
    '   the ones furthest away from the player first.  This is because
    '   what is closest to the player, will always determine what can be
    '   seen further ahead.  Therefore, if there is a wall directly in
    '   front of the player, that wall needs to be drawn last, so it covers
    '   any other walls drawn further ahead, which the player is not able
    '   to see, because there is a wall in front of them!
    '
    '   The only exception to this rule is the walls placed ahead of the
    '   player.  You'll notice that, the IF...THEN...ELSE statement ends
    '   as soon as the first wall ahead is placed.  Therefore, we don't need
    '   to start from the furthest wall and work our way in.
    '
    '   The rest of this code is the same as the above, only it is used
    '   when the player is facing a different direction.  This way, if the
    '   player is facing east, it must draw parts of the map which are to
    '   the right of them instead of straight ahead.
    '
    '   I haven't added comments to the rest of this, as, it would make
    '   for unnecessary reading, and based on what is above, you should be
    '   able to figure out the minor changes that must be made when the
    '   player is facing in a different direction.
    '
        ELSEIF PlayerDir$ = "E" THEN
            IF Map%(PlayerX% + 3, PlayerY% - 1) > 9 AND Map%(PlayerX% + 2, PlayerY% - 1) < 10 THEN
                    PutSprite "T3.BSG", Cell3LeftX, CellY, 0
                ELSEIF Map%(PlayerX% + 2, PlayerY% - 1) > 9 THEN
                    PutSprite "LW3.BSG", Cell3LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% + 2, PlayerY% - 1) > 9 AND Map%(PlayerX% + 1, PlayerY% - 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2LeftX, CellY, 0
                ELSEIF Map%(PlayerX% + 1, PlayerY% - 1) > 9 THEN
                    PutSprite "LW2.BSG", Cell2LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% + 1, PlayerY% - 1) > 9 AND Map%(PlayerX%, PlayerY% - 1) < 10 THEN
                    PutSprite "T1.BSG", Cell1LeftX, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% - 1) > 9 THEN
                    PutSprite "LW1.BSG", Cell1LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% + 3, PlayerY% + 1) > 9 AND Map%(PlayerX% + 2, PlayerY% + 1) < 10 THEN
                    PutSprite "T3.BSG", Cell3RightX, CellY, 0
                ELSEIF Map%(PlayerX% + 2, PlayerY% + 1) > 9 THEN
                    PutSprite "RW3.BSG", Cell3RightX, CellY, 0
            END IF
            IF Map%(PlayerX% + 2, PlayerY% + 1) > 9 AND Map%(PlayerX% + 1, PlayerY% + 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2RightX, CellY, 0
                ELSEIF Map%(PlayerX% + 1, PlayerY% + 1) > 9 THEN
                    PutSprite "RW2.BSG", Cell2RightX, CellY, 0
            END IF
            IF Map%(PlayerX% + 1, PlayerY% + 1) > 9 AND Map%(PlayerX%, PlayerY% + 1) < 10 THEN
                    PutSprite "T1.BSG", Cell1RightX, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% + 1) > 9 THEN
                    PutSprite "RW1.BSG", Cell1RightX, CellY, 0
            END IF
            IF Map%(PlayerX% + 1, PlayerY%) > 9 THEN
                    PutSprite "WA1.BSG", Cell1Ahead, CellY, 0
                ELSEIF Map%(PlayerX% + 2, PlayerY%) > 9 THEN
                    PutSprite "WA2.BSG", Cell2Ahead, CellY, 0
                ELSEIF Map%(PlayerX% + 3, PlayerY%) > 9 THEN
                    PutSprite "WA3.BSG", Cell3Ahead, CellY, 0
            END IF
        ELSEIF PlayerDir$ = "S" THEN
            IF Map%(PlayerX% + 1, PlayerY% + 3) > 9 AND Map%(PlayerX% + 1, PlayerY% + 2) < 10 THEN
                    PutSprite "T3.BSG", Cell3LeftX, CellY, 0
                ELSEIF Map%(PlayerX% + 1, PlayerY% + 2) > 9 THEN
                    PutSprite "LW3.BSG", Cell3LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% + 1, PlayerY% + 2) > 9 AND Map%(PlayerX% + 1, PlayerY% + 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2LeftX, CellY, 0
                ELSEIF Map%(PlayerX% + 1, PlayerY% + 1) > 9 THEN
                    PutSprite "LW2.BSG", Cell2LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% + 1, PlayerY% + 1) > 9 AND Map%(PlayerX% + 1, PlayerY%) < 10 THEN
                    PutSprite "T1.BSG", Cell1LeftX, CellY, 0
                ELSEIF Map%(PlayerX% + 1, PlayerY%) > 9 THEN
                    PutSprite "LW1.BSG", Cell1LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY% + 3) > 9 AND Map%(PlayerX% - 1, PlayerY% + 2) < 10 THEN
                    PutSprite "T3.BSG", Cell3RightX, CellY, 0
                ELSEIF Map%(PlayerX% - 1, PlayerY% + 2) > 9 THEN
                    PutSprite "RW3.BSG", Cell3RightX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY% + 2) > 9 AND Map%(PlayerX% - 1, PlayerY% + 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2RightX, CellY, 0
                ELSEIF Map%(PlayerX% - 1, PlayerY% + 1) > 9 THEN
                    PutSprite "RW2.BSG", Cell2RightX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY% + 1) > 9 AND Map%(PlayerX% - 1, PlayerY%) < 10 THEN
                    PutSprite "T1.BSG", Cell1RightX, CellY, 0
                ELSEIF Map%(PlayerX% - 1, PlayerY%) > 9 THEN
                    PutSprite "RW1.BSG", Cell1RightX, CellY, 0
            END IF
            IF Map%(PlayerX%, PlayerY% + 1) > 9 THEN
                    PutSprite "WA1.BSG", Cell1Ahead, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% + 2) > 9 THEN
                    PutSprite "WA2.BSG", Cell2Ahead, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% + 3) > 9 THEN
                    PutSprite "WA3.BSG", Cell3Ahead, CellY, 0
            END IF
        ELSEIF PlayerDir$ = "W" THEN
            IF Map%(PlayerX% - 3, PlayerY% + 1) > 9 AND Map%(PlayerX% - 2, PlayerY% + 1) < 10 THEN
                    PutSprite "T3.BSG", Cell3LeftX, CellY, 0
                ELSEIF Map%(PlayerX% - 2, PlayerY% + 1) > 9 THEN
                    PutSprite "LW3.BSG", Cell3LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% - 2, PlayerY% + 1) > 9 AND Map%(PlayerX% - 1, PlayerY% + 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2LeftX, CellY, 0
                ELSEIF Map%(PlayerX% - 1, PlayerY% + 1) > 9 THEN
                    PutSprite "LW2.BSG", Cell2LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY% + 1) > 9 AND Map%(PlayerX%, PlayerY% + 1) < 10 THEN
                    PutSprite "T1.BSG", Cell1LeftX, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% + 1) > 9 THEN
                    PutSprite "LW1.BSG", Cell1LeftX, CellY, 0
            END IF
            IF Map%(PlayerX% - 3, PlayerY% - 1) > 9 AND Map%(PlayerX% - 2, PlayerY% - 1) < 10 THEN
                    PutSprite "T3.BSG", Cell3RightX, CellY, 0
                ELSEIF Map%(PlayerX% - 2, PlayerY% - 1) > 9 THEN
                    PutSprite "RW3.BSG", Cell3RightX, CellY, 0
            END IF
            IF Map%(PlayerX% - 2, PlayerY% - 1) > 9 AND Map%(PlayerX% - 1, PlayerY% - 1) < 10 THEN
                    PutSprite "T2.BSG", Cell2RightX, CellY, 0
                ELSEIF Map%(PlayerX% - 1, PlayerY% - 1) > 9 THEN
                    PutSprite "RW2.BSG", Cell2RightX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY% - 1) > 9 AND Map%(PlayerX%, PlayerY% - 1) < 10 THEN
                    PutSprite "T1.BSG", Cell1RightX, CellY, 0
                ELSEIF Map%(PlayerX%, PlayerY% - 1) > 9 THEN
                    PutSprite "RW1.BSG", Cell1RightX, CellY, 0
            END IF
            IF Map%(PlayerX% - 1, PlayerY%) > 9 THEN
                    PutSprite "WA1.BSG", Cell1Ahead, CellY, 0
                ELSEIF Map%(PlayerX% - 2, PlayerY%) > 9 THEN
                    PutSprite "WA2.BSG", Cell2Ahead, CellY, 0
                ELSEIF Map%(PlayerX% - 3, PlayerY%) > 9 THEN
                    PutSprite "WA3.BSG", Cell3Ahead, CellY, 0
            END IF
    END IF

END SUB

SUB MoveDown
    '
    '   This SUB is called if the player presses the down arrow key.
    '   We have to first, check which direction the player is facing, then
    '   check if the cell directly ahead of the player is walkable or not.
    '   If it is, we change the player's location accordingly, and make
    '   the Moved% variable True so that the screen will be updated to
    '   reflect the player's new position in the maze.
    '
    IF PlayerDir$ = "N" THEN
            IF Map%(PlayerX%, PlayerY% + 1) < 10 THEN
                Moved% = True: PlayerY% = PlayerY% + 1
            END IF
        ELSEIF PlayerDir$ = "E" THEN
            IF Map%(PlayerX% - 1, PlayerY%) < 10 THEN
                Moved% = True: PlayerX% = PlayerX% - 1
            END IF
        ELSEIF PlayerDir$ = "S" THEN
            IF Map%(PlayerX%, PlayerY% - 1) < 10 THEN
                Moved% = True: PlayerY% = PlayerY% - 1
            END IF
        ELSEIF PlayerDir$ = "W" THEN
            IF Map%(PlayerX% + 1, PlayerY%) < 10 THEN
                Moved% = True: PlayerX% = PlayerX% + 1
            END IF
    END IF

END SUB

SUB MoveLeft
    '
    '   A very simple SUB.  This just changes the direction the player is
    '   facing in a counterclockwise movement each time the left arrow
    '   key is pressed.
    '
    Moved% = True
    IF PlayerDir$ = "S" THEN
            PlayerDir$ = "E"
        ELSEIF PlayerDir$ = "E" THEN
            PlayerDir$ = "N"
        ELSEIF PlayerDir$ = "N" THEN
            PlayerDir$ = "W"
        ELSEIF PlayerDir$ = "W" THEN
            PlayerDir$ = "S"
    END IF

END SUB

SUB MoveRight
    '
    '   A very simple SUB.  This just changes the direction the player is
    '   facing in a clockwise movement each time the right arrow key is
    '   pressed.
    '
    Moved% = True
    IF PlayerDir$ = "S" THEN
            PlayerDir$ = "W"
        ELSEIF PlayerDir$ = "E" THEN
            PlayerDir$ = "S"
        ELSEIF PlayerDir$ = "N" THEN
            PlayerDir$ = "E"
        ELSEIF PlayerDir$ = "W" THEN
            PlayerDir$ = "N"
    END IF

END SUB

SUB MoveUp
    '
    '   This SUB is called if the player presses the up arrow key.  We
    '   have to first, check which direction the player is facing, then
    '   check if the cell directly ahead of the player is walkable or not.
    '   If it is, we change the player's location accordingly, and make
    '   the Moved% variable True so that the screen will be updated to
    '   reflect the player's new position in the maze.
    '
    IF PlayerDir$ = "N" THEN
            IF Map%(PlayerX%, PlayerY% - 1) < 10 THEN
                Moved% = True: PlayerY% = PlayerY% - 1
            END IF
        ELSEIF PlayerDir$ = "E" THEN
            IF Map%(PlayerX% + 1, PlayerY%) < 10 THEN
                Moved% = True: PlayerX% = PlayerX% + 1
            END IF
        ELSEIF PlayerDir$ = "S" THEN
            IF Map%(PlayerX%, PlayerY% + 1) < 10 THEN
                Moved% = True: PlayerY% = PlayerY% + 1
            END IF
        ELSEIF PlayerDir$ = "W" THEN
            IF Map%(PlayerX% - 1, PlayerY%) < 10 THEN
                Moved% = True: PlayerX% = PlayerX% - 1
            END IF
    END IF

END SUB

SUB PutSprite (FileName$, X%, Y%, PutType%)
    '
    '   This is the SUB which we use to put all of our graphics on the
    '   screen.  So why the trouble for a sepearate SUB instead of just
    '   using PUT statements? Well, if you plan on using a graphics lib
    '   with this code, it'll be very handy.  This will be the only place
    '   where you'll need to replace the PUT statement.  Plus, with this
    '   routine, we're only using one sprite array instead of many.  This
    '   significantly reduces the amount of array memory needed.
    '
    DEF SEG = VARSEG(Sprite%(0)): BLOAD FileName$, VARPTR(Sprite%(0))
    IF PutType% = 0 THEN
            PUT (X%, Y%), Sprite%, PSET
        ELSEIF PutType% = 1 THEN
            PUT (X%, Y%), Sprite%, AND
        ELSEIF PutType% = 2 THEN
            PUT (X%, Y%), Sprite%, XOR
    END IF

END SUB

SUB ReadData (MaxX%, MaxY%)
    '
    '   Here, we fill our Map% array with values of 10, which we use to
    '   designate a plain wall.  Notice that the maximum X and Y values
    '   of the current map are passed into this SUB.  If our map was
    '   bigger, say 20 by 20, then we would pass values of 20 to the
    '   MaxX% and MaxY% variables.  This setup also allows you to have
    '   maps with differing X and Y values, such as, say, 20 and 10 or
    '   14 and 31, etc.  The current map array supports maps up to 170x170
    '   in size, which, trust me, is big enough. :)
    '
    FOR Y% = -3 TO MaxY% + 3
        FOR X% = -3 TO MaxX% + 3
            Map%(X%, Y%) = 10
        NEXT X%
    NEXT Y%
    '
    '   Now, we read our map values from the data.  Notice that reading
    '   begins 3 columns after the beginning of the Map% array and ends
    '   3 columns before the end of the Map% array.  This is 'cause we
    '   have to fill some 'dummy' data for the edges of our map.
    '
    '   We need the 'padding' on the outside for our DrawLocation sub,
    '   which will check the map values 3 spaces ahead of the player's
    '   current direction to draw the display correctly.
    '
    FOR Y% = 0 TO 9
        FOR X% = 0 TO 9
            READ Map%(X%, Y%)
        NEXT X%
    NEXT Y%

END SUB

