'       RPGs in QB
'
'       Volume II, Issue IV
'       Pixel*Tile Scrolling Engine
'
'       Started: December 15th, 2001
'       Finished: December 16th, 2001
'
'       Written by: DarkDread
'       darkdread@hotmail.com
'
'
'       Well, I did it.  I actually wrote another RPG tutorial.  Anyway
'       there are a few things you'll need to know before you hit F5 and
'       run the code.
'
'       First, you'll need to run this with the gslib quicklibrary (it's
'       included with this tut) loaded into QB.  If you haven't done that,
'       exit, and do it now.  If you're not sure how it's done, simply
'       type in qb.exe /l gslib.qlb in the directory where all of these
'       files are located.  You may need to include the full path to your
'       copy of qb.exe, so if you have it in, say c:\coding\qb45\ then you
'       would do this instead: c:\coding\qb45\qb.exe /l gslib.qlb
'
'       Anyway, once you have that done, you can hit F5, and walk around
'       on a little demo map, with a demo character.  Notice the nice
'       smooth p*t scrolling?  Now... do you want to know how it's done?
'       Then read on! I've left comments in the code, explaining what each
'       part does.
'
'
DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'gslib.bi'

DECLARE SUB LoadMap ()
DECLARE SUB Main ()
DECLARE SUB TileEngine (x1%, x2%, y1%, y2%)

'
'       Here, we declare constants and variables.  Pretty standrard stuff,
'       except that you may want to note the Buffer& array.  We need this
'       for our offscreen buffer, since we're using gslib to eliminate
'       flicker. :)
'
CONST True = -1, False = 0

DIM SHARED TileSet%(4040), Player%(4040), Buffer&(15999)
DIM SHARED ScreenMap%(-5 TO 21, -5 TO 14), TileMap%(-5 TO 45, -5 TO 45)

DIM SHARED PlayerX%, PlayerY%, ScreenX%, ScreenY%, PlayerDir%

'
'       Standard inits.  We switch to 320x200x256 mode 13h, and initialize
'       our graphics library.  We also call LoadMap, and then go into our
'       Main sub.
'
SCREEN 13
gsinit
LoadMap
Main

'
'       That's it.  Not too complicated, is it?
'
'       If you have any _specific_ questions about the tutorial, or
'       about parts of the code, feel free to e-mail me at
'       darkdread@hotmail.com and ask.  I'll try to explain to the best
'       of my abilities if there is something that needs to be clarified.
'
'       I hope you can make use of this... and as always, if you do
'       take the code from here, a little 'Thanks DarkDread for the p*t
'       scroller' in your game would be nice. :)
'
'       As an aside, yes, feel free to use the graphics from this tut as
'       well.  Honestly, I'd recommend making new ones instead tho, as
'       these are just here to demonstrate the concept, they're hardly
'       good. :)
'
'       Cheers!
'
'       DarkDread
'

REM $STATIC
SUB LoadMap

'
'       Standard inits and such.  Here, we load the tilsets of the player
'       and area which we will be using.  We also create the default start
'       on the map for the player, and init our screen and player x,y
'       display coordinates.
'
'       We also load our map data from the file.  It's pretty standard x,y
'       y data.  Each TileMap%(x%,y%) holds a number value which corresponds
'       to the type of tile to display.  The first three bits of data in the
'       file hold the max x and y size of the map, and the type of tileset
'       to load.  This is useful if you have more than one tileset.
'
'       At the end, we also fill the outside edges of the map array with
'       tile number 5, which is our water tile.  This is useful if the
'       player accidentally wanders out of the boundaries somehow :)
'
    DEF SEG = VARSEG(Player%(0)): BLOAD "wierdo.set", VARPTR(Player%(0))
    DEF SEG = VARSEG(TileSet%(0)): BLOAD "tiles.set", VARPTR(TileSet%(0))

    PlayerX% = 14: PlayerY% = 9: PlayerDir% = 1
    ScreenX% = PlayerX% - 9: ScreenY% = PlayerY% - 5: PlayerMoved% = 0

    FileNum% = FREEFILE
    OPEN "demo.map" FOR INPUT AS #FileNum%

    INPUT #FileNum%, MaxX%, MaxY%, MapType%
    FOR y% = 0 TO MaxY%
        FOR x% = 0 TO MaxX%
            INPUT #FileNum%, MazeData%
            TileMap%(x%, y%) = MazeData%
        NEXT x%
    NEXT y%
    FOR y% = 0 TO MaxY%
        TileMap%(-1, y%) = 5
        TileMap%(-2, y%) = 5
    NEXT y%
    CLOSE #FileNum%

END SUB

SUB Main

'       As it says, this is the Main sub.  It loops through a select case
'       statement, which polls for keyboard input, to see if the player
'       has pressed a key.  If they have, it passes the appopriate scroll
'       data to our TileEngine sub.
'
'       The latter half of it is for the player animations, but, since this
'       isn't a tutorial about how to properly animate a character, I'll
'       leave it up to you folks to decide how that works. :)
'
    DO

        SELECT CASE INKEY$
        CASE CHR$(0) + CHR$(72)
            PlayerDir% = 0
            IF TileMap%(PlayerX%, PlayerY% - 1) < 5 THEN
                ScreenY% = ScreenY% - 1: ShiftPlayer! = TIMER
                PlayerY% = PlayerY% - 1: Moved% = True
                ScrollY1% = -19: ScrollY2% = 0
            END IF
        CASE CHR$(0) + CHR$(80)
            PlayerDir% = 1
            IF TileMap%(PlayerX%, PlayerY% + 1) < 5 THEN
                ScreenY% = ScreenY% + 1: ShiftPlayer! = TIMER
                PlayerY% = PlayerY% + 1: Moved% = True
                ScrollY1% = 19: ScrollY2% = 0
            END IF
        CASE CHR$(0) + CHR$(75)
            PlayerDir% = 2
            IF TileMap%(PlayerX% - 1, PlayerY%) < 5 THEN
                ScreenX% = ScreenX% - 1: ShiftPlayer! = TIMER
                PlayerX% = PlayerX% - 1: Moved% = True
                ScrollX1% = -19: ScrollX2% = 0
            END IF
        CASE CHR$(0) + CHR$(77)
            PlayerDir% = 3
            IF TileMap%(PlayerX% + 1, PlayerY%) < 5 THEN
                ScreenX% = ScreenX% + 1: ShiftPlayer! = TIMER
                PlayerX% = PlayerX% + 1: Moved% = True
                ScrollX1% = 19: ScrollX2% = 0
            END IF
        CASE CHR$(27)
            ExitDemo% = True
        CASE ELSE
            ' Do Nothing.
        END SELECT

        TileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%
        ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0

        IF LastMoved% = 0 AND Moved% THEN
                LastMoved% = 1
                PlayerMoved% = 1: ShiftedPlayer% = True
            ELSEIF LastMoved% = 1 AND Moved% THEN
                LastMoved% = 0
                PlayerMoved% = 2: ShiftedPlayer% = True
        END IF
        IF ShiftPlayer! + .25 < TIMER THEN PlayerMoved% = 0
        Moved% = False

    LOOP UNTIL ExitDemo%

END SUB

SUB TileEngine (x1%, x2%, y1%, y2%)

'
'       The meat of everything.  This is the p*t scroll engine.  Notice that
'       it allows for input into how many pixel rows to scroll (These are
'       the x1%, y1%, x2%, and y2% values).  If you give all four values of
'       0, it will simply display the map.  This is used if the player is
'       standing still, and you want to animate stuff, like flickering torch
'       tiles, or water for example.
'
'       Now, if this looks complicated, just look at it like a regular tile
'       scrolling engine.  This is pretty much what it is, except for the
'       extra FOR...NEXT loops which are used to determine the scroll, and
'       where to lay the tiles.
'
'       What we have, is a bit of a 'virtual screen' which is not displayed.
'       This is in the x,y range of -1 to -20, and 320 to 340.  Here, the
'       engine still writes the tiles, even though they are not seen...
'       until the tiles are scrolled.
'
'       Finally, we also determine which part of the player tileset to
'       display here... but again, this isn't really part of the tutorial...
'       so you can figure that out for yoursevles :)
'
'       Finally, for every time this sub runs... the results are displayed
'       on the screen, and presto! We have p*t scrolling.
'
    IF x1% = 19 THEN StepX% = -1 ELSE StepX% = 1
    IF y1% = 19 THEN StepY% = -1 ELSE StepY% = 1
    FOR ScrollX% = x1% TO x2% STEP StepX%
    FOR ScrollY% = y1% TO y2% STEP StepY%
    a% = -1: B% = -1
    FOR y% = ScreenY% - 1 TO ScreenY% + 10
    
        FOR x% = ScreenX% + 1 TO ScreenX% + 18
        
            ScreenMap%(a%, B%) = TileMap%(x%, y%)
            gssprite a% * 20 + ScrollX%, B% * 20 + ScrollY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(TileSet%(ScreenMap%(a%, B%) * 202)), VARPTR(TileSet%(ScreenMap%(a%, B%) * 202))

            a% = a% + 1
            IF a% = 17 THEN a% = -1

        NEXT x%
        B% = B% + 1
        IF B% = 11 THEN B% = -1

    NEXT y%

    IF PlayerDir% = 0 THEN
            IF ScrollY% = 0 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(3 * 202)), VARPTR(Player%(3 * 202))
                ELSEIF ScrollY% >= -10 AND ScrollY% <= -1 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(4 * 202)), VARPTR(Player%(4 * 202))
                ELSEIF ScrollY% >= -19 AND ScrollY% <= -11 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(5 * 202)), VARPTR(Player%(5 * 202))
            END IF
        ELSEIF PlayerDir% = 1 THEN
            IF ScrollY% = 0 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(10 * 202)), VARPTR(Player%(0 * 202))
                ELSEIF ScrollY% >= 1 AND ScrollY% <= 10 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(1 * 202)), VARPTR(Player%(1 * 202))
                ELSEIF ScrollY% >= 11 AND ScrollY% <= 19 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(2 * 202)), VARPTR(Player%(2 * 202))
            END IF
        ELSEIF PlayerDir% = 2 THEN
            IF ScrollX% = 0 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(8 * 202)), VARPTR(Player%(8 * 202))
                ELSEIF ScrollX% >= -10 AND ScrollX% <= -1 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(9 * 202)), VARPTR(Player%(9 * 202))
                ELSEIF ScrollX% >= -19 AND ScrollX% <= -11 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(8 * 202)), VARPTR(Player%(8 * 202))
            END IF
        ELSEIF PlayerDir% = 3 THEN
            IF ScrollX% = 0 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(6 * 202)), VARPTR(Player%(6 * 202))
                ELSEIF ScrollX% >= 1 AND ScrollX% <= 10 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(7 * 202)), VARPTR(Player%(7 * 202))
                ELSEIF ScrollX% >= 11 AND ScrollX% <= 19 THEN
                    gssprite 7 * 20, 5 * 20 - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(6 * 202)), VARPTR(Player%(6 * 202))
            END IF
    END IF

    gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
    NEXT ScrollY%
    NEXT ScrollX%

END SUB

