sub init_pre_initial_screen (byref scr as screentype, byref scores as scorestype, byref options as optionstype, byref ingame as ingametype)

	scr.x=scrmaxx:scr.y=scrmaxy
	scr.hx=scr.x*.5:scr.hy=scr.y*.5
	screenres scr.x,scr.y,32,,1

	For i As Integer = 0 To 2
		scores.scoretable(i) = ImageCreate(scr.x*minitz,scr.y*minitz,black )
	Next
	openhighscores(scores)

	ingame.apple.size=9

	options.gamemode(0).title="ESCAPE"
	options.gamemode(1).title="SURVIVAL"
	options.gamemode(2).title="MAXRUN"

	options.gamemode(0).startbits=93*(ovalsize/300)
	options.gamemode(1).startbits=13*(ovalsize/300)
	options.gamemode(2).startbits=1+int((ovalsize/300)*2)

	options.gamemode_idn=1

	options.tackle_v=.9
	options.tackle_r=1

end sub

Sub alllogic(byref player as playertype, byref scores as scorestype, byval scr as screentype, bitt() as bitstype, byref ingame as ingametype, byval options as optionstype)
    
ingame.igflag.restart = 0

ingame.igflag.appleexist=0

ingame.vigour = .99

reinit(player, scr, bitt(), options, ingame)

Do
   
    player.con(1)=player.con(0)
	if options.dc=-1 then draw_cursor(player,0, 1)
    moveyourself(player,scr)
	if options.dc=-1 then draw_cursor(player,purple, 0)
	
    movebits(player, bitt(), ingame)
    
    if player.forcefield=-1 then
    	tiltbits(player, bitt(), ingame)
		player.forcefield=0
	end if

    If checkcollision(player.x , player.y, bitt(), ingame, options) Then 
        if player.oldcollision=-1 then endsub(player, scores, scr, options, ingame) 
        player.oldcollision=-1
    else
        player.oldcollision=0
    end if
   
    If checkescape(player.x,player.y,scr.hx,scr.hy) = -1 Then 
        endsub(player, scores, scr, options, ingame)
  	end if
   
    plotbits (bitt(), ingame)
   
    plotplayer (player)
   
    apples (player, scr, options, ingame)
   
    If options.gamemode_idn=1 Then
        ingame.surcounter+=1
        if ingame.surcounter>250 then
            ingame.surcounter=0
            ingame.totbits+=1
        End If
    End If
	
	sleep 5

Loop Until multikey(1) Or ingame.igflag.restart

End Sub

Sub endsub(byref player as playertype, byref scores as scorestype, byval scr as screentype, byval options as optionstype, byref ingame as ingametype)
dim as integer x,y,i
    
    do
		sel_consel (player.con(0).x,player.con(0).y, player.con(0).b, 0)
	    sleep 1
    loop while player.con(0).b<>0
   
        Locate 9,36
        If not checkescape (player.x , player.y, scr.hx, scr.hy) Then
            Color rgb(200,150,200)
            ? "CAPTURED"
            player.rings=0
            player.totrings=0
            ingame.igflag.captured=-1
            if options.gamemode_idn=0 then
            	ingame.totbits-=1
            else
            	ingame.totbits=options.gamemode(options.gamemode_idn).startbits
            end if
            	
        else
            Color palegreen
            ? "ESCAPE!"
            locate 2,2
            color white
	       	print ingame.totbits , options.tackle_v
        end if
    
    if checkescape (player.x , player.y, scr.hx, scr.hy) then 
        
        ingame.igflag.captured=1
        player.totrings+=player.rings
        if player.totrings>player.bestrings then player.bestrings=player.totrings
        
        color gold
        x=0:y=0
        for i = 1 to player.bestrings
            y+=20
            x=20*int(y/600)
            circle (x+10,(y mod 600)+10),ingame.apple.size
        next
        color cream
        x=0:y=0
        for i = 1 to player.totrings
            y+=20
            x=20*int(y/scrmaxy)
            circle (x+10,(y mod scrmaxy)+10), ingame.apple.size
        next
        
        If player.totrings > scores.highscore(options.gamemode_idn) Then 
		    scores.highscore(options.gamemode_idn) = player.totrings
        	bsavehigh(options.gamemode_idn, player, scores, scr)
		end if
		

    END IF
	
	draw string (scr.x-200,scr.y-10), "mmb quits to title", rgb(200,200,200)
	
    Do

		sel_consel (player.con(0).x,player.con(0).y, player.con(0).b, 0)
       
        If multikey(1) Then ingame.igflag.quit=-1
       
        Sleep 1
    Loop Until player.con(0).b=1 Or ingame.igflag.quit=-1 or player.con(0).b=4
   
   ingame.igflag.restart =-1
    
   if player.con(0).b=4 then 
   		ingame.igflag.restart=-2
   		ingame.igflag.captured=0
	end if
    
    do
		sel_consel (player.con(0).x,player.con(0).y, player.con(0).b, 0)
	    sleep 1
    loop while player.con(0).b<>0

    
End Sub

Sub setupbits(byval scr as screentype, bitt() as bitstype, byval options as optionstype, byval ingame as ingametype)
dim as single distance , angle
dim as integer i

    For i = 1 To maxbits
        With bitt(i)
		        angle = rnd*(pi*2)
		        distance = Int(Rnd * (ovalsize*.7) + .3*ovalsize)
		        .x = scr.hx - (Sin(angle) * distance)
		        .y = scr.hy - (Cos(angle) * distance)
		        
		        if i>ingame.totbits or (i<ingame.totbits and ingame.igflag.captured=0) then
					.scycle = rnd*(-modlen)
					.ecycle = .scycle*-1
					.anti=rnd
					.peer=rnd
					.dive=rnd
					.spd=rnd
				    .sign = 1+(2*(rnd>.5))
					.cycle =.sign
				    .colour=rgb(155+int(100-100*.anti*.spd),155+int(100*.peer*.spd),155+int(100-100*.dive*.spd))
				else
					.cycle =.sign
				end if	        	
	        	
        End With
    Next
   
End Sub

Sub reinit(byref player as playertype, byval scr as screentype, bitt() as bitstype, byval options as optionstype, byval ingame as ingametype)
       
    player.rings=0
    
    player.x = scr.hx+(player.x-player.oldx) : player.y = scr.hy+(player.y-player.oldy)
    player.oldx = scr.hx : player.oldy = scr.hy
    
    Cls
   
    Circle (scr.hx,scr.hy), ovalsize, rgb(0,int(rnd*55)+200,0)
   
    setupbits (scr, bitt(), options , ingame)
    ingame.igflag.captured=0

End Sub

Sub apples(byref player as playertype, byval scr as screentype, byval options as optionstype, byref ingame as ingametype)
dim as single mag , angle

    If ingame.igflag.appleexist = 0 Then
        do
            angle = Rnd * pi*2
            mag = (Rnd*ovalsize)-ovalsize*.1
            ingame.apple.x = scr.hx-Sin(angle)*mag
            ingame.apple.y = scr.hy-Cos(angle)*mag
        loop until sqr((ingame.apple.x-player.x)^2+(ingame.apple.y-player.y)^2) > ingame.apple.size
	    ingame.igflag.appleexist = -1
	    circle (ingame.apple.x,ingame.apple.y),ingame.apple.size,cream
    End If

    if (abs(player.x-ingame.apple.x)<(ingame.apple.size+1) and _
    	abs(player.y-ingame.apple.y) < (ingame.apple.size+1)) and _
							     ingame.igflag.appleexist = -1 then
        ingame.igflag.appleexist = 0 
        if options.gamemode_idn=0 then ingame.igflag.appleexist = -2
        
        circle (ingame.apple.x,ingame.apple.y),ingame.apple.size,black
        player.rings+=1
        If options.gamemode_idn<>1 Then ingame.totbits+=1
    End If
   
End Sub

sub initial_screen (byref player as playertype, byref scr as screentype, byval scores as scorestype, byref options as optionstype)
dim as string ts

	sleep 200,1
	cls
    
    setmouse scr.hx,scr.hy,0
    
    draw string (scr.hx-4*len("bitrunner"), 0),"bitrunner",lightblue
    draw string (scr.hx-4*49, 8),"collect and escape with as many rings as possible",palegreen
    Sleep 500,1
   
    Line (1,30)-(scr.x-1,50),rgb(255,0,0),b
    ts="GAME MODE:" & options.gamemode(options.gamemode_idn).title
    draw string (scr.hx-60,16),ts , cream
    Color rgb(150,150,150)
    Locate 5,14
    ? "use the mouse buttons inside the box to change game mode"

    Line (0,scr.hy-.3*scr.hy)-(scr.x,scr.hy-.3*scr.hy),rgb(0,250,0)
    locate 33,28
    color white
    ? "start"
    draw string (21*8,36*8), "left mouse button to continue, rmb for splashscreen", lightpink
    
    For i As Integer = 0 To 2
        Put (i*scr.x*minitz, scr.y*(1-minitz)), scores.scoretable(i)
    Next
    
	for i as integer = 0 to 2
		resettacklecircles (scr,i)
	next
	cleartacklecircles(scr)
		
	resettacklecircles (scr,options.tackle_r)
	
    Do
       	draw_cursor (player, black, 0)
        getmouse player.con(0).x , player.con(0).y , , player.con(0).b
       	draw_cursor (player, white, 0)
       	
	    If player.con(0).y < 50 And player.con(0).b <> 0 Then
	    	
	        Select Case player.con(0).b
	        Case 1
	        	options.gamemode_idn=0
	        Case 2
	        	options.gamemode_idn=2
	        Case 4
	        	options.gamemode_idn=1
	        End Select
		    line (scr.hx+20,16)-(scr.hx+84,24),black,bf
		    ts="GAME MODE:" & options.gamemode(options.gamemode_idn).title
		    draw string (scr.hx-60,16), ts, cream
	    End If
        
		locate 17,20
		? "press 1 for cursor"
		if multikey(&h2) then 
			options.dc=(options.dc=0)
			locate 19,20
			? options.dc
		end if
		
		if multikey(&h11) then 
			locate 5,2
			color gold
			? player.autostyle, "inertia"
		end if
		player.autostyle=(player.autostyle=0)
		
	    tacklesel (player,options,scr)
	
		Sleep 20
    
    Loop Until player.con(0).b <> 0 _
			and player.con(0).y > scr.hy-.3*scr.hy _
    			 Or multikey(1)

end sub

sub tacklesel ( player as playertype, byref options as optionstype, scr as screentype)
	if player.con(0).b <> 0 then
		If abs(player.con(0).y-scr.hy*.5)<5 Then 
			options.tackle_v=1
			options.tackle_r=0
		end if
		If abs(player.con(0).y-(scr.hy*.5+10))<5 And player.con(0).b <> 0 Then 
			options.tackle_v=.9
			options.tackle_r=1
		end if
		If abs(player.con(0).y-(scr.hy*.5+20))<5 And player.con(0).b <> 0 Then 
			options.tackle_v=.8
			options.tackle_r=2
		end if
	end if
	cleartacklecircles (scr)
	resettacklecircles (scr,options.tackle_r)

end sub
