DECLARE SUB Pixel (BYVAL x%, BYVAL y%, BYVAL r%, BYVAL g%, BYVAL b%)
DECLARE SUB SetText ()
DECLARE FUNCTION DetectVESA% ()
DECLARE FUNCTION SetMode% (mode%)

'$INCLUDE: 'qb.bi'
	TYPE VGAInfoBlock
		VESASignature AS STRING * 4
		VESAVersion AS INTEGER
		OEMStringPTR AS LONG
		Capabilities AS STRING * 4
		VideoModePTR AS LONG
		TotalMemory AS INTEGER
		Reserved AS STRING * 236
	END TYPE

TYPE ModeInfoBlock
	      ModeAttributes AS INTEGER
	      WinAAttributes AS STRING * 1
	      WinBAttributes AS STRING * 1
	      WinGranularity AS INTEGER
	      WinSize AS INTEGER
	      WinASegment AS INTEGER
	      WinBSegment AS INTEGER
	      WinFuncPointer AS LONG
	      BytesPerScanLine AS INTEGER
	      XResolution AS INTEGER
	      YResolution AS INTEGER
	      XCharSize AS STRING * 1
	      YCharSize AS STRING * 1
	      NumberOfPlanes AS STRING * 1
	      BitsPerPixel AS STRING * 1
	      NumberOfBanks AS STRING * 1
	      MemoryModel AS STRING * 1
	      BankSize AS STRING * 1
	      NumberOfImagePages AS STRING * 1
	      SizeOfBank AS STRING * 1
	      RedMaskSize AS STRING * 1
	      RedFieldPosition AS STRING * 1
	      GreenMaskSize AS STRING * 1
	      GreenFieldPosition AS STRING * 1
	      BlueMaskSize AS STRING * 1
	      BlueFieldPosition AS STRING * 1
	      RsvdMaskSize AS STRING * 1
	      RsvdFieldPosition AS STRING * 1
	      DirectColorModeInfo AS STRING * 1
	      Reserved AS STRING * 216
END TYPE
DIM SHARED Regs AS RegTypeX, VGAInfo AS VGAInfoBlock, xRes, yRes
DIM SHARED ModeInfo AS ModeInfoBlock
CLS
IF DetectVESA THEN BEEP: SetText: PRINT "Could not find VESA": END
pages% = SetMode(&H112)
Pixel 50, 50, 255, 0, 0
PleaseTypeAKey$ = INPUT$(1)
SetText

DEFINT A-Z
FUNCTION DetectVESA%
Regs.AX = &H4F00
Regs.es = VARSEG(VGAInfo)
Regs.di = VARPTR(VGAInfo)
CALL InterruptX(&H10, Regs, Regs)
IF Regs.AX = &H4F AND VGAInfo.VESASignature = "VESA" THEN
DetectVESA = 0
ELSE
DetectVESA = 1
END IF
PRINT "VESA Version:"; RTRIM$(STR$(VGAInfo.VESAVersion \ 255)); ".";
PRINT LTRIM$(STR$(VGAInfo.VESAVersion AND 255))
END FUNCTION

FUNCTION SetMode (mode)
Regs.AX = &H4F01
Regs.cx = mode
Regs.es = VARSEG(ModeInfo)
Regs.di = VARPTR(ModeInfo)
CALL InterruptX(&H10, Regs, Regs)
IF ModeInfo.ModeAttributes AND 1 = 0 THEN PRINT "Cannot access mode"
xRes = ModeInfo.XResolution
yRes = ModeInfo.YResolution
IF ModeInfo.WinSize < 64 THEN
  PRINT "This program only works with those modes with more than 64k of window"
  SetMode = 0
  EXIT FUNCTION                                 'these routines.
END IF
IF ASC(ModeInfo.MemoryModel) <> 6 THEN
    PRINT "This Screen Mode is not available"
    SetMode = 0
    EXIT FUNCTION
END IF

Regs.AX = &H4F02                                'Set the mode.
Regs.BX = mode
CALL InterruptX(&H10, Regs, Regs)

IF Regs.AX <> &H4F THEN                         'Make sure it worked.
  PRINT "Screen mode could not be initialized"
  SetMode = 0
  EXIT FUNCTION
END IF

SetMode = ASC(ModeInfo.NumberOfImagePages) + 1
Regs.AX = &H4F05
Regs.BX = 0
Regs.DX = 1
CALL InterruptX(&H10, Regs, Regs)
END FUNCTION

SUB SetText
Regs.AX = &H3
CALL InterruptX(&H10, Regs, Regs)
END SUB

